/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.layerwidget;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import java.util.ArrayList;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class ZoomToFeaturesWorker
extends SwingWorker<Geometry, Geometry> {
    private static final Logger LOG = Logger.getLogger(ZoomToFeaturesWorker.class);
    private static Double scaleForPoint = null;
    private Feature[] features;
    private int buffer;

    public ZoomToFeaturesWorker(Feature[] features) {
        this(features, 0);
    }

    public ZoomToFeaturesWorker(Feature[] features, int buffer) {
        this.features = features;
        this.buffer = buffer;
    }

    public static Double getScaleForPoint() {
        return scaleForPoint;
    }

    public static void setScaleForPoint(Double aScaleForPoint) {
        scaleForPoint = aScaleForPoint;
    }

    @Override
    protected Geometry doInBackground() throws Exception {
        boolean first = true;
        int srid = 0;
        ArrayList<Geometry> geomList = new ArrayList<Geometry>(this.features.length);
        for (Feature f : this.features) {
            Geometry g = f.getGeometry();
            if (g == null) continue;
            g = g.getEnvelope();
            if (first) {
                srid = g.getSRID();
                first = false;
            } else if (g.getSRID() != srid) {
                g = CrsTransformer.transformToGivenCrs(g, CrsTransformer.createCrsFromSrid(srid));
            }
            geomList.add(g);
        }
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
        Geometry union = factory.buildGeometry(geomList);
        if (union instanceof GeometryCollection) {
            union = ((GeometryCollection)union).union();
        }
        return union;
    }

    @Override
    protected void done() {
        try {
            Geometry geom = (Geometry)this.get();
            if (geom != null && !geom.isEmpty()) {
                XBoundingBox boundingBox = new XBoundingBox(geom);
                if (this.buffer != 0) {
                    boundingBox.increase(this.buffer);
                }
                MappingComponent map = CismapBroker.getInstance().getMappingComponent();
                if (geom instanceof Point && scaleForPoint != null) {
                    map.gotoBoundingBoxWithHistory(map.getScaledBoundingBox(scaleForPoint, boundingBox));
                } else {
                    map.gotoBoundingBoxWithHistory(boundingBox);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while zooming to selected features", (Throwable)e);
        }
    }
}

