/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.options;

import de.cismet.cismap.commons.gui.options.CismapOptionsCategory;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateNewGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.RubberBandZoomListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;
import de.cismet.tools.configuration.NoWriteError;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class MapInteractionOptionsPanel
extends AbstractOptionsPanel
implements OptionsPanelController {
    private static final String OPTION_NAME = NbBundle.getMessage(MapInteractionOptionsPanel.class, (String)"MapInteractionOptionsPanel.jLabel3.text");
    private static final String CONFIGURATION = "MapInteractionOptionsPanel";
    private static final String CONF_INVERTSCROLLDIRECTION = "InvertScrollDirection";
    private static final String CONF_SHOW_LINE_LENGTH = "ShowLineLength";
    private static final String CONF_SHOW_HANDLE_DISTANCE_NEIGHBOURS = "ShowHandleDistanceNeighbours";
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private boolean stillConfigured = false;
    private boolean invertScrollDirection;
    private boolean showLineLength;
    private boolean showHandleDistanceNeighours;
    private JCheckBox cbShowDistanceToNeighbours;
    private JCheckBox cbShowLineLength;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JCheckBox jCheckBox1;
    private JLabel jLabel3;
    private JPanel jPanel1;

    public MapInteractionOptionsPanel() {
        super(OPTION_NAME, CismapOptionsCategory.class);
        this.initComponents();
    }

    public int getOrder() {
        return 0;
    }

    public void update() {
        RubberBandZoomListener listener = this.getListener();
        if (listener != null) {
            this.invertScrollDirection = listener.isInvertScrollDirection();
        }
        this.jCheckBox1.setSelected(this.invertScrollDirection);
        CreateNewGeometryListener geometryListener = this.getNewGeomertyListener();
        if (geometryListener != null) {
            this.showLineLength = geometryListener.isShowCurrentLength();
        }
        this.cbShowLineLength.setSelected(this.showLineLength);
        SelectionListener selectionListener = this.getSelectionListener();
        if (selectionListener != null) {
            this.showHandleDistanceNeighours = selectionListener.isShowHandleNeighbourDistance();
        }
        this.cbShowDistanceToNeighbours.setSelected(this.showHandleDistanceNeighours);
    }

    public void applyChanges() {
        this.invertScrollDirection = this.jCheckBox1.isSelected();
        RubberBandZoomListener listener = this.getListener();
        if (listener != null) {
            listener.setInvertScrollDirection(this.invertScrollDirection);
        }
        this.showLineLength = this.cbShowLineLength.isSelected();
        CreateNewGeometryListener geometryListener = this.getNewGeomertyListener();
        if (geometryListener != null) {
            geometryListener.setShowCurrentLength(this.showLineLength);
        }
        this.showHandleDistanceNeighours = this.cbShowDistanceToNeighbours.isSelected();
        SelectionListener selection = this.getSelectionListener();
        if (selection != null) {
            selection.setShowHandleNeighbourDistance(this.showHandleDistanceNeighours);
        }
    }

    public boolean isChanged() {
        return this.invertScrollDirection != this.jCheckBox1.isSelected() || this.showLineLength != this.cbShowLineLength.isSelected() || this.showHandleDistanceNeighours != this.cbShowDistanceToNeighbours.isSelected();
    }

    public String getTooltip() {
        return NbBundle.getMessage(MapInteractionOptionsPanel.class, (String)"MapInteractionOptionsPanel.jLabel3.toolTipText");
    }

    private RubberBandZoomListener getListener() {
        RubberBandZoomListener result = null;
        if (CismapBroker.getInstance() != null && CismapBroker.getInstance().getMappingComponent() != null) {
            result = (RubberBandZoomListener)CismapBroker.getInstance().getMappingComponent().getInputListener("ZOOM");
        }
        return result;
    }

    private CreateNewGeometryListener getNewGeomertyListener() {
        CreateNewGeometryListener result = null;
        if (CismapBroker.getInstance() != null && CismapBroker.getInstance().getMappingComponent() != null) {
            result = (CreateNewGeometryListener)CismapBroker.getInstance().getMappingComponent().getInputListener("NEW_POLYGON");
        }
        return result;
    }

    private SelectionListener getSelectionListener() {
        SelectionListener result = null;
        if (CismapBroker.getInstance() != null && CismapBroker.getInstance().getMappingComponent() != null) {
            result = (SelectionListener)CismapBroker.getInstance().getMappingComponent().getInputListener("SELECT");
        }
        return result;
    }

    public void configure(Element parent) {
        if (!this.stillConfigured) {
            try {
                Element conf;
                if (parent != null && (conf = parent.getChild(CONFIGURATION)) != null) {
                    String elementInvertScrollDirection = conf.getChildText(CONF_INVERTSCROLLDIRECTION);
                    this.invertScrollDirection = elementInvertScrollDirection != null ? Boolean.valueOf(elementInvertScrollDirection) : false;
                    String elementShowLineLength = conf.getChildText(CONF_SHOW_LINE_LENGTH);
                    this.showLineLength = elementShowLineLength != null ? Boolean.valueOf(elementShowLineLength) : false;
                    String elementHandleDistanceNeighbours = conf.getChildText(CONF_SHOW_HANDLE_DISTANCE_NEIGHBOURS);
                    this.showHandleDistanceNeighours = elementHandleDistanceNeighbours != null ? Boolean.valueOf(elementHandleDistanceNeighbours) : true;
                }
            }
            catch (Exception ex) {
                this.log.error((Object)"Fehler beim Konfigurieren des MapInteractionOptionsPanel", (Throwable)ex);
            }
            this.jCheckBox1.setSelected(this.invertScrollDirection);
            this.cbShowLineLength.setSelected(this.showLineLength);
            this.cbShowDistanceToNeighbours.setSelected(this.showHandleDistanceNeighours);
            this.stillConfigured = true;
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"skip Configure MapInteractionOptionsPanel - still configured");
        }
        this.applyChanges();
    }

    public Element getConfiguration() throws NoWriteError {
        Element conf = new Element(CONFIGURATION);
        Element elementInvertScrollDirection = new Element(CONF_INVERTSCROLLDIRECTION);
        elementInvertScrollDirection.addContent(Boolean.toString(this.invertScrollDirection));
        conf.addContent((Content)elementInvertScrollDirection);
        Element elementShowLineLength = new Element(CONF_SHOW_LINE_LENGTH);
        elementShowLineLength.addContent(Boolean.toString(this.showLineLength));
        conf.addContent((Content)elementShowLineLength);
        Element elementShowHandleDistanceNeighbours = new Element(CONF_SHOW_HANDLE_DISTANCE_NEIGHBOURS);
        elementShowHandleDistanceNeighbours.addContent(Boolean.toString(this.showHandleDistanceNeighours));
        conf.addContent((Content)elementShowHandleDistanceNeighbours);
        return conf;
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.cbShowLineLength = new JCheckBox();
        this.cbShowDistanceToNeighbours = new JCheckBox();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.jLabel3.setText(NbBundle.getMessage(MapInteractionOptionsPanel.class, (String)"MapInteractionOptionsPanel.jLabel3.text"));
        this.jLabel3.setToolTipText(NbBundle.getMessage(MapInteractionOptionsPanel.class, (String)"MapInteractionOptionsPanel.jLabel3.toolTipText"));
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jCheckBox1.setText(NbBundle.getMessage(MapInteractionOptionsPanel.class, (String)"MapInteractionOptionsPanel.jCheckBox1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.jPanel1.add((Component)this.jCheckBox1, gridBagConstraints);
        this.cbShowLineLength.setText(NbBundle.getMessage(MapInteractionOptionsPanel.class, (String)"MapInteractionOptionsPanel.cbShowLineLength.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.jPanel1.add((Component)this.cbShowLineLength, gridBagConstraints);
        this.cbShowDistanceToNeighbours.setText(NbBundle.getMessage(MapInteractionOptionsPanel.class, (String)"MapInteractionOptionsPanel.cbShowDistanceToNeighbours.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.jPanel1.add((Component)this.cbShowDistanceToNeighbours, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.filler2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 5, 5, 5);
        this.add(this.jPanel1, gridBagConstraints);
    }
}

