/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicSliderUI;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class AddHandleDialog
extends JDialog {
    public static final int STATUS_NONE = -1;
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCELED = 1;
    private static final double PRECISION = 100.0;
    private static final Logger LOG = Logger.getLogger(AddHandleDialog.class);
    private static final AddHandleDialog INSTANCE = new AddHandleDialog();
    private int returnStatus = -1;
    private boolean allLocked = true;
    private boolean sliderLocked = false;
    private boolean updateLeftLocked = false;
    private boolean updateRightLocked = false;
    private double distanceToLeft = 0.0;
    private double distanceTotal;
    private JButton btnCancel;
    private JButton btnOK;
    private JButton jButton1;
    private JPanel jPanel1;
    private JSpinner jSpinner1;
    private JSpinner jSpinner2;
    private JLabel lblDescription;
    private JLabel lblDescriptionImage;
    private JLabel lblDistanceLeft;
    private JLabel lblLeftNeighbour;
    private JLabel lblLeftPoint;
    private JLabel lblRightDistance;
    private JLabel lblRightNeighbour;
    private JLabel lblRightPoint;
    private JPanel panButtons;
    private JPanel panFooter;
    private JSlider sliDistance;

    private AddHandleDialog() {
        super(StaticSwingTools.getParentFrame((Component)((Object)CismapBroker.getInstance().getMappingComponent())), true);
        this.initComponents();
        this.sliDistance.setUI(new mySliderUI(this.sliDistance));
        this.getRootPane().setDefaultButton(this.btnOK);
        StaticSwingTools.doClickButtonOnKeyStroke((JButton)this.btnOK, (KeyStroke)KeyStroke.getKeyStroke(10, 0), (JRootPane)this.getRootPane());
        StaticSwingTools.doClickButtonOnKeyStroke((JButton)this.btnCancel, (KeyStroke)KeyStroke.getKeyStroke(27, 0), (JRootPane)this.getRootPane());
        this.pack();
        this.allLocked = false;
    }

    public static AddHandleDialog getInstance() {
        return INSTANCE;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.sliDistance = new JSlider();
        this.lblLeftNeighbour = new JLabel();
        this.lblRightNeighbour = new JLabel();
        this.lblDistanceLeft = new JLabel();
        this.lblRightDistance = new JLabel();
        this.lblLeftPoint = new JLabel();
        this.lblRightPoint = new JLabel();
        this.panFooter = new JPanel();
        this.lblDescriptionImage = new JLabel();
        this.lblDescription = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jSpinner2 = new JSpinner();
        this.jButton1 = new JButton();
        this.panButtons = new JPanel();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(AddHandleDialog.class, (String)"AddHandleDialog.title"));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.sliDistance.setMajorTickSpacing(100);
        this.sliDistance.setValue(0);
        this.sliDistance.setFocusable(false);
        this.sliDistance.setMaximumSize(new Dimension(206, 54));
        this.sliDistance.setMinimumSize(new Dimension(206, 54));
        this.sliDistance.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AddHandleDialog.this.sliDistanceStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.sliDistance, gridBagConstraints);
        this.lblLeftNeighbour.setHorizontalAlignment(2);
        this.lblLeftNeighbour.setText(NbBundle.getMessage(AddHandleDialog.class, (String)"AddHandleDialog.lblLeftNeighbour.text"));
        this.lblLeftNeighbour.setVerticalAlignment(3);
        this.lblLeftNeighbour.setMaximumSize(new Dimension(150, 17));
        this.lblLeftNeighbour.setMinimumSize(new Dimension(150, 17));
        this.lblLeftNeighbour.setPreferredSize(new Dimension(150, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 25;
        this.jPanel1.add((Component)this.lblLeftNeighbour, gridBagConstraints);
        this.lblRightNeighbour.setHorizontalAlignment(4);
        this.lblRightNeighbour.setText(NbBundle.getMessage(AddHandleDialog.class, (String)"AddHandleDialog.lblRightNeighbour.text"));
        this.lblRightNeighbour.setVerticalAlignment(3);
        this.lblRightNeighbour.setMaximumSize(new Dimension(150, 17));
        this.lblRightNeighbour.setMinimumSize(new Dimension(150, 17));
        this.lblRightNeighbour.setPreferredSize(new Dimension(150, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 26;
        this.jPanel1.add((Component)this.lblRightNeighbour, gridBagConstraints);
        this.lblDistanceLeft.setHorizontalAlignment(4);
        this.lblDistanceLeft.setText(NbBundle.getMessage(AddHandleDialog.class, (String)"AddHandleDialog.lblDistanceLeft.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.lblDistanceLeft, gridBagConstraints);
        this.lblRightDistance.setHorizontalAlignment(2);
        this.lblRightDistance.setText(NbBundle.getMessage(AddHandleDialog.class, (String)"AddHandleDialog.lblDistanceRight.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.lblRightDistance, gridBagConstraints);
        this.lblLeftPoint.setHorizontalAlignment(0);
        this.lblLeftPoint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/neighbourPoint.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.lblLeftPoint, gridBagConstraints);
        this.lblRightPoint.setHorizontalAlignment(0);
        this.lblRightPoint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/neighbourPoint.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.lblRightPoint, gridBagConstraints);
        this.panFooter.setLayout(new GridBagLayout());
        this.lblDescriptionImage.setText(NbBundle.getMessage(AddHandleDialog.class, (String)"AddHandleDialog.lblDescriptionImage.text"));
        this.lblDescriptionImage.setVerticalAlignment(3);
        this.lblDescriptionImage.setPreferredSize(new Dimension(250, 120));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panFooter.add((Component)this.lblDescriptionImage, gridBagConstraints);
        this.lblDescription.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/addHandle.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panFooter.add((Component)this.lblDescription, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel1.add((Component)this.panFooter, gridBagConstraints);
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), null, (Number)1.0));
        this.jSpinner1.setMinimumSize(new Dimension(75, 26));
        this.jSpinner1.setPreferredSize(new Dimension(75, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.jSpinner1, gridBagConstraints);
        ((JSpinner.DefaultEditor)this.jSpinner1.getEditor()).getTextField().getDocument().addDocumentListener(new LeftDocumentListener());
        this.jSpinner2.setModel(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), null, (Number)1.0));
        this.jSpinner2.setMinimumSize(new Dimension(75, 26));
        this.jSpinner2.setPreferredSize(new Dimension(75, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.jSpinner2, gridBagConstraints);
        ((JSpinner.DefaultEditor)this.jSpinner2.getEditor()).getTextField().getDocument().addDocumentListener(new RightDocumentListener());
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/arrow-step.png")));
        this.jButton1.setText(NbBundle.getMessage(AddHandleDialog.class, (String)"AddHandleDialog.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(AddHandleDialog.class, (String)"AddHandleDialog.jButton1.toolTipText"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddHandleDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.panButtons.setLayout(new GridLayout(1, 0, 10, 0));
        this.btnOK.setText(NbBundle.getMessage(AddHandleDialog.class, (String)"AddHandleDialog.btnOK.text"));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddHandleDialog.this.btnOKActionPerformed(evt);
            }
        });
        this.panButtons.add(this.btnOK);
        this.btnCancel.setText(NbBundle.getMessage(AddHandleDialog.class, (String)"AddHandleDialog.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddHandleDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.panButtons.add(this.btnCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 14;
        this.jPanel1.add((Component)this.panButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.returnStatus = 0;
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.returnStatus = 1;
        this.dispose();
    }

    private void sliDistanceStateChanged(ChangeEvent evt) {
        this.sliderValueChanged();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setDistanceToLeft(this.distanceTotal / 2.0);
    }

    private double cut(double value) {
        return (double)((int)(value * 100.0)) / 100.0;
    }

    private void sliderValueChanged() {
        this.sliderLocked = true;
        try {
            this.setDistanceToLeft((double)this.sliDistance.getValue() / (double)this.sliDistance.getMaximum() * this.distanceTotal);
        }
        finally {
            this.sliderLocked = false;
        }
    }

    public void setDistanceToLeft(double distanceToLeft) {
        if (!this.allLocked) {
            this.allLocked = true;
            this.distanceToLeft = distanceToLeft;
            try {
                if (!this.sliderLocked) {
                    this.sliDistance.setValue((int)(this.distanceToLeft / this.distanceTotal * (double)this.sliDistance.getMaximum()));
                }
                if (!this.updateLeftLocked) {
                    this.jSpinner1.setValue(this.cut(this.distanceToLeft));
                }
                if (!this.updateRightLocked) {
                    this.jSpinner2.setValue(this.cut(this.distanceTotal) - this.cut(this.distanceToLeft));
                }
            }
            finally {
                this.allLocked = false;
            }
        }
    }

    public void setDistanceToRight(double distanceToRight) {
        this.setDistanceToLeft(this.distanceTotal - distanceToRight);
    }

    private void leftTextChanged() {
        this.updateLeftLocked = true;
        try {
            double value = (Double)this.jSpinner1.getValue();
            if (this.cut(this.distanceToLeft) != value) {
                this.setDistanceToLeft(value);
            }
        }
        finally {
            this.updateLeftLocked = false;
        }
    }

    private void rightTextChanged() {
        this.updateRightLocked = true;
        try {
            double value = (Double)this.jSpinner2.getValue();
            if (this.cut(this.getDistanceToRight()) != value) {
                this.setDistanceToRight(value);
            }
        }
        finally {
            this.updateRightLocked = false;
        }
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public double getDistanceTotal() {
        return this.distanceTotal;
    }

    public double getDistanceToLeft() {
        return this.distanceToLeft;
    }

    public double getDistanceToRight() {
        return this.distanceTotal - this.distanceToLeft;
    }

    public void setDistanceTotal(double distanceTotal) {
        this.distanceTotal = distanceTotal;
        this.allLocked = true;
        try {
            this.sliDistance.setMaximum(this.sliDistance.getWidth());
            ((SpinnerNumberModel)this.jSpinner1.getModel()).setMaximum(Double.valueOf(distanceTotal));
            ((SpinnerNumberModel)this.jSpinner2.getModel()).setMaximum(Double.valueOf(distanceTotal));
        }
        finally {
            this.allLocked = false;
        }
        this.setDistanceToLeft(distanceTotal / 2.0);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddHandleDialog dialog = AddHandleDialog.getInstance();
                dialog.pack();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    class mySliderUI
    extends BasicSliderUI {
        private final Image newPointImage;

        public mySliderUI(JSlider aSlider) {
            super(aSlider);
            this.newPointImage = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/newPoint.png")).getImage();
        }

        @Override
        public void paintThumb(Graphics g) {
            g.drawImage(this.newPointImage, this.thumbRect.x, this.thumbRect.y, 8, 8, null);
        }
    }

    class RightDocumentListener
    implements DocumentListener {
        RightDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AddHandleDialog.this.rightTextChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AddHandleDialog.this.rightTextChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AddHandleDialog.this.rightTextChanged();
        }
    }

    class LeftDocumentListener
    implements DocumentListener {
        LeftDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AddHandleDialog.this.leftTextChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AddHandleDialog.this.leftTextChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AddHandleDialog.this.leftTextChanged();
        }
    }
}

