/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import de.cismet.cismap.commons.gui.MappingComponent;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import org.apache.log4j.Logger;

public class CustomFixedWidthStroke
extends BasicStroke {
    protected float multiplyer = 1.0f;
    private final Logger log = Logger.getLogger(this.getClass());
    private final MappingComponent mc;

    public CustomFixedWidthStroke(float thickness) {
        this(thickness, null);
    }

    public CustomFixedWidthStroke(float thickness, MappingComponent mc) {
        super(1.0f, 1, 1);
        this.setMultiplyer(thickness);
        this.mc = mc;
    }

    public CustomFixedWidthStroke(float width, int lineCap, int lineJoin, float miterlimit, float[] dash, float dash_phase) {
        this(width, lineCap, lineJoin, miterlimit, dash, dash_phase, null);
    }

    public CustomFixedWidthStroke(float width, int lineCap, int lineJoin, float miterlimit, float[] dash, float dash_phase, MappingComponent mc) {
        super(width, lineCap, lineJoin, miterlimit, dash, dash_phase);
        this.mc = mc;
    }

    private CustomFixedWidthStroke() {
        this.mc = null;
    }

    @Override
    public float getLineWidth() {
        if (PPaintContext.CURRENT_PAINT_CONTEXT != null) {
            if (this.mc != null) {
                return super.getLineWidth() * this.multiplyer * (float)this.mc.getStickyFeatureCorrectionFactor() / (float)this.mc.getCamera().getViewScale();
            }
            return super.getLineWidth() * this.multiplyer / (float)PPaintContext.CURRENT_PAINT_CONTEXT.getScale();
        }
        return super.getLineWidth() * this.multiplyer;
    }

    @Override
    public float getMiterLimit() {
        if (PPaintContext.CURRENT_PAINT_CONTEXT != null) {
            float ml = this.mc != null ? super.getMiterLimit() / (float)this.mc.getCamera().getViewScale() : super.getMiterLimit() / (float)PPaintContext.CURRENT_PAINT_CONTEXT.getScale();
            if (ml < 1.0f) {
                return 1.0f;
            }
            return ml;
        }
        return 1.0f;
    }

    @Override
    public float[] getDashArray() {
        if (PPaintContext.CURRENT_PAINT_CONTEXT != null) {
            float[] dash = super.getDashArray();
            if (dash == null || dash.length == 0) {
                return null;
            }
            float scale = this.mc != null ? (float)this.mc.getCamera().getViewScale() : (float)PPaintContext.CURRENT_PAINT_CONTEXT.getScale();
            float[] temp = new float[dash.length];
            for (int i = dash.length - 1; i >= 0; --i) {
                temp[i] = dash[i] / scale;
            }
            return temp;
        }
        return super.getDashArray();
    }

    @Override
    public float getDashPhase() {
        if (PPaintContext.CURRENT_PAINT_CONTEXT != null) {
            if (this.mc != null) {
                return super.getDashPhase() / (float)this.mc.getCamera().getViewScale();
            }
            return super.getDashPhase() / (float)PPaintContext.CURRENT_PAINT_CONTEXT.getScale();
        }
        return super.getDashPhase();
    }

    public void setMultiplyer(float multiplyer) {
        this.multiplyer = multiplyer;
    }
}

