/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class LinearReferencedPointInfoPanel
extends JPanel {
    private static final Color COLOR_BORDER = new Color(0, 0, 0);
    private static final Color COLOR_BACKGROUND = new Color(210, 210, 210);
    private ImageIcon icoRuler = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/ruler-triangle.png"));
    private final Logger log = Logger.getLogger(this.getClass());
    private PNode pNodeParent;
    private JLabel lblLength;

    public LinearReferencedPointInfoPanel() {
        try {
            this.initComponents();
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in InfoPanel", t);
        }
    }

    private void initComponents() {
        this.lblLength = new JLabel();
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.lblLength.setBackground(UIManager.getDefaults().getColor("Nb.Desktop.background"));
        this.lblLength.setFont(new Font("Tahoma", 0, 12));
        this.lblLength.setIcon(this.icoRuler);
        this.lblLength.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LinearReferencedPointInfoPanel.this.lblLengthMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 4);
        this.add((Component)this.lblLength, gridBagConstraints);
    }

    private void lblLengthMouseClicked(MouseEvent evt) {
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(COLOR_BACKGROUND);
        g.fillRoundRect(2, 1, this.getWidth() - 4, this.getHeight() - 2, 10, 10);
        g.setColor(COLOR_BORDER);
        g.drawRoundRect(2, 1, this.getWidth() - 4, this.getHeight() - 2, 10, 10);
        if (this.pNodeParent != null) {
            this.pNodeParent.setWidth((double)this.getWidth());
            this.pNodeParent.setHeight((double)this.getHeight());
        }
    }

    public void setLengthInfo(String text) {
        this.lblLength.setText(text);
        this.revalidate();
        this.repaint();
    }

    public PNode getPNodeParent() {
        return this.pNodeParent;
    }

    public void setPNodeParent(PNode pNodeParent) {
        this.pNodeParent = pNodeParent;
    }
}

