/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.SignaturedFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.featureinfowidget.FeatureInfoDisplay;
import de.cismet.cismap.commons.gui.featureinfowidget.FeatureInfoWidget;
import de.cismet.cismap.commons.gui.featureinfowidget.MultipleFeatureInfoRequestsDisplay;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.gui.piccolo.FixedPImage;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.HoldFeatureChangeEvent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.HoldListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.MapClickListener;
import de.cismet.cismap.commons.interaction.events.MapClickedEvent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jfree.util.Log;

public class GetFeatureInfoClickDetectionListener
extends PBasicInputEventHandler
implements HoldListener {
    private static final Logger log = Logger.getLogger((String)"de.cismet.cismap.commons.gui.capabilitywidget.CapabilityWidget");
    public static final String FEATURE_INFO_MODE = "FEATURE_INFO_CLICK";
    private static final transient Logger LOG = Logger.getLogger(GetFeatureInfoClickDetectionListener.class);
    private BufferedImage info;
    private FixedPImage pInfo;
    private double lastClickX = 0.0;
    private double lastClickY = 0.0;

    public GetFeatureInfoClickDetectionListener() {
        InputStream is = this.getClass().getResourceAsStream("/de/cismet/cismap/commons/gui/res/featureInfo.png");
        try {
            this.info = ImageIO.read(is);
        }
        catch (IOException ex) {
            LOG.warn((Object)"Could not load featureInfo icon", (Throwable)ex);
        }
        if (this.info == null) {
            String msg = "Could not load featureInfoIcon";
            LOG.error((Object)"Could not load featureInfoIcon");
            throw new IllegalStateException("Could not load featureInfoIcon");
        }
        Graphics2D g2 = (Graphics2D)this.info.getGraphics();
        this.pInfo = new FixedPImage(new ImageIcon(this.info).getImage());
        this.getPInfo().setSweetSpotX(0.5);
        this.getPInfo().setSweetSpotY(1.0);
    }

    public void mouseClicked(PInputEvent pInputEvent) {
        if (pInputEvent.getComponent() instanceof MappingComponent) {
            this.lastClickX = pInputEvent.getPosition().getX();
            this.lastClickY = pInputEvent.getPosition().getY();
            boolean paintFeatureInfoIcon = true;
            Vector<MapClickListener> v = CismapBroker.getInstance().getMapClickListeners();
            for (MapClickListener listener : v) {
                if (!(listener instanceof FeatureInfoWidget)) continue;
                FeatureInfoWidget infoWidget = (FeatureInfoWidget)listener;
                Map<Object, FeatureInfoDisplay> displays = infoWidget.getDisplays();
                Collection<FeatureInfoDisplay> c = displays.values();
                for (FeatureInfoDisplay d : c) {
                    MultipleFeatureInfoRequestsDisplay multiRequestDisplay;
                    if (!(d instanceof MultipleFeatureInfoRequestsDisplay) || !(multiRequestDisplay = (MultipleFeatureInfoRequestsDisplay)((Object)d)).isDisplayVisible()) continue;
                    paintFeatureInfoIcon = false;
                }
            }
            if (paintFeatureInfoIcon) {
                MappingComponent mc = (MappingComponent)pInputEvent.getComponent();
                mc.addStickyNode(this.getPInfo());
                mc.getRubberBandLayer().removeAllChildren();
                mc.getTmpFeatureLayer().removeAllChildren();
                mc.getRubberBandLayer().addChild((PNode)this.getPInfo());
                this.getPInfo().setScale(1.0 / mc.getCamera().getViewScale());
                GeometryFactory fac = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.getCurrentSrid());
                double xCoord = mc.getWtst().getWorldX(pInputEvent.getPosition().getX());
                double yCoord = mc.getWtst().getWorldY(pInputEvent.getPosition().getY());
                Point p = fac.createPoint(new Coordinate(xCoord, yCoord));
                this.getPInfo().setOriginalGeometry(p);
                this.getPInfo().setOffset(pInputEvent.getPosition().getX(), pInputEvent.getPosition().getY());
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.getPInfo().getGlobalBounds().getWidth());
                }
                this.getPInfo().setVisible(true);
                this.getPInfo().repaint();
                mc.repaint();
            }
        }
        CismapBroker.getInstance().fireClickOnMap(new MapClickedEvent(FEATURE_INFO_MODE, pInputEvent));
    }

    public FixedPImage getPInfo() {
        return this.pInfo;
    }

    @Override
    public void holdFeaturesChanged(HoldFeatureChangeEvent evt) {
        this.showCustomFeatureInfo(evt.getHoldFeatures(), evt.getMultipleFeautureInfoRequestDisplay());
    }

    private void showCustomFeatureInfo(Collection<SignaturedFeature> c, MultipleFeatureInfoRequestsDisplay display) {
        MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
        if (!display.isDisplayVisible() || c == null || c.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MultipleFeauteInfoRequestsDisplay is not on hold or holdFeautureCollection is null or empty.");
            }
            return;
        }
        mc.getRubberBandLayer().removeAllChildren();
        mc.getTmpFeatureLayer().removeAllChildren();
        BufferedImage featureInfoIcon = null;
        BufferedImage lastFeatureInfoIcon = null;
        BufferedImage originalFeatureInfoIcon = null;
        InputStream is = this.getClass().getResourceAsStream("/de/cismet/cismap/commons/gui/res/featureInfo.png");
        try {
            originalFeatureInfoIcon = ImageIO.read(is);
            is.close();
            is = this.getClass().getResourceAsStream("/de/cismet/cismap/commons/gui/res/featureInfo.png");
            featureInfoIcon = ImageIO.read(is);
            is.close();
            is = this.getClass().getResourceAsStream("/de/cismet/cismap/commons/gui/res/lastFeatureInfo.png");
            if (is != null) {
                lastFeatureInfoIcon = ImageIO.read(is);
                is.close();
            }
        }
        catch (IOException ex) {
            LOG.warn((Object)"Could not load featureInfo icon", (Throwable)ex);
        }
        if (featureInfoIcon == null) {
            String msg = "Could not load featureInfoIcon";
            LOG.error((Object)"Could not load featureInfoIcon");
            throw new IllegalStateException("Could not load featureInfoIcon");
        }
        if (lastFeatureInfoIcon == null) {
            String msg = "Could not load lastFeatureInfoIcon";
            LOG.error((Object)"Could not load lastFeatureInfoIcon");
        }
        int width = 16;
        int height = 16;
        int xPos = featureInfoIcon.getWidth() - width;
        int yPos = 0;
        int bgR = 255;
        int bgG = 255;
        int bgB = 255;
        Color standardBG = new Color(bgR, bgG, bgB, 1);
        int lastBGR = 255;
        int lastBGG = 255;
        int lastBGB = 255;
        Color lastBG = new Color(lastBGR, lastBGG, lastBGB, 1);
        BufferedImage subimage = featureInfoIcon.getSubimage(xPos, yPos, width, height);
        Graphics2D g2d = (Graphics2D)subimage.getGraphics();
        Properties iconProps = new Properties();
        try {
            InputStream in = this.getClass().getResourceAsStream("/de/cismet/cismap/commons/gui/res/featureInfoIcon.properties");
            if (in != null) {
                iconProps.load(in);
                in.close();
            } else {
                LOG.warn((Object)"Could not laod featureInfoIcon.properties file. Default values for overlay area are used");
            }
        }
        catch (IOException ex) {
            LOG.error((Object)"Could not read featureInfoIcon.properties file. Default values for overlay area are used", (Throwable)ex);
        }
        if (!(!iconProps.isEmpty() && iconProps.containsKey("overlayPositionX") && iconProps.containsKey("overlayPositionY") && iconProps.containsKey("overlayWidth") && iconProps.containsKey("overlayHeigth") && iconProps.containsKey("overlayBackgroundColorR") && iconProps.containsKey("overlayBackgroundColorG") && iconProps.containsKey("overlayBackgroundColorB") && iconProps.containsKey("lastOverlayBackgroundColorR") && iconProps.containsKey("lastOverlayBackgroundColorG") && iconProps.containsKey("lastOverlayBackgroundColorB"))) {
            LOG.warn((Object)"featureInfoIcon.properties file does not contain all needed keys. Default values for overlay area are used");
        } else {
            try {
                xPos = Integer.parseInt((String)iconProps.get("overlayPositionX"));
                yPos = Integer.parseInt((String)iconProps.get("overlayPositionY"));
                width = Integer.parseInt((String)iconProps.get("overlayWidth"));
                height = Integer.parseInt((String)iconProps.get("overlayHeigth"));
                bgR = Integer.parseInt((String)iconProps.get("overlayBackgroundColorR"));
                bgG = Integer.parseInt((String)iconProps.get("overlayBackgroundColorG"));
                bgB = Integer.parseInt((String)iconProps.get("overlayBackgroundColorB"));
                lastBGR = Integer.parseInt((String)iconProps.get("lastOverlayBackgroundColorR"));
                lastBGG = Integer.parseInt((String)iconProps.get("lastOverlayBackgroundColorG"));
                lastBGB = Integer.parseInt((String)iconProps.get("lastOverlayBackgroundColorB"));
                subimage = featureInfoIcon.getSubimage(xPos, yPos, width, height);
                standardBG = new Color(bgR, bgG, bgB);
                lastBG = new Color(lastBGR, lastBGG, lastBGB);
                g2d = (Graphics2D)subimage.getGraphics();
            }
            catch (NumberFormatException ex) {
                Log.error((Object)"Error while retrieving properties for overlay area. Default values for overlay area are used", (Exception)ex);
            }
            catch (Exception e) {
                Log.error((Object)"Could not compute ovaerlay area for feature Info Icon.Default Area is used. Maybe you should check the properties in the properties file", (Exception)e);
            }
        }
        int nr = 0;
        for (SignaturedFeature f : c) {
            FeatureAnnotationSymbol symb;
            DefaultStyledFeature dsf = new DefaultStyledFeature();
            if (f.getOverlayIcon() == null) {
                symb = new FeatureAnnotationSymbol(originalFeatureInfoIcon);
                Log.warn((Object)"OverlayIcon for MultipleFeautreInfoRequestDisplay is null, default FeatureInfoIcon is used");
            } else if (nr == c.size() - 1 && lastFeatureInfoIcon != null) {
                g2d = (Graphics2D)lastFeatureInfoIcon.getSubimage(lastFeatureInfoIcon.getWidth() - 16, 0, 16, 16).getGraphics();
                try {
                    g2d = (Graphics2D)lastFeatureInfoIcon.getSubimage(xPos, yPos, width, height).getGraphics();
                }
                catch (Exception e) {
                    Log.error((Object)"Could not compute ovaerlay area for lastFeatureInfoIcon. Default Area is used. Maybe you should check the properties in the properties file", (Exception)e);
                }
                g2d.drawImage(f.getOverlayIcon(), 0, 0, lastBG, null);
                symb = new FeatureAnnotationSymbol(lastFeatureInfoIcon);
            } else {
                g2d.drawImage(f.getOverlayIcon(), 0, 0, standardBG, null);
                symb = new FeatureAnnotationSymbol(featureInfoIcon);
            }
            symb.setSweetSpotX(0.5);
            symb.setSweetSpotY(0.9);
            dsf.setPointAnnotationSymbol(symb);
            dsf.setGeometry(f.getGeometry());
            PFeature pf = new PFeature(dsf, mc);
            mc.getTmpFeatureLayer().addChild((PNode)pf);
            ++nr;
        }
        mc.rescaleStickyNodes();
        mc.repaint();
    }

    public void addFeatureInfoIconForLastClick() {
        MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
        mc.addStickyNode(this.getPInfo());
        mc.getRubberBandLayer().removeAllChildren();
        mc.getTmpFeatureLayer().removeAllChildren();
        mc.getRubberBandLayer().addChild((PNode)this.getPInfo());
        this.getPInfo().setScale(1.0 / mc.getCamera().getViewScale());
        this.getPInfo().setOffset(this.lastClickX, this.lastClickY);
        if (log.isDebugEnabled()) {
            log.debug((Object)this.getPInfo().getGlobalBounds().getWidth());
        }
        this.getPInfo().setVisible(true);
        this.getPInfo().repaint();
        mc.repaint();
    }
}

