/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.CommonFeatureAction;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.WMSFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.GeometryHeuristics;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.featureinfopanel.WMSGetFeatureInfoDescription;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateGeometryListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.GetFeatureInfoListener;
import de.cismet.cismap.commons.interaction.events.GetFeatureInfoEvent;
import de.cismet.cismap.commons.raster.wms.WMSLayer;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.commons.wms.capabilities.Parameter;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.deegree.model.feature.Feature;
import org.deegree.model.feature.FeatureCollection;
import org.deegree.model.feature.FeatureProperty;
import org.deegree.model.feature.GMLFeatureCollectionDocument;
import org.deegree.model.spatialschema.Geometry;
import org.deegree.model.spatialschema.JTSAdapter;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GetFeatureInfoMultiGeomListener
extends CreateGeometryListener {
    public static final String GET_FEATURE_INFO_MULTI_GEOM_NOTIFICATION = "GET_FEATURE_INFO_MULTI_GEOM_NOTIFICATION";
    private static final String WMS_GML_FORMAT = "application/vnd.ogc.gml";
    private static final String ENCODING_ATTR = "encoding=\"";
    private static final String ENCODING_ATTR_ALT = "encoding='";
    Vector<PFeature> pfVector = new Vector();
    ArrayList<? extends CommonFeatureAction> commonFeatureActions = null;
    private final Logger log = Logger.getLogger(this.getClass());
    private int clickCount = 0;
    private boolean selectionInProgress = false;
    private List<GetFeatureInfoListener> listener = new ArrayList<GetFeatureInfoListener>();
    private ImageIcon pointIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/linRefPoint.png"));

    public GetFeatureInfoMultiGeomListener() {
        Lookup.Result result = Lookup.getDefault().lookupResult(CommonFeatureAction.class);
        this.commonFeatureActions = new ArrayList(result.allInstances());
        Collections.sort(this.commonFeatureActions, new Comparator<CommonFeatureAction>(){

            @Override
            public int compare(CommonFeatureAction o1, CommonFeatureAction o2) {
                return Integer.valueOf(o1.getSorter()).compareTo(o2.getSorter());
            }
        });
        this.setGeometryFeatureClass(PureNewFeature.class);
        this.setMode("BOUNDING_BOX");
    }

    @Override
    public void mouseMoved(PInputEvent pInputEvent) {
        this.setMappingComponent(pInputEvent);
        super.mouseMoved(pInputEvent);
    }

    @Override
    public void mousePressed(PInputEvent pInputEvent) {
        this.setMappingComponent(pInputEvent);
        super.mousePressed(pInputEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(PInputEvent pInputEvent) {
        this.setMappingComponent(pInputEvent);
        super.mouseClicked(pInputEvent);
        if (this.mode.equals("BOUNDING_BOX") || this.mode.equals("ELLIPSE")) {
            this.selectionInProgress = true;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("mouseClicked():" + pInputEvent.getPickedNode()));
                }
                this.clickCount = pInputEvent.getClickCount();
                if (pInputEvent.getComponent() instanceof MappingComponent) {
                    this.mappingComponent = (MappingComponent)pInputEvent.getComponent();
                }
                int currentSrid = CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode());
                PureNewFeature feature = new PureNewFeature((com.vividsolutions.jts.geom.Geometry)this.createPointFromInput(pInputEvent));
                feature.setGeometryType(AbstractNewFeature.geomTypes.POINT);
                feature.getGeometry().setSRID(currentSrid);
                DefaultStyledFeature styledFeature = new DefaultStyledFeature();
                styledFeature.setGeometry((com.vividsolutions.jts.geom.Geometry)this.createPointFromInput(pInputEvent));
                styledFeature.getGeometry().setSRID(currentSrid);
                FeatureAnnotationSymbol fas = new FeatureAnnotationSymbol(this.pointIcon.getImage());
                fas.setSweetSpotX(0.5);
                fas.setSweetSpotY(0.5);
                styledFeature.setPointAnnotationSymbol(fas);
                this.mappingComponent.highlightFeature(styledFeature, 1500);
                this.finishingEvent = pInputEvent;
                this.finishGeometry(feature);
            }
            finally {
                this.selectionInProgress = false;
            }
        }
    }

    public void addGetFeatureInfoListener(GetFeatureInfoListener l) {
        this.listener.add(l);
    }

    public void removeGetFeatureInfoListener(GetFeatureInfoListener l) {
        this.listener.remove(l);
    }

    private Point createPointFromInput(PInputEvent event) {
        Point2D pos = event.getPosition();
        WorldToScreenTransform wtst = this.getMappingComponent().getWtst();
        Coordinate coord = new Coordinate(wtst.getSourceX(pos.getX()), wtst.getSourceY(pos.getY()));
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.getCurrentSrid());
        return gf.createPoint(coord);
    }

    @Override
    public void mouseDragged(PInputEvent e) {
        this.setMappingComponent(e);
        super.mouseDragged(e);
        this.clickCount = e.getClickCount();
    }

    @Override
    public void mouseReleased(PInputEvent event) {
        this.setMappingComponent(event);
        super.mouseReleased(event);
    }

    @Override
    protected Color getFillingColor() {
        return new Color(20, 20, 20, 20);
    }

    @Override
    protected void finishGeometry(final AbstractNewFeature feature) {
        super.finishGeometry(feature);
        this.selectionInProgress = true;
        this.mappingComponent.getHandleLayer().removeAllChildren();
        final com.vividsolutions.jts.geom.Geometry geom = feature.getGeometryType().equals((Object)AbstractNewFeature.geomTypes.POINT) ? feature.getGeometry().buffer(1.0E-6) : feature.getGeometry();
        WaitingDialogThread<List<de.cismet.cismap.commons.features.Feature>> t = new WaitingDialogThread<List<de.cismet.cismap.commons.features.Feature>>(StaticSwingTools.getParentFrame((Component)((Object)this.mappingComponent)), true, NbBundle.getMessage(GetFeatureInfoMultiGeomListener.class, (String)"GetFeatureInfoMultiGeomListener.finishGeometry.WaitingDialogThread"), null, 200, true){

            protected List<de.cismet.cismap.commons.features.Feature> doInBackground() throws Exception {
                List<de.cismet.cismap.commons.features.Feature> toBeSelected = Collections.synchronizedList(new ArrayList());
                if (geom != null) {
                    if (GetFeatureInfoMultiGeomListener.this.log.isDebugEnabled()) {
                        GetFeatureInfoMultiGeomListener.this.log.debug((Object)("Markiergeometrie = " + geom.toText()));
                    }
                    TreeMap<Integer, MapService> serviceTree = ((ActiveLayerModel)GetFeatureInfoMultiGeomListener.this.mappingComponent.getMappingModel()).getMapServices();
                    ExecutorService executor = CismetExecutors.newFixedThreadPool((int)10);
                    Map<MapService, List<de.cismet.cismap.commons.features.Feature>> featureMap = new HashMap(serviceTree.size());
                    featureMap = Collections.synchronizedMap(featureMap);
                    for (Integer key : serviceTree.keySet()) {
                        MapService service = serviceTree.get(key);
                        FeatureRetriever fr = new FeatureRetriever(featureMap, service, geom, feature);
                        executor.submit(fr);
                    }
                    executor.shutdown();
                    executor.awaitTermination(1L, TimeUnit.HOURS);
                    for (MapService service : featureMap.keySet()) {
                        if (featureMap.get(service) == null) continue;
                        toBeSelected.addAll((Collection<de.cismet.cismap.commons.features.Feature>)featureMap.get(service));
                    }
                }
                return toBeSelected;
            }

            protected void done() {
                try {
                    List toBeSelected = (List)this.get();
                    GetFeatureInfoEvent evt = new GetFeatureInfoEvent(GetFeatureInfoMultiGeomListener.this.mappingComponent, geom);
                    evt.setFeatures(toBeSelected);
                    GetFeatureInfoMultiGeomListener.this.fireGetFeatureInfoEvent(evt);
                    GetFeatureInfoMultiGeomListener.this.postSelectionChanged();
                }
                catch (Exception e) {
                    GetFeatureInfoMultiGeomListener.this.log.error((Object)"Error while trying to receiving features.", (Throwable)e);
                }
                finally {
                    GetFeatureInfoMultiGeomListener.this.selectionInProgress = false;
                    GetFeatureInfoMultiGeomListener.this.mappingComponent.getFeatureCollection().removeFeature(feature);
                }
            }
        };
        t.start();
    }

    private List<de.cismet.cismap.commons.features.Feature> getWMSFeatures(String url, WMSServiceLayer wmsServiceLayer, com.vividsolutions.jts.geom.Geometry clickPoint) throws Exception {
        InputStream respIs = WebAccessManager.getInstance().doRequest(new URL(url));
        GMLFeatureCollectionDocument featureCollectionDocument = new GMLFeatureCollectionDocument();
        String res = this.readInputStream(respIs, null);
        String encodingString = null;
        if (res.contains(ENCODING_ATTR)) {
            encodingString = res.substring(res.indexOf(ENCODING_ATTR) + ENCODING_ATTR.length());
            encodingString = encodingString.substring(0, encodingString.indexOf("\""));
        } else if (res.contains(ENCODING_ATTR_ALT)) {
            encodingString = res.substring(res.indexOf(ENCODING_ATTR_ALT) + ENCODING_ATTR_ALT.length());
            encodingString = encodingString.substring(0, encodingString.indexOf("'"));
        }
        if (encodingString != null) {
            res = this.readInputStream(new ByteArrayInputStream(res.getBytes()), encodingString);
        }
        StringReader re = new StringReader(res);
        featureCollectionDocument.load((Reader)re, "http://dummyID");
        if (featureCollectionDocument.getFeatureCount() == 0) {
            return null;
        }
        FeatureCollection featureCollection = featureCollectionDocument.parse();
        if (featureCollection.size() == 1 && featureCollection.getFeature(0).getName() != null && featureCollection.getFeature(0).getName().getLocalName().equals("ExceptionText")) {
            try {
                String errorMessage = featureCollectionDocument.getRootElement().getFirstChild().getFirstChild().getTextContent();
                throw new Exception(errorMessage);
            }
            catch (NullPointerException e) {
                throw new Exception("The wfs replies with an Exception, but the error text cannot be extracted.");
            }
        }
        if (featureCollection.size() > 0) {
            return this.processFeatureCollection(featureCollection.toArray(), true, wmsServiceLayer, clickPoint);
        }
        return new ArrayList<de.cismet.cismap.commons.features.Feature>();
    }

    private String readInputStream(InputStream respIs, String charset) throws IOException {
        String tmp;
        InputStreamReader reader = charset != null ? new InputStreamReader((InputStream)new BufferedInputStream(respIs), charset) : new InputStreamReader(new BufferedInputStream(respIs));
        StringBuilder res = new StringBuilder();
        BufferedReader br = new BufferedReader(reader);
        while ((tmp = br.readLine()) != null) {
            res.append(tmp);
        }
        return res.toString();
    }

    protected List<de.cismet.cismap.commons.features.Feature> processFeatureCollection(Feature[] featureCollection, boolean evaluateExpressions, WMSServiceLayer layer, com.vividsolutions.jts.geom.Geometry clickPoint) throws Exception {
        int i = 0;
        int geometryIndex = GeometryHeuristics.findBestGeometryIndex(featureCollection[0]);
        Vector<de.cismet.cismap.commons.features.Feature> featureVector = new Vector<de.cismet.cismap.commons.features.Feature>(featureCollection.length);
        for (Feature degreeFeature : featureCollection) {
            WMSFeature featureServiceFeature = new WMSFeature(layer);
            int srid = CrsTransformer.getCurrentSrid();
            this.initialiseFeature(featureServiceFeature, degreeFeature, evaluateExpressions, i, geometryIndex, srid, clickPoint);
            featureVector.add(featureServiceFeature);
            ++i;
        }
        return featureVector;
    }

    protected void initialiseFeature(WMSFeature featureServiceFeature, Feature degreeFeature, boolean evaluateExpressions, int index, int geometryIndex, int featureSrid, com.vividsolutions.jts.geom.Geometry clickPoint) throws Exception {
        featureServiceFeature.setLayerProperties(new DefaultLayerProperties());
        if (featureServiceFeature.getGeometry() == null) {
            try {
                featureServiceFeature.setGeometry(JTSAdapter.export((Geometry)degreeFeature.getGeometryPropertyValues()[geometryIndex]));
            }
            catch (Exception e) {
                featureServiceFeature.setGeometry(clickPoint);
            }
        }
        if (featureServiceFeature.getGeometry() != null) {
            featureServiceFeature.getGeometry().setSRID(featureSrid);
        }
        if (degreeFeature.getProperties() != null && degreeFeature.getProperties().length > 0) {
            FeatureProperty[] featureProperties;
            for (FeatureProperty fp : featureProperties = degreeFeature.getProperties()) {
                featureServiceFeature.addProperty(fp.getName().getAsString(), fp.getValue());
            }
        }
    }

    public void fireGetFeatureInfoEvent(GetFeatureInfoEvent evt) {
        for (GetFeatureInfoListener l : this.listener) {
            l.getFeatureInfoRequest(evt);
        }
    }

    private void setMappingComponent(PInputEvent pInputEvent) {
        if (this.getMappingComponent() == null) {
            super.setMappingComponent((MappingComponent)pInputEvent.getComponent());
        }
    }

    private void postSelectionChanged() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"postSelectionChanged");
        }
        PNotificationCenter pn = PNotificationCenter.defaultCenter();
        pn.postNotification(GET_FEATURE_INFO_MULTI_GEOM_NOTIFICATION, (Object)this);
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public boolean isSelectionInProgress() {
        return this.selectionInProgress;
    }

    public void setSelectionInProgress(boolean selectionInProgress) {
        this.selectionInProgress = selectionInProgress;
    }

    private class FeatureRetriever
    implements Runnable {
        private final Map<MapService, List<de.cismet.cismap.commons.features.Feature>> featureMap;
        private final MapService service;
        private final com.vividsolutions.jts.geom.Geometry geom;
        private final AbstractNewFeature feature;

        public FeatureRetriever(Map<MapService, List<de.cismet.cismap.commons.features.Feature>> featureMap, MapService service, com.vividsolutions.jts.geom.Geometry geom, AbstractNewFeature feature) {
            this.featureMap = featureMap;
            this.service = service;
            this.geom = geom;
            this.feature = feature;
        }

        @Override
        public void run() {
            WMSServiceLayer wmsService;
            List<Object> featuresFromService = new ArrayList();
            if (this.service instanceof AbstractFeatureService) {
                try {
                    AbstractFeatureService featureService = (AbstractFeatureService)this.service;
                    if (!featureService.isInitialized()) {
                        featureService.initAndWait();
                    }
                    featuresFromService = featureService.getFeatureFactory().createFeatures(featureService.getQuery(), new XBoundingBox(this.geom), null, 0, Integer.MAX_VALUE, null);
                }
                catch (Exception e) {
                    GetFeatureInfoMultiGeomListener.this.log.error((Object)"Error while receiving features", (Throwable)e);
                }
            } else if (this.feature.getGeometryType().equals((Object)AbstractNewFeature.geomTypes.POINT) && this.service instanceof WMSServiceLayer && (wmsService = (WMSServiceLayer)this.service).isQueryable() && wmsService.getWmsCapabilities().getRequest().getFeatureInfoOperation() != null) {
                Parameter p = wmsService.getWmsCapabilities().getRequest().getFeatureInfoOperation().getParameter("Format");
                boolean gmlResponsePossible = p != null && p.getAllowedValues() != null && p.getAllowedValues().contains(GetFeatureInfoMultiGeomListener.WMS_GML_FORMAT);
                for (WMSLayer layer : wmsService.getWMSLayers()) {
                    if (gmlResponsePossible) {
                        try {
                            featuresFromService.addAll(GetFeatureInfoMultiGeomListener.this.getWMSFeatures(wmsService.getGetFeatureInfoUrl((int)GetFeatureInfoMultiGeomListener.this.finishingEvent.getCanvasPosition().getX(), (int)GetFeatureInfoMultiGeomListener.this.finishingEvent.getCanvasPosition().getY(), layer, GetFeatureInfoMultiGeomListener.WMS_GML_FORMAT), wmsService, this.feature.getGeometry()));
                        }
                        catch (Exception e) {
                            GetFeatureInfoMultiGeomListener.this.log.error((Object)"Error while retrieving features from wms", (Throwable)e);
                        }
                        continue;
                    }
                    featuresFromService.add(new WMSGetFeatureInfoDescription(this.feature.getGeometry(), GetFeatureInfoMultiGeomListener.this.finishingEvent, layer, wmsService));
                }
            }
            this.featureMap.put(this.service, featuresFromService);
        }
    }
}

