/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequenceFactory;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.FixedWidthStroke;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.PFeatureTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MeasurementListener
extends PBasicInputEventHandler {
    public static final String LENGTH_CHANGED = "LENGTH_CHANGED";
    protected Point2D startPoint;
    protected PPath tempFeature;
    protected MappingComponent mc;
    protected boolean inProgress;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private Vector points;
    private double measuredLength = 0.0;

    public MeasurementListener(MappingComponent mc) {
        this.mc = mc;
    }

    public void mouseMoved(PInputEvent pInputEvent) {
        super.mouseMoved(pInputEvent);
        if (this.inProgress) {
            Point2D point = this.mc.isSnappingEnabled() ? PFeatureTools.getNearestPointInArea(this.mc, pInputEvent.getCanvasPosition(), true, null).getPoint() : pInputEvent.getPosition();
            this.updatePolygon(point);
        }
    }

    public void mouseClicked(PInputEvent pInputEvent) {
        super.mouseClicked(pInputEvent);
        if (pInputEvent.getButton() == 1) {
            if (pInputEvent.getClickCount() == 1) {
                Point2D point;
                Point2D point2D = point = this.mc.isSnappingEnabled() ? PFeatureTools.getNearestPointInArea(this.mc, pInputEvent.getCanvasPosition(), true, null).getPoint() : pInputEvent.getPosition();
                if (!this.inProgress) {
                    this.tempFeature = new PPath();
                    this.points = new Vector();
                    FixedWidthStroke fws = new FixedWidthStroke();
                    fws.setMultiplyer(3.0f);
                    this.tempFeature.setStroke((Stroke)fws);
                    this.mc.getTmpFeatureLayer().removeAllChildren();
                    this.mc.getTmpFeatureLayer().addChild((PNode)this.tempFeature);
                    this.startPoint = point;
                    this.points.add(this.startPoint);
                    this.inProgress = true;
                } else {
                    this.points.add(point);
                    this.updatePolygon(null);
                }
            } else if (pInputEvent.getClickCount() == 2) {
                this.mc.getTmpFeatureLayer().removeAllChildren();
                this.measuredLength = this.getLength(this.getPoints(null));
                this.postLength();
                this.inProgress = false;
            }
        }
    }

    private double getLength(Point2D[] canvasPoints) {
        Coordinate[] coordArr = new Coordinate[canvasPoints.length];
        float[] xp = new float[canvasPoints.length];
        float[] yp = new float[canvasPoints.length];
        for (int i = 0; i < canvasPoints.length; ++i) {
            xp[i] = (float)canvasPoints[i].getX();
            yp[i] = (float)canvasPoints[i].getY();
            coordArr[i] = new Coordinate(this.mc.getWtst().getSourceX((double)xp[i] - this.mc.getClip_offset_x()), this.mc.getWtst().getSourceY((double)yp[i] - this.mc.getClip_offset_y()));
        }
        CoordinateSequence cs = new PackedCoordinateSequenceFactory().create(coordArr);
        LineString ls = new LineString(cs, new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.getCurrentSrid()));
        LineString geom = CrsTransformer.transformToMetricCrs(ls, CismapBroker.getInstance().getMappingComponent().getCrsList());
        double l = geom.getLength();
        return l;
    }

    protected Color getFillingColor() {
        return new Color(1.0f, 0.0f, 0.0f, 0.5f);
    }

    protected void updatePolygon(Point2D lastPoint) {
        Point2D[] p = this.getPoints(lastPoint);
        this.tempFeature.setPathToPolyline(p);
        this.tempFeature.repaint();
        this.measuredLength = this.getLength(p);
        this.postLength();
    }

    protected Point2D[] getPoints(Point2D lastPoint) {
        int plus;
        boolean movin = false;
        if (lastPoint != null) {
            plus = 1;
            movin = true;
        } else {
            plus = 0;
            movin = false;
        }
        Point2D[] p = new Point2D[this.points.size() + plus];
        for (int i = 0; i < this.points.size(); ++i) {
            p[i] = (Point2D)this.points.get(i);
        }
        if (movin) {
            p[this.points.size()] = lastPoint;
        }
        return p;
    }

    protected void postLength() {
        PNotificationCenter pn = PNotificationCenter.defaultCenter();
        pn.postNotification(LENGTH_CHANGED, (Object)this);
    }

    public double getMeasuredLength() {
        return this.measuredLength;
    }

    public void setMeasuredLength(double measuredLength) {
        this.measuredLength = measuredLength;
    }
}

