/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.CustomFixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.EllipsePHandle;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.RubberBandZoomListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureDeleteAction;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.PFeatureTools;
import de.cismet.tools.collections.TypeSafeCollections;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class MessenGeometryListener
extends PBasicInputEventHandler
implements FeatureCollectionListener {
    public static final String LINESTRING = "LINESTRING";
    public static final String POINT = "POINT";
    public static final String POLYGON = "POLYGON";
    public static final String RECTANGLE = "BOUNDING_BOX";
    public static final String ELLIPSE = "ELLIPSE";
    private static final int NUMOF_ELLIPSE_EDGES = 36;
    public static final String GEOMETRY_CREATED_NOTIFICATION = "GEOMETRY_CREATED_NOTIFICATION";
    private static final Color FALLBACK_PAINT_COLOR = new Color(255, 0, 255, 45);
    private static final Color FALLBACK_LINE_COLOR = FALLBACK_PAINT_COLOR.darker();
    private static final int FALLBACK_LINE_WIDTH = 1;
    protected Point2D startPoint;
    protected PPath tempFeature;
    protected MappingComponent mc;
    protected boolean inProgress;
    private final Logger log = Logger.getLogger(this.getClass());
    private final List<Point2D> points = TypeSafeCollections.newArrayList();
    private final List<Point2D> undoPoints = TypeSafeCollections.newArrayList();
    private int numOfEllipseEdges;
    private String mode = "POLYGON";
    private Class<? extends PureNewFeature> geometryFeatureClass = null;
    private final PBasicInputEventHandler zoomDelegate;
    private Feature latestCreation = null;

    public MessenGeometryListener(MappingComponent mc) {
        this(mc, PureNewFeature.class);
    }

    protected MessenGeometryListener(MappingComponent mc, Class geometryFeatureClass) {
        this.setGeometryFeatureClass(geometryFeatureClass);
        this.zoomDelegate = new RubberBandZoomListener();
        this.mc = mc;
        this.undoPoints.clear();
        mc.getFeatureCollection().addFeatureCollectionListener(this);
    }

    public void setMode(String m) throws IllegalArgumentException {
        if (!(m.equals(LINESTRING) || m.equals(POINT) || m.equals(POLYGON) || m.equals(ELLIPSE) || m.equals(RECTANGLE))) {
            throw new IllegalArgumentException("Mode:" + m + " is not a valid Mode in this Listener.");
        }
        this.mode = m;
        this.mc.getTmpFeatureLayer().removeAllChildren();
        this.inProgress = false;
    }

    public void mouseMoved(PInputEvent pInputEvent) {
        super.mouseMoved(pInputEvent);
        if (this.inProgress) {
            Point2D point = this.mc.isSnappingEnabled() ? PFeatureTools.getNearestPointInArea(this.mc, pInputEvent.getCanvasPosition(), true, null).getPoint() : pInputEvent.getPosition();
            this.updatePolygon(point);
        }
    }

    public void mousePressed(PInputEvent pInputEvent) {
        super.mouseClicked(pInputEvent);
        if (this.mc.isReadOnly()) {
            ((DefaultFeatureCollection)this.mc.getFeatureCollection()).removeFeaturesByInstance(Feature.class);
        }
        if (this.isInMode(POINT)) {
            if (pInputEvent.isLeftMouseButton()) {
                Point2D point = this.mc.isSnappingEnabled() ? PFeatureTools.getNearestPointInArea(this.mc, pInputEvent.getCanvasPosition(), true, null).getPoint() : pInputEvent.getPosition();
                try {
                    Constructor<? extends PureNewFeature> c = this.geometryFeatureClass.getConstructor(Point2D.class, WorldToScreenTransform.class);
                    PureNewFeature pnf = c.newInstance(point, this.mc.getWtst());
                    this.applyCurrentStyle(pnf);
                    pnf.setGeometryType(AbstractNewFeature.geomTypes.POINT);
                    this.finishGeometry(pnf);
                }
                catch (Throwable t) {
                    this.log.error((Object)("Fehler beim Erzeugen der Geometrie: " + this.geometryFeatureClass), t);
                }
            }
        } else if (this.isInMode(RECTANGLE)) {
            if (!this.inProgress) {
                this.tempFeature = this.initTempFeature(true);
                this.mc.getTmpFeatureLayer().addChild((PNode)this.tempFeature);
                this.startPoint = pInputEvent.getPosition();
            }
        } else if (this.isInMode(ELLIPSE)) {
            if (!this.inProgress) {
                this.tempFeature = this.initTempFeature(true);
                this.mc.getTmpFeatureLayer().addChild((PNode)this.tempFeature);
                this.startPoint = pInputEvent.getPosition();
            }
        } else if (this.isInMode(POLYGON) || this.isInMode(LINESTRING)) {
            if (pInputEvent.getClickCount() == 1) {
                Point2D point;
                this.undoPoints.clear();
                Point2D point2D = point = this.mc.isSnappingEnabled() ? PFeatureTools.getNearestPointInArea(this.mc, pInputEvent.getCanvasPosition(), true, null).getPoint() : pInputEvent.getPosition();
                if (!this.inProgress) {
                    this.tempFeature = this.isInMode(POLYGON) ? this.initTempFeature(true) : this.initTempFeature(false);
                    this.mc.getTmpFeatureLayer().addChild((PNode)this.tempFeature);
                    this.points.clear();
                    this.startPoint = point;
                    this.points.add(this.startPoint);
                    if (this.latestCreation != null) {
                        this.mc.getFeatureCollection().removeFeature(this.latestCreation);
                    }
                    this.inProgress = true;
                } else {
                    this.points.add(point);
                    this.updatePolygon(null);
                }
            } else if (pInputEvent.getClickCount() == 2) {
                try {
                    Constructor<? extends PureNewFeature> c = this.geometryFeatureClass.getConstructor(Point2D[].class, WorldToScreenTransform.class);
                    Object[] p = this.getFinalPoints(null);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Anzahl Punkte:" + p.length + " (" + Arrays.deepToString(p) + ")"));
                    }
                    PureNewFeature pnf = c.newInstance(p, this.mc.getWtst());
                    this.applyCurrentStyle(pnf);
                    if (this.isInMode(POLYGON)) {
                        pnf.setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                    } else if (this.isInMode(LINESTRING)) {
                        pnf.setGeometryType(AbstractNewFeature.geomTypes.LINESTRING);
                    }
                    this.finishGeometry(pnf);
                }
                catch (Throwable t) {
                    this.log.error((Object)("Fehler beim Erzeugen der Geometrie: " + this.geometryFeatureClass), t);
                }
                this.inProgress = false;
            }
        }
    }

    public void mouseReleased(PInputEvent arg0) {
        super.mouseReleased(arg0);
        if ((this.isInMode(RECTANGLE) || this.isInMode(ELLIPSE)) && this.inProgress) {
            try {
                Constructor<? extends PureNewFeature> c = this.geometryFeatureClass.getConstructor(Point2D[].class, WorldToScreenTransform.class);
                Object[] p = this.getFinalPoints(null);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Anzahl Punkte:" + p.length + " (" + Arrays.deepToString(p) + ")"));
                }
                PureNewFeature pnf = c.newInstance(p, this.mc.getWtst());
                this.applyCurrentStyle(pnf);
                if (this.isInMode(RECTANGLE)) {
                    pnf.setGeometryType(AbstractNewFeature.geomTypes.RECTANGLE);
                } else {
                    pnf.setGeometryType(AbstractNewFeature.geomTypes.ELLIPSE);
                }
                this.finishGeometry(pnf);
            }
            catch (Throwable ex) {
                this.log.error((Object)"", ex);
            }
            this.inProgress = false;
        }
    }

    public void keyPressed(PInputEvent event) {
        if (this.inProgress) {
            if (!event.isControlDown() && this.points.size() > 0) {
                this.undoPoints.add(this.points.get(this.points.size() - 1));
                this.points.remove(this.points.size() - 1);
                if (this.points.size() == 0) {
                    this.startPoint = null;
                    this.mc.getTmpFeatureLayer().removeAllChildren();
                    this.inProgress = false;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Backspace gedr\u00fcckt: letzter eingef\u00fcgter Punkt gel\u00f6scht.");
                }
                this.updatePolygon(null);
            } else if (event.isControlDown() && !this.undoPoints.isEmpty()) {
                this.points.add(this.undoPoints.remove(this.undoPoints.size() - 1));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Backspace + STRG gedr\u00fcckt: letzter gel\u00f6schter Punkt wiederhergestellt.");
                }
                this.updatePolygon(null);
            }
        } else if (!this.inProgress && this.points.isEmpty() && event.isControlDown()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Versuche Polygon und Startpunkt wiederherzustellen");
            }
            this.tempFeature = this.initTempFeature(true);
            this.mc.getTmpFeatureLayer().addChild((PNode)this.tempFeature);
            this.startPoint = this.undoPoints.remove(this.undoPoints.size() - 1);
            this.points.add(this.startPoint);
            this.inProgress = true;
        }
    }

    private void createAction(MappingComponent m, PureNewFeature f) {
        this.mc.getMemUndo().addAction(new FeatureDeleteAction(m, f));
        this.mc.getMemRedo().clear();
    }

    protected Color getFillingColor() {
        Color fillingColor = CismapBroker.getInstance().getMeasurementFillingColor();
        return fillingColor != null ? fillingColor : FALLBACK_PAINT_COLOR;
    }

    protected Color getLineColor() {
        Color lineColor = CismapBroker.getInstance().getMeasurementLineColor();
        return lineColor != null ? lineColor : FALLBACK_LINE_COLOR;
    }

    protected int getLineWidth() {
        Integer lineWitdth = CismapBroker.getInstance().getMeasurementLineWidth();
        return lineWitdth != null ? lineWitdth : 1;
    }

    private void applyCurrentStyle(Feature toProcess) {
        if (toProcess instanceof StyledFeature) {
            Color fillingColor = this.getFillingColor();
            StyledFeature sf = (StyledFeature)toProcess;
            sf.setLineWidth(this.getLineWidth());
            sf.setFillingPaint(fillingColor);
            sf.setLinePaint(this.getLineColor());
            sf.setTransparency((float)fillingColor.getTransparency() / 255.0f);
        }
    }

    protected void updatePolygon(Point2D lastPoint) {
        Point2D[] p = this.getPoints(lastPoint);
        Feature pnf = null;
        try {
            Constructor<? extends PureNewFeature> c = this.geometryFeatureClass.getConstructor(Point2D[].class, WorldToScreenTransform.class);
            pnf = c.newInstance(p, this.mc.getWtst());
            this.applyCurrentStyle(pnf);
        }
        catch (Throwable t) {
            this.log.error((Object)"Fehler beim Erzeugen der Geometrie", t);
        }
        ArrayList v = TypeSafeCollections.newArrayList((int)1);
        v.add(pnf);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("hinzugef\u00fcgt:" + pnf));
        }
        ((DefaultFeatureCollection)this.mc.getFeatureCollection()).fireFeaturesChanged(v);
        this.tempFeature.setPathToPolyline(p);
        this.tempFeature.repaint();
    }

    protected Point2D[] getFinalPoints(Point2D lastPoint) {
        return this.getPoints(true, lastPoint);
    }

    protected Point2D[] getPoints(Point2D lastPoint) {
        return this.getPoints(false, lastPoint);
    }

    protected Point2D[] getPoints(boolean isFinal, Point2D lastPoint) {
        boolean movin = false;
        try {
            int plus;
            if (lastPoint != null) {
                plus = 2;
                movin = true;
            } else {
                plus = 1;
                movin = false;
            }
            if (!this.isInMode(POLYGON) || this.isInMode(POLYGON) && this.points.size() == 2 && !movin) {
                --plus;
            }
            if (isFinal && this.isInMode(POLYGON) && this.points.size() == 2 && !movin) {
                Point2D[] p = new Point2D[5];
                p[0] = this.points.get(0);
                p[2] = this.points.get(1);
                p[1] = new Point2D.Double(p[0].getX(), p[2].getY());
                p[3] = new Point2D.Double(p[2].getX(), p[0].getY());
                p[4] = p[0];
                return p;
            }
            Point2D[] p = new Point2D[this.points.size() + plus];
            for (int i = 0; i < this.points.size(); ++i) {
                p[i] = this.points.get(i);
            }
            if (movin) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"movin");
                }
                p[this.points.size()] = lastPoint;
                if (this.isInMode(POLYGON)) {
                    p[this.points.size() + 1] = this.startPoint;
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"not movin");
                }
                if (this.points.size() > 2 && this.isInMode(POLYGON)) {
                    p[this.points.size()] = this.startPoint;
                }
            }
            return p;
        }
        catch (Exception e) {
            this.log.warn((Object)"Fehler in getPoints()", (Throwable)e);
            return new Point2D[0];
        }
    }

    public boolean isInMode(String mode) {
        return this.mode.equals(mode);
    }

    public String getMode() {
        return this.mode;
    }

    public Class getGeometryFeatureClass() {
        return this.geometryFeatureClass;
    }

    public void setGeometryFeatureClass(Class<? extends PureNewFeature> geometryFeatureClass) {
        this.geometryFeatureClass = geometryFeatureClass;
    }

    private void postGeometryCreatedNotificaton(PureNewFeature newFeature) {
        PNotificationCenter pn = PNotificationCenter.defaultCenter();
        pn.postNotification(GEOMETRY_CREATED_NOTIFICATION, (Object)newFeature);
    }

    @Override
    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        super.mouseDragged(pInputEvent);
        if (this.isInMode(RECTANGLE)) {
            this.inProgress = true;
            this.points.clear();
            this.points.add(this.startPoint);
            this.points.add(new Point2D.Double(this.startPoint.getX(), pInputEvent.getPosition().getY()));
            this.points.add(pInputEvent.getPosition());
            this.points.add(new Point2D.Double(pInputEvent.getPosition().getX(), this.startPoint.getY()));
            this.points.add(this.startPoint);
            this.updatePolygon(null);
        } else if (this.isInMode(ELLIPSE)) {
            this.inProgress = true;
            Point2D dragPoint = pInputEvent.getPosition();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("pInputEvent.getModifiers() = " + pInputEvent.getModifiers()));
            }
            double a = this.startPoint.getX() - dragPoint.getX();
            double b = this.startPoint.getY() - dragPoint.getY();
            double startX = this.startPoint.getX();
            double startY = this.startPoint.getY();
            Coordinate[] coordArr = EllipsePHandle.createEllipseCoordinates(this.getNumOfEllipseEdges(), a, b, pInputEvent.isControlDown(), pInputEvent.isShiftDown());
            this.points.clear();
            for (int i = 0; i < coordArr.length; ++i) {
                this.points.add(new Point2D.Double(startX - coordArr[i].x, startY - coordArr[i].y));
            }
            this.updatePolygon(null);
        }
    }

    @Override
    public void featureCollectionChanged() {
    }

    @Override
    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
    }

    @Override
    public void featureSelectionChanged(FeatureCollectionEvent fce) {
    }

    @Override
    public void featuresAdded(FeatureCollectionEvent fce) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Features added to map");
        }
        for (Feature curFeature : fce.getEventFeatures()) {
            if (!(curFeature instanceof PureNewFeature)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Added Feature is PureNewFeature. PostingGeometryCreateNotification");
            }
            this.postGeometryCreatedNotificaton((PureNewFeature)curFeature);
            this.createAction(this.mc, (PureNewFeature)curFeature);
        }
    }

    @Override
    public void featuresChanged(FeatureCollectionEvent fce) {
    }

    @Override
    public void featuresRemoved(FeatureCollectionEvent fce) {
    }

    protected void finishGeometry(PureNewFeature newFeature) {
        this.latestCreation = newFeature;
        this.mc.getTmpFeatureLayer().removeAllChildren();
        newFeature.setEditable(true);
        this.mc.getFeatureCollection().addFeature(newFeature);
    }

    public void setNumOfEllipseEdges(int numOfEllipseEdges) {
        if (numOfEllipseEdges <= 2) {
            numOfEllipseEdges = 36;
        }
        this.numOfEllipseEdges = numOfEllipseEdges;
    }

    public int getNumOfEllipseEdges() {
        return this.numOfEllipseEdges;
    }

    protected PPath initTempFeature(boolean filled) {
        this.tempFeature = new PPath();
        this.tempFeature.setStroke((Stroke)new CustomFixedWidthStroke(this.getLineWidth()));
        Color fillingColor = this.getFillingColor();
        this.tempFeature.setStrokePaint((Paint)this.getLineColor());
        if (filled) {
            this.tempFeature.setPaint((Paint)fillingColor);
        } else {
            this.tempFeature.setPaint(null);
        }
        return this.tempFeature;
    }

    public void mouseWheelRotated(PInputEvent evt) {
        this.zoomDelegate.mouseWheelRotated(evt);
        this.mouseMoved(evt);
    }
}

