/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import de.cismet.cismap.commons.features.SearchFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.AbstractCreateSearchGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MetaSearchCreateSearchGeometryListener;
import java.awt.Color;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class MetaSearchFollowingCreateSearchGeometryListener
extends AbstractCreateSearchGeometryListener
implements PropertyChangeListener {
    public static final String ACTION_SEARCH_STARTED = "ACTION_SEARCH_STARTED";
    private final MetaSearchCreateSearchGeometryListener metaSearchListener;

    public MetaSearchFollowingCreateSearchGeometryListener(MappingComponent mappingComponent, String listenerName) {
        super(mappingComponent, listenerName);
        this.metaSearchListener = (MetaSearchCreateSearchGeometryListener)mappingComponent.getInputListener("SEARCH_POLYGON");
        this.metaSearchListener.addPropertyChangeListener(this);
        mappingComponent.addCustomInputListener(listenerName, this);
        mappingComponent.putCursor(listenerName, new Cursor(1));
        this.setMode(this.metaSearchListener.getMode());
        this.setLastFeature(this.metaSearchListener.getLastSearchFeature());
        this.setNumOfEllipseEdges(this.metaSearchListener.getNumOfEllipseEdges());
        this.setHoldGeometries(this.metaSearchListener.isHoldingGeometries());
        this.setSearchColor(this.metaSearchListener.getSearchColor());
        this.setSearchTransparency(this.metaSearchListener.getSearchTransparency());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        if ("INTERACTION_MODE".equals(propertyName)) {
            if (this.getInputListenerName().equals(newValue)) {
                this.generateAndShowPointerAnnotation();
            }
        } else if ("PROPERTY_LAST_FEATURE".equals(propertyName)) {
            super.setLastFeature((SearchFeature)newValue);
        } else if ("PROPERTY_MODE".equals(propertyName)) {
            super.setMode(newValue.toString());
        } else if ("PROPERTY_HOLD_GEOMETRIES".equals(propertyName) && newValue instanceof Boolean) {
            super.setHoldGeometries((Boolean)newValue);
        } else if ("PROPERTY_NUM_OF_ELLIPSE_EDGES".equals(propertyName) && newValue instanceof Integer) {
            super.setNumOfEllipseEdges((Integer)newValue);
        } else if ("PROPERTY_SEARCH_COLOR".equals(propertyName) && newValue instanceof Color) {
            super.setSearchColor((Color)newValue);
        } else if ("PROPERTY_SEARCH_TRANSPARENCY".equals(propertyName) && newValue instanceof Float) {
            super.setSearchTransparency(((Float)newValue).floatValue());
        }
    }

    @Override
    public final void setMode(String newValue) throws IllegalArgumentException {
        super.setMode(newValue);
        this.metaSearchListener.setMode(newValue);
    }

    @Override
    public final void setLastFeature(SearchFeature newValue) {
        super.setLastFeature(newValue);
        this.metaSearchListener.setLastFeature(newValue);
    }

    @Override
    public final void setNumOfEllipseEdges(int newValue) {
        super.setNumOfEllipseEdges(newValue);
        this.metaSearchListener.setNumOfEllipseEdges(newValue);
    }

    @Override
    public final void setHoldGeometries(boolean newValue) {
        super.setHoldGeometries(newValue);
        this.metaSearchListener.setHoldGeometries(newValue);
    }

    @Override
    public final void setSearchColor(Color newValue) {
        super.setSearchColor(newValue);
        this.metaSearchListener.setSearchColor(newValue);
    }

    @Override
    public final void setSearchTransparency(float newValue) {
        super.setSearchTransparency(newValue);
        this.metaSearchListener.setSearchTransparency(newValue);
    }

    @Override
    protected boolean performSearch(SearchFeature searchFeature) {
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        this.setLastFeature(searchFeature);
        propertyChangeSupport.firePropertyChange(ACTION_SEARCH_STARTED, null, searchFeature.getGeometry());
        return true;
    }
}

