/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.PHandle;
import de.cismet.cismap.commons.tools.PFeatureTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class PerpendicularIntersectionListener
extends PBasicInputEventHandler {
    private static final Logger LOG = Logger.getLogger(PerpendicularIntersectionListener.class);
    private static final Color COLOR_PERPENDICULAR_HANDLE = new Color(205, 133, 0, 150);
    private final MappingComponent mappingComponent;
    private LineSegment perpendicularSegment = null;
    private Coordinate perpendicularCoordinate;
    private PPath perpendicularPathLine = null;
    private PHandle perpendicularHandle = null;
    private PLocator locator = null;
    private Feature selectedFeature = null;
    private Collection<AddHandle> addHandles = new ArrayList<AddHandle>();
    private Collection<PHandle> featureHandles = new ArrayList<PHandle>();
    private Stage stage = Stage.SELECT_FEATURE;

    public PerpendicularIntersectionListener(MappingComponent mappingComponent) {
        this.mappingComponent = mappingComponent;
        this.perpendicularPathLine = new PPath();
        this.locator = new PLocator(){

            public double locateX() {
                if (PerpendicularIntersectionListener.this.perpendicularCoordinate != null) {
                    return ((PerpendicularIntersectionListener)PerpendicularIntersectionListener.this).perpendicularCoordinate.x;
                }
                return Double.MIN_VALUE;
            }

            public double locateY() {
                if (PerpendicularIntersectionListener.this.perpendicularCoordinate != null) {
                    return ((PerpendicularIntersectionListener)PerpendicularIntersectionListener.this).perpendicularCoordinate.y;
                }
                return Double.MIN_VALUE;
            }
        };
        this.perpendicularHandle = new PHandle(this.locator, mappingComponent){

            @Override
            public void handleClicked(PInputEvent e) {
                PerpendicularIntersectionListener.this.finishCreatePerpendicular();
            }
        };
        this.perpendicularHandle.setPaint(COLOR_PERPENDICULAR_HANDLE);
    }

    private void createFeatureHandles(Feature feature) {
        this.createFeatureHandles(feature, this.stage == Stage.ADD_HANDLES);
    }

    private void createFeatureHandles(Feature feature, boolean isInAddHandleStage) {
        this.createFeatureHandles(Arrays.asList(feature), isInAddHandleStage);
    }

    private synchronized void createFeatureHandles(Collection col, boolean isInAddHandleStage) {
        if (isInAddHandleStage) {
            this.addHandles.clear();
        }
        this.featureHandles.clear();
        for (Object obj : col) {
            Geometry geometry;
            if (!(obj instanceof Feature) || !((Feature)obj).isEditable()) continue;
            Feature feature = (Feature)obj;
            PFeature pFeature = this.mappingComponent.getPFeatureHM().get(feature);
            if (pFeature == null || !((geometry = pFeature.getFeature().getGeometry()) instanceof Polygon) && !(geometry instanceof LineString) && !(geometry instanceof MultiPolygon)) continue;
            for (int entityIndex = 0; entityIndex < pFeature.getNumOfEntities(); ++entityIndex) {
                for (int ringIndex = 0; ringIndex < pFeature.getNumOfRings(entityIndex); ++ringIndex) {
                    float[] xp = pFeature.getXp(entityIndex, ringIndex);
                    float[] yp = pFeature.getYp(entityIndex, ringIndex);
                    for (int coordPosition = xp.length - 1; coordPosition > 0; --coordPosition) {
                        Coordinate intersectionCoord;
                        final LineSegment segment = new LineSegment((double)xp[coordPosition - 1], (double)yp[coordPosition - 1], (double)xp[coordPosition], (double)yp[coordPosition]);
                        this.featureHandles.add(new PHandle(new PLocator(){

                            public double locateX() {
                                return segment.p0.x;
                            }

                            public double locateY() {
                                return segment.p0.y;
                            }
                        }, this.mappingComponent));
                        if (!isInAddHandleStage || (intersectionCoord = segment.intersection(this.perpendicularSegment)) == null) continue;
                        Coordinate floatSegmentStartCoord = new Coordinate((double)((float)segment.p0.x), (double)((float)segment.p0.y));
                        Coordinate floatSegmentEndCoord = new Coordinate((double)((float)segment.p1.x), (double)((float)segment.p1.y));
                        if (floatSegmentStartCoord.equals2D(intersectionCoord) || floatSegmentEndCoord.equals2D(intersectionCoord)) continue;
                        AddHandle addHandle = new AddHandle(pFeature, entityIndex, ringIndex, coordPosition, intersectionCoord, segment);
                        this.addHandles.add(addHandle);
                    }
                }
            }
        }
    }

    private void createAddHandles() {
        this.createFeatureHandles(this.mappingComponent.getFeatureCollection().getAllFeatures(), true);
    }

    private synchronized void recalculatePerpendicular(PInputEvent event) {
        Point2D triggerPoint;
        Coordinate triggerCoord;
        LineSegment nearestSegment;
        this.perpendicularSegment = null;
        this.perpendicularCoordinate = null;
        if (this.selectedFeature != null && (nearestSegment = this.getNearestSegment(triggerCoord = new Coordinate((triggerPoint = event.getPosition()).getX(), triggerPoint.getY()), this.selectedFeature)) != null) {
            int snappingDistance = this.mappingComponent.getSnappingRectSize() / 2;
            if (this.mappingComponent.isSnappingEnabled()) {
                Point2D localTriggerPoint = this.mappingComponent.getCamera().viewToLocal((Point2D)triggerPoint.clone());
                Point2D localNearestSegmentStartPoint = this.mappingComponent.getCamera().viewToLocal((Point2D)new Point2D.Double(nearestSegment.p0.x, nearestSegment.p0.y));
                Point2D localNearestSegmentEndPoint = this.mappingComponent.getCamera().viewToLocal((Point2D)new Point2D.Double(nearestSegment.p1.x, nearestSegment.p1.y));
                if (localTriggerPoint.distance(localNearestSegmentStartPoint) < (double)snappingDistance) {
                    this.perpendicularCoordinate = nearestSegment.p0;
                } else if (localTriggerPoint.distance(localNearestSegmentEndPoint) < (double)snappingDistance) {
                    this.perpendicularCoordinate = nearestSegment.p1;
                }
            }
            if (this.perpendicularCoordinate == null) {
                this.perpendicularCoordinate = nearestSegment.closestPoint(triggerCoord);
            }
            PBounds bounds = new PBounds(this.mappingComponent.getCamera().getViewBounds());
            List<Feature> allFeatures = this.mappingComponent.getFeatureCollection().getAllFeatures();
            for (Feature feature : allFeatures) {
                PFeature pfeature = this.mappingComponent.getPFeatureHM().get(feature);
                bounds.add(pfeature.getBounds());
            }
            LineSegment top = new LineSegment(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMinY());
            LineSegment bottom = new LineSegment(bounds.getMinX(), bounds.getMaxY(), bounds.getMaxX(), bounds.getMaxY());
            LineSegment left = new LineSegment(bounds.getMinX(), bounds.getMinY(), bounds.getMinX(), bounds.getMaxY());
            LineSegment right = new LineSegment(bounds.getMaxX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
            double maxLength = Math.sqrt(Math.pow(bounds.getWidth(), 2.0) * Math.pow(bounds.getHeight(), 2.0));
            LineSegment leftyPerpendicular = this.leftyPerpendicular(nearestSegment, this.perpendicularCoordinate, maxLength);
            LineSegment rightyPerpendicular = this.rightyPerpendicular(nearestSegment, this.perpendicularCoordinate, maxLength);
            ArrayList<LineSegment> boundLines = new ArrayList<LineSegment>();
            boundLines.add(top);
            boundLines.add(bottom);
            boundLines.add(left);
            boundLines.add(right);
            Coordinate leftyIntersection = null;
            Coordinate rightyIntersection = null;
            Iterator boundsIterator = boundLines.iterator();
            while (boundsIterator.hasNext() && (leftyIntersection == null || rightyIntersection == null)) {
                LineSegment boundsLine = (LineSegment)boundsIterator.next();
                if (leftyIntersection == null) {
                    leftyIntersection = boundsLine.intersection(leftyPerpendicular);
                }
                if (rightyIntersection != null) continue;
                rightyIntersection = boundsLine.intersection(rightyPerpendicular);
            }
            if (leftyIntersection != null && rightyIntersection != null) {
                this.perpendicularSegment = new LineSegment(leftyIntersection, rightyIntersection);
            }
        }
    }

    public void mouseMoved(final PInputEvent event) {
        super.mouseMoved(event);
        try {
            if (this.stage == Stage.CREATE_PERPENDICULAR) {
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        PerpendicularIntersectionListener.this.recalculatePerpendicular(event);
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception ex) {
                            LOG.warn((Object)ex, (Throwable)ex);
                        }
                        PerpendicularIntersectionListener.this.refreshHandles();
                        PerpendicularIntersectionListener.this.relocatePerpendicularHandle();
                    }
                }.execute();
            }
        }
        catch (Exception ex) {
            LOG.info((Object)"Exception in mouseMoved", (Throwable)ex);
        }
    }

    private void relocatePerpendicularHandle() {
        if (this.mappingComponent.getHandleLayer().getChildrenReference().contains(this.perpendicularPathLine) && this.perpendicularSegment != null) {
            Point2D localPerpendicularSegmentStartPoint = this.mappingComponent.getCamera().viewToLocal((Point2D)new Point2D.Double(this.perpendicularSegment.p0.x, this.perpendicularSegment.p0.y));
            Point2D localPerpendicularSegmentEndPoint = this.mappingComponent.getCamera().viewToLocal((Point2D)new Point2D.Double(this.perpendicularSegment.p1.x, this.perpendicularSegment.p1.y));
            this.perpendicularPathLine.setPathToPolyline(new Point2D[]{localPerpendicularSegmentStartPoint, localPerpendicularSegmentEndPoint});
        }
        if (this.mappingComponent.getHandleLayer().getChildrenReference().contains((Object)this.perpendicularHandle) && this.perpendicularCoordinate != null) {
            this.perpendicularHandle.relocateHandle();
        }
    }

    private void setPPathVisible(boolean visible, PPath ... pPaths) {
        for (PPath pPath : pPaths) {
            boolean found = this.mappingComponent.getHandleLayer().getChildrenReference().contains(pPath);
            if (visible) {
                if (found) continue;
                this.mappingComponent.getHandleLayer().addChild((PNode)pPath);
                continue;
            }
            if (!found) continue;
            this.mappingComponent.getHandleLayer().removeChild((PNode)pPath);
        }
    }

    private void setPerpendicularHandleVisible(boolean visible) {
        this.setPPathVisible(visible, this.perpendicularHandle);
    }

    private void setFeatureHandlesVisible(boolean visible) {
        this.setPPathVisible(visible, this.featureHandles.toArray(new PPath[0]));
    }

    private void setAddHandlesVisible(boolean visible) {
        this.setPPathVisible(visible, this.addHandles.toArray(new PPath[0]));
    }

    private void setPerpendicularLineVisible(boolean visible) {
        this.setPPathVisible(visible, this.perpendicularPathLine);
    }

    public void init() {
        if (this.mappingComponent.getFeatureCollection() instanceof DefaultFeatureCollection && ((DefaultFeatureCollection)this.mappingComponent.getFeatureCollection()).getSelectedFeatures().size() == 1) {
            Feature old = this.selectedFeature;
            this.selectedFeature = ((DefaultFeatureCollection)this.mappingComponent.getFeatureCollection()).getSelectedFeatures().toArray(new Feature[0])[0];
            if (old != this.selectedFeature) {
                this.perpendicularSegment = null;
                this.perpendicularCoordinate = null;
                this.stage = Stage.CREATE_PERPENDICULAR;
            }
        } else {
            this.perpendicularSegment = null;
            this.perpendicularCoordinate = null;
            this.selectedFeature = null;
            this.stage = Stage.SELECT_FEATURE;
        }
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                if (PerpendicularIntersectionListener.this.selectedFeature == null) {
                    PerpendicularIntersectionListener.this.featureHandles.clear();
                    PerpendicularIntersectionListener.this.addHandles.clear();
                } else {
                    PerpendicularIntersectionListener.this.createFeatureHandles(PerpendicularIntersectionListener.this.selectedFeature);
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
                PerpendicularIntersectionListener.this.refreshHandles();
            }
        }.execute();
    }

    private void refreshHandles() {
        this.mappingComponent.getHandleLayer().removeAllChildren();
        this.setPerpendicularLineVisible(this.perpendicularSegment != null && this.stage != Stage.SELECT_FEATURE);
        this.setFeatureHandlesVisible(this.stage != Stage.SELECT_FEATURE);
        this.setAddHandlesVisible(this.stage == Stage.ADD_HANDLES);
        this.setPerpendicularHandleVisible(this.perpendicularCoordinate != null && this.stage == Stage.CREATE_PERPENDICULAR);
    }

    public void mouseClicked(final PInputEvent event) {
        super.mouseClicked(event);
        if (event.isRightMouseButton()) {
            this.mappingComponent.getFeatureCollection().unselectAll();
            this.stage = Stage.SELECT_FEATURE;
            this.refreshHandles();
        } else if (event.isLeftMouseButton()) {
            if (this.stage == Stage.SELECT_FEATURE) {
                PFeature pFeature = (PFeature)PFeatureTools.getFirstValidObjectUnderPointer(event, new Class[]{PFeature.class}, true);
                if (pFeature != null) {
                    this.selectedFeature = pFeature.getFeature();
                    this.mappingComponent.getFeatureCollection().select(this.selectedFeature);
                    new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            PerpendicularIntersectionListener.this.stage = Stage.CREATE_PERPENDICULAR;
                            PerpendicularIntersectionListener.this.recalculatePerpendicular(event);
                            PerpendicularIntersectionListener.this.createFeatureHandles(PerpendicularIntersectionListener.this.selectedFeature);
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception ex) {
                                LOG.warn((Object)ex, (Throwable)ex);
                            }
                            PerpendicularIntersectionListener.this.refreshHandles();
                            PerpendicularIntersectionListener.this.relocatePerpendicularHandle();
                        }
                    }.execute();
                }
            } else if (this.stage == Stage.CREATE_PERPENDICULAR) {
                this.finishCreatePerpendicular();
            } else if (this.stage == Stage.ADD_HANDLES && event.getClickCount() == 2) {
                this.finishAddHandles();
            }
        }
    }

    private void finishCreatePerpendicular() {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                PerpendicularIntersectionListener.this.stage = Stage.ADD_HANDLES;
                PerpendicularIntersectionListener.this.createAddHandles();
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
                PerpendicularIntersectionListener.this.refreshHandles();
            }
        }.execute();
    }

    private void finishAddHandles() {
        new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                PerpendicularIntersectionListener.this.stage = Stage.CREATE_PERPENDICULAR;
                for (AddHandle addHandle : PerpendicularIntersectionListener.this.addHandles) {
                    if (!addHandle.isSelected()) continue;
                    addHandle.insertCoordinate();
                }
                PerpendicularIntersectionListener.this.createFeatureHandles(PerpendicularIntersectionListener.this.selectedFeature);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
                PerpendicularIntersectionListener.this.refreshHandles();
            }
        }.execute();
    }

    private LineSegment perpendicular(LineSegment segment, Coordinate perpendicularStart, double length, boolean isLefty) {
        double deltaX = segment.p1.x - segment.p0.x;
        double deltaY = segment.p1.y - segment.p0.y;
        double alpha = Math.atan2(deltaY, deltaX);
        double alpha90 = alpha + Math.toRadians(isLefty ? -90.0 : 90.0);
        double x = Math.cos(alpha90) * length;
        double y = Math.sin(alpha90) * length;
        Coordinate perpendicularEnd = new Coordinate(x + perpendicularStart.x, y + perpendicularStart.y);
        return new LineSegment(perpendicularStart, perpendicularEnd);
    }

    private LineSegment leftyPerpendicular(LineSegment segment, Coordinate perpendicularStart, double length) {
        return this.perpendicular(segment, perpendicularStart, length, true);
    }

    private LineSegment rightyPerpendicular(LineSegment segment, Coordinate perpendicularStart, double length) {
        return this.perpendicular(segment, perpendicularStart, length, false);
    }

    private LineSegment getNearestSegment(Coordinate trigger, Feature feature) {
        Geometry geometry;
        LineSegment segment = null;
        double dist = Double.POSITIVE_INFINITY;
        PFeature pfeature = this.mappingComponent.getPFeatureHM().get(feature);
        if (pfeature != null && ((geometry = pfeature.getFeature().getGeometry()) instanceof Polygon || geometry instanceof LineString || geometry instanceof MultiPolygon)) {
            for (int entityIndex = 0; entityIndex < pfeature.getNumOfEntities(); ++entityIndex) {
                for (int ringIndex = 0; ringIndex < pfeature.getNumOfRings(entityIndex); ++ringIndex) {
                    float[] xp = pfeature.getXp(entityIndex, ringIndex);
                    float[] yp = pfeature.getYp(entityIndex, ringIndex);
                    for (int coordIndex = xp.length - 1; coordIndex > 0; --coordIndex) {
                        LineSegment tmpSegment = new LineSegment((double)xp[coordIndex - 1], (double)yp[coordIndex - 1], (double)xp[coordIndex], (double)yp[coordIndex]);
                        double tmpDist = tmpSegment.distance(trigger);
                        if (!(tmpDist < dist)) continue;
                        dist = tmpDist;
                        segment = tmpSegment;
                    }
                }
            }
        }
        return segment;
    }

    class AddHandle
    extends PHandle {
        private final PFeature pFeature;
        private final int entityPosition;
        private final int ringPosition;
        private final int coordPosition;
        private final Coordinate coordinate;
        private final LineSegment segment;

        public AddHandle(PFeature pFeature, int entityPosition, int ringPosition, int coordPosition, final Coordinate coordinate, LineSegment segment) {
            super(new PLocator(){

                public double locateX() {
                    return coordinate.x;
                }

                public double locateY() {
                    return coordinate.y;
                }
            }, PerpendicularIntersectionListener.this.mappingComponent);
            this.pFeature = pFeature;
            this.entityPosition = entityPosition;
            this.ringPosition = ringPosition;
            this.coordPosition = coordPosition;
            this.coordinate = coordinate;
            this.segment = segment;
        }

        @Override
        protected Color getDefaultColor() {
            return COLOR_PERPENDICULAR_HANDLE;
        }

        @Override
        public void handleClicked(PInputEvent pInputEvent) {
            if (pInputEvent.getClickCount() == 2) {
                this.setSelected(true);
                PerpendicularIntersectionListener.this.finishAddHandles();
            } else if (pInputEvent.isLeftMouseButton()) {
                this.setSelected(!this.isSelected());
            }
        }

        public void insertCoordinate() {
            float handleX = (float)this.coordinate.x;
            float handleY = (float)this.coordinate.y;
            this.pFeature.insertCoordinate(this.entityPosition, this.ringPosition, this.coordPosition, handleX, handleY);
        }
    }

    private static enum Stage {
        SELECT_FEATURE,
        CREATE_PERPENDICULAR,
        ADD_HANDLES;

    }
}

