/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.ChildNodesProvider;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.PreventNamingDuplicates;
import de.cismet.cismap.commons.features.RequestForNonreflectingFeature;
import de.cismet.cismap.commons.features.RequestForRotatingPivotLock;
import de.cismet.cismap.commons.features.RequestForUnaddableHandles;
import de.cismet.cismap.commons.features.RequestForUnmoveableHandles;
import de.cismet.cismap.commons.features.RequestForUnremovableHandles;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DeriveRule;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DerivedCommandArea;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.RectangleMath;
import de.cismet.cismap.commons.gui.printing.PrintingSettingsWidget;
import de.cismet.cismap.commons.gui.printing.Resolution;
import de.cismet.cismap.commons.gui.printing.Scale;
import de.cismet.cismap.commons.gui.printing.Template;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.PFeatureTools;
import de.cismet.tools.gui.StaticSwingTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class PrintTemplateFeature
extends DefaultStyledFeature
implements XStyledFeature,
ChildNodesProvider,
PreventNamingDuplicates,
RequestForRotatingPivotLock,
RequestForUnaddableHandles,
RequestForUnmoveableHandles,
RequestForUnremovableHandles,
RequestForNonreflectingFeature {
    public static final double DEFAULT_JAVA_RESOLUTION_IN_DPI = 72.0;
    public static final double MILLIMETER_OF_AN_INCH = 25.4;
    public static final double INCH_OF_A_MILLIMETER = 0.039;
    public static final double MILLIMETER_OF_A_METER = 1000.0;
    static final Color TEXTCOLOR = new Color(11, 72, 107);
    Template template;
    Resolution resolution;
    Scale scale;
    String name;
    int number = 0;
    ArrayList<PNode> children = null;
    private MappingComponent mappingComponent;
    private final Logger log = Logger.getLogger(this.getClass());
    private Future<Image> futureMapImage;

    public PrintTemplateFeature(PrintTemplateFeature ptfTemplate, Side side) {
        this(ptfTemplate.template, ptfTemplate.resolution, ptfTemplate.scale, ptfTemplate.mappingComponent, true);
        Coordinate[] translationSide = ptfTemplate.getSideLineCoords(this.getTranslationSide(side));
        AffineTransformation translationAT = AffineTransformation.translationInstance((double)(translationSide[1].x - translationSide[0].x), (double)(translationSide[1].y - translationSide[0].y));
        this.setGeometry(translationAT.transform(ptfTemplate.getGeometry()));
    }

    public PrintTemplateFeature(Template template, Resolution resolution, Scale scale, MappingComponent mappingComponent) {
        this(template, resolution, scale, mappingComponent, false);
    }

    private PrintTemplateFeature(Template template, Resolution resolution, Scale scale, MappingComponent mappingComponent, boolean cloning) {
        this.mappingComponent = mappingComponent;
        this.template = template;
        this.resolution = resolution;
        this.scale = scale;
        BoundingBox boundingBoxToCalculateTheLocationOfTHeTemplate = CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBoxFromCamera();
        double dimensionWidth = mappingComponent.getCamera().getViewBounds().getWidth();
        double dimensionHeight = mappingComponent.getCamera().getViewBounds().getHeight();
        this.init(boundingBoxToCalculateTheLocationOfTHeTemplate, dimensionWidth, dimensionHeight, cloning);
    }

    public final void init(BoundingBox boundingBoxToCalculateTheLocationOfTHeTemplate) {
        this.init(boundingBoxToCalculateTheLocationOfTHeTemplate, null, null, false);
    }

    public final void init(BoundingBox boundingBoxToCalculateTheLocationOfTHeTemplate, Double dimensionWidth, Double dimensionHeight, boolean cloning) {
        if (dimensionHeight == null && this.template != null) {
            dimensionHeight = this.template.getMapHeight();
        }
        if (dimensionWidth == null && this.template != null) {
            dimensionWidth = this.template.getMapWidth();
        }
        this.children = new ArrayList();
        int placeholderWidth = this.template.getMapWidth();
        int placeholderHeight = this.template.getMapHeight();
        int scaleDenominator = this.scale.getDenominator();
        double widthToHeightRatio = (double)placeholderWidth / (double)placeholderHeight;
        double realWorldHeight = 0.0;
        double realWorldWidth = 0.0;
        if ((scaleDenominator = (int)((double)scaleDenominator * CrsTransformer.getCrsFactor(null))) == -1 && !cloning) {
            String s = JOptionPane.showInputDialog(StaticSwingTools.getParentFrame((Component)((Object)this.mappingComponent)), NbBundle.getMessage(PrintTemplateFeature.class, (String)"PrintingFrameListener.init(double,int,int,String).message"), "");
            try {
                scaleDenominator = Integer.parseInt(s);
            }
            catch (Exception skip) {
                this.log.warn((Object)"Could not determine the given scale denominator. It will be set to '0.0' to enable free scaling.", (Throwable)skip);
                scaleDenominator = 0;
            }
        }
        if (scaleDenominator == 0) {
            if (widthToHeightRatio / (dimensionWidth / dimensionHeight) < 1.0) {
                realWorldHeight = dimensionHeight * 0.75;
                realWorldWidth = realWorldHeight * widthToHeightRatio;
            } else {
                realWorldWidth = dimensionWidth * 0.75;
                realWorldHeight = realWorldWidth / widthToHeightRatio;
            }
        } else {
            realWorldWidth = (double)placeholderWidth / 72.0 * 25.4 / 1000.0 * (double)scaleDenominator;
            realWorldHeight = (double)placeholderHeight / 72.0 * 25.4 / 1000.0 * (double)scaleDenominator;
            if (!this.mappingComponent.getMappingModel().getSrs().isMetric()) {
                try {
                    String srs = this.mappingComponent.getMappingModel().getSrs().getCode();
                    BoundingBox currentBox = this.mappingComponent.getCurrentBoundingBox();
                    GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs(srs));
                    Point point = factory.createPoint(new Coordinate(currentBox.getX1(), currentBox.getY1()));
                    point = CrsTransformer.transformToMetricCrs(point);
                    XBoundingBox metricBbox = new XBoundingBox(point.getX(), point.getY(), point.getX() + 1.0, point.getY() + 1.0, CrsTransformer.createCrsFromSrid(point.getSRID()), true);
                    CrsTransformer geoTransformer = new CrsTransformer(srs);
                    XBoundingBox geoBbox = geoTransformer.transformBoundingBox(metricBbox);
                    realWorldWidth *= geoBbox.getX2() - geoBbox.getX1();
                    realWorldHeight *= geoBbox.getX2() - geoBbox.getX1();
                }
                catch (Exception e) {
                    this.log.error((Object)"Error while trying to convert the boundingbox to a metric one.", (Throwable)e);
                }
            }
        }
        double centerX = (boundingBoxToCalculateTheLocationOfTHeTemplate.getX1() + boundingBoxToCalculateTheLocationOfTHeTemplate.getX2()) / 2.0;
        double centerY = (boundingBoxToCalculateTheLocationOfTHeTemplate.getY1() + boundingBoxToCalculateTheLocationOfTHeTemplate.getY2()) / 2.0;
        double halfRealWorldWidth = realWorldWidth / 2.0;
        double halfRealWorldHeigth = realWorldHeight / 2.0;
        Coordinate[] outerCoords = new Coordinate[]{new Coordinate(-halfRealWorldWidth, -halfRealWorldHeigth), new Coordinate(halfRealWorldWidth, -halfRealWorldHeigth), new Coordinate(halfRealWorldWidth, halfRealWorldHeigth), new Coordinate(-halfRealWorldWidth, halfRealWorldHeigth), new Coordinate(-halfRealWorldWidth, -halfRealWorldHeigth)};
        LinearRing outerRing = this.getGF().createLinearRing(outerCoords);
        LinearRing[] innerRings = null;
        AffineTransformation translateToDestination = AffineTransformation.translationInstance((double)centerX, (double)centerY);
        outerRing = (LinearRing)translateToDestination.transform((Geometry)outerRing);
        this.setGeometry((Geometry)this.getGF().createPolygon(outerRing, innerRings));
        this.setCanBeSelected(true);
        this.setEditable(true);
    }

    private Side getTranslationSide(Side side) {
        switch (side) {
            case NORTH: {
                return Side.EAST;
            }
            case SOUTH: {
                return Side.WEST;
            }
            case WEST: {
                return Side.NORTH;
            }
        }
        return Side.SOUTH;
    }

    public String toString() {
        return "Druckbereich ";
    }

    private GeometryFactory getGF() {
        return new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode()));
    }

    public Point getTemplateCenter() {
        return this.getGeometry().getCentroid();
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    public Scale getScale() {
        return this.scale;
    }

    public long getRealScaleDenominator() {
        Coordinate[] corrds = this.getGeometry().getCoordinates();
        Coordinate p0 = corrds[0];
        Coordinate p1 = corrds[1];
        double realwidth = Math.sqrt((p0.x - p1.x) * (p0.x - p1.x) + (p0.y - p1.y) * (p0.y - p1.y));
        double paperwidth = (double)this.template.getMapWidth() / 72.0 * 25.4 / 1000.0;
        double denom = realwidth / paperwidth;
        return Math.round(denom / CrsTransformer.getCrsFactor(this.getGeometry().getCentroid()));
    }

    public void setScale(Scale scale) {
        this.scale = scale;
    }

    public double getRotationAngle() {
        if (this.getGeometry() != null) {
            Coordinate[] corrds = this.getGeometry().getCoordinates();
            Coordinate point00 = corrds[0];
            Coordinate pointX0 = corrds[1];
            double oppositeLeg = pointX0.y - point00.y;
            double adjacentLeg = pointX0.x - point00.x;
            double tangens = oppositeLeg / adjacentLeg;
            double result = adjacentLeg > 0.0 ? 0.0 : 180.0;
            result = oppositeLeg > 0.0 ? -result : result;
            return result -= Math.toDegrees(Math.atan(tangens));
        }
        return -1.0;
    }

    @Override
    public ImageIcon getIconImage() {
        if (this.template != null) {
            return this.template.getIcon();
        }
        return null;
    }

    @Override
    public String getType() {
        return this.template != null ? this.template.getShortname() : "";
    }

    @Override
    public JComponent getInfoComponent(Refreshable refresh) {
        return null;
    }

    @Override
    public Stroke getLineStyle() {
        return null;
    }

    public Future<Image> getFutureMapImage() {
        return this.futureMapImage;
    }

    public void setFutureMapImage(Future<Image> futureMapImage) {
        this.futureMapImage = futureMapImage;
    }

    @Override
    public Paint getFillingPaint() {
        return this.mappingComponent.getPrintingSettingsDialog().getFeatureFillingPaint();
    }

    @Override
    public float getTransparency() {
        return 0.75f;
    }

    @Override
    public String getName() {
        if (this.mappingComponent.getSpecialFeatureCollection(PrintTemplateFeature.class).size() == 1) {
            return this.getOriginalName();
        }
        return this.getOriginalName() + " - " + this.number;
    }

    @Override
    public String getOriginalName() {
        return "Druckbereich ";
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public void setNumber(int n) {
        this.number = n;
    }

    @Override
    public Collection<PNode> provideChildren(PFeature parent) {
        if (this.children.size() == 0) {
            this.initPNodeChildren(parent);
        }
        return this.children;
    }

    private void initPNodeChildren(PFeature parent) {
        PTFDerivedCommandArea commands = new PTFDerivedCommandArea(parent);
        this.children.add((PNode)new SubPText((PNode)commands));
        this.children.add((PNode)new DerivedCloneArea(parent, Side.WEST));
        this.children.add((PNode)new DerivedCloneArea(parent, Side.EAST));
        this.children.add((PNode)new DerivedCloneArea(parent, Side.NORTH));
        this.children.add((PNode)new DerivedCloneArea(parent, Side.SOUTH));
        this.children.add((PNode)commands);
    }

    private Geometry getLineFromCoordsAt(int indexA, int indexB) {
        return this.getGF().createLineString(this.getCoordsArrayFromGeometryCoordsAt(indexA, indexB));
    }

    private Coordinate[] getCoordsArrayFromGeometryCoordsAt(int indexA, int indexB) {
        Coordinate[] cs = this.getGeometry().getCoordinates();
        Coordinate[] lineCoords = new Coordinate[]{cs[indexA], cs[indexB]};
        return lineCoords;
    }

    private Coordinate[] getSideLineCoords(Side side) {
        switch (side) {
            case NORTH: {
                return this.getCoordsArrayFromGeometryCoordsAt(2, 3);
            }
            case SOUTH: {
                return this.getCoordsArrayFromGeometryCoordsAt(0, 1);
            }
            case WEST: {
                return this.getCoordsArrayFromGeometryCoordsAt(3, 0);
            }
            case EAST: {
                return this.getCoordsArrayFromGeometryCoordsAt(1, 2);
            }
        }
        throw new RuntimeException("Error in Universe");
    }

    protected Geometry getSideLine(Side side) {
        return this.getGF().createLineString(this.getSideLineCoords(side));
    }

    protected double getShortSideLength() {
        Geometry southLine = this.getSideLine(Side.SOUTH);
        Geometry westLine = this.getSideLine(Side.WEST);
        if (southLine.getLength() < westLine.getLength()) {
            return southLine.getLength();
        }
        return westLine.getLength();
    }

    protected double getLongSideLength() {
        Geometry southLine = this.getSideLine(Side.SOUTH);
        Geometry westLine = this.getSideLine(Side.WEST);
        if (southLine.getLength() > westLine.getLength()) {
            return southLine.getLength();
        }
        return westLine.getLength();
    }

    class SubPText
    extends PText
    implements PropertyChangeListener {
        PNode parentNode;

        public SubPText(PNode parent) {
            this.parentNode = parent;
            this.setText(this.getPTFString());
            this.setTextPaint(TEXTCOLOR);
            this.setJustification(0.5f);
            parent.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setText(this.getPTFString());
            this.centerFullBoundsOnPoint(this.parentNode.getGlobalBounds().getCenterX(), this.parentNode.getGlobalBounds().getCenterY());
            this.setScale(9.0E-4 * (double)PrintTemplateFeature.this.getRealScaleDenominator());
            this.setRotation(Math.toRadians(PrintTemplateFeature.this.getRotationAngle()));
        }

        public String getPTFString() {
            String s = PrintTemplateFeature.this.template.getShortname() + "\n\n\n#" + PrintTemplateFeature.this.getNumber() + "\n\n\n1:" + PrintTemplateFeature.this.getRealScaleDenominator() + "\n\n\nAufl\u00f6sung:" + PrintTemplateFeature.this.resolution.getResolution() + " dpi";
            return s;
        }
    }

    public class DerivedCloneArea
    extends DerivedCommandArea {
        private Side side;

        public DerivedCloneArea(PFeature parent, final Side side) {
            super(parent, new DeriveRule(){

                @Override
                public Geometry derive(Geometry in) {
                    Coordinate[] line = new Coordinate[]{RectangleMath.getPointPerpendicular(PrintTemplateFeature.this.getSideLineCoords(side), RectangleMath.getPointFromStartByFraction(PrintTemplateFeature.this.getSideLineCoords(side), 0.25), 0.04 * PrintTemplateFeature.this.getShortSideLength()), RectangleMath.getPointPerpendicular(PrintTemplateFeature.this.getSideLineCoords(side), RectangleMath.getPointFromStartByFraction(PrintTemplateFeature.this.getSideLineCoords(side), 0.75), 0.04 * PrintTemplateFeature.this.getShortSideLength())};
                    return PrintTemplateFeature.this.getGF().createLineString(line).buffer(0.02 * PrintTemplateFeature.this.getShortSideLength());
                }
            });
            this.side = side;
            this.setPaint(Color.white);
            this.setStroke(null);
            this.setTransparency(0.3f);
        }

        @Override
        public void mouseClicked(PInputEvent event) {
            super.mouseClicked(event);
            if (event.getClickCount() == 1 && event.isLeftMouseButton() && event.getPickedNode() instanceof DerivedCloneArea) {
                DerivedCloneArea dca = (DerivedCloneArea)event.getPickedNode();
                PrintTemplateFeature ptf = (PrintTemplateFeature)dca.parent.getFeature();
                PrintTemplateFeature newPTF = new PrintTemplateFeature(ptf, dca.getSide());
                DefaultFeatureCollection mapFeatureCol = (DefaultFeatureCollection)PrintTemplateFeature.this.mappingComponent.getFeatureCollection();
                mapFeatureCol.holdFeature(newPTF);
                mapFeatureCol.addFeature(newPTF);
                PrintTemplateFeature.this.mappingComponent.adjustMapForSpecialFeatureClasses(PrintTemplateFeature.class);
            }
        }

        @Override
        public void mouseMoved(PInputEvent event) {
        }

        public Side getSide() {
            return this.side;
        }
    }

    public class PTFDerivedCommandArea
    extends DerivedCommandArea {
        private final Logger log;

        public PTFDerivedCommandArea(PFeature parent) {
            super(parent, new DeriveRule(){

                @Override
                public Geometry derive(Geometry in) {
                    return PrintTemplateFeature.this.getGeometry().buffer(-0.1 * PrintTemplateFeature.this.getShortSideLength());
                }
            });
            this.log = Logger.getLogger(this.getClass());
            this.setPaint(Color.white);
            this.setStroke(null);
            this.setTransparency(0.3f);
        }

        @Override
        public void mouseClicked(PInputEvent event) {
            super.mouseClicked(event);
            if (event.getClickCount() > 1 && event.isLeftMouseButton()) {
                PrintTemplateFeature.this.mappingComponent.showPrintingDialog();
            } else if (event.getClickCount() == 1 && event.isRightMouseButton()) {
                JPopupMenu changeMenu = new JPopupMenu();
                PrintingSettingsWidget settings = PrintTemplateFeature.this.mappingComponent.getPrintingSettingsDialog();
                JMenu menTemplates = new JMenu(settings.getTemplateString());
                for (final Template template : settings.getTemplates()) {
                    menTemplates.add(new JMenuItem(new AbstractAction(template.getTitle()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PrintTemplateFeature.this.mappingComponent.getFeatureCollection().removeFeature(PrintTemplateFeature.this);
                            PrintTemplateFeature.this.setTemplate(template);
                            PTFDerivedCommandArea.this.addAndRefresh();
                        }
                    }));
                }
                changeMenu.add(menTemplates);
                JMenu menScales = new JMenu(settings.getScaleString());
                for (final Scale s : settings.getScales()) {
                    menScales.add(new JMenuItem(new AbstractAction(s.getText()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PrintTemplateFeature.this.mappingComponent.getFeatureCollection().removeFeature(PrintTemplateFeature.this);
                            PrintTemplateFeature.this.setScale(s);
                            PTFDerivedCommandArea.this.addAndRefresh();
                        }
                    }));
                }
                changeMenu.add(menScales);
                JMenu jMenu = new JMenu(settings.getResolutionString());
                for (final Resolution r : settings.getResolutions()) {
                    jMenu.add(new JMenuItem(new AbstractAction(r.getText()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PrintTemplateFeature.this.mappingComponent.getFeatureCollection().removeFeature(PrintTemplateFeature.this);
                            PrintTemplateFeature.this.setResolution(r);
                            PTFDerivedCommandArea.this.addAndRefresh();
                        }
                    }));
                }
                changeMenu.add(jMenu);
                changeMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingTemplateFeature.removeAction")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PrintTemplateFeature.this.mappingComponent.getFeatureCollection().removeFeature(PrintTemplateFeature.this);
                    }
                }));
                changeMenu.show((Component)((Object)PrintTemplateFeature.this.mappingComponent), (int)event.getCanvasPosition().getX(), (int)event.getCanvasPosition().getY());
            }
        }

        private void addAndRefresh() {
            DefaultFeatureCollection mapFeatureCol = (DefaultFeatureCollection)PrintTemplateFeature.this.mappingComponent.getFeatureCollection();
            PrintTemplateFeature.this.init(new XBoundingBox(PrintTemplateFeature.this.getGeometry()));
            mapFeatureCol.holdFeature(PrintTemplateFeature.this);
            mapFeatureCol.addFeature(PrintTemplateFeature.this);
            PrintTemplateFeature.this.mappingComponent.adjustMapForSpecialFeatureClasses(PrintTemplateFeature.class);
            mapFeatureCol.select(PrintTemplateFeature.this);
            PrintTemplateFeature.this.mappingComponent.showHandles(false);
        }

        @Override
        public void mousePressed(PInputEvent event) {
            super.mousePressed(event);
            ((PBasicInputEventHandler)PrintTemplateFeature.this.mappingComponent.getInputListener("MOVE_POLYGON")).mousePressed(event);
        }

        @Override
        public void mouseDragged(PInputEvent event) {
            super.mouseDragged(event);
            ((PBasicInputEventHandler)PrintTemplateFeature.this.mappingComponent.getInputListener("MOVE_POLYGON")).mouseDragged(event);
        }

        @Override
        public void mouseReleased(PInputEvent event) {
            super.mouseReleased(event);
            ((PBasicInputEventHandler)PrintTemplateFeature.this.mappingComponent.getInputListener("MOVE_POLYGON")).mouseReleased(event);
            PrintTemplateFeature.this.mappingComponent.ensureVisibilityOfSpecialFeatures(PrintTemplateFeature.class);
        }

        @Override
        public void mouseMoved(PInputEvent event) {
            super.mouseMoved(event);
            ((PBasicInputEventHandler)PrintTemplateFeature.this.mappingComponent.getInputListener("MOVE_POLYGON")).mouseMoved(event);
        }

        @Override
        public void mouseWheelRotated(PInputEvent event) {
            super.mouseWheelRotatedByBlock(event);
            PNode o = PFeatureTools.getFirstValidObjectUnderPointer(event, new Class[]{PFeature.class}, true);
            if (!(o instanceof PFeature)) {
                return;
            }
            PFeature sel = (PFeature)o;
            if (!(sel.getFeature() instanceof PrintTemplateFeature)) {
                return;
            }
            PrintTemplateFeature ptf = (PrintTemplateFeature)sel.getFeature();
            if (ptf.getScale().getDenominator() == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)event.getWheelRotation());
                }
                if (event.getWheelRotation() < 0) {
                    this.zoom(0.9, ptf);
                    PrintTemplateFeature.this.mappingComponent.adjustMapForSpecialFeatureClasses(PrintTemplateFeature.class);
                } else {
                    this.zoom(1.1, ptf);
                    PrintTemplateFeature.this.mappingComponent.adjustMapForSpecialFeatureClasses(PrintTemplateFeature.class);
                }
            }
        }

        private void zoom(double scale, PrintTemplateFeature printingTemplate) {
            Point centroid = printingTemplate.getGeometry().getCentroid();
            AffineTransformation at = AffineTransformation.scaleInstance((double)scale, (double)scale, (double)centroid.getX(), (double)centroid.getY());
            Geometry g = at.transform(printingTemplate.getGeometry());
            printingTemplate.setGeometry(g);
            PFeature printPFeature = PrintTemplateFeature.this.mappingComponent.getPFeatureHM().get(printingTemplate);
            printPFeature.visualize();
            PrintTemplateFeature.this.mappingComponent.showHandles(true);
        }
    }

    public static enum Side {
        SOUTH,
        NORTH,
        WEST,
        EAST;

    }
}

