/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.tools.PFeatureTools;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import org.apache.log4j.Logger;

public class RectangleRubberBandListener
extends PBasicInputEventHandler {
    protected PPath rectangle;
    protected Point2D pressPoint;
    protected Point2D dragPoint;
    protected boolean rectangleEmpty = true;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public void mousePressed(PInputEvent e) {
        super.mousePressed(e);
        try {
            if (e.isLeftMouseButton() && !this.isMouseOverStickyNode(e)) {
                PLayer layer = ((MappingComponent)e.getComponent()).getRubberBandLayer();
                this.dragPoint = this.pressPoint = e.getPosition();
                this.rectangle = new PPath();
                this.rectangle.setPaint((Paint)new Color(20, 20, 20, 20));
                this.rectangle.setStroke((Stroke)new BasicStroke((float)(1.0 / e.getCamera().getViewScale())));
                layer.addChild((PNode)this.rectangle);
                this.rectangle.moveToFront();
                this.updateRectangle();
                this.rectangleEmpty = true;
            }
        }
        catch (ClassCastException cce) {
            this.log.error((Object)"PCanvas muss vom Typ SimpleFeatureViewer sein", (Throwable)cce);
        }
    }

    public void mouseDragged(PInputEvent e) {
        super.mouseDragged(e);
        this.dragPoint = e.getPosition();
        this.updateRectangle();
        this.rectangleEmpty = false;
    }

    public void mouseReleased(PInputEvent e) {
        super.mouseReleased(e);
        PBounds b = new PBounds();
        if (this.pressPoint != null) {
            b.add(this.pressPoint);
            b.add(this.dragPoint);
        }
        if (e.getButton() == 1) {
            this.updateRectangle();
            if (this.rectangle != null && this.rectangle.getParent() != null) {
                this.rectangle.removeFromParent();
            }
        }
    }

    private void updateRectangle() {
        if (this.rectangle != null) {
            PBounds b = new PBounds();
            b.add(this.pressPoint);
            b.add(this.dragPoint);
            this.rectangle.setPathTo((Shape)b);
            Object var1_1 = null;
        }
    }

    private boolean isMouseOverStickyNode(PInputEvent pInputEvent) {
        PFeature pFeature;
        PNode stickyChild;
        PNode firstPFeatureUnderMouse = PFeatureTools.getFirstValidObjectUnderPointer(pInputEvent, new Class[]{PFeature.class}, true);
        return firstPFeatureUnderMouse != null && firstPFeatureUnderMouse instanceof PFeature && (stickyChild = (pFeature = (PFeature)firstPFeatureUnderMouse).getStickyChild()) != null && stickyChild.getVisible() && stickyChild.getFullBounds().contains(pInputEvent.getPosition());
    }
}

