/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.CheckedFeaturesProvider;
import de.cismet.cismap.commons.features.CommonFeatureAction;
import de.cismet.cismap.commons.features.CommonFeaturePreciseAction;
import de.cismet.cismap.commons.features.CommonMultiAndSingleFeatureAction;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.DoubleClickableFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureNameProvider;
import de.cismet.cismap.commons.features.FeaturesProvider;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.SelectFeature;
import de.cismet.cismap.commons.gui.MapPopupAction;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectableServiceFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.PFeatureTools;
import de.cismet.tools.gui.ActionsProvider;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.Color;
import java.awt.Component;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.apache.commons.collections.MultiHashMap;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SelectionListener
extends CreateGeometryListener {
    public static final String SELECTION_CHANGED_NOTIFICATION = "SELECTION_CHANGED_NOTIFICATION";
    public static final String DOUBLECLICK_POINT_NOTIFICATION = "DOUBLECLICK_POINT_NOTIFICATION";
    public static final String PROPERTY_LAST_FEATURE = "PROPERTY_LAST_FEATURE";
    public static final String PROPERTY_MODE = "PROPERTY_MODE";
    Point doubleclickPoint = null;
    PFeature sel = null;
    Collection<PFeature> pfVector = new ArrayList<PFeature>();
    ArrayList<? extends CommonFeatureAction> allCommonFeatureActions = null;
    private final Logger log = Logger.getLogger(this.getClass());
    private int clickCount = 0;
    private Map<Feature, PFeature> selectedFeatures = Collections.synchronizedMap(new HashMap());
    private boolean selectMultipleFeatures = false;
    private boolean featuresFromServicesSelectable = false;
    private boolean selectionInProgress = false;
    private boolean featureAdded = false;
    private List<Feature> lastUnselectedFeatures;
    private boolean holdGeometries = false;
    private SelectFeature lastFeature;
    private SelectFeature selectFeature;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean showHandleNeighbourDistance = true;

    public SelectionListener() {
        Lookup.Result result = Lookup.getDefault().lookupResult(CommonFeatureAction.class);
        this.allCommonFeatureActions = new ArrayList(result.allInstances());
        Collections.sort(this.allCommonFeatureActions, new Comparator<CommonFeatureAction>(){

            @Override
            public int compare(CommonFeatureAction o1, CommonFeatureAction o2) {
                return Integer.valueOf(o1.getSorter()).compareTo(o2.getSorter());
            }
        });
        this.setGeometryFeatureClass(PureNewFeature.class);
        this.setMode("BOUNDING_BOX");
    }

    public boolean isShowHandleNeighbourDistance() {
        return this.showHandleNeighbourDistance;
    }

    public void setShowHandleNeighbourDistance(boolean showHandleNeighbourDistance) {
        this.showHandleNeighbourDistance = showHandleNeighbourDistance;
    }

    @Override
    public void mouseMoved(PInputEvent pInputEvent) {
        this.setMappingComponent(pInputEvent);
        super.mouseMoved(pInputEvent);
    }

    @Override
    public void mousePressed(PInputEvent pInputEvent) {
        this.setMappingComponent(pInputEvent);
        super.mousePressed(pInputEvent);
    }

    private void handleRightClick(PInputEvent pInputEvent) {
        List<PNode> allClickedPFeatures;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"right mouseclick");
        }
        boolean clickOnSelection = false;
        boolean multiFeaturePopupEnabled = CismapBroker.getInstance().isMultiFeaturePopupMenuEnabled();
        PFeature clickedPFeature = (PFeature)PFeatureTools.getFirstValidObjectUnderPointer(pInputEvent, new Class[]{PFeature.class}, true);
        if (clickedPFeature != null && clickedPFeature.getFeature() != null && clickedPFeature.getFeature().getGeometry() instanceof Point) {
            Point p = (Point)clickedPFeature.getFeature().getGeometry();
            p = CrsTransformer.transformToCurrentCrs(p);
            allClickedPFeatures = PFeatureTools.getValidObjectsUnderPointer(pInputEvent, p.getX(), p.getY(), new Class[]{PFeature.class}, 0.003, false);
        } else {
            allClickedPFeatures = PFeatureTools.getAllValidObjectsUnderPointer(pInputEvent, new Class[]{PFeature.class});
        }
        ArrayList<PFeature> selectedPFeatures = new ArrayList<PFeature>(this.selectedFeatures.size());
        for (Feature feature : this.selectedFeatures.keySet()) {
            PFeature selectedPFeature = this.selectedFeatures.get(feature);
            if (allClickedPFeatures.contains(selectedPFeature)) {
                clickOnSelection = true;
            }
            selectedPFeatures.add(selectedPFeature);
        }
        DefaultFeatureCollection dfc = (DefaultFeatureCollection)this.mappingComponent.getFeatureCollection();
        for (Feature selectedFeature : (LinkedHashSet)dfc.getSelectedFeatures()) {
            PFeature selectedPFeature = this.mappingComponent.getPFeatureHM().get(selectedFeature);
            if (selectedPFeature == null) continue;
            if (allClickedPFeatures.contains(selectedPFeature)) {
                clickOnSelection = true;
            }
            if (selectedPFeatures.contains(selectedPFeature)) continue;
            selectedPFeatures.add(selectedPFeature);
        }
        ArrayList<PFeature> arrayList = new ArrayList<PFeature>();
        if (clickOnSelection) {
            arrayList.addAll(selectedPFeatures);
        } else if (multiFeaturePopupEnabled) {
            arrayList.addAll(allClickedPFeatures);
        } else if (clickedPFeature != null) {
            arrayList.add(clickedPFeature);
        }
        Point point = this.createPointFromInput(pInputEvent);
        Collection lookupResult = Lookup.getDefault().lookupAll(MapPopupAction.class);
        ArrayList allPopupActions = new ArrayList(lookupResult);
        Collections.sort(allPopupActions);
        MultiHashMap actionProviderMap = new MultiHashMap();
        MultiHashMap commonFeatureActionsMap = new MultiHashMap();
        MultiHashMap popupActionMap = new MultiHashMap();
        MultiHashMap multipleCommonFeatureActionProvider = new MultiHashMap();
        for (PFeature pFeature : arrayList) {
            if (pFeature instanceof ActionsProvider && (multiFeaturePopupEnabled || pFeature.equals(clickedPFeature))) {
                Iterator<? extends CommonFeatureAction> actions = ((ActionsProvider)pFeature.getFeature()).getActions();
                actionProviderMap.putAll((Object)pFeature, actions);
            }
            if (this.allCommonFeatureActions != null) {
                for (CommonFeatureAction commonFeatureAction : this.allCommonFeatureActions) {
                    CommonFeatureAction cfa;
                    try {
                        cfa = commonFeatureAction instanceof FeaturesProvider ? commonFeatureAction : (CommonFeatureAction)commonFeatureAction.getClass().newInstance();
                    }
                    catch (Exception ex) {
                        break;
                    }
                    cfa.setSourceFeature(pFeature.getFeature());
                    if (!cfa.isActive()) continue;
                    if (cfa instanceof CommonFeaturePreciseAction) {
                        Point2D pos = pInputEvent.getPosition();
                        WorldToScreenTransform wtst = this.getMappingComponent().getWtst();
                        Coordinate coord = new Coordinate(wtst.getSourceX(pos.getX()), wtst.getSourceY(pos.getY()));
                        ArrayList<Feature> allFeatures = new ArrayList<Feature>();
                        for (PFeature feature : arrayList) {
                            allFeatures.add(feature.getFeature());
                        }
                        ((CommonFeaturePreciseAction)cfa).setActionCoordinate(coord);
                        ((CommonFeaturePreciseAction)cfa).setAllSourceFeatures(allFeatures);
                    }
                    if (cfa instanceof FeaturesProvider) {
                        CommonFeatureAction cfa2;
                        if (((FeaturesProvider)((Object)cfa)).isResponsibleFor(pFeature.getFeature()) && (!(cfa instanceof CommonMultiAndSingleFeatureAction) || arrayList.size() > 1)) {
                            multipleCommonFeatureActionProvider.put((Object)cfa, (Object)pFeature.getFeature());
                        }
                        if (!(cfa instanceof CommonMultiAndSingleFeatureAction) || !multiFeaturePopupEnabled && !pFeature.equals(clickedPFeature)) continue;
                        try {
                            cfa2 = (CommonFeatureAction)commonFeatureAction.getClass().newInstance();
                        }
                        catch (Exception ex) {
                            break;
                        }
                        cfa2.setSourceFeature(pFeature.getFeature());
                        commonFeatureActionsMap.put((Object)pFeature, (Object)cfa2);
                        continue;
                    }
                    if (!multiFeaturePopupEnabled && !pFeature.equals(clickedPFeature)) continue;
                    commonFeatureActionsMap.put((Object)pFeature, (Object)cfa);
                }
            }
            for (MapPopupAction mapPopupAction : allPopupActions) {
                mapPopupAction.setPoint(point);
                if (!mapPopupAction.isActive(pFeature instanceof PFeature) || !multiFeaturePopupEnabled && !pFeature.equals(clickedPFeature)) continue;
                JMenu submenu = mapPopupAction.getSubmenu();
                popupActionMap.put((Object)pFeature, submenu != null ? submenu : mapPopupAction);
            }
        }
        MultiHashMap menuMap = new MultiHashMap();
        for (PFeature pFeature : arrayList) {
            Collection collection = actionProviderMap.getCollection((Object)pFeature);
            Collection commonFeatureActions = commonFeatureActionsMap.getCollection((Object)pFeature);
            Collection popupActions = popupActionMap.getCollection((Object)pFeature);
            if (collection != null) {
                if (menuMap.getCollection((Object)pFeature) != null) {
                    menuMap.put((Object)pFeature, (Object)new JSeparator());
                }
                menuMap.putAll((Object)pFeature, collection);
            }
            if (commonFeatureActions != null) {
                if (menuMap.getCollection((Object)pFeature) != null) {
                    menuMap.put((Object)pFeature, (Object)new JSeparator());
                }
                menuMap.putAll((Object)pFeature, commonFeatureActions);
            }
            if (popupActions == null || popupActions.size() <= 0) continue;
            if (menuMap.getCollection((Object)pFeature) != null) {
                menuMap.put((Object)pFeature, (Object)new JSeparator());
            }
            menuMap.putAll((Object)pFeature, popupActions);
        }
        JPopupMenu jPopupMenu = new JPopupMenu("MapPopup");
        Set menuMapPFeatures = menuMap.keySet();
        if (menuMapPFeatures.size() > 1) {
            for (Object pFeature : menuMapPFeatures) {
                String featureName = ((PFeature)pFeature).getFeature() instanceof FeatureNameProvider && ((FeatureNameProvider)((Object)((PFeature)pFeature).getFeature())).getName() != null ? ((FeatureNameProvider)((Object)((PFeature)pFeature).getFeature())).getName() : ResourceBundle.getBundle("de/cismet/cismap/commons/gui/piccolo/eventlistener/Bundle").getString("SelectionListener.unknown_featureName");
                JMenu featurePopup = new JMenu(featureName + " | " + new DecimalFormat("#.##").format(((PFeature)pFeature).getFeature().getGeometry().getArea()) + " m\u00b2");
                featurePopup.addMouseListener(new MouseAdapter((PFeature)pFeature){
                    final /* synthetic */ PFeature val$pFeature;
                    {
                        this.val$pFeature = pFeature;
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        ((DefaultFeatureCollection)SelectionListener.this.mappingComponent.getFeatureCollection()).unselectAll();
                        ((DefaultFeatureCollection)SelectionListener.this.mappingComponent.getFeatureCollection()).addToSelection(this.val$pFeature.getFeature());
                    }
                });
                for (Object menuItemComponent : menuMap.getCollection(pFeature)) {
                    SelectionListener.addItemToMenu(menuItemComponent, featurePopup);
                }
                if (featurePopup.getMenuComponentCount() > 0) {
                    jPopupMenu.add(featurePopup);
                    continue;
                }
                JMenuItem mi = new JMenuItem(featurePopup.getText());
                mi.addActionListener(new ActionListener((PFeature)pFeature){
                    final /* synthetic */ PFeature val$pFeature;
                    {
                        this.val$pFeature = pFeature;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((DefaultFeatureCollection)SelectionListener.this.mappingComponent.getFeatureCollection()).unselectAll();
                        ((DefaultFeatureCollection)SelectionListener.this.mappingComponent.getFeatureCollection()).addToSelection(this.val$pFeature.getFeature());
                    }
                });
                jPopupMenu.add(mi);
            }
        } else if (menuMapPFeatures.size() > 0) {
            Object e = menuMapPFeatures.iterator().next();
            for (Object menuItemComponent : menuMap.getCollection(e)) {
                SelectionListener.addItemToMenu(menuItemComponent, jPopupMenu);
            }
        }
        if (!multipleCommonFeatureActionProvider.isEmpty() && jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.add(new JSeparator());
        }
        for (FeaturesProvider action : multipleCommonFeatureActionProvider.keySet()) {
            Collection multipleCommonFeature = multipleCommonFeatureActionProvider.getCollection((Object)action);
            if (multipleCommonFeature.isEmpty() || action instanceof CheckedFeaturesProvider && (!(action instanceof CheckedFeaturesProvider) || !((CheckedFeaturesProvider)action).isActiveForFeatures(new ArrayList<Feature>(multipleCommonFeature)))) continue;
            action.setSourceFeatures(new ArrayList<Feature>(multipleCommonFeature));
            SelectionListener.addItemToMenu(action, jPopupMenu);
        }
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.show((Component)((Object)this.mappingComponent), (int)pInputEvent.getCanvasPosition().getX(), (int)pInputEvent.getCanvasPosition().getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(PInputEvent pInputEvent) {
        this.setMappingComponent(pInputEvent);
        super.mouseClicked(pInputEvent);
        if (pInputEvent.isRightMouseButton()) {
            if (!this.isInProgress()) {
                try {
                    this.handleRightClick(pInputEvent);
                }
                catch (RuntimeException e) {
                    this.log.error((Object)"Problem while creating context menu", (Throwable)e);
                    ErrorInfo errorInfo = new ErrorInfo(NbBundle.getMessage(SelectionListener.class, (String)"SelectionListener.mouseClicked().title"), NbBundle.getMessage(SelectionListener.class, (String)"SelectionListener.mouseClicked().message"), null, null, (Throwable)e, Level.ALL, null);
                    JXErrorPane.showDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), (ErrorInfo)errorInfo);
                }
            }
        } else if (this.mode.equals("BOUNDING_BOX") || this.mode.equals("ELLIPSE")) {
            this.selectionInProgress = true;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("mouseClicked():" + pInputEvent.getPickedNode()));
                }
                this.clickCount = pInputEvent.getClickCount();
                if (this.clickCount == 2 && pInputEvent.isLeftMouseButton()) {
                    this.doubleclickPoint = this.createPointFromInput(pInputEvent);
                    PNotificationCenter pn = PNotificationCenter.defaultCenter();
                    pn.postNotification(DOUBLECLICK_POINT_NOTIFICATION, (Object)this);
                }
                if (pInputEvent.getComponent() instanceof MappingComponent) {
                    this.mappingComponent = (MappingComponent)pInputEvent.getComponent();
                }
                PFeature clickedPFeature = (PFeature)PFeatureTools.getFirstValidObjectUnderPointer(pInputEvent, new Class[]{PFeature.class}, true);
                try {
                    Point2D point = this.mappingComponent.isSnappingEnabled() ? PFeatureTools.getNearestPointInArea(this.mappingComponent, pInputEvent.getCanvasPosition(), true, null).getPoint() : pInputEvent.getPosition();
                    AbstractNewFeature.geomTypes geomType = AbstractNewFeature.geomTypes.POINT;
                    int currentSrid = CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode());
                    PureNewFeature newFeature = new PureNewFeature(point, this.mappingComponent.getWtst());
                    newFeature.setGeometryType(geomType);
                    newFeature.getGeometry().setSRID(currentSrid);
                    Geometry geom = CrsTransformer.transformToGivenCrs(newFeature.getGeometry(), this.mappingComponent.getMappingModel().getSrs().getCode());
                    newFeature.setGeometry(geom);
                    this.finishingEvent = pInputEvent;
                    this.finishGeometry(newFeature);
                }
                catch (Throwable throwable) {
                    this.log.error((Object)"Error during the creation of the geometry", throwable);
                }
                if (clickedPFeature != null) {
                    Feature feature;
                    this.sel = clickedPFeature;
                    if (this.clickCount == 2 && (feature = this.sel.getFeature()) instanceof DoubleClickableFeature && pInputEvent.isLeftMouseButton()) {
                        ((DoubleClickableFeature)((Object)feature)).doubleClickPerformed(this);
                    }
                }
            }
            finally {
                this.selectionInProgress = false;
            }
        }
    }

    @Override
    public MappingComponent getMappingComponent() {
        return this.mappingComponent;
    }

    private static void addItemToMenu(Object menuItemComponent, Object menuOrPopup) {
        if (menuOrPopup instanceof JMenu) {
            JMenu menu = (JMenu)menuOrPopup;
            if (menuItemComponent instanceof Action) {
                menu.add((Action)menuItemComponent);
            } else if (menuItemComponent instanceof Component) {
                menu.add((Component)menuItemComponent);
            } else if (menuItemComponent instanceof JMenuItem) {
                menu.add((JMenuItem)menuItemComponent);
            } else if (menuItemComponent instanceof PopupMenu) {
                menu.add((PopupMenu)menuItemComponent);
            } else if (menuItemComponent instanceof String) {
                menu.add((String)menuItemComponent);
            }
        } else if (menuOrPopup instanceof JPopupMenu) {
            JPopupMenu popup = (JPopupMenu)menuOrPopup;
            if (menuItemComponent instanceof Action) {
                popup.add((Action)menuItemComponent);
            } else if (menuItemComponent instanceof Component) {
                popup.add((Component)menuItemComponent);
            } else if (menuItemComponent instanceof JMenuItem) {
                popup.add((JMenuItem)menuItemComponent);
            } else if (menuItemComponent instanceof PopupMenu) {
                popup.add((PopupMenu)menuItemComponent);
            } else if (menuItemComponent instanceof String) {
                popup.add((String)menuItemComponent);
            }
        }
    }

    private void unselectAll() {
        ArrayList<Feature> allKeys = new ArrayList<Feature>(this.selectedFeatures.keySet());
        for (Feature f : allKeys) {
            PFeature pf;
            if (!this.featuresFromServicesSelectable && !(f instanceof SelectableServiceFeature) || (pf = this.selectedFeatures.remove(f)) == null) continue;
            pf.setSelected(false);
        }
    }

    private void changeSelection(PFeature f) {
        if (this.featuresFromServicesSelectable || f != null && f.getFeature() instanceof SelectableServiceFeature) {
            f.setSelected(!this.isSelected(f));
            if (f.isSelected()) {
                this.selectedFeatures.put(f.getFeature(), f);
            } else {
                this.selectedFeatures.remove(f.getFeature());
            }
        }
    }

    private boolean isSelected(PFeature f) {
        return this.selectedFeatures.get(f.getFeature()) != null;
    }

    public void addSelectedFeature(PFeature pf) {
        if (this.featuresFromServicesSelectable || pf != null && pf.getFeature() instanceof SelectableServiceFeature) {
            this.selectedFeatures.put(pf.getFeature(), pf);
        }
    }

    public void removeSelectedFeature(PFeature pf) {
        if (this.featuresFromServicesSelectable || pf != null && pf.getFeature() instanceof SelectableServiceFeature) {
            this.selectedFeatures.remove(pf.getFeature());
        }
    }

    public void setFeaturesFromServicesSelectable(boolean featuresFromServicesSelectable) {
        this.featuresFromServicesSelectable = featuresFromServicesSelectable;
    }

    private Point createPointFromInput(PInputEvent event) {
        Point2D pos = event.getPosition();
        WorldToScreenTransform wtst = this.getMappingComponent().getWtst();
        Coordinate coord = new Coordinate(wtst.getSourceX(pos.getX()), wtst.getSourceY(pos.getY()));
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.getCurrentSrid());
        return gf.createPoint(coord);
    }

    @Override
    public void mouseDragged(PInputEvent e) {
        this.setMappingComponent(e);
        super.mouseDragged(e);
        this.clickCount = e.getClickCount();
    }

    @Override
    public void mouseReleased(PInputEvent event) {
        this.setMappingComponent(event);
        super.mouseReleased(event);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public Color getSelectColor() {
        return this.getFillingColor();
    }

    public float getSelectTransparency() {
        return this.getFillingColor().getTransparency();
    }

    @Override
    protected Color getFillingColor() {
        return new Color(20, 20, 20, 20);
    }

    public void redoLastSelect() {
        this.select(this.lastFeature);
    }

    public void showLastFeature() {
        this.showFeature(this.lastFeature);
        this.getMappingComponent().getFeatureCollection().holdFeature(this.lastFeature);
    }

    protected void showFeature(SelectFeature feature) {
        if (feature != null) {
            feature.setEditable(feature.getGeometryType() != AbstractNewFeature.geomTypes.MULTIPOLYGON);
            this.getMappingComponent().getFeatureCollection().addFeature(feature);
            if (this.isHoldingGeometries()) {
                this.getMappingComponent().getFeatureCollection().holdFeature(feature);
            }
        }
    }

    protected void setLastFeature(SelectFeature newValue) {
        SelectFeature oldValue = this.lastFeature;
        this.lastFeature = newValue;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_LAST_FEATURE, oldValue, newValue);
    }

    public SelectFeature getLastSelectFeature() {
        return this.lastFeature;
    }

    public void select(SelectFeature selectFeature) {
        if (selectFeature != null) {
            this.setSelectFeature(selectFeature);
            boolean selectExecuted = this.performSelect(selectFeature);
            if (selectExecuted) {
                this.setLastFeature(selectFeature);
                this.showFeature(selectFeature);
                this.cleanup(selectFeature);
            }
        }
    }

    protected void cleanup(final SelectFeature feature) {
        final PFeature pFeature = this.getMappingComponent().getPFeatureHM().get(feature);
        if (this.isHoldingGeometries()) {
            pFeature.moveToFront();
            feature.setEditable(true);
            this.getMappingComponent().getFeatureCollection().holdFeature(feature);
        } else {
            this.getMappingComponent().getTmpFeatureLayer().addChild((PNode)pFeature);
            pFeature.animateToTransparency(0.0f, 2500L);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (pFeature.getTransparency() > 0.0f) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    SelectionListener.this.getMappingComponent().getFeatureCollection().removeFeature(feature);
                }
            }).start();
        }
    }

    @Override
    public void setMode(String newValue) throws IllegalArgumentException {
        String oldValue = this.getMode();
        super.setMode(newValue);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_MODE, oldValue, newValue);
    }

    protected boolean performSelect(SelectFeature selectFeature) {
        Geometry geom = selectFeature.getGeometry();
        this.mappingComponent.getHandleLayer().removeAllChildren();
        if (geom != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Markiergeometrie = " + geom.toText()));
            }
            if (!this.finishingEvent.isControlDown()) {
                this.lastUnselectedFeatures = null;
                ((DefaultFeatureCollection)this.mappingComponent.getFeatureCollection()).unselectAll();
                this.unselectAll();
                this.featureAdded = false;
            } else {
                this.featureAdded = true;
            }
            PFeature[] pfArr = new PFeature[]{};
            if (geom.getGeometryType().equalsIgnoreCase("point")) {
                if (this.isSelectMultipleFeatures()) {
                    pfArr = PFeatureTools.getAllValidObjectsUnderPointer(this.finishingEvent, new Class[]{PFeature.class}).toArray(new PFeature[0]);
                } else {
                    PNode o = PFeatureTools.getFirstValidObjectUnderPointer(this.finishingEvent, new Class[]{PFeature.class}, true);
                    if (o != null) {
                        pfArr = new PFeature[]{(PFeature)o};
                    }
                }
            } else {
                pfArr = PFeatureTools.getPFeaturesInArea(this.mappingComponent, geom);
            }
            ArrayList<Feature> toBeSelected = new ArrayList<Feature>();
            ArrayList<Feature> toBeUnselected = new ArrayList<Feature>();
            for (PFeature pf : pfArr) {
                if (pf.getFeature().canBeSelected()) {
                    if (!(this.mappingComponent.getFeatureCollection() instanceof DefaultFeatureCollection)) continue;
                    if (!((DefaultFeatureCollection)this.mappingComponent.getFeatureCollection()).isSelected(pf.getFeature())) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Feature markiert: " + pf + " feature: " + String.valueOf(pf.getFeature())));
                        }
                        toBeSelected.add(pf.getFeature());
                    } else {
                        toBeUnselected.add(pf.getFeature());
                    }
                    this.changeSelection(pf);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Feature cannot be selected");
                }
                if (!(this.mappingComponent.getFeatureCollection() instanceof DefaultFeatureCollection)) continue;
                toBeUnselected.add(pf.getFeature());
            }
            ((DefaultFeatureCollection)this.mappingComponent.getFeatureCollection()).addToSelection(toBeSelected);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("toBeSelected.size:" + toBeSelected.size()));
            }
            this.lastUnselectedFeatures = toBeUnselected;
            ((DefaultFeatureCollection)this.mappingComponent.getFeatureCollection()).unselect(toBeUnselected);
            this.pfVector = new ArrayList<PFeature>(((DefaultFeatureCollection)this.mappingComponent.getFeatureCollection()).getSelectedFeatures());
            this.postSelectionChanged();
        }
        this.setLastFeature(selectFeature);
        return true;
    }

    public boolean isHoldingGeometries() {
        return this.holdGeometries;
    }

    public void setHoldGeometries(boolean newValue) {
        this.holdGeometries = newValue;
    }

    public SelectFeature getSelectFeature() {
        return this.selectFeature;
    }

    protected void setSelectFeature(SelectFeature selectFeature) {
        this.selectFeature = selectFeature;
    }

    @Override
    protected void finishGeometry(AbstractNewFeature feature) {
        super.finishGeometry(feature);
        this.selectionInProgress = true;
        try {
            Geometry geom = feature.getGeometry();
            this.performSelect(new SelectFeature(geom, "SELECT"));
        }
        finally {
            this.selectionInProgress = false;
        }
    }

    private void setMappingComponent(PInputEvent pInputEvent) {
        if (this.getMappingComponent() == null) {
            super.setMappingComponent((MappingComponent)pInputEvent.getComponent());
        }
    }

    private void postSelectionChanged() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"postSelectionChanged");
        }
        PNotificationCenter pn = PNotificationCenter.defaultCenter();
        pn.postNotification(SELECTION_CHANGED_NOTIFICATION, (Object)this);
    }

    public List<PFeature> getAllSelectedPFeatures() {
        ArrayList<PFeature> featureList = new ArrayList<PFeature>();
        featureList.addAll(this.selectedFeatures.values());
        return featureList;
    }

    public PFeature getAffectedPFeature() {
        return this.sel;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public Point getDoubleclickPoint() {
        return this.doubleclickPoint;
    }

    public boolean isSelectionInProgress() {
        return this.selectionInProgress;
    }

    public void setSelectionInProgress(boolean selectionInProgress) {
        this.selectionInProgress = selectionInProgress;
    }

    public boolean isSelectMultipleFeatures() {
        return this.selectMultipleFeatures;
    }

    public void setSelectMultipleFeatures(boolean selectMultipleFeatures) {
        this.selectMultipleFeatures = selectMultipleFeatures;
    }

    public boolean isFeatureAdded() {
        return this.featureAdded;
    }

    public void setFeatureAdded(boolean featureAdded) {
        this.featureAdded = featureAdded;
    }

    public List<Feature> getLastUnselectedFeatures() {
        return this.lastUnselectedFeatures;
    }
}

