/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.printing;

import de.cismet.cismap.commons.gui.printing.AdditionalTemplateParameter;
import java.util.Objects;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class Template {
    private static final Logger LOG = Logger.getLogger(Template.class);
    private String title = "";
    private String file = "";
    private String className = "";
    private String mapPlaceholder = "";
    private String northArrowPlaceholder = "northarrow";
    private int mapWidth = 0;
    private int mapHeight = 0;
    private String scaleDemoninatorPlaceholder = "";
    private Vector<AdditionalTemplateParameter> additionalParameters = new Vector();
    private String iconPath = "/de/cismet/cismap/commons/gui/printing/document.png";
    private String shortname = "";
    private transient ImageIcon icon = null;

    public Template(Element template) throws Exception {
        this.title = template.getAttribute("title").getValue();
        this.file = template.getAttribute("file").getValue();
        this.className = template.getAttribute("className").getValue();
        this.mapPlaceholder = template.getAttribute("mapPlaceholder").getValue();
        try {
            this.mapPlaceholder = template.getAttribute("northArrowPlaceholder").getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mapWidth = template.getAttribute("mapWidth").getIntValue();
        this.mapHeight = template.getAttribute("mapHeight").getIntValue();
        this.scaleDemoninatorPlaceholder = template.getAttribute("scaleDenominatorPlaceholder").getValue();
        try {
            this.iconPath = template.getAttribute("iconPath").getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.shortname = template.getAttribute("shortname").getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setIcon();
    }

    public String toString() {
        return this.getTitle();
    }

    public Element getElement(boolean selected) {
        Element e = new Element("template");
        e.setAttribute("selected", String.valueOf(selected));
        e.setAttribute("title", this.getTitle());
        e.setAttribute("file", this.getFile());
        e.setAttribute("className", this.getClassName());
        e.setAttribute("mapPlaceholder", this.getMapPlaceholder());
        e.setAttribute("northArrowPlaceholder", this.getMapPlaceholder());
        e.setAttribute("mapWidth", this.getMapWidth() + "");
        e.setAttribute("mapHeight", this.getMapHeight() + "");
        e.setAttribute("scaleDenominatorPlaceholder", this.getScaleDemoninatorPlaceholder());
        e.setAttribute("iconPath", this.getIconPath() + "");
        e.setAttribute("shortname", this.getShortname() + "");
        return e;
    }

    public boolean equals(Object obj) {
        return obj instanceof Template && ((Template)obj).title.equals(this.title) && ((Template)obj).file.equals(this.file) && ((Template)obj).getClassName().equals(this.getClassName()) && ((Template)obj).mapPlaceholder.equals(this.mapPlaceholder) && ((Template)obj).northArrowPlaceholder.equals(this.northArrowPlaceholder) && ((Template)obj).mapWidth == this.mapWidth && ((Template)obj).mapHeight == this.mapHeight && ((Template)obj).iconPath.equals(this.iconPath) && ((Template)obj).shortname.equals(this.shortname) && ((Template)obj).scaleDemoninatorPlaceholder.equals(this.scaleDemoninatorPlaceholder);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.title);
        hash = 67 * hash + Objects.hashCode(this.file);
        hash = 67 * hash + Objects.hashCode(this.mapPlaceholder);
        hash = 67 * hash + Objects.hashCode(this.northArrowPlaceholder);
        hash = 67 * hash + this.mapWidth;
        hash = 67 * hash + this.mapHeight;
        hash = 67 * hash + Objects.hashCode(this.scaleDemoninatorPlaceholder);
        hash = 67 * hash + Objects.hashCode(this.iconPath);
        hash = 67 * hash + Objects.hashCode(this.shortname);
        return hash;
    }

    public String getNorthArrowPlaceholder() {
        return this.northArrowPlaceholder;
    }

    public void setNorthArrowPlaceholder(String northArrowPlaceholder) {
        this.northArrowPlaceholder = northArrowPlaceholder;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getMapPlaceholder() {
        return this.mapPlaceholder;
    }

    public void setMapPlaceholder(String mapPlaceholder) {
        this.mapPlaceholder = mapPlaceholder;
    }

    public String getScaleDemoninatorPlaceholder() {
        return this.scaleDemoninatorPlaceholder;
    }

    public void setScaleDemoninatorPlaceholder(String scaleDemoninatorPlaceholder) {
        this.scaleDemoninatorPlaceholder = scaleDemoninatorPlaceholder;
    }

    public Vector<AdditionalTemplateParameter> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public void setAdditionalParameters(Vector<AdditionalTemplateParameter> additionalParameters) {
        this.additionalParameters = additionalParameters;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public void setMapHeight(int mapHeight) {
        this.mapHeight = mapHeight;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public void setMapWidth(int mapWidth) {
        this.mapWidth = mapWidth;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public String getShortname() {
        return this.shortname;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public final void setIcon() {
        try {
            this.icon = new ImageIcon(Template.class.getResource(this.iconPath));
        }
        catch (Exception e) {
            LOG.warn((Object)"Problem when setting the Icon of a Template.", (Throwable)e);
        }
    }
}

