/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.interaction.memento;

import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.CustomAction;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureCreateAction;
import de.cismet.cismap.commons.interaction.memento.MementoInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Stack;
import org.apache.log4j.Logger;

public class Memento
extends Observable
implements MementoInterface {
    private final Logger log = Logger.getLogger(this.getClass());
    private Stack<CustomAction> history = new Stack();

    @Override
    public CustomAction getLastAction() {
        if (this.history.size() > 1) {
            return this.history.pop();
        }
        if (this.history.size() == 1) {
            this.setChanged();
            this.notifyObservers("DEACTIVATE");
            return this.history.pop();
        }
        this.setChanged();
        this.notifyObservers("DEACTIVATE");
        return null;
    }

    @Override
    public void addAction(CustomAction a) {
        this.history.push(a);
        this.setChanged();
        this.notifyObservers("ACTIVATE");
    }

    @Override
    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    @Override
    public void clear() {
        this.history.clear();
        this.setChanged();
        this.notifyObservers("DEACTIVATE");
    }

    @Override
    public String getHistory() {
        return this.history.toString();
    }

    @Override
    public void featuresRemoved(Collection<Feature> f) {
        if (this.history.size() > 0) {
            for (Feature feature : f) {
                CustomAction lastAction = (CustomAction)this.history.lastElement();
                if (lastAction instanceof FeatureCreateAction && ((FeatureCreateAction)lastAction).featureConcerned(feature)) continue;
                ArrayList<CustomAction> historyList = new ArrayList<CustomAction>(this.history);
                for (CustomAction action : historyList) {
                    if (!action.featureConcerned(feature)) continue;
                    this.history.remove(action);
                    this.setChanged();
                }
            }
            if (this.history.isEmpty()) {
                this.notifyObservers("DEACTIVATE");
            }
        }
    }
}

