/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.internaldb;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.JDBCFeatureService;
import de.cismet.cismap.commons.featureservice.factory.H2FeatureServiceFactory;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableFactory;
import de.cismet.cismap.commons.gui.capabilitywidget.StringFilter;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.internaldb.DBEntry;
import de.cismet.cismap.commons.internaldb.DBFolder;
import de.cismet.cismap.commons.internaldb.DBTableInformation;
import de.cismet.cismap.commons.internaldb.DBTransferable;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.tools.PointReferencingDialog;
import de.cismet.cismap.linearreferencing.tools.LinearReferencingDialog;
import de.cismet.tools.gui.DefaultPopupMenuListener;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.h2gis.utilities.wrapper.ConnectionWrapper;
import org.openide.util.NbBundle;

public class InternalDbTree
extends JTree {
    private static final Logger LOG = Logger.getLogger(InternalDbTree.class);
    List<InternalDbMenuItem> menuList = new ArrayList<InternalDbMenuItem>();
    private Icon shapeIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerShape.png"));
    private String databasePath;
    private JPopupMenu popupMenu = new JPopupMenu();
    private final List<TreePath> expendedPaths = new ArrayList<TreePath>();

    public InternalDbTree(final String databasePath) {
        this.databasePath = databasePath;
        this.setDragEnabled(true);
        this.setEditable(true);
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.setTransferHandler(new DBTransferHandler());
        this.getSelectionModel().setSelectionMode(4);
        this.menuList.add(new ZoomTo());
        this.menuList.add(new AddFolderItem());
        this.menuList.add(new RemoveItem());
        this.menuList.add(new AddPointGeometry());
        this.menuList.add(new AddLinearReferencing());
        this.addMouseListener((MouseListener)new DefaultPopupMenuListener(this.popupMenu){

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
            }
        });
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (c instanceof JLabel) {
                    if (value instanceof DBEntry && !(value instanceof DBFolder)) {
                        Icon serviceIcon = H2FeatureService.getLayerIcon(0, ((DBEntry)value).getName(), databasePath);
                        ((JLabel)c).setIcon(serviceIcon);
                    } else if (value instanceof DBEntry) {
                        if (expanded) {
                            ((JLabel)c).setIcon(this.getOpenIcon());
                        } else {
                            ((JLabel)c).setIcon(this.getClosedIcon());
                        }
                    } else if (value.equals(InternalDbTree.this.getModel().getRoot())) {
                        if (expanded) {
                            ((JLabel)c).setIcon(this.getOpenIcon());
                        } else {
                            ((JLabel)c).setIcon(this.getClosedIcon());
                        }
                    }
                }
                return c;
            }
        };
        this.setCellRenderer(renderer);
        this.setCellEditor(new DefaultTreeCellEditor(this, renderer){

            @Override
            protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
                if (this.renderer != null) {
                    if (value instanceof DBEntry && !(value instanceof DBFolder)) {
                        this.editingIcon = H2FeatureService.getLayerIcon(0, ((DBEntry)value).getName(), databasePath);
                    } else if (value instanceof DBEntry) {
                        this.editingIcon = expanded ? this.renderer.getOpenIcon() : this.renderer.getClosedIcon();
                    } else if (value.equals(InternalDbTree.this.getModel().getRoot())) {
                        this.editingIcon = expanded ? this.renderer.getOpenIcon() : this.renderer.getClosedIcon();
                    }
                    this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
                } else {
                    this.editingIcon = null;
                    this.offset = 0;
                }
            }

            @Override
            protected boolean canEditImmediately(EventObject event) {
                return true;
            }
        });
        this.setModel(new InternalDBTreeModel());
        this.createPopupMenu();
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                InternalDbTree.this.createPopupMenu();
            }
        });
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Object object = InternalDbTree.this.popupMenu.getTreeLock();
                synchronized (object) {
                    for (int i = 0; i < InternalDbTree.this.popupMenu.getComponentCount(); ++i) {
                        TreePath[] paths = InternalDbTree.this.getSelectionPaths();
                        Component component = InternalDbTree.this.popupMenu.getComponent(i);
                        if (!(component instanceof InternalDbMenuItem)) continue;
                        InternalDbMenuItem menuItem = (InternalDbMenuItem)component;
                        menuItem.refreshText(paths);
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (newValue != null || !propertyName.equals("dropLocation")) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void createPopupMenu() {
        TreePath[] paths = this.getSelectionPaths();
        this.popupMenu.removeAll();
        for (InternalDbMenuItem item : this.menuList) {
            if (!item.isVisible(paths)) continue;
            this.popupMenu.add(item);
        }
    }

    public void refresh() {
        this.setModel(new InternalDBTreeModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolder(DBFolder folder) {
        ArrayList<DBEntry> copy = new ArrayList<DBEntry>(folder.getChildren());
        for (DBEntry entry : copy) {
            this.removeEntry(entry);
        }
        InternalDBTreeModel model = (InternalDBTreeModel)this.getModel();
        Statement st = null;
        try {
            st = model.getConnection().createStatement();
            st.execute("delete from \"sort_meta_data\" where table = '" + folder.getName() + "'");
            st.execute("delete from \"sort_meta_data\" where left(folder, " + folder.getName().length() + ") = '" + folder.getName() + "'");
        }
        catch (Exception e) {
            LOG.error((Object)"Error while removing folder", (Throwable)e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Error while removing folder", (Throwable)ex);
                }
            }
        }
        model.removeFolder(folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(DBEntry entry) {
        try {
            if (entry instanceof DBFolder) {
                this.removeFolder((DBFolder)entry);
                ((InternalDBTreeModel)this.getModel()).fireTreeStructureChanged();
                return;
            }
            InternalDBTreeModel model = (InternalDBTreeModel)this.getModel();
            Connection con = model.getConnection();
            Statement st = null;
            H2FeatureService.removeTableIfExists(entry.getName());
            try {
                st = con.createStatement();
                st.execute("delete from \"sort_meta_data\" where table = '" + entry.getName() + "'");
            }
            catch (Exception e) {
                LOG.error((Object)"Error while removing folder", (Throwable)e);
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException ex) {
                        LOG.error((Object)"Error while removing folder", (Throwable)ex);
                    }
                }
            }
            model.remove(entry.getName());
            this.removeEntryFromActiveLayerModel(entry);
            ((InternalDBTreeModel)this.getModel()).fireTreeStructureChanged();
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot remove entry", (Throwable)e);
        }
    }

    private void removeEntryFromActiveLayerModel(DBEntry entry) {
        MappingModel model = CismapBroker.getInstance().getMappingComponent().getMappingModel();
        TreeMap map = model.getRasterServices();
        if (map != null) {
            for (MapService service : map.values()) {
                H2FeatureService h2Service;
                if (!(service instanceof H2FeatureService) || !(h2Service = (H2FeatureService)service).getTableName().equals(entry.getName())) continue;
                model.removeLayer(h2Service);
                AttributeTableFactory.getInstance().closeAttributeTable(h2Service);
            }
        }
    }

    private void saveExpandedPaths() {
        InternalDBTreeModel model = (InternalDBTreeModel)this.getModel();
        this.expendedPaths.clear();
        TreePath root = new TreePath(new Object[]{model.getRoot()});
        Enumeration<TreePath> en = this.getExpandedDescendants(root);
        while (en.hasMoreElements()) {
            this.expendedPaths.add(en.nextElement());
        }
    }

    private void resetExpansion() {
        InternalDBTreeModel model = (InternalDBTreeModel)this.getModel();
        ArrayList<TreePath> pathCopy = new ArrayList<TreePath>(this.expendedPaths);
        if (pathCopy.isEmpty()) {
            TreePath root = new TreePath(new Object[]{model.getRoot()});
            pathCopy.add(root);
        }
        for (TreePath tp : pathCopy) {
            this.expandPath(tp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFolder(String name) {
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath != null && selectionPath.getLastPathComponent() instanceof DBFolder) {
            DBFolder folder = (DBFolder)selectionPath.getLastPathComponent();
            DBFolder newFolder = new DBFolder(folder.getName() + "->" + name);
            int count = 0;
            while (folder.contains(newFolder)) {
                newFolder = new DBFolder(folder.getName() + "->" + name + "_" + ++count);
            }
            folder.addChildren(newFolder);
            Statement st = null;
            try {
                st = ((InternalDBTreeModel)this.getModel()).getConnection().createStatement();
                st.execute("insert into \"sort_meta_data\" (folder, table, position) VALUES ('" + folder.getName() + "', '" + folder.getName() + "->" + newFolder + "', (select max(position) + 1 from \"" + "sort_meta_data" + "\"))");
            }
            catch (Exception e) {
                LOG.error((Object)"Error while removing folder", (Throwable)e);
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException ex) {
                        LOG.error((Object)"Error while removing folder", (Throwable)ex);
                    }
                }
            }
            ((InternalDBTreeModel)this.getModel()).fireTreeStructureChanged();
        } else {
            ((InternalDBTreeModel)this.getModel()).addFolder(name);
        }
    }

    public static void main(String[] ergs) {
        String a = "asd->sada->dfds";
        "asd->sada->dfds".split("->");
    }

    public DBTableInformation[] getDBTableInformationOfSelectionPath() {
        TreePath[] paths;
        ArrayList<DBEntry> entries = new ArrayList<DBEntry>();
        for (TreePath path : paths = this.getSelectionPaths()) {
            Object o = path.getLastPathComponent();
            if (o instanceof DBFolder) {
                entries.add((DBFolder)o);
                continue;
            }
            if (!(o instanceof DBEntry)) continue;
            entries.add((DBEntry)o);
        }
        DBTableInformation[] databaseTables = new DBTableInformation[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            DBEntry e = (DBEntry)entries.get(i);
            databaseTables[i] = e instanceof DBFolder ? this.getFolderInformation((DBFolder)e) : new DBTableInformation(e.toString(), this.databasePath, e.getName(), e instanceof DBFolder);
        }
        return databaseTables;
    }

    private DBTableInformation getFolderInformation(DBFolder folder) {
        DBTableInformation databaseTable = new DBTableInformation(folder.toString(), this.databasePath, folder.getName(), true);
        for (int n = folder.getChildren().size() - 1; n >= 0; --n) {
            DBEntry entry = folder.getChildren().get(n);
            if (entry instanceof DBFolder) {
                databaseTable.addChild(this.getFolderInformation((DBFolder)entry));
                continue;
            }
            DBTableInformation tmp = new DBTableInformation(entry.toString(), this.databasePath, entry.getName(), false);
            databaseTable.addChild(tmp);
        }
        return databaseTable;
    }

    private void addEntriesToList(List<DBEntry> entries, DBFolder folder) {
        for (DBEntry entry : folder.getChildren()) {
            if (entry instanceof DBFolder) {
                this.addEntriesToList(entries, (DBFolder)entry);
                continue;
            }
            entries.add(entry);
        }
    }

    private abstract class InternalDbMenuItem
    extends JMenuItem
    implements ActionListener {
        public InternalDbMenuItem(String text) {
            super(text);
            this.addActionListener(this);
        }

        public boolean isVisible(TreePath[] paths) {
            return paths != null && paths.length > 0;
        }

        public void refreshText(TreePath[] paths) {
        }
    }

    private class DBEntryComparator
    implements Comparator<DBEntry> {
        private final PreparedStatement positionStatement;
        private final PreparedStatement maxPosStatement;
        private final PreparedStatement insertStatement;
        private String folder;

        public DBEntryComparator(ConnectionWrapper conn, String folder) throws Exception {
            H2FeatureServiceFactory.createSortMetaTableIfNotExist();
            this.positionStatement = conn.prepareStatement("select position from \"sort_meta_data\" where folder = ? and table = ?");
            this.maxPosStatement = conn.prepareStatement("select max(position) from \"sort_meta_data\" where folder = ?");
            this.insertStatement = conn.prepareStatement("insert into \"sort_meta_data\" (folder, table, position) VALUES (?, ?, ?)");
            this.folder = folder;
        }

        @Override
        public int compare(DBEntry o1, DBEntry o2) {
            Integer posO1 = this.getPosition(o1);
            Integer posO2 = this.getPosition(o2);
            return posO1.compareTo(posO2);
        }

        public int getPosition(DBEntry entry) {
            try {
                this.positionStatement.setString(1, this.folder);
                this.positionStatement.setString(2, entry.getName());
                ResultSet rs = this.positionStatement.executeQuery();
                if (rs.next()) {
                    return rs.getInt(1);
                }
                this.maxPosStatement.setString(1, this.folder);
                rs.close();
                rs = this.maxPosStatement.executeQuery();
                int newPos = 1;
                if (rs.next()) {
                    newPos = rs.getInt(1) + 1;
                }
                rs.close();
                this.insertStatement.setString(1, this.folder);
                this.insertStatement.setString(2, entry.getName());
                this.insertStatement.setInt(3, newPos);
                this.insertStatement.execute();
                return newPos;
            }
            catch (Exception e) {
                LOG.error((Object)"SQL error: ", (Throwable)e);
                return 0;
            }
        }

        private void cleanup() {
            try {
                this.positionStatement.close();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while closing statement: ", (Throwable)e);
            }
            try {
                this.maxPosStatement.close();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while closing statement: ", (Throwable)e);
            }
            try {
                this.insertStatement.close();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while closing statement: ", (Throwable)e);
            }
        }
    }

    private class AddPointGeometry
    extends InternalDbMenuItem {
        public AddPointGeometry() {
            super(NbBundle.getMessage(AddPointGeometry.class, (String)"InternalDbTree.AddPointGeometry.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] tps;
            for (TreePath tp : tps = InternalDbTree.this.getSelectionPaths()) {
                if (!(tp.getLastPathComponent() instanceof DBEntry) || tp.getLastPathComponent() instanceof DBFolder) continue;
                try {
                    DBEntry entry = (DBEntry)tp.getLastPathComponent();
                    H2FeatureService service = new H2FeatureService(entry.getNameWithoutFolder(), InternalDbTree.this.databasePath, entry.getName(), null);
                    PointReferencingDialog dialog = new PointReferencingDialog(StaticSwingTools.getParentFrame((Component)InternalDbTree.this), true, service);
                    dialog.setSize(645, 260);
                    dialog.pack();
                    StaticSwingTools.showDialog((JDialog)dialog);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while creating a H2 service instance.", (Throwable)ex);
                }
            }
        }

        @Override
        public boolean isVisible(TreePath[] paths) {
            if (paths != null) {
                boolean visible = true;
                for (TreePath path : paths) {
                    if (!(path.getLastPathComponent() instanceof DBFolder) && !path.getLastPathComponent().equals(InternalDbTree.this.getModel().getRoot())) continue;
                    visible = false;
                    break;
                }
                return visible;
            }
            return false;
        }
    }

    private class AddLinearReferencing
    extends InternalDbMenuItem {
        public AddLinearReferencing() {
            super(NbBundle.getMessage(AddLinearReferencing.class, (String)"InternalDbTree.AddLinearReferencing.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] tps;
            for (TreePath tp : tps = InternalDbTree.this.getSelectionPaths()) {
                if (!(tp.getLastPathComponent() instanceof DBEntry) || tp.getLastPathComponent() instanceof DBFolder) continue;
                try {
                    DBEntry entry = (DBEntry)tp.getLastPathComponent();
                    H2FeatureService service = new H2FeatureService(entry.getNameWithoutFolder(), InternalDbTree.this.databasePath, entry.getName(), null);
                    LinearReferencingDialog dialog = new LinearReferencingDialog(StaticSwingTools.getParentFrame((Component)InternalDbTree.this), true, service);
                    dialog.setSize(645, 260);
                    dialog.pack();
                    StaticSwingTools.showDialog((JDialog)dialog);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while creating a H2 service instance.", (Throwable)ex);
                }
            }
        }

        @Override
        public boolean isVisible(TreePath[] paths) {
            if (paths != null) {
                boolean visible = true;
                for (TreePath path : paths) {
                    if (!(path.getLastPathComponent() instanceof DBFolder) && !path.getLastPathComponent().equals(InternalDbTree.this.getModel().getRoot())) continue;
                    visible = false;
                    break;
                }
                return visible;
            }
            return false;
        }
    }

    private class ZoomTo
    extends InternalDbMenuItem {
        public ZoomTo() {
            super(NbBundle.getMessage(ZoomTo.class, (String)"InternalDbTree.ZoomTo.refreshText().both"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.zoomToExtent();
        }

        private void zoomToExtent() {
            DBTableInformation[] infos = InternalDbTree.this.getDBTableInformationOfSelectionPath();
            Geometry geom = null;
            ArrayList<DBTableInformation> infoList = new ArrayList<DBTableInformation>();
            for (DBTableInformation info : infos) {
                if (info.isFolder()) {
                    infoList.addAll(this.getChildren(info));
                    continue;
                }
                infoList.add(info);
            }
            for (DBTableInformation dbInfo : infoList) {
                try {
                    H2FeatureService layer = new H2FeatureService(dbInfo.getName(), dbInfo.getDatabasePath(), dbInfo.getDatabaseTable(), null);
                    layer.initAndWait();
                    Geometry envelope = ((H2FeatureServiceFactory)layer.getFeatureFactory()).getEnvelope();
                    if (envelope == null) continue;
                    if (geom == null) {
                        geom = envelope;
                        continue;
                    }
                    geom = geom.union(envelope);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while creating H2FeatureService", (Throwable)ex);
                }
            }
            if (geom != null) {
                CismapBroker.getInstance().getMappingComponent().gotoBoundingBoxWithHistory(new XBoundingBox(geom));
            }
        }

        private List<DBTableInformation> getChildren(DBTableInformation infoFolder) {
            ArrayList<DBTableInformation> infoList = new ArrayList<DBTableInformation>();
            if (infoFolder.getChildren() != null) {
                for (DBTableInformation info : infoFolder.getChildren()) {
                    if (info.isFolder()) {
                        infoList.addAll(this.getChildren(info));
                        continue;
                    }
                    infoList.add(info);
                }
            }
            return infoList;
        }

        @Override
        public void refreshText(TreePath[] paths) {
            if (paths != null) {
                boolean folder = false;
                boolean theme = false;
                for (TreePath path : paths) {
                    if (path.getLastPathComponent() instanceof DBFolder) {
                        folder = true;
                        continue;
                    }
                    if (path.getLastPathComponent() instanceof DBEntry) {
                        theme = true;
                        continue;
                    }
                    folder = true;
                }
                if (folder && theme) {
                    this.setText(NbBundle.getMessage(RemoveItem.class, (String)"InternalDbTree.ZoomTo.refreshText().both"));
                } else if (folder) {
                    this.setText(NbBundle.getMessage(RemoveItem.class, (String)"InternalDbTree.ZoomTo.refreshText().folder"));
                } else if (theme) {
                    this.setText(NbBundle.getMessage(RemoveItem.class, (String)"InternalDbTree.ZoomTo.refreshText().theme"));
                }
            }
        }
    }

    private class RemoveItem
    extends InternalDbMenuItem {
        public RemoveItem() {
            super(NbBundle.getMessage(RemoveItem.class, (String)"InternalDbTree.RemoveItem.refreshText().both"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] tps;
            for (TreePath tp : tps = InternalDbTree.this.getSelectionPaths()) {
                DBEntry entry = (DBEntry)tp.getLastPathComponent();
                if (!(tp.getLastPathComponent() instanceof DBEntry)) continue;
                InternalDbTree.this.removeEntry(entry);
            }
        }

        @Override
        public boolean isVisible(TreePath[] paths) {
            if (paths != null) {
                boolean visible = true;
                for (TreePath path : paths) {
                    if (!path.getLastPathComponent().equals(InternalDbTree.this.getModel().getRoot())) continue;
                    visible = false;
                    break;
                }
                return visible;
            }
            return false;
        }

        @Override
        public void refreshText(TreePath[] paths) {
            if (paths != null) {
                boolean folder = false;
                boolean theme = false;
                for (TreePath path : paths) {
                    if (path.getLastPathComponent() instanceof DBFolder) {
                        folder = true;
                        continue;
                    }
                    if (!(path.getLastPathComponent() instanceof DBEntry)) continue;
                    theme = true;
                }
                if (folder && theme) {
                    this.setText(NbBundle.getMessage(RemoveItem.class, (String)"InternalDbTree.RemoveItem.refreshText().both"));
                } else if (folder) {
                    this.setText(NbBundle.getMessage(RemoveItem.class, (String)"InternalDbTree.RemoveItem.refreshText().folder"));
                } else if (theme) {
                    this.setText(NbBundle.getMessage(RemoveItem.class, (String)"InternalDbTree.RemoveItem.refreshText().theme"));
                }
            }
        }
    }

    private class AddFolderItem
    extends InternalDbMenuItem {
        public AddFolderItem() {
            super(NbBundle.getMessage(AddFolderItem.class, (String)"InternalDbTree.AddFolderItem.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InternalDbTree.this.addFolder(NbBundle.getMessage(AddFolderItem.class, (String)"InternalDbTree.AddFolderItem.addFolder"));
        }

        @Override
        public boolean isVisible(TreePath[] path) {
            if (path != null && path.length == 1) {
                return path[0].getLastPathComponent() instanceof DBFolder || path[0].getLastPathComponent().equals(InternalDbTree.this.getModel().getRoot());
            }
            return false;
        }
    }

    private class InternalDBTreeModel
    implements TreeModel,
    StringFilter {
        private ConnectionWrapper conn;
        private List<DBEntry> entries = new ArrayList<DBEntry>();
        private String root = "Intern";
        private List<TreeModelListener> listener = new ArrayList<TreeModelListener>();
        private String filterString;

        public InternalDBTreeModel() {
            this.conn = H2FeatureServiceFactory.getDBConnection(InternalDbTree.this.databasePath);
            this.loadFromDb();
        }

        public void loadFromDb() {
            try {
                ResultSet rs = this.conn.getMetaData().getTables(null, null, "%", new String[]{"TABLE"});
                this.entries.clear();
                while (rs.next()) {
                    String name = rs.getString("TABLE_NAME");
                    if (name.equalsIgnoreCase("spatial_ref_sys") || name.equalsIgnoreCase("linear_referencing_meta") || name.equalsIgnoreCase("table_meta") || name.equalsIgnoreCase("table_attributes_meta") || name.equalsIgnoreCase("sort_meta_data") || name.equalsIgnoreCase("Zeichnungen") || name.equalsIgnoreCase("sld_meta_data") || name.equalsIgnoreCase("cs_lock")) continue;
                    String[] parts = name.split("->");
                    List<DBEntry> parent = this.entries;
                    String parentFolder = "";
                    for (int i = 0; i < parts.length; ++i) {
                        String part = parts[i];
                        if (i == parts.length - 1) {
                            parent.add(new DBEntry(name));
                            continue;
                        }
                        String newFolderName = !parentFolder.equals("") ? parentFolder + "->" + part : part;
                        DBFolder folder = new DBFolder(newFolderName);
                        int folderIndex = parent.indexOf(folder);
                        if (folderIndex == -1) {
                            parent.add(folder);
                        } else {
                            folder = (DBFolder)parent.get(folderIndex);
                        }
                        if (!parentFolder.equals("")) {
                            parentFolder = parentFolder + "->";
                        }
                        parentFolder = parentFolder + part;
                        parent = folder.getChildren();
                    }
                }
                this.addFolder();
                this.sortTables(this.entries);
            }
            catch (Exception e) {
                LOG.error((Object)("Error while retrieving meta infos from the db" + InternalDbTree.this.databasePath), (Throwable)e);
            }
        }

        private void addFolder() {
            Map<Integer, DBFolder> allEntries = this.getAllEntriesInFolder("/");
            for (Integer key : allEntries.keySet()) {
                DBFolder f = allEntries.get(key);
                if (this.entries.contains(f) || this.entries.contains(new DBEntry(f.getName()))) continue;
                if (key > this.entries.size()) {
                    this.entries.add(this.entries.size(), f);
                    continue;
                }
                this.entries.add(key > this.entries.size() ? this.entries.size() : key.intValue(), f);
            }
            for (DBEntry entry : this.entries) {
                if (!(entry instanceof DBFolder)) continue;
                this.addFolder((DBFolder)entry);
            }
        }

        private void addFolder(DBFolder folder) {
            Map<Integer, DBFolder> allEntries = this.getAllEntriesInFolder(folder.getName());
            for (Integer key : allEntries.keySet()) {
                DBFolder f = allEntries.get(key);
                if (folder.contains(f) || folder.contains(new DBEntry(f.getName()))) continue;
                folder.addChildren(f, key);
            }
            for (DBEntry entry : folder.getChildren()) {
                if (!(entry instanceof DBFolder)) continue;
                this.addFolder((DBFolder)entry);
            }
        }

        private Map<Integer, DBFolder> getAllEntriesInFolder(String parent) {
            HashMap<Integer, DBFolder> resultMap = new HashMap<Integer, DBFolder>();
            try {
                Statement st = this.conn.createStatement();
                ResultSet rs = st.executeQuery("select table, position from \"sort_meta_data\" where folder = '" + parent + "'");
                while (rs.next()) {
                    String table = rs.getString(1);
                    if (parent.equals("/")) {
                        if (table.indexOf("->") != -1) continue;
                        resultMap.put(rs.getInt(2) - 1, new DBFolder(table));
                        continue;
                    }
                    if (table.length() <= parent.length() + 2 || table.substring(parent.length() + 2).indexOf("->") != -1) continue;
                    resultMap.put(rs.getInt(2) - 1, new DBFolder(table));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while reading folder", (Throwable)e);
            }
            return resultMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void sortTables(List<DBEntry> parent) {
            DBEntryComparator comparator = null;
            try {
                comparator = new DBEntryComparator(this.conn, "/");
                Collections.sort(parent, comparator);
                for (DBEntry entry : parent) {
                    if (!(entry instanceof DBFolder)) continue;
                    this.sortFolder((DBFolder)entry);
                }
                if (comparator == null) return;
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"Cannot sort folder", (Throwable)e);
                    if (comparator == null) return;
                }
                catch (Throwable throwable) {
                    if (comparator == null) throw throwable;
                    comparator.cleanup();
                    throw throwable;
                }
                comparator.cleanup();
                return;
            }
            comparator.cleanup();
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void saveTableOrder(List<DBEntry> parent) {
            DBEntryComparator comparator = null;
            try {
                comparator = new DBEntryComparator(this.conn, "/");
                for (DBEntry entry : parent) {
                    comparator.getPosition(entry);
                }
                for (DBEntry entry : parent) {
                    if (!(entry instanceof DBFolder)) continue;
                    this.saveFolderOrder((DBFolder)entry);
                }
                if (comparator == null) return;
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"Cannot sort folder", (Throwable)e);
                    if (comparator == null) return;
                }
                catch (Throwable throwable) {
                    if (comparator == null) throw throwable;
                    comparator.cleanup();
                    throw throwable;
                }
                comparator.cleanup();
                return;
            }
            comparator.cleanup();
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void saveFolderOrder(DBFolder folder) throws Exception {
            DBEntryComparator comparator = null;
            try {
                comparator = new DBEntryComparator(this.conn, folder.getName());
                for (DBEntry entry : folder.getChildren()) {
                    comparator.getPosition(entry);
                }
                for (DBEntry entry : folder.getChildren()) {
                    if (!(entry instanceof DBFolder)) continue;
                    this.saveFolderOrder((DBFolder)entry);
                }
                if (comparator == null) return;
            }
            catch (Throwable throwable) {
                if (comparator == null) throw throwable;
                comparator.cleanup();
                throw throwable;
            }
            comparator.cleanup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void sortFolder(DBFolder folder) throws Exception {
            DBEntryComparator comparator = null;
            try {
                comparator = new DBEntryComparator(this.conn, folder.getName());
                Collections.sort(folder.getChildren(), comparator);
                for (DBEntry entry : folder.getChildren()) {
                    if (!(entry instanceof DBFolder)) continue;
                    this.sortFolder((DBFolder)entry);
                }
                if (comparator == null) return;
            }
            catch (Throwable throwable) {
                if (comparator == null) throw throwable;
                comparator.cleanup();
                throw throwable;
            }
            comparator.cleanup();
        }

        public List<DBEntry> getEntries() {
            return this.entries;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent == this.root) {
                return this.filterChildren(this.entries).get(index);
            }
            if (parent instanceof DBFolder) {
                return this.filterChildren(((DBFolder)parent).getChildren()).get(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == this.root) {
                return this.filterChildren(this.entries).size();
            }
            if (parent instanceof DBFolder) {
                return this.filterChildren(((DBFolder)parent).getChildren()).size();
            }
            return 0;
        }

        private List<DBEntry> filterChildren(List<DBEntry> entryList) {
            ArrayList<DBEntry> entries = new ArrayList<DBEntry>();
            for (DBEntry entry : entryList) {
                if (!this.fulfilFilterRequirements(entry)) continue;
                entries.add(entry);
            }
            return entries;
        }

        private boolean fulfilFilterRequirements(DBEntry entry) {
            if (entry instanceof DBFolder) {
                if (this.filterString == null || entry.getNameWithoutFolder().toLowerCase().contains(this.filterString.toLowerCase())) {
                    return true;
                }
                for (DBEntry e : ((DBFolder)entry).getChildren()) {
                    if (!this.fulfilFilterRequirements(e)) continue;
                    return true;
                }
            } else {
                return this.filterString == null || entry.getNameWithoutFolder().toLowerCase().contains(this.filterString.toLowerCase());
            }
            return false;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            try {
                if (newValue != null && !newValue.equals("")) {
                    DBEntry entry = (DBEntry)path.getLastPathComponent();
                    Statement st = this.conn.createStatement();
                    if (entry instanceof DBFolder) {
                        String folderName = newValue.toString();
                        if (entry.getFolderName() != null && !entry.getFolderName().equals("")) {
                            folderName = entry.getFolderName() + "->" + folderName;
                        }
                        this.renameFolder((DBFolder)entry, folderName);
                    } else {
                        String newName = newValue.toString() + "_" + entry.getHash();
                        if (entry.getFolderName() != null && !entry.getFolderName().equals("")) {
                            newName = entry.getFolderName() + "->" + newName;
                        }
                        st.execute("alter table \"" + entry.getName() + "\" rename to \"" + newName + "\"");
                        this.renameExistingService(entry.getName(), newName);
                        entry.setName(newName);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error during rename operation.", (Throwable)e);
            }
        }

        private void renameFolder(DBFolder folder, String newName) {
            try {
                Statement st = this.conn.createStatement();
                for (DBEntry e : folder.getChildren()) {
                    if (e instanceof DBFolder) {
                        this.renameFolder((DBFolder)e, newName + "->" + e.getNameWithoutFolder());
                        continue;
                    }
                    String name = newName + "->" + e.getNameWithoutFolder();
                    st.execute("alter table \"" + e.getName() + "\" rename to \"" + name + "\"");
                    this.renameExistingService(e.getName(), name);
                    e.setName(name);
                }
                folder.setName(newName);
            }
            catch (Exception e) {
                LOG.error((Object)"Error during rename operation.", (Throwable)e);
            }
        }

        private void renameExistingService(String oldName, String newName) {
            ActiveLayerModel mappingModel = (ActiveLayerModel)CismapBroker.getInstance().getMappingComponent().getMappingModel();
            TreeMap<Integer, MapService> treeMap = mappingModel.getMapServices();
            ArrayList<Integer> keyList = new ArrayList<Integer>(treeMap.keySet());
            Iterator it = keyList.iterator();
            while (it.hasNext()) {
                H2FeatureService featureService;
                MapService service = treeMap.get(it.next());
                if (!(service instanceof H2FeatureService) || (featureService = (H2FeatureService)service).getTableName() == null || !featureService.getTableName().equals(oldName)) continue;
                featureService.setTableName(newName);
            }
        }

        public void addEntry(DBEntry e) {
            this.entries.add(e);
            this.fireTreeStructureChanged();
        }

        public void addEntry(DBEntry e, int index) {
            this.entries.add(index, e);
            this.fireTreeStructureChanged();
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent == this.root) {
                return this.filterChildren(this.entries).indexOf(child);
            }
            if (parent instanceof DBFolder) {
                return this.filterChildren(((DBFolder)parent).getChildren()).indexOf(child);
            }
            return 0;
        }

        private void fireTreeStructureChanged() {
            InternalDbTree.this.saveExpandedPaths();
            for (TreeModelListener l : this.listener) {
                l.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.root}));
            }
            InternalDbTree.this.resetExpansion();
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listener.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listener.remove(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFolder(String name) {
            DBFolder folder = new DBFolder(name);
            int count = 0;
            while (this.entries.contains(folder)) {
                folder = new DBFolder(name + "_" + ++count);
            }
            this.entries.add(folder);
            Statement st = null;
            try {
                st = ((InternalDBTreeModel)InternalDbTree.this.getModel()).getConnection().createStatement();
                st.execute("insert into \"sort_meta_data\" (folder, table, position) VALUES ('/', '" + folder.getName() + "', (select max(position) + 1 from \"" + "sort_meta_data" + "\"))");
            }
            catch (Exception e) {
                LOG.error((Object)"Error while removing folder", (Throwable)e);
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException ex) {
                        LOG.error((Object)"Error while removing folder", (Throwable)ex);
                    }
                }
            }
            this.fireTreeStructureChanged();
        }

        public int remove(String tableName) {
            String[] parts = tableName.split("->");
            List<DBEntry> parent = this.entries;
            DBFolder folder = null;
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (i == parts.length - 1) {
                    int position = parent.indexOf(new DBEntry(tableName));
                    if (!parent.remove(new DBEntry(tableName))) {
                        position = parent.indexOf(new DBFolder(tableName));
                        parent.remove(new DBFolder(tableName));
                    }
                    return position;
                }
                int folderIndex = parent.indexOf(folder = folder == null ? new DBFolder(part) : new DBFolder(folder.getName() + "->" + part));
                if (folderIndex == -1) break;
                folder = (DBFolder)parent.get(folderIndex);
                parent = folder.getChildren();
            }
            this.fireTreeStructureChanged();
            return -1;
        }

        public void removeFolder(DBFolder folderToRemove) {
            for (DBEntry e : folderToRemove.getChildren()) {
                if (e instanceof DBFolder) {
                    this.removeFolder((DBFolder)e);
                    continue;
                }
                this.remove(e.getName());
            }
            String[] parts = folderToRemove.getName().split("->");
            List<DBEntry> parent = this.entries;
            DBFolder folder = null;
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (i == parts.length - 1) {
                    parent.remove(folderToRemove);
                    continue;
                }
                int folderIndex = parent.indexOf(folder = folder == null ? new DBFolder(part) : new DBFolder(folder.getName() + "->" + part));
                if (folderIndex == -1) break;
                folder = (DBFolder)parent.get(folderIndex);
                parent = folder.getChildren();
            }
            this.fireTreeStructureChanged();
        }

        public Connection getConnection() {
            return this.conn;
        }

        @Override
        public void setFilterString(String filterString) {
            this.filterString = filterString;
        }
    }

    private class DBTransferHandler
    extends TransferHandler {
        private DataFlavor TREEPATH_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "SelectionAndCapabilities");

        @Override
        protected Transferable createTransferable(JComponent c) {
            InternalDbTree tree = (InternalDbTree)c;
            DBTableInformation[] databaseTables = tree.getDBTableInformationOfSelectionPath();
            return new DBTransferable(databaseTables);
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            JTree t = (JTree)info.getComponent();
            JTree.DropLocation dl = (JTree.DropLocation)info.getDropLocation();
            JTree tree = (JTree)info.getComponent();
            int dropRow = tree.getRowForPath(dl.getPath());
            int[] selRows = tree.getSelectionRows();
            for (int i = 0; i < selRows.length; ++i) {
                if (selRows[i] == dropRow) {
                    return false;
                }
                if (selRows[i] != 0) continue;
                return false;
            }
            Object targetNode = dl.getPath().getLastPathComponent();
            if (!(targetNode instanceof DBFolder) && !targetNode.equals(t.getModel().getRoot())) {
                return false;
            }
            TreePath p = t.getPathForLocation(info.getDropLocation().getDropPoint().x, info.getDropLocation().getDropPoint().y);
            return p != null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            block35: {
                info.setShowDropLocation(true);
                JTree target = (JTree)info.getComponent();
                TreePath p = target.getPathForLocation(info.getDropLocation().getDropPoint().x, info.getDropLocation().getDropPoint().y);
                JTree.DropLocation dl = (JTree.DropLocation)info.getDropLocation();
                InternalDBTreeModel model = (InternalDBTreeModel)target.getModel();
                Connection con = model.getConnection();
                Statement st = null;
                try {
                    int index;
                    st = con.createStatement();
                    Object targetFolder = dl.getPath().getLastPathComponent();
                    int n = index = dl.getChildIndex() != -1 ? dl.getChildIndex() : 0;
                    if (targetFolder instanceof DBFolder || targetFolder.equals(model.getRoot())) {
                        DBTableInformation[] o;
                        DBFolder folder = null;
                        for (DBTableInformation ti : o = (DBTableInformation[])info.getTransferable().getTransferData(this.TREEPATH_FLAVOR)) {
                            MappingModel mm;
                            DBEntry entry;
                            String targetFolderString;
                            String newName = null;
                            if (targetFolder instanceof DBFolder) {
                                folder = (DBFolder)targetFolder;
                                newName = folder.getName() + "->" + this.getNameWithoutFolder(ti.getDatabaseTable());
                            } else if (targetFolder.equals(model.getRoot())) {
                                newName = this.getNameWithoutFolder(ti.getDatabaseTable());
                            }
                            String string = targetFolderString = targetFolder.equals(model.getRoot()) ? "/" : ((DBFolder)targetFolder).getName();
                            if (ti.isFolder()) {
                                entry = this.getEntryFromTableInformation(ti);
                                entry.setName(newName);
                                if (!ti.getParentFolder().equals(targetFolderString)) {
                                    List<DBEntry> entries = this.getDBEntriesFromFolder((DBFolder)entry);
                                    for (DBEntry e : entries) {
                                        String newTableName = newName + "->" + e.getName().substring(ti.getDatabaseTable().length() + 2);
                                        ResultSet rs = con.getMetaData().getTables(null, null, newTableName, null);
                                        if (rs.next()) {
                                            JOptionPane.showMessageDialog(InternalDbTree.this, "Tabelle existiert bereits", "titel", 2);
                                            rs.close();
                                            boolean bl = false;
                                            return bl;
                                        }
                                        rs.close();
                                    }
                                    for (DBEntry e : entries) {
                                        String oldName = e.getName();
                                        String newTableName = newName + "->" + e.getName().substring(ti.getDatabaseTable().length() + 2);
                                        st.execute("alter table \"" + oldName + "\" rename to \"" + newTableName + "\"");
                                        e.setName(newTableName);
                                    }
                                }
                            } else {
                                entry = new DBEntry(newName);
                                if (!ti.getDatabaseTable().equals(newName)) {
                                    st.execute("alter table \"" + ti.getDatabaseTable() + "\" rename to \"" + newName + "\"");
                                }
                            }
                            InternalDbTree.this.saveExpandedPaths();
                            int removeFromPosition = model.remove(ti.getDatabaseTable());
                            if (ti.getParentFolder().equals(targetFolderString) && removeFromPosition != -1 && removeFromPosition <= index) {
                                --index;
                            }
                            if (targetFolder instanceof DBFolder) {
                                folder.addChildren(entry, index);
                            } else if (targetFolder.equals(model.getRoot())) {
                                model.addEntry(entry, index);
                            }
                            st.execute("delete from \"sort_meta_data\"");
                            model.saveTableOrder(model.getEntries());
                            if (!ti.isFolder() && (mm = CismapBroker.getInstance().getMappingComponent().getMappingModel()) instanceof ActiveLayerModel) {
                                ActiveLayerModel activeModel = (ActiveLayerModel)mm;
                                TreeMap<Integer, MapService> map = activeModel.getMapServices();
                                for (Integer key : map.keySet()) {
                                    JDBCFeatureService jdbcs;
                                    MapService service = map.get(key);
                                    if (!(service instanceof JDBCFeatureService) || !(jdbcs = (JDBCFeatureService)service).getTableName().equals(ti.getDatabaseTable())) continue;
                                    jdbcs.setTableName(newName);
                                }
                            }
                            model.loadFromDb();
                            model.fireTreeStructureChanged();
                            InternalDbTree.this.resetExpansion();
                        }
                        break block35;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (Exception e) {
                    LOG.error((Object)"Error during drop operation.", (Throwable)e);
                }
                finally {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException ex) {
                            LOG.error((Object)"cannot close statement", (Throwable)ex);
                        }
                    }
                }
            }
            return true;
        }

        private List<DBEntry> getDBEntriesFromFolder(DBFolder folder) {
            ArrayList<DBEntry> list = new ArrayList<DBEntry>();
            for (DBEntry e : folder.getChildren()) {
                if (e instanceof DBFolder) {
                    list.addAll(this.getDBEntriesFromFolder((DBFolder)e));
                    continue;
                }
                list.add(e);
            }
            return list;
        }

        private DBEntry getEntryFromTableInformation(DBTableInformation ti) {
            if (ti.isFolder()) {
                DBFolder folder = new DBFolder(ti.getDatabaseTable());
                for (DBTableInformation inf : ti.getChildren()) {
                    folder.addChildren(this.getEntryFromTableInformation(inf));
                }
                return folder;
            }
            return new DBEntry(ti.getDatabaseTable());
        }

        private String getNameWithoutFolder(String name) {
            int start = 0;
            if (name.indexOf("->") != -1) {
                start = name.lastIndexOf("->") + 2;
            }
            return name.substring(start);
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int act) {
        }
    }
}

