/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.preferences;

import de.cismet.cismap.commons.preferences.CapabilitiesListTreeNode;
import de.cismet.cismap.commons.preferences.CapabilityLink;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class CapabilitiesPreferences {
    static final Logger log = Logger.getLogger(CapabilitiesPreferences.class);
    private TreeMap<Integer, CapabilityLink> capabilities = new TreeMap();
    private CapabilitiesListTreeNode capabilitiesListTree;
    private boolean searchActivated;

    public CapabilitiesPreferences() {
    }

    public CapabilitiesPreferences(Element serverParent, Element localParent) {
        Attribute searchActive;
        Element serverRoot = serverParent.getChild("cismapCapabilitiesPreferences");
        Element clientRoot = localParent.getChild("cismapCapabilitiesPreferences");
        if (serverRoot != null && (searchActive = serverRoot.getAttribute("searchPanelActivated")) != null) {
            try {
                this.searchActivated = searchActive.getBooleanValue();
            }
            catch (DataConversionException e) {
                log.warn((Object)"Invalid value for attribute searchPanelActivated found", (Throwable)e);
            }
        }
        if (clientRoot != null) {
            searchActive = clientRoot.getAttribute("searchPanelActivated");
            if (searchActive != null) {
                try {
                    this.searchActivated = searchActive.getBooleanValue();
                }
                catch (DataConversionException e) {
                    log.warn((Object)"Invalid value for attribute searchPanelActivated found", (Throwable)e);
                }
            }
            List caps = clientRoot.getChildren("capabilities");
            Iterator it = caps.iterator();
            int counter = 0;
            while (it.hasNext()) {
                try {
                    Element elem = (Element)it.next();
                    String type = elem.getAttribute("type").getValue();
                    String alias = elem.getAttributeValue("alias");
                    String link = elem.getTextTrim();
                    String subparent = elem.getAttributeValue("subparent");
                    boolean active = false;
                    try {
                        active = elem.getAttribute("active").getBooleanValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    boolean reverseAxisOrder = false;
                    try {
                        reverseAxisOrder = elem.getAttribute("reverseAxisOrder").getBooleanValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.capabilities.put(new Integer(counter++), new CapabilityLink(type, link, reverseAxisOrder, active, subparent, alias));
                }
                catch (Throwable t) {
                    log.warn((Object)"Error while reading the CapabilityPreferences.", t);
                }
            }
        }
        this.capabilitiesListTree = CapabilitiesPreferences.createCapabilitiesListTreeNode(null, serverRoot);
    }

    private static CapabilitiesListTreeNode createCapabilitiesListTreeNode(String nodetitle, Element element) {
        CapabilitiesListTreeNode node = new CapabilitiesListTreeNode();
        int listCounter = 0;
        node.setTitle(nodetitle);
        TreeMap<Integer, CapabilityLink> capabilitiesList = new TreeMap<Integer, CapabilityLink>();
        for (Element elem : element.getChildren("capabilitiesList")) {
            try {
                String type = elem.getAttribute("type").getValue();
                String title = elem.getAttribute("titlestring").getValue();
                boolean reverseAxisOrder = false;
                Attribute reverseAxisOrderElement = elem.getAttribute("reverseAxisOrder");
                if (reverseAxisOrderElement != null) {
                    reverseAxisOrder = reverseAxisOrderElement.getBooleanValue();
                }
                if (type.equals("MENU")) {
                    node.addSubnode(CapabilitiesPreferences.createCapabilitiesListTreeNode(title, elem));
                    continue;
                }
                String alias = elem.getAttributeValue("alias");
                String link = alias != null ? alias : elem.getTextTrim();
                String subparent = elem.getAttributeValue("subparent");
                capabilitiesList.put(new Integer(listCounter++), new CapabilityLink(type, link, reverseAxisOrder, title, subparent));
            }
            catch (Throwable t) {
                log.warn((Object)"Error while reading the CapabilityListPreferences.", t);
            }
        }
        node.setCapabilitiesList(capabilitiesList);
        return node;
    }

    public TreeMap<Integer, CapabilityLink> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(TreeMap<Integer, CapabilityLink> capabilities) {
        this.capabilities = capabilities;
    }

    public CapabilitiesListTreeNode getCapabilitiesListTree() {
        return this.capabilitiesListTree;
    }

    public boolean isSearchActivated() {
        return this.searchActivated;
    }

    public void setSearchActivated(boolean searchActivated) {
        this.searchActivated = searchActivated;
    }
}

