/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.preferences;

import de.cismet.cismap.commons.preferences.CapabilitiesPreferences;
import de.cismet.cismap.commons.preferences.GlobalPreferences;
import de.cismet.cismap.commons.preferences.LayersPreferences;
import java.net.URL;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class CismapPreferences {
    final Logger log = Logger.getLogger(this.getClass());
    private LayersPreferences layersPrefs;
    private GlobalPreferences globalPrefs;
    private CapabilitiesPreferences capabilityPrefs;

    public CismapPreferences(URL url) {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build(url);
            Element prefs = doc.getRootElement();
            this.readFromCismapPreferences(prefs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CismapPreferences(Element cismapPreferences) {
        this.readFromCismapPreferences(cismapPreferences);
    }

    private void readFromCismapPreferences(Element cismapPreferences) {
        try {
            this.layersPrefs = new LayersPreferences(this, cismapPreferences.getChild("cismapLayersPreferences"));
        }
        catch (Exception e) {
            this.log.warn((Object)"Error while loading the LayersPreferences", (Throwable)e);
        }
        try {
            this.globalPrefs = new GlobalPreferences(cismapPreferences.getChild("cismapGlobalPreferences"));
        }
        catch (Exception e) {
            this.log.warn((Object)"Error while loading the GlobalPreferences", (Throwable)e);
        }
        try {
            this.capabilityPrefs = new CapabilitiesPreferences(cismapPreferences.getChild("cismapCapabilitiesPreferences"), cismapPreferences.getChild("cismapCapabilitiesPreferences"));
        }
        catch (Exception e) {
            this.log.warn((Object)"Error while loading the CapabilitiesPreferences", (Throwable)e);
        }
    }

    public LayersPreferences getLayersPrefs() {
        return this.layersPrefs;
    }

    public void setLayersPrefs(LayersPreferences layersPrefs) {
        this.layersPrefs = layersPrefs;
    }

    public GlobalPreferences getGlobalPrefs() {
        return this.globalPrefs;
    }

    public void setGlobalPrefs(GlobalPreferences globalPrefs) {
        this.globalPrefs = globalPrefs;
    }

    public CapabilitiesPreferences getCapabilityPrefs() {
        return this.capabilityPrefs;
    }

    public void setCapabilityPrefs(CapabilitiesPreferences capabilityPrefs) {
        this.capabilityPrefs = capabilityPrefs;
    }
}

