/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.raster.wms;

import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.SlidableWMSServiceLayerGroup;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.tools.gui.VerticalTextIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SlidableWMSServiceLayerGroupInternalFrame
extends JInternalFrame {
    private static final ImageIcon LOCK_ICON = new ImageIcon(SlidableWMSServiceLayerGroupInternalFrame.class.getResource("/de/cismet/cismap/commons/raster/wms/res/lock.png"));
    private static final ImageIcon UNLOCK_ICON = new ImageIcon(SlidableWMSServiceLayerGroupInternalFrame.class.getResource("/de/cismet/cismap/commons/raster/wms/res/lock-unlock.png"));
    private static final transient Logger LOG = Logger.getLogger(SlidableWMSServiceLayerGroupInternalFrame.class);
    private final SlidableWMSServiceLayerGroupJSlider slider = new SlidableWMSServiceLayerGroupJSlider();
    private final JButton btnLock = new JButton();
    private SlidableWMSServiceLayerGroup model;
    private boolean allowCrossfade;

    public SlidableWMSServiceLayerGroupInternalFrame(SlidableWMSServiceLayerGroup model, int sliderValue) {
        this.model = model;
        this.slider.setMinimum(0);
        this.slider.setMaximum((model.getLayers().size() - 1) * 100);
        this.slider.setValue(sliderValue);
        this.slider.setMinorTickSpacing(100);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.slider, "Center");
        this.slider.setSnapToTicks(true);
        this.slider.repaint();
        this.btnLock.setText("");
        this.btnLock.setIcon(LOCK_ICON);
        this.btnLock.setBorder(null);
        this.btnLock.setContentAreaFilled(false);
        this.btnLock.setPreferredSize(new Dimension(32, (int)this.slider.getPreferredSize().getHeight()));
        this.btnLock.setFocusPainted(false);
        this.btnLock.setToolTipText(NbBundle.getMessage(SlidableWMSServiceLayerGroup.class, (String)"SlidableWMSServiceLayerGroup.initDialog().btnLock.tooltip"));
        this.btnLock.setVisible(model.isResourceConserving());
        this.getContentPane().add((Component)this.btnLock, "West");
        this.updateHorizontalOrVertical();
        this.setResizable(true);
        this.addListenersFromModel();
    }

    public void updateHorizontalOrVertical() {
        int mapCWidth = CismapBroker.getInstance().getMappingComponent().getWidth();
        double sliderWidth = this.slider.estimateSliderWidthHorizontalLabels();
        if (sliderWidth / (double)mapCWidth < this.model.getVerticalLabelWidthThreshold()) {
            this.slider.drawLabels(SlidableWMSServiceLayerGroup.LabelDirection.HORIZONTAL);
        } else {
            this.slider.drawLabels(SlidableWMSServiceLayerGroup.LabelDirection.VERTICAL);
            sliderWidth = this.slider.estimateSliderWidthVerticalLabels();
        }
        this.setPreferredSize(new Dimension((int)sliderWidth + 24, (int)this.slider.getPreferredSize().getHeight() + 15));
        this.pack();
    }

    public int getSliderValue() {
        return this.slider.getValue();
    }

    public void enableSlider(boolean enable) {
        this.slider.setEnabled(enable);
    }

    public void setLockIcon() {
        this.btnLock.setIcon(LOCK_ICON);
    }

    public void setUnlocIcon() {
        this.btnLock.setIcon(UNLOCK_ICON);
    }

    private void addListenersFromModel() {
        this.slider.addChangeListener(this.model);
        this.btnLock.addActionListener(this.model.getLockListener());
    }

    public SlidableWMSServiceLayerGroup getModel() {
        return this.model;
    }

    public void setModel(SlidableWMSServiceLayerGroup model) {
        this.model = model;
        this.addListenersFromModel();
    }

    public void removeModel() {
        this.slider.removeChangeListener(this.model);
        this.btnLock.removeActionListener(this.model.getLockListener());
        this.model = null;
    }

    public boolean isAllowCrossfade() {
        return this.allowCrossfade;
    }

    public String getTickTitle(WMSServiceLayer wsl) {
        String name = wsl.getName();
        if (name.contains("$fromConfig$")) {
            return name.replace("$fromConfig$", "");
        }
        return this.createShortLayerTitle(wsl);
    }

    private String createShortLayerTitle(WMSServiceLayer layer) {
        String layerTitle = "";
        try {
            String[] keywords;
            for (String keyword : keywords = ((Layer)layer.ogcLayers.get(0)).getKeywords()) {
                if (!keyword.startsWith("cismapSlidingLayerGroupMember.tickTitle")) continue;
                layerTitle = keyword.split(":")[1];
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"An error occured while parsing tickTitle. Use layer title or name.", (Throwable)ex);
        }
        if (layerTitle.trim().equals("")) {
            layerTitle = layer.getTitle();
            if (layerTitle.trim().equals("")) {
                layerTitle = layer.getName();
            }
            if (layerTitle.length() > 8) {
                layerTitle = layerTitle.substring(0, 3) + "." + layerTitle.substring(layerTitle.length() - 4);
            }
        }
        return layerTitle;
    }

    void setSliderValue(int value) {
        this.slider.setValue(value);
    }

    private class SlidableWMSServiceLayerGroupJSlider
    extends JSlider
    implements ComponentListener {
        private SlidableWMSServiceLayerGroup.LabelDirection labelDirection;

        public SlidableWMSServiceLayerGroupJSlider() {
            this.addComponentListener(this);
        }

        public void drawLabels(SlidableWMSServiceLayerGroup.LabelDirection direction) {
            this.labelDirection = direction;
            switch (direction) {
                case HORIZONTAL: {
                    this.drawLabelsHorizontally();
                    break;
                }
                case VERTICAL: {
                    this.drawLabelsVertically();
                }
            }
        }

        private void drawLabelsHorizontally() {
            this.setLabelTable(null);
            Hashtable<Integer, JLabel> lableTable = new Hashtable<Integer, JLabel>();
            int x = 0;
            for (WMSServiceLayer wsl : SlidableWMSServiceLayerGroupInternalFrame.this.model.getLayers()) {
                String layerTitle = SlidableWMSServiceLayerGroupInternalFrame.this.getTickTitle(wsl);
                JLabel label = new JLabel(layerTitle);
                Font font = label.getFont().deriveFont(10.0f);
                label.setFont(font);
                lableTable.put(x * 100, label);
                ++x;
            }
            this.setLabelTable(lableTable);
        }

        private void drawLabelsVertically() {
            this.setLabelTable(null);
            Hashtable<Integer, JLabel> lableTable = new Hashtable<Integer, JLabel>();
            int x = 0;
            for (WMSServiceLayer wsl : SlidableWMSServiceLayerGroupInternalFrame.this.model.getLayers()) {
                String layerTitle = SlidableWMSServiceLayerGroupInternalFrame.this.getTickTitle(wsl);
                JLabel label = new JLabel();
                label.setIcon((Icon)new VerticalTextIcon(layerTitle, false));
                lableTable.put(x * 100, label);
                ++x;
            }
            this.setLabelTable(lableTable);
        }

        private void drawDisabledLabelsVertically() {
            this.setLabelTable(null);
            Hashtable<Integer, JLabel> lableTable = new Hashtable<Integer, JLabel>();
            int x = 0;
            for (WMSServiceLayer wsl : SlidableWMSServiceLayerGroupInternalFrame.this.model.getLayers()) {
                String layerTitle = SlidableWMSServiceLayerGroupInternalFrame.this.getTickTitle(wsl);
                JLabel label = new JLabel();
                label.setIcon((Icon)new VerticalTextIcon(layerTitle, false, Color.DARK_GRAY));
                lableTable.put(x * 100, label);
                ++x;
            }
            this.setLabelTable(lableTable);
        }

        public double estimateSliderWidthHorizontalLabels() {
            StringBuilder text = new StringBuilder();
            for (WMSServiceLayer wsl : SlidableWMSServiceLayerGroupInternalFrame.this.model.getLayers()) {
                String layerTitle = SlidableWMSServiceLayerGroupInternalFrame.this.getTickTitle(wsl);
                text.append(layerTitle);
                text.append("  ");
            }
            return this.getFontMetrics(this.getFont()).getStringBounds(text.toString(), this.getGraphics()).getWidth();
        }

        public double estimateSliderWidthVerticalLabels() {
            double sliderWidth = 0.0;
            WMSServiceLayer firstLayer = SlidableWMSServiceLayerGroupInternalFrame.this.model.getLayers().get(0);
            String layerTitle = SlidableWMSServiceLayerGroupInternalFrame.this.getTickTitle(firstLayer);
            VerticalTextIcon icon = new VerticalTextIcon(layerTitle, false);
            int iconWidth = icon.getIconWidth();
            int gap = 5;
            for (WMSServiceLayer wsl : SlidableWMSServiceLayerGroupInternalFrame.this.model.getLayers()) {
                sliderWidth += (double)(iconWidth + 5);
            }
            return sliderWidth;
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (this.labelDirection != null && this.labelDirection.equals((Object)SlidableWMSServiceLayerGroup.LabelDirection.VERTICAL)) {
                if (enabled) {
                    this.drawLabelsVertically();
                } else {
                    this.drawDisabledLabelsVertically();
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            SlidableWMSServiceLayerGroupInternalFrame.this.allowCrossfade = (double)this.getWidth() * 1.0 / (double)SlidableWMSServiceLayerGroupInternalFrame.this.model.getLayers().size() > 30.0 || SlidableWMSServiceLayerGroupInternalFrame.this.model.isCrossfadeEnabled();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            SlidableWMSServiceLayerGroupInternalFrame.this.allowCrossfade = (double)this.getWidth() * 1.0 / (double)SlidableWMSServiceLayerGroupInternalFrame.this.model.getLayers().size() > 30.0 || SlidableWMSServiceLayerGroupInternalFrame.this.model.isCrossfadeEnabled();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }
}

