/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.raster.wms;

import de.cismet.cismap.commons.capabilities.AbstractCapabilitiesTreeModel;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.commons.wms.capabilities.Style;
import de.cismet.commons.wms.capabilities.WMSCapabilities;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class WMSCapabilitiesTreeModel
extends AbstractCapabilitiesTreeModel {
    private WMSCapabilities capabilities = null;
    private String subparent = null;
    private Vector listener = new Vector();

    public WMSCapabilitiesTreeModel(WMSCapabilities capabilities) {
        this(capabilities, null);
    }

    public WMSCapabilitiesTreeModel(WMSCapabilities capabilities, String subparent) {
        this.capabilities = capabilities;
        this.subparent = subparent;
    }

    private WMSCapabilitiesTreeModel() {
    }

    public WMSCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(WMSCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof Layer && ((Layer)node).getChildren().length == 0 && ((Layer)node).getStyles().length == 0 || node instanceof Style;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof Layer) {
            int layerChilds = ((Layer)parent).getChildren().length;
            int styleChilds = ((Layer)parent).getStyles().length;
            return layerChilds + styleChilds;
        }
        return 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listener.remove(l);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listener.add(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof Layer) {
            int layerChilds = ((Layer)parent).getChildren().length;
            if (index < layerChilds) {
                return ((Layer)parent).getChildren()[index];
            }
            return ((Layer)parent).getStyles()[index - layerChilds];
        }
        return null;
    }

    @Override
    public Object getRoot() {
        Layer rootLayer = this.subparent != null ? this.getLayerByTitle(this.capabilities.getLayer(), this.subparent) : this.capabilities.getLayer();
        if (rootLayer != null) {
            rootLayer.setFilterString(this.filterString);
        }
        return rootLayer;
    }

    private Layer getLayerByTitle(Layer layer, String title) {
        Layer[] larr;
        if (layer.getTitle() != null && layer.getTitle().equals(title)) {
            return layer;
        }
        for (Layer l : larr = layer.getChildren()) {
            Layer test = this.getLayerByTitle(l, title);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return 0;
    }
}

