/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.raster.wms;

import de.cismet.cismap.commons.ChildrenProvider;
import de.cismet.cismap.commons.LayerInfoProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.capabilities.CapabilitiesCache;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.interaction.events.StatusEvent;
import de.cismet.cismap.commons.preferences.CapabilityLink;
import de.cismet.cismap.commons.raster.wms.AbstractWMSServiceLayer;
import de.cismet.cismap.commons.raster.wms.WMSLayer;
import de.cismet.cismap.commons.rasterservice.ImageRetrieval;
import de.cismet.cismap.commons.rasterservice.RasterMapService;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.commons.wms.capabilities.Operation;
import de.cismet.commons.wms.capabilities.Style;
import de.cismet.commons.wms.capabilities.WMSCapabilities;
import de.cismet.commons.wms.capabilities.WMSCapabilitiesFactory;
import de.cismet.tools.CalculationCache;
import de.cismet.tools.PropertyEqualsProvider;
import edu.umd.cs.piccolo.PNode;
import java.awt.EventQueue;
import java.beans.PropertyChangeSupport;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.openide.util.NbBundle;

public final class WMSServiceLayer
extends AbstractWMSServiceLayer
implements RetrievalServiceLayer,
RasterMapService,
PropertyEqualsProvider,
LayerInfoProvider,
ChildrenProvider {
    private static final transient Logger LOG = Logger.getLogger(WMSServiceLayer.class);
    private static final String TEMPLATETOKEN_WIDTH = "<cismap:width>";
    private static final String TEMPLATETOKEN_HEIGHT = "<cismap:height>";
    private static final String TEMPLATETOKEN_BOUNDINGBOX_LL_X = "<cismap:boundingBox_ll_x>";
    private static final String TEMPLATETOKEN_BOUNDINGBOX_LL_Y = "<cismap:boundingBox_ll_y>";
    private static final String TEMPLATETOKEN_BOUNDINGBOX_UR_X = "<cismap:boundingBox_ur_x>";
    private static final String TEMPLATETOKEN_BOUNDINGBOX_UR_Y = "<cismap:boundingBox_ur_y>";
    private static final String TEMPLATETOKEN_SRS = "<cismap:srs>";
    private static final String TEMPLATETOKEN_CUSTOMSTYLE = "<cismap:customStyle>";
    public static final String TEMPLATETOKEN_CUSTOMSTYLE_LAYERNAME = "<cismap:layerName>";
    public static final String TEMPLATETOKEN_CUSTOMSTYLE_TITLE = "<cismap:title>";
    private static final String EPSG_NAMESPACE = "http://www.opengis.net/gml/srs/epsg.xml";
    private static final String TEMPLATE_GETMAP_PAYLOAD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GetMap xmlns:ows=\"http://www.opengis.net/ows\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" version=\"1.1.1\" service=\"WMS\"><cismap:customStyle><BoundingBox srsName=\"http://www.opengis.net/gml/srs/epsg.xml#<cismap:srs>\"><gml:coord><gml:X><cismap:boundingBox_ll_x></gml:X><gml:Y><cismap:boundingBox_ll_y></gml:Y></gml:coord><gml:coord><gml:X><cismap:boundingBox_ur_x></gml:X><gml:Y><cismap:boundingBox_ur_y></gml:Y></gml:coord></BoundingBox><Output><Format>image/png</Format><Size><Width><cismap:width></Width><Height><cismap:height></Height></Size><Transparent>true</Transparent></Output><Exceptions>application/vnd.ogc.se+xml</Exceptions></GetMap>";
    List wmsLayers = new ArrayList();
    List ogcLayers = new ArrayList();
    Object retrievalBlocker = new Object();
    private PNode imageObject = new PNode();
    private String imageFormat = null;
    private String backgroundColor = null;
    private String exceptionsFormat = null;
    private boolean transparentImage = true;
    private String srs;
    private String title;
    private WMSCapabilities wmsCapabilities;
    private String capabilitiesUrl;
    private String customSLD;
    private List treePaths;
    private Element wmsServiceLayerElement;
    private HashMap<String, WMSCapabilities> capabilities;
    private List<WMSLayer> dummyLayer = new ArrayList<WMSLayer>();
    private boolean reverseAxisOrder = false;

    public WMSServiceLayer() {
    }

    public WMSServiceLayer(List treePaths) {
        this(treePaths, true, false);
    }

    public WMSServiceLayer(Layer l) {
        this.setTitle(l.getTitle());
        this.setName(l.getName());
        this.addLayer(l);
    }

    public WMSServiceLayer(Element wmsServiceLayerElement, HashMap<String, WMSCapabilities> capabilities) {
        this.wmsServiceLayerElement = wmsServiceLayerElement;
        this.capabilities = capabilities;
        this.init(wmsServiceLayerElement, capabilities, false);
    }

    public WMSServiceLayer(List treePaths, boolean reverseLayerOrder, boolean reverseSubLayerOrder) {
        this.treePaths = treePaths;
        if (treePaths != null) {
            int i;
            if (treePaths.size() > 1) {
                this.setName("Layerzusammenstellung");
            }
            int n = i = reverseLayerOrder ? treePaths.size() - 1 : 0;
            while (reverseLayerOrder ? i >= 0 : i < treePaths.size()) {
                Object next = treePaths.get(i);
                if (next instanceof TreePath) {
                    TreePath nextTreePath = (TreePath)next;
                    if (nextTreePath.getLastPathComponent() instanceof Layer) {
                        Layer nextLayer = (Layer)nextTreePath.getLastPathComponent();
                        this.addLayer(nextLayer, null, true, false, true, reverseSubLayerOrder);
                        if (this.getName() == null) {
                            this.setName(nextLayer.getTitle());
                        }
                    } else if (nextTreePath.getLastPathComponent() instanceof Style) {
                        Style nextStyle = (Style)nextTreePath.getLastPathComponent();
                        if (nextTreePath.getPathComponent(nextTreePath.getPathCount() - 2) instanceof Layer) {
                            Layer nextLayer = (Layer)nextTreePath.getPathComponent(nextTreePath.getPathCount() - 2);
                            this.addLayer(nextLayer, nextStyle);
                            if (this.getName() == null) {
                                this.setName(nextLayer.getTitle());
                            }
                        }
                    }
                }
                if (reverseLayerOrder) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    private void init(Element wmsServiceLayerElement, HashMap<String, WMSCapabilities> capabilities, boolean loadCapDoc) {
        Attribute attributeReverseAxisOrder;
        this.setName(wmsServiceLayerElement.getAttribute("name").getValue());
        Attribute attributeTitle = wmsServiceLayerElement.getAttribute("title");
        if (attributeTitle != null) {
            this.setTitle(attributeTitle.getValue());
        }
        if ((attributeReverseAxisOrder = wmsServiceLayerElement.getAttribute("reverseAxisOrder")) != null) {
            try {
                this.reverseAxisOrder = attributeReverseAxisOrder.getBooleanValue();
            }
            catch (DataConversionException e) {
                LOG.error((Object)"Cannot parse the reverse axis order", (Throwable)e);
            }
        }
        try {
            this.setVisible(wmsServiceLayerElement.getAttribute("visible").getBooleanValue());
        }
        catch (DataConversionException e) {
            // empty catch block
        }
        try {
            this.setTranslucency(wmsServiceLayerElement.getAttribute("translucency").getFloatValue());
        }
        catch (DataConversionException e) {
            // empty catch block
        }
        try {
            Float minOpacity = CismapBroker.getInstance().getMinOpacityToStayEnabled();
            if (minOpacity != null && (this.getTranslucency() <= minOpacity.floatValue() || !this.isVisible())) {
                this.setEnabled(false);
            } else {
                this.setEnabled(wmsServiceLayerElement.getAttribute("enabled").getBooleanValue());
            }
        }
        catch (DataConversionException ex) {
            LOG.error((Object)"Error while set WMSServiceLayer.enabled", (Throwable)ex);
        }
        this.setBackgroundColor(wmsServiceLayerElement.getAttribute("bgColor").getValue());
        this.setImageFormat(wmsServiceLayerElement.getAttribute("imageFormat").getValue());
        this.setExceptionsFormat(wmsServiceLayerElement.getAttribute("exceptionFormat").getValue());
        CapabilityLink cp = new CapabilityLink(wmsServiceLayerElement);
        WMSCapabilities wmsCaps = capabilities.get(cp.getLink());
        if (loadCapDoc && wmsCaps == null) {
            try {
                wmsCaps = this.createCapabilitiesDocument();
                capabilities.put(cp.getLink(), wmsCaps);
            }
            catch (Exception e) {
                this.errorObject = e.getMessage();
                LOG.error((Object)"Error while initialising a WMSServiceLayer object.", (Throwable)e);
            }
        }
        this.setWmsCapabilities(wmsCaps);
        this.setCapabilitiesUrl(cp.getLink());
        List layerList = wmsServiceLayerElement.getChildren("wmsLayer");
        Iterator it = layerList.iterator();
        this.wmsLayers.clear();
        this.ogcLayers.clear();
        this.dummyLayer.clear();
        while (it.hasNext()) {
            Element elem = (Element)it.next();
            String lName = elem.getAttribute("name").getValue();
            String styleName = null;
            boolean isEnabled = true;
            boolean info = false;
            try {
                isEnabled = elem.getAttribute("enabled").getBooleanValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                info = elem.getAttribute("info").getBooleanValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                styleName = elem.getAttribute("style").getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (wmsCaps != null) {
                Layer l = this.searchForLayer(this.getWmsCapabilities().getLayer(), lName);
                if (l == null) continue;
                if (layerList.size() == 1 && (this.getName() == null || this.getName().equals(""))) {
                    this.setName(l.getTitle());
                }
                Style style = null;
                if (styleName != null) {
                    style = l.getStyleResource(styleName);
                }
                this.addLayer(l, style, isEnabled, info, false);
                continue;
            }
            this.addLayer(lName, styleName, true, info);
        }
        this.setEnabled(this.isEnabled());
    }

    protected void addLayer(Layer nextLayer, Style selectedStyle, boolean enabled, boolean info) {
        this.addLayer(nextLayer, selectedStyle, enabled, info, true);
    }

    protected void addLayer(Layer nextLayer, Style selectedStyle, boolean enabled, boolean info, boolean addSubLayer) {
        this.addLayer(nextLayer, selectedStyle, enabled, info, addSubLayer, false);
    }

    protected void addLayer(Layer nextLayer, Style selectedStyle, boolean enabled, boolean info, boolean addSubLayer, boolean reverseSubLayerOrder) {
        block7: {
            if (nextLayer.getName() != null && !nextLayer.getName().equals("")) {
                if (selectedStyle == null && nextLayer.getStyles() != null && nextLayer.getStyles().length > 0 && nextLayer.getStyles()[0] != null) {
                    selectedStyle = nextLayer.getStyles()[0];
                }
                final WMSLayer wmsLayer = new WMSLayer(nextLayer, selectedStyle);
                wmsLayer.setEnabled(enabled);
                wmsLayer.setParentServiceLayer(this);
                wmsLayer.setQuerySelected(info);
                if (this.ogcLayers.indexOf(wmsLayer.getOgcCapabilitiesLayer()) < 0) {
                    this.wmsLayers.add(wmsLayer);
                    this.ogcLayers.add(wmsLayer.getOgcCapabilitiesLayer());
                }
                EventQueue.invokeLater(new Thread("fireLayerInformationStatusChanged"){

                    @Override
                    public void run() {
                        ActiveLayerEvent ale = new ActiveLayerEvent();
                        ale.setLayer(wmsLayer);
                        CismapBroker.getInstance().fireLayerInformationStatusChanged(ale);
                    }
                });
            }
            if (!addSubLayer) break block7;
            if (reverseSubLayerOrder) {
                for (int i = nextLayer.getChildren().length - 1; i >= 0; --i) {
                    Layer childLayer = nextLayer.getChildren()[i];
                    this.addLayer(childLayer, null, true, false, true, true);
                }
            } else {
                for (int i = 0; i < nextLayer.getChildren().length; ++i) {
                    Layer childLayer = nextLayer.getChildren()[i];
                    this.addLayer(childLayer);
                }
            }
        }
    }

    protected void addLayer(String name, String styleName, boolean enabled, boolean info) {
        WMSLayer wmsLayer = new WMSLayer(name, styleName, enabled, info);
        wmsLayer.setEnabled(enabled);
        wmsLayer.setParentServiceLayer(this);
        wmsLayer.setQuerySelected(false);
        this.dummyLayer.add(wmsLayer);
    }

    protected void addLayer(Layer nextLayer, Style selectedStyle) {
        this.addLayer(nextLayer, selectedStyle, true, false);
    }

    protected void addLayer(Layer nextLayer) {
        this.addLayer(nextLayer, null);
    }

    public void removeLayer(WMSLayer layer) {
        this.wmsLayers.remove(layer);
        this.ogcLayers.remove(layer.getOgcCapabilitiesLayer());
        this.disableWhenChildrenDisabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            boolean enableAll = true;
            for (Object o : this.getWMSLayers()) {
                if (!(o instanceof WMSLayer) || !((WMSLayer)o).isEnabled()) continue;
                enableAll = false;
                break;
            }
            if (enableAll) {
                for (Object o : this.getWMSLayers()) {
                    if (!(o instanceof WMSLayer)) continue;
                    ((WMSLayer)o).setEnabled(enabled);
                }
            }
        }
    }

    public void disableWhenChildrenDisabled() {
        boolean childrenDisabled = true;
        for (Object o : this.getWMSLayers()) {
            if (!(o instanceof WMSLayer) || !((WMSLayer)o).isEnabled()) continue;
            childrenDisabled = false;
            break;
        }
        if (childrenDisabled) {
            this.setEnabled(false);
        }
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return "...";
    }

    public List getWMSLayers() {
        if (this.isDummy()) {
            return this.dummyLayer;
        }
        return this.wmsLayers;
    }

    @Override
    public void retrieve(boolean forced) {
        if (this.isDummy()) {
            this.init(this.wmsServiceLayerElement, this.capabilities, true);
            if (!this.isDummy()) {
                if (CismapBroker.getInstance().isEnableDummyLayerWhenAvailable()) {
                    this.setEnabled(true);
                }
                this.dummyLayer.clear();
                StatusEvent se = new StatusEvent("awaked.from.dummy", this);
                CismapBroker.getInstance().fireStatusValueChanged(se);
            } else {
                this.retrievalError(new RetrievalEvent());
                return;
            }
        }
        this.setRefreshNeeded(false);
        String getMapUrl = this.getGetMapUrl(this.customSLD != null);
        if (getMapUrl == null) {
            RetrievalEvent e = new RetrievalEvent();
            e.setInitialisationEvent(true);
            e.setPercentageDone(0);
            e.setHasErrors(true);
            e.setRetrievedObject(NbBundle.getMessage(WMSServiceLayer.class, (String)"WMSServiceLayer.retrieve.urlNotFound"));
            this.fireRetrievalError(e);
            return;
        }
        String getMapPayload = this.getGetMapPayload();
        if (this.ir != null && this.ir.isAlive() && this.ir.getUrl().equals(getMapUrl) && !forced) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Multiple invocations with the same url. Skipping this invocation.");
            }
        } else if (this.width < 1 || this.height < 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Width or height is less than 1. Skipping retrieval.");
            }
        } else {
            if (this.ir != null && this.ir.isAlive()) {
                this.ir.youngerWMSCall();
                this.ir.interrupt();
                this.retrievalAborted(new RetrievalEvent());
            }
            this.ir = new ImageRetrieval(this);
            this.ir.setUrl(getMapUrl);
            if (getMapPayload != null) {
                this.ir.setPayload(getMapPayload);
            }
            this.ir.setWMSCapabilities(this.getWmsCapabilities());
            this.ir.setPriority(5);
            this.ir.start();
        }
    }

    private WMSCapabilities createCapabilitiesDocument() throws Exception {
        WMSCapabilitiesFactory factory = new WMSCapabilitiesFactory((CalculationCache)CapabilitiesCache.getInstance());
        CapabilityLink link = new CapabilityLink(this.wmsServiceLayerElement);
        return factory.createCapabilities(link.getLink());
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public String getBackgroundColor() {
        if (this.backgroundColor != null) {
            return this.backgroundColor;
        }
        LOG.warn((Object)"backgroundcolor was null. Set it to 0xF0F0F0");
        this.backgroundColor = "0xF0F0F0";
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getExceptionsFormat() {
        return this.exceptionsFormat;
    }

    public void setExceptionsFormat(String exceptionsFormat) {
        List exceptions;
        List list = exceptions = this.wmsCapabilities != null ? this.wmsCapabilities.getExceptions() : null;
        if (exceptionsFormat != null && exceptions != null && exceptions.size() > 0 && !exceptions.contains(exceptionsFormat)) {
            String format = null;
            for (String tmp : exceptions) {
                if (tmp.toLowerCase().indexOf(exceptionsFormat.toLowerCase()) != -1) {
                    format = tmp;
                    break;
                }
                if (tmp.toLowerCase().indexOf("xml") == -1) continue;
                format = tmp;
            }
            if (format == null) {
                format = (String)exceptions.get(0);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Preferred exception format is not supported. Use format: " + format));
            }
            this.exceptionsFormat = format;
        } else {
            this.exceptionsFormat = exceptionsFormat;
        }
    }

    public String getSrs() {
        return this.srs;
    }

    public void setSrs(String srs) {
        this.srs = srs;
    }

    private String getGetMapUrl(boolean minimalUrl) {
        String version;
        String mapPrefix = this.getGetMapPrefix();
        if (mapPrefix == null) {
            return null;
        }
        StringBuilder url = new StringBuilder(mapPrefix);
        if (this.bb == null || url == null || url.length() == 0) {
            return null;
        }
        if (url.indexOf("?") < 0) {
            url.append("?");
        }
        if ((version = this.getWmsCapabilities().getVersion()).trim().equals("1.0.0") || version.trim().equals("1.0") || version.trim().equals("1")) {
            url.append("&WMTVER=1.0.0&REQUEST=map");
        } else {
            url.append("&VERSION=").append(version);
            url.append("&REQUEST=GetMap");
        }
        url.append("&SERVICE=WMS");
        url.append("&BBOX=").append(this.bb.getURLString());
        url.append("&WIDTH=").append(this.width);
        url.append("&HEIGHT=").append(this.height);
        if (minimalUrl) {
            return url.toString();
        }
        if (version.trim().equals("1.3") || version.trim().equals("1.3.0")) {
            url.append("&CRS=");
        } else {
            url.append("&SRS=");
        }
        url.append(this.srs);
        url.append("&FORMAT=").append(this.imageFormat);
        url.append("&TRANSPARENT=").append(Boolean.valueOf(this.transparentImage).toString().toUpperCase());
        url.append("&BGCOLOR=").append(this.getBackgroundColor());
        url.append("&EXCEPTIONS=").append(this.exceptionsFormat);
        url.append(this.getLayersString());
        if (this.hasEveryLayerAStyle()) {
            url.append(this.getStylesString());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"style parameter was added without a value to the getMap Request, because not every layer, which is used within the request has a selected style");
            }
            url.append("&STYLES=");
        }
        return url.toString();
    }

    private String getGetMapPayload() {
        if (this.customSLD == null || this.srs == null || this.bb == null) {
            return null;
        }
        String result = TEMPLATE_GETMAP_PAYLOAD;
        result = result.replaceAll(TEMPLATETOKEN_CUSTOMSTYLE, this.customSLD.replaceAll(TEMPLATETOKEN_CUSTOMSTYLE_LAYERNAME, this.name));
        result = result.replaceAll(TEMPLATETOKEN_SRS, this.srs.startsWith("EPSG:") ? this.srs.substring(this.srs.indexOf(58) + 1) : this.srs);
        result = result.replaceAll(TEMPLATETOKEN_BOUNDINGBOX_LL_X, Double.toString(this.bb.getX1()));
        result = result.replaceAll(TEMPLATETOKEN_BOUNDINGBOX_LL_Y, Double.toString(this.bb.getY1()));
        result = result.replaceAll(TEMPLATETOKEN_BOUNDINGBOX_UR_X, Double.toString(this.bb.getX2()));
        result = result.replaceAll(TEMPLATETOKEN_BOUNDINGBOX_UR_Y, Double.toString(this.bb.getY2()));
        result = result.replaceAll(TEMPLATETOKEN_WIDTH, Integer.toString(this.width));
        result = result.replaceAll(TEMPLATETOKEN_HEIGHT, Integer.toString(this.height));
        return result;
    }

    public String getGetFeatureInfoUrl(int x, int y, WMSLayer l) {
        return this.getGetFeatureInfoUrl_internal(x, y, l, "text/html");
    }

    public String getGetFeatureInfoUrl(int x, int y, WMSLayer l, String format) {
        return this.getGetFeatureInfoUrl_internal(x, y, l, format);
    }

    private String getGetFeatureInfoUrl_internal(int x, int y, WMSLayer l, String format) {
        String url = this.getGetFeatureInfoPrefix();
        if (this.bb != null && url != null) {
            String version;
            if (url.indexOf("?") < 0) {
                url = url + "?";
            }
            url = (version = this.getWmsCapabilities().getVersion()).trim().equals("1.0.0") || version.trim().equals("1.0") || version.trim().equals("1") ? url + "&WMTVER=1.0.0&REQUEST=feature_info" : url + "&VERSION=" + version + "&REQUEST=GetFeatureInfo";
            url = url + "&BBOX=" + this.bb.getURLString();
            url = url + "&WIDTH=" + this.width;
            url = url + "&HEIGHT=" + this.height;
            url = version.trim().equals("1.3") || version.trim().equals("1.3.0") ? url + "&CRS=" + this.srs : url + "&SRS=" + this.srs;
            url = url + "&FORMAT=" + this.imageFormat;
            url = url + "&TRANSPARENT=" + Boolean.valueOf(this.transparentImage).toString().toUpperCase();
            url = url + "&BGCOLOR=" + this.backgroundColor;
            url = url + "&EXCEPTIONS=" + this.exceptionsFormat;
            url = url + "&FEATURE_COUNT=99";
            url = url + this.getLayersString();
            if (this.hasEveryLayerAStyle()) {
                url = url + this.getStylesString();
            }
            url = url + "&QUERY_LAYERS=" + l.getOgcCapabilitiesLayer().getName().replaceAll(" ", "%20");
            url = url + "&INFO_FORMAT=" + format;
            if (version.trim().equals("1.3") || version.trim().equals("1.3.0")) {
                url = url + "&I=" + x;
                url = url + "&J=" + y;
            } else {
                url = url + "&X=" + x;
                url = url + "&Y=" + y;
            }
            return url;
        }
        return null;
    }

    private String getGetMapPrefix() {
        try {
            Operation op;
            String prefix = null;
            if (this.getWmsCapabilities() != null && this.getWmsCapabilities().getRequest() != null && (op = this.getWmsCapabilities().getRequest().getMapOperation()) != null) {
                if (op.getGet() != null) {
                    prefix = op.getGet().toString();
                    prefix = this.addUserAndPasswordToUrlIfRequired(prefix);
                } else if (op.getPost() != null) {
                    prefix = op.getPost().toString();
                    prefix = this.addUserAndPasswordToUrlIfRequired(prefix);
                } else {
                    return null;
                }
            }
            return CismapBroker.getInstance().aliasToUrl(prefix);
        }
        catch (Throwable npe) {
            LOG.warn((Object)"Throwable in getMapPrefix", npe);
            return null;
        }
    }

    private String addUserAndPasswordToUrlIfRequired(String url) {
        if (this.capabilitiesUrl != null && this.capabilitiesUrl.contains("@") && this.capabilitiesUrl.contains("://") && this.capabilitiesUrl.indexOf("@") > this.capabilitiesUrl.indexOf("://")) {
            String userPwd = this.capabilitiesUrl.substring(this.capabilitiesUrl.indexOf("://") + 3, this.capabilitiesUrl.indexOf("@"));
            return url.substring(0, url.indexOf("://") + 3) + userPwd + "@" + url.substring(url.indexOf("://") + 3);
        }
        if (this.capabilitiesUrl.contains("secres/$(user-jwt)")) {
            if (this.capabilitiesUrl.contains("?")) {
                return this.capabilitiesUrl.substring(0, this.capabilitiesUrl.indexOf("?"));
            }
            return this.capabilitiesUrl;
        }
        return url;
    }

    private String getGetFeatureInfoPrefix() {
        try {
            Operation op = this.getWmsCapabilities().getRequest().getFeatureInfoOperation();
            String prefix = null;
            if (op != null) {
                prefix = op.getGet().toString();
                prefix = this.addUserAndPasswordToUrlIfRequired(prefix);
            }
            return CismapBroker.getInstance().aliasToUrl(prefix);
        }
        catch (NullPointerException npe) {
            LOG.warn((Object)"NPE in getGetMapPrefix()", (Throwable)npe);
            return null;
        }
    }

    private String getLayersString() {
        StringBuilder layerString = new StringBuilder("");
        int counter = 0;
        for (Object o : this.getWMSLayers()) {
            if (!(o instanceof WMSLayer) || !((WMSLayer)o).isEnabled()) continue;
            if (++counter > 1) {
                layerString.append(",");
            }
            if (!this.isDummy()) {
                layerString.append(((WMSLayer)o).getOgcCapabilitiesLayer().getName().replaceAll(" ", "%20"));
                continue;
            }
            layerString.append(((WMSLayer)o).toString().replaceAll(" ", "%20"));
        }
        if (counter > 0) {
            return "&LAYERS=" + layerString.toString();
        }
        return "";
    }

    private String getStylesString() {
        StringBuilder stylesString = new StringBuilder("");
        int counter = 0;
        for (Object o : this.getWMSLayers()) {
            if (!(o instanceof WMSLayer) || !((WMSLayer)o).isEnabled() || (this.isDummy() || ((WMSLayer)o).getSelectedStyle() == null) && (!this.isDummy() || ((WMSLayer)o).getStyleName() == null)) continue;
            if (++counter > 1) {
                stylesString.append(",");
            }
            if (!this.isDummy()) {
                stylesString.append(((WMSLayer)o).getSelectedStyle().getName());
                continue;
            }
            stylesString.append(((WMSLayer)o).getStyleName());
        }
        try {
            return "&STYLES=" + URLEncoder.encode(stylesString.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "&STYLES=" + URLEncoder.encode(stylesString.toString());
        }
    }

    private boolean hasEveryLayerAStyle() {
        for (Object o : this.getWMSLayers()) {
            if (!(o instanceof WMSLayer) || !((WMSLayer)o).isEnabled() || ((WMSLayer)o).getSelectedStyle() != null) continue;
            return false;
        }
        return true;
    }

    public WMSCapabilities getWmsCapabilities() {
        return this.wmsCapabilities;
    }

    public void setWmsCapabilities(WMSCapabilities wmsCapabilities) {
        this.wmsCapabilities = wmsCapabilities;
    }

    @Override
    public void setPNode(PNode imageObject) {
        boolean vis = imageObject.getVisible();
        this.imageObject = imageObject;
        imageObject.setVisible(vis);
    }

    @Override
    public PNode getPNode() {
        return this.imageObject;
    }

    public String getCapabilitiesUrl() {
        return this.capabilitiesUrl;
    }

    public void setCapabilitiesUrl(String capabilitiesUrl) {
        this.capabilitiesUrl = capabilitiesUrl;
    }

    public void setCustomSLD(String customSLD) {
        this.customSLD = customSLD;
    }

    public Element getElement() {
        try {
            Element layerConf = new Element("WMSServiceLayer");
            layerConf.setAttribute("name", this.getName());
            layerConf.setAttribute("title", this.title == null ? "" : this.title);
            layerConf.setAttribute("visible", Boolean.valueOf(this.getPNode().getVisible()).toString());
            layerConf.setAttribute("enabled", Boolean.valueOf(this.isEnabled()).toString());
            layerConf.setAttribute("translucency", new Float(this.getTranslucency()).toString());
            layerConf.setAttribute("bgColor", this.getBackgroundColor());
            layerConf.setAttribute("imageFormat", this.getImageFormat());
            layerConf.setAttribute("exceptionFormat", this.getExceptionsFormat());
            CapabilityLink capLink = new CapabilityLink("OGC", this.getCapabilitiesUrl(), this.reverseAxisOrder, false);
            layerConf.addContent((Content)capLink.getElement());
            for (Object elem : this.getWMSLayers()) {
                if (!(elem instanceof WMSLayer)) continue;
                WMSLayer wmsLayer = (WMSLayer)elem;
                Element wmsLayerConf = new Element("wmsLayer");
                if (!this.isDummy()) {
                    wmsLayerConf.setAttribute("name", wmsLayer.getOgcCapabilitiesLayer().getName());
                    wmsLayerConf.setAttribute("title", wmsLayer.getOgcCapabilitiesLayer().getTitle());
                } else {
                    wmsLayerConf.setAttribute("name", wmsLayer.toString());
                    wmsLayerConf.setAttribute("title", wmsLayer.toString());
                }
                wmsLayerConf.setAttribute("enabled", Boolean.valueOf(wmsLayer.isEnabled()).toString());
                try {
                    if (!this.isDummy()) {
                        wmsLayerConf.setAttribute("style", wmsLayer.getSelectedStyle().getName());
                    } else {
                        wmsLayerConf.setAttribute("style", wmsLayer.getStyleName());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                wmsLayerConf.setAttribute("info", Boolean.valueOf(wmsLayer.isQuerySelected()).toString());
                layerConf.addContent((Content)wmsLayerConf);
            }
            return layerConf;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while saving layer", (Throwable)e);
            return new Element("WMSServiceLayer");
        }
    }

    private Layer searchForLayer(Layer layer, String name) {
        if (layer.getName() != null && layer.getName().equals(name)) {
            return layer;
        }
        Layer[] lArr = layer.getChildren();
        for (int i = 0; i < lArr.length; ++i) {
            Layer l = this.searchForLayer(lArr[i], name);
            if (l == null) continue;
            return l;
        }
        return null;
    }

    @Override
    public Object clone() {
        WMSServiceLayer w = null;
        w = this.treePaths != null ? new WMSServiceLayer(this.treePaths) : new WMSServiceLayer(this.wmsServiceLayerElement, this.capabilities);
        w.bb = this.bb;
        w.capabilitiesUrl = this.capabilitiesUrl;
        w.enabled = this.enabled;
        w.errorObject = this.errorObject;
        w.exceptionsFormat = this.exceptionsFormat;
        w.height = this.height;
        w.imageFormat = this.imageFormat;
        w.visible = this.visible;
        w.imageObject = null;
        w.ir = new ImageRetrieval(w);
        w.propertyChangeSupport = new PropertyChangeSupport(this);
        w.layerPosition = this.layerPosition;
        w.listeners = new ArrayList(this.listeners);
        w.name = this.name;
        w.ogcLayers = this.ogcLayers;
        w.progress = this.progress;
        w.refreshNeeded = this.refreshNeeded;
        w.srs = this.srs;
        w.translucency = this.translucency;
        w.transparentImage = this.transparentImage;
        w.treePaths = this.treePaths;
        w.width = this.width;
        w.wmsCapabilities = this.wmsCapabilities;
        w.wmsServiceLayerElement = this.wmsServiceLayerElement;
        w.capabilities = this.capabilities;
        w.dummyLayer = this.dummyLayer;
        w.reverseAxisOrder = this.reverseAxisOrder;
        ArrayList<WMSLayer> layers = new ArrayList<WMSLayer>(this.wmsLayers.size());
        for (Object layerObject : this.wmsLayers) {
            WMSLayer layer = (WMSLayer)layerObject;
            WMSLayer newLayer = new WMSLayer(layer.getOgcCapabilitiesLayer(), layer.getSelectedStyle());
            newLayer.setParentServiceLayer(w);
            layers.add(newLayer);
        }
        w.wmsLayers = layers;
        return w;
    }

    public boolean propertyEquals(Object obj) {
        if (obj instanceof WMSServiceLayer) {
            WMSServiceLayer tester = (WMSServiceLayer)obj;
            if (this.getName().equals(tester.getName()) && (this.getGetMapPrefix() == tester.getGetMapPrefix() || this.getGetMapPrefix() != null && this.getGetMapPrefix().equals(tester.getGetMapPrefix())) && this.getLayersString().equals(tester.getLayersString()) && this.getStylesString().equals(tester.getStylesString()) && this.getServerURI().equals(tester.getServerURI())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getLayerURI() {
        return this.getName();
    }

    @Override
    public String getServerURI() {
        return this.getCapabilitiesUrl();
    }

    @Override
    public Collection getChildren() {
        return this.getWMSLayers();
    }

    @Override
    public boolean isLayerQuerySelected() {
        return ((WMSLayer)this.getWMSLayers().get(0)).isQuerySelected();
    }

    @Override
    public void setLayerQuerySelected(boolean selected) {
        ((WMSLayer)this.getWMSLayers().get(0)).setQuerySelected(selected);
    }

    @Override
    public boolean isQueryable() {
        return this.getWMSLayers().size() == 1 && ((WMSLayer)this.getWMSLayers().get(0)).isQueryable();
    }

    @Override
    public Layer getLayerInformation() {
        if (this.wmsCapabilities != null) {
            Object wmsLayer;
            Layer layer = null;
            List layerList = this.getWMSLayers();
            if (layerList != null && layerList.size() == 1 && (wmsLayer = layerList.get(0)) instanceof WMSLayer) {
                layer = this.searchForLayer(this.wmsCapabilities.getLayer(), ((WMSLayer)wmsLayer).getOgcCapabilitiesLayer().getName());
            }
            if (layer == null) {
                layer = this.searchForLayer(this.wmsCapabilities.getLayer(), this.name);
            }
            if (layer == null) {
                layer = this.wmsCapabilities.getLayer();
            }
            return layer;
        }
        return null;
    }

    public boolean isDummy() {
        return this.getWmsCapabilities() == null;
    }
}

