/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.raster.wms.simple;

import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.LayerInfoProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.raster.wms.AbstractWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.cismap.commons.rasterservice.ImageRetrieval;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.rasterservice.RasterMapService;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.commons.wms.capabilities.Layer;
import edu.umd.cs.piccolo.PNode;
import java.util.Vector;
import org.apache.commons.httpclient.HttpClient;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

public class SimpleWMS
extends AbstractWMS
implements MapService,
RasterMapService,
RetrievalServiceLayer,
LayerInfoProvider {
    private final Logger log = Logger.getLogger(this.getClass());
    private SimpleWmsGetMapUrl gmUrl;
    private ImageRetrieval ir;
    private PNode pNode;
    private String name = "SimpleWMS";
    private HttpClient preferredClient = null;

    public SimpleWMS(SimpleWMS s) {
        this(s.gmUrl);
        if (s.bb != null) {
            this.bb = (BoundingBox)s.bb.clone();
        }
        this.enabled = s.enabled;
        this.height = s.height;
        this.layerPosition = s.layerPosition;
        this.name = s.name;
        this.translucency = s.translucency;
        this.width = s.width;
        this.ir = new ImageRetrieval(s);
        this.listeners = new Vector();
        this.listeners.addAll(s.listeners);
    }

    public SimpleWMS(SimpleWmsGetMapUrl gmUrl) {
        this.gmUrl = gmUrl;
    }

    public SimpleWMS(Element object) throws Exception {
        Attribute translucencyAttr;
        Attribute visAttr;
        Attribute nameAttr;
        Attribute enabledAttr;
        SimpleWmsGetMapUrl url;
        String urlTemplate = object.getTextTrim();
        this.gmUrl = url = new SimpleWmsGetMapUrl(urlTemplate);
        Attribute layerPositionAttr = object.getAttribute("layerPosition");
        if (layerPositionAttr != null) {
            try {
                this.layerPosition = layerPositionAttr.getIntValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((enabledAttr = object.getAttribute("enabled")) != null) {
            try {
                this.enabled = enabledAttr.getBooleanValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((nameAttr = object.getAttribute("name")) != null) {
            try {
                this.name = nameAttr.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((visAttr = object.getAttribute("visible")) != null) {
            try {
                this.visible = visAttr.getBooleanValue();
                this.pNode.setVisible(this.visible);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((translucencyAttr = object.getAttribute("translucency")) != null) {
            try {
                this.setTranslucency(translucencyAttr.getFloatValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SimpleWMS(SimpleWmsGetMapUrl gmUrl, int layerPosition, boolean enabled, boolean canbeDisabled, String name) {
        this.gmUrl = gmUrl;
        this.layerPosition = layerPosition;
        this.enabled = enabled;
        this.name = name;
    }

    public Element getElement() {
        Element element = new Element("simpleWms");
        element.setAttribute("layerPosition", new Integer(this.layerPosition).toString());
        element.setAttribute("skip", "false");
        element.setAttribute("enabled", Boolean.toString(this.enabled));
        element.setAttribute("visible", Boolean.toString(this.pNode.getVisible()));
        element.setAttribute("name", this.name);
        element.setAttribute("translucency", new Float(this.translucency).toString());
        CDATA data = new CDATA(this.gmUrl.getUrlTemplate());
        element.addContent((Content)data);
        return element;
    }

    @Override
    public synchronized void retrieve(boolean forced) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"retrieve()");
        }
        this.gmUrl.setHeight(this.height);
        this.gmUrl.setWidth(this.width);
        this.gmUrl.setX1(this.bb.getX1());
        this.gmUrl.setY1(this.bb.getY1());
        this.gmUrl.setX2(this.bb.getX2());
        this.gmUrl.setY2(this.bb.getY2());
        if (this.ir != null && this.ir.isAlive() && this.ir.getUrl().equals(this.gmUrl.toString()) && !forced) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"multiple invocations with the same url = humbug");
            }
        } else {
            if (this.ir != null && this.ir.isAlive()) {
                this.ir.youngerWMSCall();
                this.ir.interrupt();
                this.retrievalAborted(new RetrievalEvent());
            }
            this.ir = new ImageRetrieval(this);
            this.ir.setPreferredHttpClient(this.preferredClient);
            this.ir.setUrl(this.gmUrl.toString());
            this.ir.setPayload(this.gmUrl.createPayload());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"ir.start();");
            }
            this.ir.setPriority(5);
            this.ir.start();
        }
    }

    public SimpleWmsGetMapUrl getGmUrl() {
        return this.gmUrl;
    }

    public void setGmUrl(SimpleWmsGetMapUrl gmUrl) {
        this.gmUrl = gmUrl;
    }

    @Override
    public void setPNode(PNode imageObject) {
        this.pNode = imageObject;
    }

    @Override
    public PNode getPNode() {
        return this.pNode;
    }

    @Override
    public Object clone() {
        return new SimpleWMS(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }

    public HttpClient getPreferredClient() {
        return this.preferredClient;
    }

    public void setPreferredClient(HttpClient preferredClient) {
        this.preferredClient = preferredClient;
    }

    @Override
    public String getLayerURI() {
        return null;
    }

    @Override
    public String getServerURI() {
        return this.gmUrl.getUrlTemplate();
    }

    @Override
    public boolean isLayerQuerySelected() {
        return false;
    }

    @Override
    public void setLayerQuerySelected(boolean selected) {
    }

    @Override
    public boolean isQueryable() {
        return false;
    }

    @Override
    public Layer getLayerInformation() {
        return null;
    }
}

