/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.raster.wms.simple;

import de.cismet.cismap.commons.interaction.CismapBroker;

public class SimpleWmsGetMapUrl {
    public static final String WIDTH_TOKEN = "<cismap:width>";
    public static final String HEIGHT_TOKEN = "<cismap:height>";
    public static final String BOUNDING_BOX_TOKEN = "<cismap:boundingBox>";
    public static final String BOUNDING_BOX_TOKEN_LL_X = "<cismap:boundingBox_ll_x>";
    public static final String BOUNDING_BOX_TOKEN_LL_Y = "<cismap:boundingBox_ll_y>";
    public static final String BOUNDING_BOX_TOKEN_UR_X = "<cismap:boundingBox_ur_x>";
    public static final String BOUNDING_BOX_TOKEN_UR_Y = "<cismap:boundingBox_ur_y>";
    public static final String SRS_TOKEN = "<cismap:srs>";
    public static final String EPSG_NAMESPACE = "http://www.opengis.net/gml/srs/epsg.xml";
    protected String urlTemplate;
    private double x1 = 0.0;
    private double y1 = 0.0;
    private double x2 = 0.0;
    private double y2 = 0.0;
    private String widthToken;
    private String heightToken;
    private String boundingBoxToken;
    private String payloadTemplate;
    private int width = 0;
    private int height = 0;

    public SimpleWmsGetMapUrl(String urlTemplate) {
        this(urlTemplate, null);
    }

    public SimpleWmsGetMapUrl(String urlTemplate, String payloadTemplate) {
        this(urlTemplate, WIDTH_TOKEN, HEIGHT_TOKEN, BOUNDING_BOX_TOKEN, payloadTemplate);
    }

    public SimpleWmsGetMapUrl(String urlTemplate, String widthToken, String heightToken, String boundingBoxToken) {
        this(urlTemplate, widthToken, heightToken, boundingBoxToken, null);
    }

    public SimpleWmsGetMapUrl(String urlTemplate, String widthToken, String heightToken, String boundingBoxToken, String payloadTemplate) {
        this.urlTemplate = urlTemplate;
        this.widthToken = widthToken;
        this.heightToken = heightToken;
        this.boundingBoxToken = boundingBoxToken;
        this.payloadTemplate = payloadTemplate;
    }

    public String getPayloadTemplate() {
        return this.payloadTemplate;
    }

    public void setPayloadTemplate(String payloadTemplate) {
        this.payloadTemplate = payloadTemplate;
    }

    public String createPayload() {
        if (this.payloadTemplate == null) {
            return null;
        }
        String payload = this.payloadTemplate;
        payload = payload.replaceAll(this.heightToken, String.valueOf(this.height));
        payload = payload.replaceAll(this.widthToken, String.valueOf(this.width));
        payload = payload.replaceAll(BOUNDING_BOX_TOKEN_LL_X, String.valueOf(this.x1));
        payload = payload.replaceAll(BOUNDING_BOX_TOKEN_LL_Y, String.valueOf(this.y1));
        payload = payload.replaceAll(BOUNDING_BOX_TOKEN_UR_X, String.valueOf(this.x2));
        payload = payload.replaceAll(BOUNDING_BOX_TOKEN_UR_Y, String.valueOf(this.y2));
        String srsCode = CismapBroker.getInstance().getSrs().getCode();
        String srs = srsCode.substring(srsCode.indexOf(58) + 1);
        payload = payload.replaceAll(SRS_TOKEN, "http://www.opengis.net/gml/srs/epsg.xml#" + srs);
        return payload;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setX1(double coord) {
        this.x1 = coord;
    }

    public void setY1(double coord) {
        this.y1 = coord;
    }

    public void setX2(double coord) {
        this.x2 = coord;
    }

    public void setY2(double coord) {
        this.y2 = coord;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public String toString() {
        String url = this.urlTemplate.replaceAll(this.widthToken, new Integer(this.width).toString());
        url = url.replaceAll(this.heightToken, new Integer(this.height).toString());
        url = url.replaceAll(this.boundingBoxToken, new Double(this.x1).toString() + "," + new Double(this.y1).toString() + "," + new Double(this.x2).toString() + "," + new Double(this.y2).toString());
        url = url.replaceAll(SRS_TOKEN, CismapBroker.getInstance().getSrs().getCode());
        return url;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

