/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice.georeferencing;

import com.vividsolutions.jts.geom.Coordinate;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.gui.SimpleBackgroundedJPanel;
import de.cismet.cismap.commons.rasterservice.georeferencing.PointCoordinatePair;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingHandler;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingWizard;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingWizardListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXTable;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RasterGeoReferencingPanel
extends JPanel {
    private static final transient Logger LOG = Logger.getLogger(RasterGeoReferencingPanel.class);
    private static final String[] COLUMN_NAMES = new String[]{NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.colName.position"), NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.colName.point"), NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.colName.coord"), NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.colName.error"), NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.colName.enabled")};
    private static final Class[] COLUMN_CLASSES = new Class[]{Integer.class, String.class, String.class, String.class, Boolean.class};
    private final CellSelectionListener selectionListener = new CellSelectionListener();
    private boolean wizardRefreshing = false;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private JButton jButton1;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JDialog jDialog1;
    private JDialog jDialog2;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenuItem jMenuItem2;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JXTable jXTable1;
    private JPanel panContent;
    private JPanel panInstructions;
    private JPanel panMapOverview;
    private JPanel panTable;
    private SimpleBackgroundedJPanel simpleBackgroundedJPanel1;
    private SimpleBackgroundedJPanel simpleBackgroundedJPanel2;
    private BindingGroup bindingGroup;

    public RasterGeoReferencingPanel() {
        this.initComponents();
        if (this.getWizard() != null) {
            this.getWizard().addListener(new WizardListener());
        }
        this.simpleBackgroundedJPanel1.setPCanvas(this.getWizard().getPointZoomViewCanvas());
        this.getWizard().addPropertyChangeListener(this.simpleBackgroundedJPanel1);
        this.simpleBackgroundedJPanel2.setPCanvas(this.getWizard().getCoordinateZoomViewCanvas());
        this.getWizard().addPropertyChangeListener(this.simpleBackgroundedJPanel2);
    }

    public final RasterGeoReferencingWizard getWizard() {
        return RasterGeoReferencingWizard.getInstance();
    }

    public RasterGeoReferencingHandler getHandler() {
        return this.getWizard().getHandler();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jDialog1 = new JDialog();
        this.jDialog2 = new JDialog();
        this.jLabel12 = new JLabel();
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem2 = new JMenuItem();
        this.panContent = new JPanel();
        this.panInstructions = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.panTable = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jXTable1 = new JXTable();
        this.jPanel4 = new JPanel();
        this.jButton8 = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jButton1 = new JButton();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.panMapOverview = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.simpleBackgroundedJPanel1 = new SimpleBackgroundedJPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.simpleBackgroundedJPanel2 = new DnDTargetSimpleBackgroundedJPanel();
        this.jLabel11 = new JLabel();
        this.jLabel10 = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jLabel12.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jMenuItem2, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jMenuItem2.text"));
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterGeoReferencingPanel.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem2);
        this.setMinimumSize(new Dimension(420, 500));
        this.setPreferredSize(new Dimension(420, 520));
        this.setLayout(new GridBagLayout());
        this.panContent.setLayout(new GridBagLayout());
        this.panInstructions.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jLabel7.text_1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.panInstructions.add((Component)this.jLabel7, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jLabel5.text"));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${wizard.pointSelected}"), (Object)this.jLabel5, (Property)BeanProperty.create((String)"enabled"), (String)"wizPointEnable");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.panInstructions.add((Component)this.jLabel5, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jLabel6.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${wizard.coordinateSelected}"), (Object)this.jLabel6, (Property)BeanProperty.create((String)"enabled"), (String)"wizCoordinateEnable");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.panInstructions.add((Component)this.jLabel6, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(1, 2, 5, 0));
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/control-180.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton6, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jButton6.text"));
        this.jButton6.setBorderPainted(false);
        this.jButton6.setContentAreaFilled(false);
        this.jButton6.setFocusPainted(false);
        this.jButton6.setFocusable(false);
        this.jButton6.setHorizontalTextPosition(0);
        this.jButton6.setVerticalTextPosition(3);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${backwardPossible}"), (Object)this.jButton6, (Property)BeanProperty.create((String)"enabled"), (String)"wizBackwardEnable");
        this.bindingGroup.addBinding((Binding)binding);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterGeoReferencingPanel.this.jButton6ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton6);
        this.jButton7.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/control.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton7, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jButton7.text"));
        this.jButton7.setBorderPainted(false);
        this.jButton7.setContentAreaFilled(false);
        this.jButton7.setFocusPainted(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${forwardPossible}"), (Object)this.jButton7, (Property)BeanProperty.create((String)"enabled"), (String)"wizForwardEnable");
        this.bindingGroup.addBinding((Binding)binding);
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterGeoReferencingPanel.this.jButton7ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.panInstructions.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel8.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/rasterservice/georeferencing/georef_wizard_icon.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 0, 5, 20);
        this.panInstructions.add((Component)this.jLabel8, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.jXTable1, (Property)ELProperty.create((String)"<html><b>${selectedRow + 1}"), (Object)this.jLabel9, (Property)BeanProperty.create((String)"text"), (String)"wizPosition");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panInstructions.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panContent.add((Component)this.panInstructions, gridBagConstraints);
        this.panTable.setMinimumSize(new Dimension(400, 60));
        this.panTable.setPreferredSize(new Dimension(400, 382));
        this.panTable.setLayout(new GridBagLayout());
        this.jXTable1.setModel((TableModel)new PairTableModel());
        this.jXTable1.setAutoResizeMode(1);
        this.jXTable1.setCellSelectionEnabled(true);
        this.jXTable1.setSortable(false);
        this.jXTable1.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView((Component)this.jXTable1);
        this.jXTable1.setSelectionMode(0);
        this.jXTable1.getColumnModel().getSelectionModel().addListSelectionListener(this.getSelectionListener());
        this.jXTable1.getSelectionModel().addListSelectionListener(this.getSelectionListener());
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        this.jXTable1.getColumnModel().getColumn(0).setMinWidth(15);
        this.jXTable1.getColumnModel().getColumn(0).setMaxWidth(25);
        this.jXTable1.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.jXTable1.getColumnModel().getColumn(1).setMinWidth(60);
        this.jXTable1.getColumnModel().getColumn(1).setMaxWidth(120);
        this.jXTable1.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.jXTable1.getColumnModel().getColumn(2).setMinWidth(150);
        this.jXTable1.getColumnModel().getColumn(2).setPreferredWidth(180);
        this.jXTable1.getColumnModel().getColumn(3).setCellRenderer(rightRenderer);
        this.jXTable1.getColumnModel().getColumn(3).setMinWidth(40);
        this.jXTable1.getColumnModel().getColumn(3).setMaxWidth(60);
        this.jXTable1.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.jXTable1.getColumnModel().getColumn(4).setMinWidth(25);
        this.jXTable1.getColumnModel().getColumn(4).setMaxWidth(25);
        this.jXTable1.getColumnModel().getColumn(4).setPreferredWidth(25);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panTable.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jButton8.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/plus.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton8, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jButton8.text"));
        this.jButton8.setToolTipText(NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jButton8.toolTipText"));
        this.jButton8.setBorderPainted(false);
        this.jButton8.setContentAreaFilled(false);
        this.jButton8.setFocusPainted(false);
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterGeoReferencingPanel.this.jButton8ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 24;
        this.jPanel4.add((Component)this.jButton8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.filler2, gridBagConstraints);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/minus.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jButton1.text"));
        this.jButton1.setBorderPainted(false);
        this.jButton1.setContentAreaFilled(false);
        this.jButton1.setFocusPainted(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.jXTable1, (Property)ELProperty.create((String)"${selectedElement != null}"), (Object)this.jButton1, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterGeoReferencingPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel4.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.filler3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.panTable.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panContent.add((Component)this.panTable, gridBagConstraints);
        this.panMapOverview.setLayout(new GridBagLayout());
        this.jLabel3.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 2);
        this.panMapOverview.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 2, 5, 0);
        this.panMapOverview.add((Component)this.jLabel4, gridBagConstraints);
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setVerticalScrollBarPolicy(21);
        this.jScrollPane2.setMaximumSize(new Dimension(200, 200));
        this.jScrollPane2.setMinimumSize(new Dimension(200, 200));
        this.jScrollPane2.setPreferredSize(new Dimension(200, 200));
        this.simpleBackgroundedJPanel1.setBackground(new Color(255, 255, 255));
        this.simpleBackgroundedJPanel1.setBorder(BorderFactory.createBevelBorder(1));
        this.simpleBackgroundedJPanel1.setMaximumSize(new Dimension(200, 200));
        this.simpleBackgroundedJPanel1.setMinimumSize(new Dimension(200, 200));
        this.simpleBackgroundedJPanel1.setPreferredSize(new Dimension(200, 200));
        this.simpleBackgroundedJPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/rasterservice/georeferencing/georef_dot.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jLabel1.text"));
        this.simpleBackgroundedJPanel1.add((Component)this.jLabel1, new GridBagConstraints());
        this.jScrollPane2.setViewportView(this.simpleBackgroundedJPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.panMapOverview.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jScrollPane3.setHorizontalScrollBarPolicy(31);
        this.jScrollPane3.setVerticalScrollBarPolicy(21);
        this.jScrollPane3.setMaximumSize(new Dimension(200, 200));
        this.jScrollPane3.setMinimumSize(new Dimension(200, 200));
        this.jScrollPane3.setPreferredSize(new Dimension(200, 200));
        this.simpleBackgroundedJPanel2.setBackground(new Color(255, 255, 255));
        this.simpleBackgroundedJPanel2.setBorder(BorderFactory.createBevelBorder(1));
        this.simpleBackgroundedJPanel2.setMaximumSize(new Dimension(200, 200));
        this.simpleBackgroundedJPanel2.setMinimumSize(new Dimension(200, 200));
        this.simpleBackgroundedJPanel2.setPreferredSize(new Dimension(200, 200));
        this.simpleBackgroundedJPanel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RasterGeoReferencingPanel.this.simpleBackgroundedJPanel2MousePressed(evt);
            }
        });
        this.simpleBackgroundedJPanel2.setLayout(new GridBagLayout());
        this.jLabel11.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/pointsymbols/info.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jLabel11.text"));
        this.jLabel11.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RasterGeoReferencingPanel.this.jLabel11MousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.simpleBackgroundedJPanel2.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel11.setVisible(false);
        this.jLabel10.setHorizontalAlignment(0);
        this.jLabel10.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/rasterservice/georeferencing/georef_cross.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(RasterGeoReferencingPanel.class, (String)"RasterGeoReferencingPanel.jLabel10.text"));
        this.jLabel10.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RasterGeoReferencingPanel.this.jLabel10MousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.simpleBackgroundedJPanel2.add((Component)this.jLabel10, gridBagConstraints);
        this.jScrollPane3.setViewportView(this.simpleBackgroundedJPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.panMapOverview.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panMapOverview.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panContent.add((Component)this.panMapOverview, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        final int position = this.jXTable1.getSelectedRow();
        new SwingWorker<Boolean, Object>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                boolean success = RasterGeoReferencingPanel.this.getHandler().removePair(position);
                return success;
            }

            @Override
            protected void done() {
                try {
                    Boolean success = (Boolean)this.get();
                    if (Boolean.TRUE.equals(success)) {
                        RasterGeoReferencingPanel.this.refreshModel();
                        if (success.booleanValue() && RasterGeoReferencingPanel.this.getHandler().getNumOfPairs() != 0) {
                            RasterGeoReferencingPanel.this.getWizard().selectCoordinate(position - 1);
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.info((Object)ex, (Throwable)ex);
                }
            }
        }.execute();
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        new SwingWorker<Integer, Object>(){

            @Override
            protected Integer doInBackground() throws Exception {
                int position = RasterGeoReferencingPanel.this.getHandler().addPair();
                return position;
            }

            @Override
            protected void done() {
                try {
                    int position = (Integer)this.get();
                    RasterGeoReferencingPanel.this.refreshModel();
                    RasterGeoReferencingPanel.this.getWizard().selectPoint(position);
                }
                catch (Exception ex) {
                    LOG.info((Object)ex, (Throwable)ex);
                }
            }
        }.execute();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        new SwingWorker<Void, Object>(){

            @Override
            protected Void doInBackground() throws Exception {
                RasterGeoReferencingPanel.this.getWizard().forward();
                return null;
            }
        }.execute();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        new SwingWorker<Void, Object>(){

            @Override
            protected Void doInBackground() throws Exception {
                RasterGeoReferencingPanel.this.getWizard().backward();
                return null;
            }
        }.execute();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.resetLayer();
    }

    private void jLabel11MousePressed(MouseEvent evt) {
        this.showResetLayerPopup(evt);
    }

    private void jLabel10MousePressed(MouseEvent evt) {
        this.showResetLayerPopup(evt);
    }

    private void simpleBackgroundedJPanel2MousePressed(MouseEvent evt) {
        this.showResetLayerPopup(evt);
    }

    private void showResetLayerPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void resetLayer() {
        this.getWizard().setSingleLayer(null);
        this.jLabel10.setToolTipText(null);
        this.jLabel11.setVisible(false);
    }

    public boolean isBackwardPossible() {
        return this.getHandler() != null && this.getHandler().getNumOfPairs() > 0 && (this.jXTable1.getSelectedRow() > 0 || this.getWizard().isCoordinateSelected());
    }

    public boolean isForwardPossible() {
        return this.getHandler() != null && this.getHandler().getNumOfPairs() > 0 && (this.jXTable1.getSelectedRow() < this.getHandler().getNumOfPairs() - 1 || this.getWizard().isPointSelected());
    }

    private void refreshWizardBinding() {
        if (!this.isWizardRefreshing()) {
            this.setWizardRefreshing(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        RasterGeoReferencingPanel.this.bindingGroup.getBinding("wizPosition").unbind();
                        RasterGeoReferencingPanel.this.bindingGroup.getBinding("wizBackwardEnable").unbind();
                        RasterGeoReferencingPanel.this.bindingGroup.getBinding("wizForwardEnable").unbind();
                        RasterGeoReferencingPanel.this.bindingGroup.getBinding("wizPointEnable").unbind();
                        RasterGeoReferencingPanel.this.bindingGroup.getBinding("wizCoordinateEnable").unbind();
                        RasterGeoReferencingPanel.this.bindingGroup.getBinding("wizPosition").bind();
                        RasterGeoReferencingPanel.this.bindingGroup.getBinding("wizBackwardEnable").bind();
                        RasterGeoReferencingPanel.this.bindingGroup.getBinding("wizForwardEnable").bind();
                        RasterGeoReferencingPanel.this.bindingGroup.getBinding("wizPointEnable").bind();
                        RasterGeoReferencingPanel.this.bindingGroup.getBinding("wizCoordinateEnable").bind();
                    }
                    finally {
                        RasterGeoReferencingPanel.this.setWizardRefreshing(false);
                    }
                }
            });
        }
    }

    private void refreshModel() {
        ((PairTableModel)this.jXTable1.getModel()).fireTableDataChanged();
    }

    private CellSelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    private boolean isWizardRefreshing() {
        return this.wizardRefreshing;
    }

    private void setWizardRefreshing(boolean wizardRefreshing) {
        this.wizardRefreshing = wizardRefreshing;
    }

    class DnDTargetSimpleBackgroundedJPanel
    extends SimpleBackgroundedJPanel
    implements DropTargetListener {
        public DnDTargetSimpleBackgroundedJPanel() {
            DropTarget dt = new DropTarget(this, 3, this);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                RasterGeoReferencingPanel.this.getWizard().drop(dtde);
                RetrievalServiceLayer layer = RasterGeoReferencingPanel.this.getWizard().getSingleLayer();
                String tooltip = layer != null ? "<html>" + RasterGeoReferencingPanel.this.jLabel12.getText() + ": " + layer.getName() : null;
                RasterGeoReferencingPanel.this.jLabel10.setToolTipText(tooltip);
                RasterGeoReferencingPanel.this.jLabel11.setToolTipText(tooltip);
                RasterGeoReferencingPanel.this.jLabel11.setVisible(layer != null);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error in drop", (Throwable)ex);
            }
        }
    }

    private class CellSelectionListener
    implements ListSelectionListener {
        private CellSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                RasterGeoReferencingPanel.this.refreshWizardBinding();
                int position = RasterGeoReferencingPanel.this.jXTable1.getSelectedRow();
                if (position < 0) {
                    RasterGeoReferencingPanel.this.getWizard().clearSelection();
                } else if (RasterGeoReferencingPanel.this.jXTable1.getSelectedColumn() == 1) {
                    RasterGeoReferencingPanel.this.getWizard().selectPoint(position);
                } else if (RasterGeoReferencingPanel.this.jXTable1.getSelectedColumn() == 2) {
                    RasterGeoReferencingPanel.this.getWizard().selectCoordinate(position);
                }
            }
        }
    }

    private class WizardListener
    implements RasterGeoReferencingWizardListener {
        private WizardListener() {
        }

        @Override
        public void positionAdded(int position) {
            RasterGeoReferencingPanel.this.refreshModel();
            RasterGeoReferencingPanel.this.refreshWizardBinding();
            if (RasterGeoReferencingPanel.this.getHandler().getNumOfPairs() == 1) {
                RasterGeoReferencingPanel.this.getWizard().selectPoint(0);
            }
        }

        @Override
        public void positionRemoved(int position) {
            RasterGeoReferencingPanel.this.refreshModel();
            RasterGeoReferencingPanel.this.refreshWizardBinding();
        }

        @Override
        public void positionChanged(int position) {
            if (RasterGeoReferencingPanel.this.getWizard().isPointSelected()) {
                RasterGeoReferencingPanel.this.refreshModel();
                this.pointSelected(position);
            } else if (RasterGeoReferencingPanel.this.getWizard().isCoordinateSelected()) {
                RasterGeoReferencingPanel.this.refreshModel();
                this.coordinateSelected(position);
            }
            RasterGeoReferencingPanel.this.refreshWizardBinding();
        }

        @Override
        public void transformationChanged() {
        }

        @Override
        public void pointSelected(int position) {
            RasterGeoReferencingPanel.this.jXTable1.changeSelection(position, 1, false, false);
            RasterGeoReferencingPanel.this.refreshWizardBinding();
        }

        @Override
        public void coordinateSelected(int position) {
            RasterGeoReferencingPanel.this.jXTable1.changeSelection(position, 2, false, false);
            RasterGeoReferencingPanel.this.refreshWizardBinding();
        }

        @Override
        public void handlerChanged(RasterGeoReferencingHandler handler) {
            RasterGeoReferencingPanel.this.refreshModel();
            RasterGeoReferencingPanel.this.refreshWizardBinding();
            if (RasterGeoReferencingPanel.this.getHandler() != null && RasterGeoReferencingPanel.this.getHandler().getNumOfPairs() > 0) {
                RasterGeoReferencingPanel.this.getWizard().selectPoint(0);
            }
        }
    }

    private class PairTableModel
    extends AbstractTableModel {
        private PairTableModel() {
        }

        @Override
        public int getRowCount() {
            return RasterGeoReferencingPanel.this.getHandler() == null || RasterGeoReferencingPanel.this.getHandler() == null ? 0 : RasterGeoReferencingPanel.this.getHandler().getNumOfPairs();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_CLASSES.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PointCoordinatePair pair = RasterGeoReferencingPanel.this.getHandler().getPair(rowIndex);
            Point point = pair.getPoint();
            Coordinate coordinate = pair.getCoordinate();
            DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols();
            otherSymbols.setDecimalSeparator(',');
            DecimalFormat format = new DecimalFormat("#0.00", otherSymbols);
            switch (columnIndex) {
                case 0: {
                    return rowIndex + 1;
                }
                case 1: {
                    return point != null ? "[" + (int)point.getX() + ";" + (int)point.getY() + "]" : null;
                }
                case 2: {
                    return coordinate != null ? "[" + format.format(coordinate.x) + ";" + format.format(coordinate.y) + "]" : null;
                }
                case 3: {
                    if (RasterGeoReferencingPanel.this.getHandler().isComplete()) {
                        return format.format(RasterGeoReferencingPanel.this.getHandler().getError(rowIndex));
                    }
                    return "-";
                }
                case 4: {
                    return RasterGeoReferencingPanel.this.getHandler().isPositionEnabled(rowIndex);
                }
            }
            return null;
        }

        public void setPoint(final int position, final Point point) {
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    RasterGeoReferencingPanel.this.getHandler().setPoint(position, point);
                    return null;
                }
            }.execute();
        }

        public void setCoordinate(final int position, final Coordinate coordinate) {
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    RasterGeoReferencingPanel.this.getHandler().setCoordinate(position, coordinate);
                    return null;
                }
            }.execute();
        }

        public void setPostitionEnabled(final int position, final boolean enabled) {
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    RasterGeoReferencingPanel.this.getHandler().setPositionEnabled(position, enabled);
                    return null;
                }
            }.execute();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1 || columnIndex == 2) {
                String[] split;
                String value;
                String string = value = aValue != null ? ((String)aValue).trim() : null;
                if (value != null && (split = value.replaceAll("\\(|\\)|\\[|\\]| ", "").replaceAll("\\.", "").replaceAll("\\||/", ";").replaceAll(",", ".").split(";")).length == 2) {
                    try {
                        if (columnIndex == 1) {
                            int x = Integer.parseInt(split[0].trim());
                            int y = Integer.parseInt(split[1].trim());
                            this.setPoint(rowIndex, new Point(x, y));
                        } else {
                            double x = Double.parseDouble(split[0].trim());
                            double y = Double.parseDouble(split[1].trim());
                            this.setCoordinate(rowIndex, new Coordinate(x, y));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                if (columnIndex == 1) {
                    this.setPoint(rowIndex, null);
                } else {
                    this.setCoordinate(rowIndex, null);
                }
            } else if (columnIndex == 4) {
                Boolean value = (Boolean)aValue;
                this.setPostitionEnabled(rowIndex, Boolean.TRUE.equals(value));
            }
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 || columnIndex == 2 || columnIndex == 4;
        }
    }
}

