/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice.georeferencing;

import com.vividsolutions.jts.geom.Coordinate;
import de.cismet.cismap.commons.PNodeProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.capabilitywidget.SelectionAndCapabilities;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.rasterservice.ImageRasterService;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingHandler;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingWizardListener;
import de.cismet.cismap.commons.retrieval.AbstractRetrievalService;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class RasterGeoReferencingWizard
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(RasterGeoReferencingWizard.class);
    private static final DataFlavor CAPABILITIES_DATA_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "SelectionAndCapabilities");
    private static final int MAX_LAYER_COUNT = 3;
    private static final int DEFAULT_ZOOMVIEW_WIDTH = 200;
    private static final int DEFAULT_ZOOMVIEW_HEIGHT = 200;
    private static final int DEFAULT_ZOOMVIEW_FACTOR = 2;
    private RetrievalServiceLayer singleLayer = null;
    private final ListenerHandler listenerHandler = new ListenerHandler();
    private RasterGeoReferencingHandler handler;
    private Point selectedPoint;
    private Coordinate selectedCoordinate;
    private SelectionMode selectionMode = SelectionMode.NONE;
    private int position = 0;
    private final MappingComponent pointZoomMap = new MappingComponent();
    private final MappingComponent coordinateZoomMap = new MappingComponent();
    private int zoomViewWidth = 200;
    private int zoomViewHeight = 200;
    private double zoomViewFactor = 2.0;
    private final PCanvas pointZoomViewCanvas = new PCanvas();
    private final PCanvas coordinateZoomViewCanvas = new PCanvas();
    private boolean ignoreMapChange;
    private final PropertyChangeListenerHandler propertyChangeListenerHandler = new PropertyChangeListenerHandler();
    private final RetrievalListenerAdapter retrievalListenerAdapter = new RetrievalListenerAdapter();
    private final Collection<PropertyChangeListener> propertyChangeListeners = new ArrayList<PropertyChangeListener>();
    private Collection<RetrievalServiceLayer> ignoreLayerList = new ArrayList<RetrievalServiceLayer>();

    private RasterGeoReferencingWizard() {
        this.pointZoomMap.setAnimationDuration(0);
        this.pointZoomMap.setResizeEventActivated(false);
        this.pointZoomMap.setInternalLayerWidgetAvailable(false);
        this.refreshPointZoomMap();
        this.coordinateZoomMap.setAnimationDuration(0);
        this.coordinateZoomMap.setResizeEventActivated(false);
        this.coordinateZoomMap.setInternalLayerWidgetAvailable(false);
        this.refreshCoordinateZoomMap();
    }

    public boolean addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        return this.getPropertyChangeListeners().add(propertyChangeListener);
    }

    public boolean removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        return this.getPropertyChangeListeners().remove(propertyChangeListener);
    }

    private void refreshZoomViewCanvas(PCanvas pCanvas, MappingComponent zoomMap) {
        PCamera camera = new PCamera();
        camera.addLayer(zoomMap.getLayer());
        pCanvas.setCamera(camera);
        zoomMap.getRoot().addChild((PNode)camera);
    }

    public void updateZoom(int position) {
        this.updateZoom(position, SelectionMode.POINT);
        this.updateZoom(position, SelectionMode.COORDINATE);
    }

    private void updateZoom(int position, SelectionMode mode) {
        WorldToScreenTransform wtst;
        RasterGeoReferencingHandler handler = this.getHandler();
        Coordinate coordinate = SelectionMode.POINT.equals((Object)mode) ? handler.getPointCoordinate(position) : handler.getCoordinate(position);
        WorldToScreenTransform worldToScreenTransform = wtst = SelectionMode.POINT.equals((Object)mode) ? this.getPointZoomMap().getWtst() : this.getCoordinateZoomMap().getWtst();
        if (coordinate != null) {
            Point2D screenPoint = RasterGeoReferencingWizard.getScreenPoint(coordinate, wtst);
            this.setZoom(screenPoint, mode);
        }
    }

    private static Point2D getScreenPoint(Coordinate coordinate, WorldToScreenTransform wtst) {
        return new Point2D.Double(wtst.getScreenX(coordinate.x), wtst.getScreenY(coordinate.y));
    }

    public void setPointZoom(Coordinate coordinate) {
        this.setZoom(coordinate, SelectionMode.POINT);
    }

    public void setCoordinateZoom(Coordinate coordinate) {
        this.setZoom(coordinate, SelectionMode.COORDINATE);
    }

    private void setZoom(Coordinate coordinate, SelectionMode mode) {
        Point2D screenPoint = RasterGeoReferencingWizard.getScreenPoint(coordinate, this.getZoomMap(mode).getWtst());
        this.setZoom(screenPoint, mode);
    }

    private void setZoom(Point2D screenPoint, SelectionMode mode) {
        double factor = RasterGeoReferencingWizard.getMainMap().getCamera().getViewScale() * this.getZoomViewFactor();
        double width = (double)this.getZoomViewWidth() / factor;
        double height = (double)this.getZoomViewHeight() / factor;
        Rectangle2D.Double viewBounds = new Rectangle2D.Double(screenPoint.getX() - width / 2.0, screenPoint.getY() - height / 2.0, width, height);
        PCanvas pCanvas = SelectionMode.POINT.equals((Object)mode) ? this.getPointZoomViewCanvas() : this.getCoordinateZoomViewCanvas();
        pCanvas.getCamera().setViewBounds((Rectangle2D)viewBounds);
        pCanvas.getCamera().setViewScale(factor);
        this.getPropertyChangeListenerHandler().propertyChange(null);
    }

    public MappingComponent getPointZoomMap() {
        return this.getZoomMap(SelectionMode.POINT);
    }

    public MappingComponent getCoordinateZoomMap() {
        return this.getZoomMap(SelectionMode.COORDINATE);
    }

    private MappingComponent getZoomMap(SelectionMode mode) {
        return SelectionMode.POINT.equals((Object)mode) ? this.pointZoomMap : this.coordinateZoomMap;
    }

    public static MappingComponent getMainMap() {
        return CismapBroker.getInstance().getMappingComponent();
    }

    public static RetrievalServiceLayer cloneRetrievalServiceLayer(RetrievalServiceLayer retrievalServiceLayer) {
        AbstractRetrievalService ars;
        AbstractRetrievalService clone;
        if (!retrievalServiceLayer.isEnabled()) {
            return null;
        }
        if (!(retrievalServiceLayer instanceof PNodeProvider)) {
            return null;
        }
        RetrievalServiceLayer pnodeProvider = retrievalServiceLayer;
        PNode pnode = pnodeProvider.getPNode();
        if (pnode == null || !pnode.getVisible()) {
            return null;
        }
        if (retrievalServiceLayer instanceof AbstractRetrievalService && (clone = (ars = (AbstractRetrievalService)((Object)retrievalServiceLayer)).cloneWithoutRetrievalListeners()) instanceof RetrievalServiceLayer) {
            return (RetrievalServiceLayer)((Object)clone);
        }
        return null;
    }

    public final void refreshPointZoomMap() {
        this.refreshZoomMap(SelectionMode.POINT);
    }

    public final void refreshCoordinateZoomMap() {
        this.refreshZoomMap(SelectionMode.COORDINATE);
    }

    public void setSingleLayer(RetrievalServiceLayer singleLayer) {
        this.singleLayer = singleLayer;
        this.refreshZoomMap(SelectionMode.COORDINATE);
    }

    public RetrievalServiceLayer getSingleLayer() {
        return this.singleLayer;
    }

    public boolean drop(DropTargetDropEvent dtde) {
        if (dtde.getTransferable().isDataFlavorSupported(CAPABILITIES_DATA_FLAVOR)) {
            try {
                for (int i = 0; i < dtde.getTransferable().getTransferDataFlavors().length; ++i) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("DataFlavour" + i + ": " + dtde.getTransferable().getTransferDataFlavors()[i]));
                }
                Object o = dtde.getTransferable().getTransferData(CAPABILITIES_DATA_FLAVOR);
                ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
                dtde.dropComplete(true);
                if (o instanceof SelectionAndCapabilities) {
                    TreePath[] tpa = ((SelectionAndCapabilities)o).getSelection();
                    for (int i = 0; i < tpa.length; ++i) {
                        treePaths.add(tpa[i]);
                    }
                    WMSServiceLayer layer = ((SelectionAndCapabilities)o).getUrl().contains("cismap.dont.touch.ordering=true") ? new WMSServiceLayer(treePaths, false, false) : new WMSServiceLayer(treePaths, true, true);
                    layer.setWmsCapabilities(((SelectionAndCapabilities)o).getCapabilities());
                    layer.setCapabilitiesUrl(((SelectionAndCapabilities)o).getUrl());
                    this.setSingleLayer(layer);
                    return true;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        return false;
    }

    private void refreshZoomMap(SelectionMode mode) {
        MappingComponent origMap = RasterGeoReferencingWizard.getMainMap();
        if (origMap != null) {
            MappingComponent mappingComponent = SelectionMode.POINT.equals((Object)mode) ? this.pointZoomMap : this.coordinateZoomMap;
            PCanvas pCanvas = SelectionMode.POINT.equals((Object)mode) ? this.getPointZoomViewCanvas() : this.getCoordinateZoomViewCanvas();
            MappingComponent zoomMap = this.getZoomMap(mode);
            WorldToScreenTransform wtst = zoomMap.getWtst();
            Point2D zoomPoint = pCanvas.getCamera().getViewBounds().getCenter2D();
            Coordinate zoomCoordinate = wtst != null ? new Coordinate(wtst.getWorldX(zoomPoint.getX()), wtst.getWorldY(zoomPoint.getY())) : null;
            origMap.removePropertyChangeListener(this);
            origMap.addPropertyChangeListener(this);
            XBoundingBox origBb = (XBoundingBox)origMap.getCurrentBoundingBoxFromCamera();
            WorldToScreenTransform origWtst = origMap.getWtst();
            double zoomWidth = (double)this.getZoomViewWidth() / this.getZoomViewFactor();
            double zoomHeight = (double)this.getZoomViewHeight() / this.getZoomViewFactor();
            Point2D.Double topLeft = new Point2D.Double(origWtst.getScreenX(origBb.getX1()) - zoomWidth / 2.0, origWtst.getScreenY(origBb.getY1()) - zoomHeight / 2.0);
            Point2D.Double bottomRight = new Point2D.Double(origWtst.getScreenX(origBb.getX2()) + zoomWidth / 2.0, origWtst.getScreenY(origBb.getY2()) + zoomHeight / 2.0);
            Rectangle mapBounds = new Rectangle((int)((double)origMap.getWidth() + zoomWidth), (int)((double)origMap.getHeight() + zoomHeight));
            Dimension zoomMapDimension = mapBounds.getSize();
            XBoundingBox bb = new XBoundingBox(origWtst.getWorldX(((Point2D)topLeft).getX()), origWtst.getWorldY(((Point2D)topLeft).getY()), origWtst.getWorldX(((Point2D)bottomRight).getX()), origWtst.getWorldY(((Point2D)bottomRight).getY()), origBb.getSrs(), origBb.isMetric());
            ActiveLayerModel mappingModel = new ActiveLayerModel();
            mappingModel.setSrs(origMap.getMappingModel().getSrs());
            mappingModel.addHome(bb);
            if (SelectionMode.COORDINATE.equals((Object)mode) && this.getSingleLayer() != null) {
                mappingModel.addLayer(this.getSingleLayer());
            } else {
                int layerCount = 0;
                for (Object rasterService : origMap.getMappingModel().getRasterServices().values()) {
                    RetrievalServiceLayer retrievalServiceLayer;
                    boolean including;
                    if (layerCount == 3) break;
                    if (!(rasterService instanceof RetrievalServiceLayer) || !(including = (retrievalServiceLayer = (RetrievalServiceLayer)rasterService) instanceof ImageRasterService && SelectionMode.POINT.equals((Object)mode) || (this.getHandler() == null || this.getHandler().getService() == null || !this.getHandler().getService().equals(rasterService)) && SelectionMode.COORDINATE.equals((Object)mode))) continue;
                    RetrievalServiceLayer clone = RasterGeoReferencingWizard.cloneRetrievalServiceLayer(retrievalServiceLayer);
                    if (SelectionMode.POINT.equals((Object)mode)) {
                        clone.setTranslucency(1.0f);
                    }
                    if (clone == null) continue;
                    clone.addRetrievalListener(this.getRetrievalListenerAdapter());
                    this.getIgnoreLayerList().add(clone);
                    mappingModel.addLayer(clone);
                    ++layerCount;
                }
            }
            ActiveLayerModel oldMappingModel = (ActiveLayerModel)mappingComponent.getMappingModel();
            if (oldMappingModel != null) {
                oldMappingModel.removeMappingModelListener(mappingComponent);
                Collection<MapService> oldLayers = oldMappingModel.getMapServices().values();
                for (MapService mapService : oldMappingModel.getMapServices().values()) {
                    if (!(mapService instanceof RetrievalServiceLayer)) continue;
                    RetrievalServiceLayer retrievalServiceLayer = (RetrievalServiceLayer)((Object)mapService);
                    retrievalServiceLayer.removeRetrievalListener(this.getRetrievalListenerAdapter());
                }
                oldMappingModel.removeAllLayers();
                this.getIgnoreLayerList().removeAll(oldLayers);
            }
            if (SelectionMode.POINT.equals((Object)mode)) {
                mappingComponent.getMapServiceLayer().removeAllChildren();
            }
            mappingComponent.lock();
            mappingComponent.setSize(zoomMapDimension);
            mappingComponent.setMappingModel(mappingModel);
            mappingComponent.unlock();
            if (!mappingComponent.getInteractionMode().equals("MUTE")) {
                mappingComponent.setInteractionMode("MUTE");
            }
            this.refreshZoomViewCanvas(pCanvas, zoomMap);
            if (zoomCoordinate != null) {
                this.setZoom(zoomCoordinate, mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        MappingComponent mappingComponent = RasterGeoReferencingWizard.getMainMap();
        synchronized (mappingComponent) {
            if (RasterGeoReferencingWizard.getMainMap().equals(evt.getSource()) && !this.isIgnoreMapChange()) {
                this.setIgnoreMapChange(true);
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        Thread.sleep(1000L);
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            if (RasterGeoReferencingWizard.this.isPointSelected()) {
                                RasterGeoReferencingWizard.this.refreshPointZoomMap();
                            }
                            if (RasterGeoReferencingWizard.this.isCoordinateSelected()) {
                                RasterGeoReferencingWizard.this.refreshCoordinateZoomMap();
                            }
                        }
                        finally {
                            RasterGeoReferencingWizard.this.setIgnoreMapChange(false);
                        }
                    }
                }.execute();
            }
        }
    }

    public boolean addListener(RasterGeoReferencingWizardListener listener) {
        return this.listenerHandler.add(listener);
    }

    public boolean removeListener(RasterGeoReferencingWizardListener listener) {
        return this.listenerHandler.remove(listener);
    }

    public boolean isPointSelected() {
        return SelectionMode.POINT.equals((Object)this.selectionMode);
    }

    public boolean isCoordinateSelected() {
        return SelectionMode.COORDINATE.equals((Object)this.selectionMode);
    }

    public boolean isPointSelectionMode() {
        return SelectionMode.POINT == this.selectionMode;
    }

    public boolean isCoordinateSelectionMode() {
        return SelectionMode.COORDINATE == this.selectionMode;
    }

    private void setPosition(int position) {
        this.position = position;
    }

    public void forward() {
        int position = this.getPosition();
        if (this.isPointSelected()) {
            this.selectCoordinate(position);
        } else if (this.isCoordinateSelected()) {
            if (position + 1 == this.getHandler().getNumOfPairs()) {
                this.getHandler().addPair();
            }
            this.selectPoint(position + 1);
        }
    }

    public void backward() {
        if (this.isPointSelected()) {
            if (this.getPosition() > 0) {
                this.selectCoordinate(this.getPosition() - 1);
            } else {
                this.selectCoordinate(this.getHandler().getNumOfPairs() - 1);
            }
        } else if (this.isCoordinateSelected()) {
            this.selectPoint(this.getPosition());
        }
    }

    public void setHandler(RasterGeoReferencingHandler newHandler) {
        boolean handlerChanged;
        RasterGeoReferencingHandler oldHandler = this.getHandler();
        boolean bl = handlerChanged = newHandler != null && !newHandler.equals(oldHandler) || newHandler == null && oldHandler != null;
        if (handlerChanged) {
            if (newHandler != null) {
                newHandler.addListener(this.listenerHandler);
            }
            this.handler = newHandler;
            this.listenerHandler.handlerChanged(newHandler);
            if (this.handler != null && this.handler.getNumOfPairs() <= 0) {
                this.handler.addPair();
            }
            if (oldHandler != null) {
                oldHandler.removeListener(this.listenerHandler);
            }
        }
    }

    public void clearSelection() {
        this.selectionMode = SelectionMode.NONE;
        this.selectedPoint = null;
        this.selectedCoordinate = null;
    }

    private void changeTransparency(SelectionMode mode) {
        ImageRasterService service = this.getHandler().getService();
        float transparency = SelectionMode.COORDINATE.equals((Object)mode) ? 0.2f : 1.0f;
        service.setTranslucency(transparency);
        PNode pi = service.getPNode();
        if (pi != null) {
            pi.setTransparency(transparency);
            pi.repaint();
        }
    }

    public void selectPoint(int position) throws IndexOutOfBoundsException {
        boolean changed;
        Point point = this.getHandler().getPoint(position);
        boolean bl = changed = this.selectedPoint == null || point == null && this.selectedPoint != null || point != null && !point.equals(this.selectedPoint);
        if (changed) {
            this.setPosition(position);
            this.selectionMode = SelectionMode.POINT;
            this.selectedPoint = point;
            this.selectedCoordinate = null;
            this.listenerHandler.pointSelected(position);
        }
        this.changeTransparency(SelectionMode.POINT);
    }

    public void selectCoordinate(int position) throws IndexOutOfBoundsException {
        boolean changed;
        Coordinate coordinate = this.getHandler().getCoordinate(position);
        boolean bl = changed = this.selectedCoordinate == null || coordinate == null && this.selectedCoordinate != null || coordinate != null && !coordinate.equals((Object)this.selectedCoordinate);
        if (changed) {
            this.setPosition(position);
            this.selectionMode = SelectionMode.COORDINATE;
            this.selectedPoint = null;
            this.selectedCoordinate = coordinate;
            this.listenerHandler.coordinateSelected(position);
        }
        this.changeTransparency(SelectionMode.COORDINATE);
    }

    public static RasterGeoReferencingWizard getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public RasterGeoReferencingHandler getHandler() {
        return this.handler;
    }

    public Point getSelectedPoint() {
        return this.selectedPoint;
    }

    public Coordinate getSelectedCoordinate() {
        return this.selectedCoordinate;
    }

    public int getPosition() {
        return this.position;
    }

    public int getZoomViewWidth() {
        return this.zoomViewWidth;
    }

    public void setZoomViewWidth(int zoomViewWidth) {
        this.zoomViewWidth = zoomViewWidth;
    }

    public int getZoomViewHeight() {
        return this.zoomViewHeight;
    }

    public void setZoomViewHeight(int zoomViewHeight) {
        this.zoomViewHeight = zoomViewHeight;
    }

    public double getZoomViewFactor() {
        return this.zoomViewFactor;
    }

    public void setZoomViewFactor(double zoomViewFactor) {
        this.zoomViewFactor = zoomViewFactor;
    }

    public PCanvas getPointZoomViewCanvas() {
        return this.pointZoomViewCanvas;
    }

    public PCanvas getCoordinateZoomViewCanvas() {
        return this.coordinateZoomViewCanvas;
    }

    private boolean isIgnoreMapChange() {
        return this.ignoreMapChange;
    }

    private void setIgnoreMapChange(boolean ignoreMapChange) {
        this.ignoreMapChange = ignoreMapChange;
    }

    private PropertyChangeListenerHandler getPropertyChangeListenerHandler() {
        return this.propertyChangeListenerHandler;
    }

    private RetrievalListenerAdapter getRetrievalListenerAdapter() {
        return this.retrievalListenerAdapter;
    }

    private Collection<PropertyChangeListener> getPropertyChangeListeners() {
        return this.propertyChangeListeners;
    }

    public Collection<RetrievalServiceLayer> getIgnoreLayerList() {
        return this.ignoreLayerList;
    }

    private void setIgnoreLayerList(Collection<RetrievalServiceLayer> ignoreLayerList) {
        this.ignoreLayerList = ignoreLayerList;
    }

    class RetrievalListenerAdapter
    implements RetrievalListener {
        RetrievalListenerAdapter() {
        }

        @Override
        public void retrievalStarted(RetrievalEvent e) {
        }

        @Override
        public void retrievalProgress(RetrievalEvent e) {
        }

        @Override
        public void retrievalComplete(RetrievalEvent e) {
            RasterGeoReferencingWizard.this.getPropertyChangeListenerHandler().propertyChange(null);
        }

        @Override
        public void retrievalAborted(RetrievalEvent e) {
        }

        @Override
        public void retrievalError(RetrievalEvent e) {
        }
    }

    class PropertyChangeListenerHandler
    implements PropertyChangeListener {
        PropertyChangeListenerHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            for (PropertyChangeListener propertyChangeListener : RasterGeoReferencingWizard.this.propertyChangeListeners) {
                propertyChangeListener.propertyChange(evt);
            }
        }
    }

    private class ListenerHandler
    implements RasterGeoReferencingWizardListener {
        private final Collection<RasterGeoReferencingWizardListener> listeners = new ArrayList<RasterGeoReferencingWizardListener>();

        private ListenerHandler() {
        }

        public boolean add(RasterGeoReferencingWizardListener listener) {
            return this.listeners.add(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(RasterGeoReferencingWizardListener listener) {
            Collection<RasterGeoReferencingWizardListener> collection = this.listeners;
            synchronized (collection) {
                return this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RasterGeoReferencingWizardListener[] getSyncedListeners() {
            Collection<RasterGeoReferencingWizardListener> collection = this.listeners;
            synchronized (collection) {
                return this.listeners.toArray(new RasterGeoReferencingWizardListener[0]);
            }
        }

        @Override
        public void pointSelected(int position) {
            for (RasterGeoReferencingWizardListener listener : this.getSyncedListeners()) {
                listener.pointSelected(position);
            }
        }

        @Override
        public void coordinateSelected(int position) {
            for (RasterGeoReferencingWizardListener listener : this.getSyncedListeners()) {
                listener.coordinateSelected(position);
            }
        }

        @Override
        public void handlerChanged(RasterGeoReferencingHandler handler) {
            for (RasterGeoReferencingWizardListener listener : this.getSyncedListeners()) {
                listener.handlerChanged(handler);
            }
        }

        @Override
        public void positionAdded(int position) {
            for (RasterGeoReferencingWizardListener listener : this.getSyncedListeners()) {
                listener.positionAdded(position);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (RasterGeoReferencingWizard.this.getHandler().getNumOfPairs() == 1) {
                        RasterGeoReferencingWizard.this.selectPoint(0);
                    }
                }
            });
        }

        @Override
        public void positionRemoved(int position) {
            for (RasterGeoReferencingWizardListener listener : this.getSyncedListeners()) {
                listener.positionRemoved(position);
            }
        }

        @Override
        public void positionChanged(int position) {
            for (RasterGeoReferencingWizardListener listener : this.getSyncedListeners()) {
                listener.positionChanged(position);
            }
        }

        @Override
        public void transformationChanged() {
            for (RasterGeoReferencingWizardListener listener : this.getSyncedListeners()) {
                listener.transformationChanged();
            }
        }
    }

    private static final class LazyInitialiser {
        private static final RasterGeoReferencingWizard INSTANCE = new RasterGeoReferencingWizard();

        private LazyInitialiser() {
        }
    }

    private static enum SelectionMode {
        POINT,
        COORDINATE,
        NONE;

    }
}

