/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.retrieval;

import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.cismap.commons.retrieval.RetrievalService;
import de.cismet.tools.CurrentStackTrace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractRetrievalService
implements RetrievalService {
    public static final String PROGRESS_PROPERTY = "progress";
    public static final String PROGRESS_REFRESH = "refresh";
    protected static final boolean DEBUG = false;
    private static final Logger LOG = Logger.getLogger(AbstractRetrievalService.class);
    protected int progress = -1;
    protected boolean refreshNeeded = false;
    protected List<RetrievalListener> listeners = new ArrayList<RetrievalListener>();
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected Object errorObject = null;
    final Object fireRetrievalStartedLock = new Object();
    final Object fireRetrievalProgressLock = new Object();
    final Object fireRetrievalCompleteLock = new Object();
    final Object fireRetrievalAbortedLock = new Object();
    final Object fireRetrievalErrorLock = new Object();

    @Override
    public void removeRetrievalListener(RetrievalListener irl) {
        this.listeners.remove(irl);
    }

    @Override
    public void addRetrievalListener(RetrievalListener irl) {
        if (!this.listeners.contains(irl)) {
            this.listeners.add(irl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRetrievalStarted(RetrievalEvent e) {
        Object object = this.fireRetrievalStartedLock;
        synchronized (object) {
            this.setProgress(-1);
            e.setRetrievalService(this);
            for (int i = 0; i < this.listeners.size(); ++i) {
                RetrievalListener l = this.listeners.get(i);
                if (!(l instanceof RetrievalListener)) continue;
                l.retrievalStarted(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRetrievalProgress(RetrievalEvent e) {
        Object object = this.fireRetrievalProgressLock;
        synchronized (object) {
            this.setProgress(e.getPercentageDone());
            e.setRetrievalService(this);
            for (RetrievalListener l : this.listeners) {
                if (!(l instanceof RetrievalListener)) continue;
                l.retrievalProgress(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRetrievalComplete(RetrievalEvent e) {
        Object object = this.fireRetrievalCompleteLock;
        synchronized (object) {
            this.setProgress(100);
            e.setRetrievalService(this);
            for (RetrievalListener l : new ArrayList<RetrievalListener>(this.listeners)) {
                if (!(l instanceof RetrievalListener)) continue;
                l.retrievalComplete(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRetrievalAborted(RetrievalEvent e) {
        Object object = this.fireRetrievalAbortedLock;
        synchronized (object) {
            this.setProgress(0);
            e.setRetrievalService(this);
            for (RetrievalListener l : this.listeners) {
                if (!(l instanceof RetrievalListener)) continue;
                l.retrievalAborted(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRetrievalError(RetrievalEvent e) {
        Object object = this.fireRetrievalErrorLock;
        synchronized (object) {
            this.setProgress(0);
            LOG.warn((Object)"fireRetrievalError: ", (Throwable)new CurrentStackTrace());
            e.setRetrievalService(this);
            for (RetrievalListener l : this.listeners) {
                if (!(l instanceof RetrievalListener)) continue;
                l.retrievalError(e);
            }
        }
    }

    @Override
    public abstract void retrieve(boolean var1);

    public abstract Object clone();

    public AbstractRetrievalService cloneWithoutRetrievalListeners() {
        AbstractRetrievalService ret = (AbstractRetrievalService)this.clone();
        ret.listeners.clear();
        return ret;
    }

    public List<RetrievalListener> getListeners() {
        return this.listeners;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(int progress) {
        int oldProgress = this.progress;
        if (progress > 100 || progress < -1) {
            LOG.warn((Object)("invalid progress '" + progress + "', setting to -1 (indeterminate)"));
            this.progress = -1;
        } else {
            this.progress = progress;
        }
        this.propertyChangeSupport.firePropertyChange(PROGRESS_PROPERTY, oldProgress, this.progress);
    }

    public Object getErrorObject() {
        return this.errorObject;
    }

    public void setErrorObject(Object errorObject) {
        this.errorObject = errorObject;
    }

    @Override
    public boolean isRefreshNeeded() {
        return this.refreshNeeded;
    }

    @Override
    public void setRefreshNeeded(boolean refreshNeeded) {
        boolean oldRefreshNeeded = this.refreshNeeded;
        this.refreshNeeded = refreshNeeded;
        this.propertyChangeSupport.firePropertyChange(PROGRESS_REFRESH, oldRefreshNeeded, this.refreshNeeded);
    }

    public boolean hasErrors() {
        return this.errorObject != null;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }
}

