/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class GeometryUtils {
    private static final Logger LOG = Logger.getLogger(GeometryUtils.class);

    public static Geometry createDummyGeometry(String geometryType) {
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), -1);
        if (geometryType.equalsIgnoreCase("Point")) {
            return factory.createPoint(new Coordinate(1.0, 2.0));
        }
        if (geometryType.equalsIgnoreCase("MultiPoint")) {
            return factory.createMultiPoint(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(2.0, 2.0)});
        }
        if (geometryType.equalsIgnoreCase("LineString")) {
            return factory.createLineString(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(2.0, 2.0)});
        }
        if (geometryType.equalsIgnoreCase("MultiLineString")) {
            LineString ls1 = factory.createLineString(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(2.0, 2.0)});
            LineString ls2 = factory.createLineString(new Coordinate[]{new Coordinate(3.0, 3.0), new Coordinate(4.0, 3.0)});
            return factory.createMultiLineString(new LineString[]{ls1, ls2});
        }
        if (geometryType.equalsIgnoreCase("Polygon")) {
            return factory.createPolygon(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(2.0, 2.0), new Coordinate(2.0, 3.0), new Coordinate(1.0, 3.0), new Coordinate(1.0, 2.0)});
        }
        if (geometryType.equalsIgnoreCase("MultiPolygon")) {
            Polygon p = factory.createPolygon(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(2.0, 2.0), new Coordinate(2.0, 3.0), new Coordinate(1.0, 3.0), new Coordinate(1.0, 2.0)});
            return factory.createMultiPolygon(new Polygon[]{p});
        }
        return null;
    }

    public static Geometry force2d(Geometry g) {
        if (g != null) {
            g.apply(new CoordinateFilter(){

                public void filter(Coordinate coord) {
                    coord.z = 0.0;
                }
            });
            g.geometryChanged();
        }
        return g;
    }

    public static Geometry reverseGeometryCoordinates(Geometry g) {
        g.apply(new CoordinateFilter(){

            public void filter(Coordinate crdnt) {
                double newX = crdnt.y;
                crdnt.y = crdnt.x;
                crdnt.x = newX;
            }
        });
        g.geometryChanged();
        return g;
    }

    public static byte getShpGeometryType(String geometryType) {
        if (geometryType.equalsIgnoreCase("Point")) {
            return 1;
        }
        if (geometryType.equalsIgnoreCase("MultiPoint")) {
            return 8;
        }
        if (geometryType.equalsIgnoreCase("LineString")) {
            return 3;
        }
        if (geometryType.equalsIgnoreCase("MultiLineString")) {
            return 3;
        }
        if (geometryType.equalsIgnoreCase("Polygon")) {
            return 5;
        }
        if (geometryType.equalsIgnoreCase("MultiPolygon")) {
            return 5;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearShpOrShxFile(String fileName, int shpGeoType) throws IOException {
        File origFile = new File(fileName);
        if (origFile.exists()) {
            InputStream is = null;
            OutputStream os = null;
            origFile.delete();
            try {
                int b;
                is = GeometryUtils.class.getResourceAsStream("/de/cismet/watergis/gui/actions/emptyShapeTemplate.shp");
                os = new FileOutputStream(new File(fileName));
                int index = 0;
                while ((b = is.read()) != -1) {
                    if (index == 32) {
                        os.write(shpGeoType);
                    } else {
                        os.write(b);
                    }
                    ++index;
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot close " + origFile.getAbsolutePath()), (Throwable)e);
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot close " + fileName), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDbfFile(String fileName) throws IOException {
        File origFile = new File(fileName);
        if (origFile.exists()) {
            FileInputStream is = null;
            OutputStream os = null;
            origFile.renameTo(new File(fileName + ".backup"));
            origFile = new File(fileName + ".backup");
            try {
                int content;
                is = new FileInputStream(origFile);
                os = new FileOutputStream(new File(fileName));
                int byteCounter = 0;
                int tmpLength = 0;
                int length = 1000;
                while ((content = ((InputStream)is).read()) != -1) {
                    if (++byteCounter == 5) {
                        os.write(0);
                        continue;
                    }
                    if (byteCounter == 9) {
                        tmpLength = content;
                    }
                    if (byteCounter == 10) {
                        length = tmpLength += content << 8;
                    }
                    os.write(content);
                    if (byteCounter < length - 1 || content != 13) continue;
                    break;
                }
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot close " + origFile.getAbsolutePath()), (Throwable)e);
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot close " + fileName), (Throwable)e);
                }
                origFile.delete();
            }
        }
    }
}

