/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

public class PixelDPICalculator {
    private int widthPixel;
    private int heightPixel;
    private int dpi;
    private final double aspectRatio;
    private final double widthInches;

    public PixelDPICalculator(int widthPixel, int heightPixel, int dpi) {
        this.widthPixel = widthPixel;
        this.heightPixel = heightPixel;
        this.dpi = dpi;
        this.aspectRatio = (double)widthPixel * 1.0 / (double)heightPixel;
        this.widthInches = (double)widthPixel * 1.0 / (double)dpi;
    }

    public int getHeightPixel() {
        return this.heightPixel;
    }

    public void setHeightPixel(int newHeightPixel) {
        this.widthPixel = (int)Math.round((double)newHeightPixel * this.aspectRatio);
        double newDpi = (double)this.widthPixel / this.widthInches;
        this.dpi = (int)Math.round(newDpi);
        this.heightPixel = newHeightPixel;
    }

    public int getDPI() {
        return this.dpi;
    }

    public void setDPI(int newDpi) {
        double newWidthPixel = (double)this.widthPixel * 1.0 / (double)this.dpi * (double)newDpi;
        this.widthPixel = (int)Math.round(newWidthPixel);
        this.heightPixel = (int)Math.round((double)this.widthPixel * 1.0 / this.aspectRatio);
        this.dpi = newDpi;
    }

    public int getWidthPixel() {
        return this.widthPixel;
    }

    public void setWidthPixel(int newWidthPixel) {
        this.heightPixel = (int)Math.round((double)newWidthPixel * 1.0 / this.aspectRatio);
        this.widthPixel = newWidthPixel;
        double newDpi = (double)this.widthPixel / this.widthInches;
        this.dpi = (int)Math.round(newDpi);
    }
}

