/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.tools.FeatureTools;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.deegree.datatypes.QualifiedName;
import org.deegree.io.datastore.PropertyPathResolvingException;
import org.deegree.model.feature.AbstractFeatureCollection;
import org.deegree.model.feature.Feature;
import org.deegree.model.feature.FeatureFactory;
import org.deegree.model.feature.FeatureProperty;
import org.deegree.model.feature.schema.FeatureType;
import org.deegree.model.feature.schema.PropertyType;
import org.deegree.model.feature.schema.SimplePropertyType;
import org.deegree.model.spatialschema.Curve;
import org.deegree.model.spatialschema.GeometryException;
import org.deegree.model.spatialschema.JTSAdapter;
import org.deegree.model.spatialschema.MultiCurve;
import org.deegree.model.spatialschema.MultiPoint;
import org.deegree.model.spatialschema.MultiSurface;
import org.deegree.model.spatialschema.Point;
import org.deegree.model.spatialschema.Polygon;
import org.deegree.model.spatialschema.Surface;
import org.deegree.ogcbase.PropertyPath;

public class SimpleFeatureCollection
extends AbstractFeatureCollection {
    private static final Logger LOG = Logger.getLogger(SimpleFeatureCollection.class);
    List<String[]> aliasAttributeList;
    private Feature[] features;
    private Map<String, FeatureServiceAttribute> attributeMap;

    public SimpleFeatureCollection(String id, FeatureServiceFeature[] features, List<String[]> aliasAttributeList) {
        this(id, features, aliasAttributeList, null);
    }

    public SimpleFeatureCollection(String id, FeatureServiceFeature[] features, List<String[]> aliasAttributeList, Map<String, FeatureServiceAttribute> attributeMap) {
        super(id);
        this.features = new Feature[features.length];
        this.aliasAttributeList = aliasAttributeList;
        this.attributeMap = attributeMap;
        int index = 0;
        if (aliasAttributeList == null) {
            this.aliasAttributeList = this.generateAliasAttributeList(features);
        }
        if (features.length > 0) {
            PropertyType[] propTypeArray = this.getPropertyTypes(features[0]);
            for (FeatureServiceFeature tmp : features) {
                this.features[index++] = this.toDeegreeFeature(tmp, propTypeArray);
            }
        }
    }

    private List<String[]> generateAliasAttributeList(FeatureServiceFeature[] features) {
        ArrayList<String[]> aliasAttrList = new ArrayList<String[]>();
        Map<Object, Object> props = null;
        props = this.attributeMap != null ? this.attributeMap : (features[0].getLayerProperties() != null && features[0].getLayerProperties().getFeatureService() != null && features[0].getLayerProperties().getFeatureService().getFeatureServiceAttributes() != null ? features[0].getLayerProperties().getFeatureService().getFeatureServiceAttributes() : features[0].getProperties());
        if (features != null && features.length > 0) {
            for (Object key : props.keySet()) {
                String[] aliasAttr = new String[]{key.toString(), key.toString()};
                aliasAttrList.add(aliasAttr);
            }
        }
        return aliasAttrList;
    }

    public FeatureProperty getDefaultProperty(PropertyPath pp) throws PropertyPathResolvingException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setProperty(FeatureProperty fp, int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addProperty(FeatureProperty fp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeProperty(QualifiedName qn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void replaceProperty(FeatureProperty fp, FeatureProperty fp1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Feature cloneDeep() throws CloneNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void clear() {
        this.features = null;
    }

    public Feature getFeature(int i) {
        if (this.features != null) {
            return this.features[i];
        }
        return null;
    }

    public Feature getFeature(String string) {
        if (this.features != null) {
            for (int i = 0; i < this.features.length; ++i) {
                if (!this.features[i].getId().equals(string)) continue;
                return this.features[i];
            }
        }
        return null;
    }

    public Feature[] toArray() {
        return this.features;
    }

    public Iterator<Feature> iterator() {
        return Arrays.asList(this.features).iterator();
    }

    public void add(Feature ftr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Feature remove(Feature ftr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Feature remove(int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int size() {
        return this.features.length;
    }

    private Feature toDeegreeFeature(FeatureServiceFeature feature, PropertyType[] propTypeArray) {
        HashMap props = feature.getProperties();
        FeatureProperty[] propArray = new DefaultFeatureProperty[this.aliasAttributeList.size()];
        int index = 0;
        for (String[] aliasAttr : this.aliasAttributeList) {
            QualifiedName name = new QualifiedName(aliasAttr[0]);
            Object value = props.get(aliasAttr[1]);
            if (value instanceof Geometry) {
                try {
                    value = JTSAdapter.wrap((Geometry)((Geometry)value));
                }
                catch (GeometryException ex) {
                    LOG.error((Object)"Cannot convert JTS geometry to deegree geometry.", (Throwable)ex);
                }
            }
            propArray[index++] = new DefaultFeatureProperty(name, value);
        }
        FeatureType ft = FeatureFactory.createFeatureType((String)"test", (boolean)false, (PropertyType[])propTypeArray);
        return FeatureFactory.createFeature((String)String.valueOf(feature.getId()), (FeatureType)ft, (FeatureProperty[])propArray);
    }

    private PropertyType[] getPropertyTypes(FeatureServiceFeature feature) {
        HashMap props = feature.getProperties();
        Map<String, FeatureServiceAttribute> featureServiceAttributes = this.attributeMap != null ? this.attributeMap : feature.getLayerProperties().getFeatureService().getFeatureServiceAttributes();
        PropertyType[] propTypeArray = new PropertyType[this.aliasAttributeList.size()];
        int index = 0;
        for (String[] aliasAttr : this.aliasAttributeList) {
            FeatureServiceAttribute attr;
            QualifiedName name = new QualifiedName(aliasAttr[0]);
            Object value = props.get(aliasAttr[1]);
            if (value instanceof Geometry) {
                try {
                    value = JTSAdapter.wrap((Geometry)((Geometry)value));
                }
                catch (GeometryException ex) {
                    LOG.error((Object)"Cannot convert JTS geometry to deegree geometry.", (Throwable)ex);
                }
            }
            if ((attr = featureServiceAttributes.get(aliasAttr[1])) == null) {
                attr = featureServiceAttributes.get(aliasAttr[1].toUpperCase());
            }
            propTypeArray[index++] = this.getPropertyType(name, attr, value);
        }
        return propTypeArray;
    }

    private PropertyType getPropertyType(QualifiedName name, FeatureServiceAttribute attr, Object value) {
        block24: {
            if (attr != null && !attr.isGeometry()) {
                Class<?> cl = FeatureTools.getClass(attr);
                if (cl.equals(String.class)) {
                    return new SimplePropertyType(name, 12, 0, 1);
                }
                if (cl.equals(Integer.class)) {
                    return new SimplePropertyType(name, 4, 0, 1);
                }
                if (cl.equals(Long.class)) {
                    return new SimplePropertyType(name, -5, 0, 1);
                }
                if (cl.equals(Double.class)) {
                    return new SimplePropertyType(name, 8, 0, 1);
                }
                if (cl.equals(Date.class)) {
                    return new SimplePropertyType(name, 93, 0, 1);
                }
                if (cl.equals(Boolean.class)) {
                    return new SimplePropertyType(name, 16, 0, 1);
                }
                if (cl.equals(BigDecimal.class)) {
                    return new SimplePropertyType(name, 2, 0, 1);
                }
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Unknown attribute type found. Try to convert it to a deegree type");
                    }
                    int deegreeType = Integer.parseInt(attr.getType());
                    return new SimplePropertyType(name, deegreeType, 0, 1);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isDebugEnabled()) break block24;
                    LOG.debug((Object)"Unknown attribute type cannot be converted to a deegree type.", (Throwable)e);
                }
            }
        }
        if (value instanceof Integer) {
            return new SimplePropertyType(name, 4, 0, 1);
        }
        if (value instanceof Double) {
            return new SimplePropertyType(name, 8, 0, 1);
        }
        if (value instanceof String) {
            return new SimplePropertyType(name, 12, 0, 1);
        }
        if (value instanceof Float) {
            return new SimplePropertyType(name, 6, 0, 1);
        }
        if (value instanceof Polygon) {
            return new SimplePropertyType(name, 11013, 0, 1);
        }
        if (value instanceof Point) {
            return new SimplePropertyType(name, 11012, 0, 1);
        }
        if (value instanceof MultiPoint) {
            return new SimplePropertyType(name, 11015, 0, 1);
        }
        if (value instanceof Long) {
            return new SimplePropertyType(name, -5, 0, 1);
        }
        if (value instanceof Curve) {
            return new SimplePropertyType(name, 11013, 0, 1);
        }
        if (value instanceof MultiCurve) {
            return new SimplePropertyType(name, 11016, 0, 1);
        }
        if (value instanceof Surface) {
            return new SimplePropertyType(name, 11014, 0, 1);
        }
        if (value instanceof MultiSurface) {
            return new SimplePropertyType(name, 11017, 0, 1);
        }
        if (value instanceof Timestamp) {
            return new SimplePropertyType(name, 93, 0, 1);
        }
        LOG.error((Object)("unbekannter Typ: " + value.getClass().getName()));
        return null;
    }

    private class DefaultFeatureProperty
    implements FeatureProperty {
        private Object value = null;
        private QualifiedName name = null;

        DefaultFeatureProperty(QualifiedName name, Object value) {
            this.setValue(value);
            this.name = name;
        }

        public QualifiedName getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getValue(Object defaultValue) {
            if (this.value == null) {
                return defaultValue;
            }
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String toString() {
            String ret = null;
            ret = "name = " + this.name + "\n";
            ret = ret + "value = " + this.value + "\n";
            return ret;
        }

        public Feature getOwner() {
            return null;
        }
    }
}

