/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

import de.cismet.cismap.commons.BoundingBox;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.awt.Image;
import java.io.File;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.openide.util.Exceptions;

public class WorldFileDownload
extends AbstractDownload {
    private static final Logger LOG = Logger.getLogger(WorldFileDownload.class);
    private Future<Image> futureImage;
    private final BoundingBox boundingBoxFromMap;

    public WorldFileDownload(String title, Future<Image> futureImage, BoundingBox boundingBoxFromMap, String fileAbsolutPath) {
        this.futureImage = futureImage;
        this.boundingBoxFromMap = boundingBoxFromMap;
        this.title = title;
        this.fileToSaveTo = new File(fileAbsolutPath);
        this.status = Download.State.WAITING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.status != Download.State.WAITING) {
                this.releaseMemory();
                return;
            }
            this.status = Download.State.RUNNING;
            this.stateChanged();
            Image image = this.futureImage.get();
            String content = this.getWorldFileContent(image);
            if (content == null || content.length() <= 0) {
                log.info((Object)"Downloaded content seems to be empty..");
                if (this.status == Download.State.RUNNING) {
                    this.status = Download.State.COMPLETED;
                    this.stateChanged();
                }
                this.releaseMemory();
                return;
            }
            try (PrintWriter out = null;){
                out = new PrintWriter(this.fileToSaveTo);
                out.println(content);
            }
            if (this.status == Download.State.RUNNING) {
                this.status = Download.State.COMPLETED;
                this.stateChanged();
            }
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            LOG.error((Object)"Error while creating world file.", (Throwable)ex);
        }
        this.releaseMemory();
    }

    private String getWorldFileContent(Image image) {
        BoundingBox boundingBox = this.boundingBoxFromMap;
        DecimalFormat df = new DecimalFormat("#.");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setMaximumFractionDigits(32);
        double widthPixel = image.getWidth(null);
        double heightPixel = image.getHeight(null);
        double xPixelSize = (boundingBox.getX2() - boundingBox.getX1()) / widthPixel;
        boolean yRotation = false;
        boolean xRotation = false;
        double yPixelSize = (boundingBox.getY1() - boundingBox.getY2()) / heightPixel;
        double xPixelCenter = boundingBox.getX1() + xPixelSize / 2.0;
        double yPixelCenter = boundingBox.getY2() + yPixelSize / 2.0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(df.format(xPixelSize));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(0);
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(0);
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(df.format(yPixelSize));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(df.format(xPixelCenter));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(df.format(yPixelCenter));
        return stringBuilder.toString();
    }

    private void releaseMemory() {
        this.futureImage = null;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.title != null ? this.title.hashCode() : 0);
        hash = 31 * hash + (this.fileToSaveTo != null ? this.fileToSaveTo.hashCode() : 0);
        hash = 31 * hash + (this.boundingBoxFromMap != null ? this.boundingBoxFromMap.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        WorldFileDownload other = (WorldFileDownload)((Object)obj);
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (!(this.fileToSaveTo == other.fileToSaveTo || this.fileToSaveTo != null && this.fileToSaveTo.equals(other.fileToSaveTo))) {
            return false;
        }
        return this.boundingBoxFromMap == other.boundingBoxFromMap || this.boundingBoxFromMap != null && this.boundingBoxFromMap.equals(other.boundingBoxFromMap);
    }
}

