/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.util;

import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureWithId;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.factory.AbstractFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableFactory;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.retrieval.RepaintEvent;
import de.cismet.cismap.commons.retrieval.RepaintListener;
import de.cismet.cismap.commons.util.SelectionChangedEvent;
import de.cismet.cismap.commons.util.SelectionChangedListener;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class SelectionManager
implements FeatureCollectionListener,
ListSelectionListener {
    private static final Logger LOG = Logger.getLogger(SelectionManager.class);
    private static final AbstractFeatureService DUMMY = new DummyFeatureService();
    private final Map<AbstractFeatureService, Set<Feature>> selectedFeatures = new ConcurrentHashMap<AbstractFeatureService, Set<Feature>>();
    private final HashMap<AbstractFeatureService, AttributeTable> consideredAttributeTables = new HashMap();
    private List<AbstractFeatureService> editableServices = new ArrayList<AbstractFeatureService>();
    private final List<SelectionChangedListener> listener = new ArrayList<SelectionChangedListener>();
    private boolean selectionChangeInProgress = false;
    private MapSelectionRefresher mapRefresher = new MapSelectionRefresher();

    private SelectionManager() {
        this.editableServices = Collections.synchronizedList(this.editableServices);
        this.init();
    }

    public void init() {
        MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
        if (mc != null) {
            mc.getFeatureCollection().addFeatureCollectionListener(this);
            mc.addRepaintListener(new RepaintListener(){

                @Override
                public void repaintStart(RepaintEvent e) {
                }

                @Override
                public void repaintComplete(RepaintEvent e) {
                    if (e.getRetrievalEvent().getRetrievalService() instanceof AbstractFeatureService) {
                        SelectionManager.this.synchronizeSelectionWithMap((AbstractFeatureService)e.getRetrievalEvent().getRetrievalService());
                    }
                }

                @Override
                public void repaintError(RepaintEvent e) {
                }
            });
        }
    }

    private void synchronizeSelectionWithMap(AbstractFeatureService service) {
        List<Feature> selectedServiceFeatures;
        ArrayList features = new ArrayList();
        if (service.getPNode() != null) {
            features.addAll(service.getPNode().getChildrenReference());
        }
        if ((selectedServiceFeatures = this.getSelectedFeatures(service)) != null) {
            int[] selectedFeatureIds = new int[selectedServiceFeatures.size()];
            ArrayList<Feature> featuresToSelect = new ArrayList<Feature>();
            ArrayList<Feature> featuresToUnselect = new ArrayList<Feature>();
            int index = -1;
            for (Feature f : selectedServiceFeatures) {
                PFeature mapFeature = CismapBroker.getInstance().getMappingComponent().getPFeatureHM().get(f);
                if (mapFeature != null && !mapFeature.isSelected()) {
                    mapFeature.setSelected(true);
                }
                if (!(f instanceof FeatureWithId)) continue;
                selectedFeatureIds[++index] = ((FeatureWithId)((Object)f)).getId();
            }
            Arrays.sort(selectedFeatureIds);
            SelectionListener sl = (SelectionListener)CismapBroker.getInstance().getMappingComponent().getInputEventListener().get("SELECT");
            for (PFeature pfeature : features) {
                int featureIndex;
                boolean selected;
                Feature feature = pfeature.getFeature();
                if (!(feature instanceof FeatureWithId)) continue;
                boolean bl = selected = Arrays.binarySearch(selectedFeatureIds, ((FeatureWithId)((Object)feature)).getId()) >= 0;
                if (selected != pfeature.isSelected()) {
                    pfeature.setSelected(selected);
                }
                if ((featureIndex = selectedServiceFeatures.indexOf(feature)) != -1 && (feature = selectedServiceFeatures.get(featureIndex)).isEditable()) {
                    pfeature.setFeature(feature);
                }
                if (selected) {
                    sl.addSelectedFeature(pfeature);
                    featuresToSelect.add(feature);
                    continue;
                }
                sl.removeSelectedFeature(pfeature);
                featuresToUnselect.add(feature);
            }
            this.mapRefresher.refresh(featuresToSelect, featuresToUnselect);
        }
    }

    public void addSelectedFeatures(List<? extends Feature> featureList) {
        this.setSelectedFeatures(featureList, false, true);
        this.fireSelectionChangedEvent();
    }

    public void setSelectedFeatures(List<? extends Feature> featureList) {
        this.setSelectedFeatures(featureList, true, true);
        this.fireSelectionChangedEvent();
    }

    public void setSelectedFeaturesForService(AbstractFeatureService service, List<? extends Feature> featureList) {
        AbstractFeatureService s = service;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"setSelectedFeaturesForService invoked");
        }
        if (s == null) {
            s = DUMMY;
        }
        this.selectedFeatures.remove(service);
        this.removeSelectionFromMap(service);
        for (Feature feature : featureList) {
            if (!(feature instanceof DefaultFeatureServiceFeature)) continue;
            DefaultFeatureServiceFeature fsf = (DefaultFeatureServiceFeature)feature;
            Set<Feature> list = this.selectedFeatures.get(s);
            if (list == null) {
                list = Collections.synchronizedSet(new HashSet());
                this.selectedFeatures.put(s, list);
            }
            list.add(fsf);
        }
        this.synchronizeSelectionWithMap(s);
        this.fireSelectionChangedEvent();
    }

    public void removeSelectedFeatures(Feature feature) {
        this.removeSelectedFeatures(Collections.nCopies(1, feature));
    }

    public void removeSelectedFeatures(List<? extends Feature> featureList) {
        HashMap<AbstractFeatureService, Object> selectedFeaturesToRemove = new HashMap<AbstractFeatureService, Object>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"removeSelectedFeatures invoked");
        }
        if (featureList == null) {
            return;
        }
        for (Feature feature : featureList) {
            Object list;
            if (!(feature instanceof DefaultFeatureServiceFeature)) continue;
            DefaultFeatureServiceFeature fsf = (DefaultFeatureServiceFeature)feature;
            AbstractFeatureService service = DUMMY;
            if (fsf.getLayerProperties() != null && fsf.getLayerProperties().getFeatureService() != null) {
                service = fsf.getLayerProperties().getFeatureService();
            }
            if ((list = (TreeSet<DefaultFeatureServiceFeature>)selectedFeaturesToRemove.get(service)) == null) {
                list = new TreeSet<DefaultFeatureServiceFeature>();
                selectedFeaturesToRemove.put(service, list);
            }
            ((TreeSet)list).add(fsf);
        }
        for (AbstractFeatureService abstractFeatureService : selectedFeaturesToRemove.keySet()) {
            TreeSet list = (TreeSet)selectedFeaturesToRemove.get(abstractFeatureService);
            Set<Feature> features = this.selectedFeatures.get(abstractFeatureService);
            if (features != null) {
                for (DefaultFeatureServiceFeature f : list) {
                    if (!features.contains(f)) continue;
                    features.remove(f);
                }
            }
            MappingComponent map = CismapBroker.getInstance().getMappingComponent();
            SelectionListener sl = (SelectionListener)map.getInputEventListener().get("SELECT");
            List<PFeature> sel = sl.getAllSelectedPFeatures();
            ArrayList<Feature> toBeUnselected = new ArrayList<Feature>();
            for (PFeature feature : sel) {
                FeatureServiceFeature fsf;
                if (!(feature.getFeature() instanceof FeatureServiceFeature) || !featureList.contains(fsf = (FeatureServiceFeature)feature.getFeature()) || !feature.isSelected()) continue;
                feature.setSelected(false);
                sl.removeSelectedFeature(feature);
                toBeUnselected.add(feature.getFeature());
            }
            this.selectionChangeInProgress = true;
            ((DefaultFeatureCollection)CismapBroker.getInstance().getMappingComponent().getFeatureCollection()).unselect(toBeUnselected);
            this.selectionChangeInProgress = false;
            this.fireSelectionChangedEvent();
        }
    }

    private boolean setSelectedFeatures(List<? extends Feature> featureList, boolean removeOldSelection, boolean syncMap) {
        boolean added = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"setSelectedFeatures invoked");
        }
        if (removeOldSelection) {
            this.selectedFeatures.clear();
            if (syncMap) {
                this.removeSelectionFromMap();
            }
        }
        for (Feature feature : featureList) {
            FeatureServiceFeature modifiableFeature;
            AttributeTable table;
            Set<Feature> list;
            if (!(feature instanceof FeatureServiceFeature)) continue;
            FeatureServiceFeature fsf = (FeatureServiceFeature)feature;
            AbstractFeatureService service = DUMMY;
            if (fsf.getLayerProperties() != null && fsf.getLayerProperties().getFeatureService() != null) {
                service = fsf.getLayerProperties().getFeatureService();
            }
            if ((list = this.selectedFeatures.get(service)) == null) {
                list = Collections.synchronizedSet(new HashSet());
                this.selectedFeatures.put(service, list);
            }
            if ((table = this.consideredAttributeTables.get(service)) != null && (modifiableFeature = this.consideredAttributeTables.get(service).getFeatureById(fsf.getId())) != null) {
                fsf = modifiableFeature;
            }
            added = list.add(fsf) | added;
        }
        if (syncMap) {
            for (AbstractFeatureService abstractFeatureService : this.selectedFeatures.keySet()) {
                this.synchronizeSelectionWithMap(abstractFeatureService);
            }
        }
        return added;
    }

    private void removeSelectionFromMap() {
        MappingComponent map = CismapBroker.getInstance().getMappingComponent();
        SelectionListener sl = (SelectionListener)map.getInputEventListener().get("SELECT");
        List<PFeature> sel = sl.getAllSelectedPFeatures();
        ArrayList<Feature> toBeUnselected = new ArrayList<Feature>();
        for (PFeature feature : sel) {
            if (!feature.isSelected()) continue;
            feature.setSelected(false);
            sl.removeSelectedFeature(feature);
            toBeUnselected.add(feature.getFeature());
        }
        this.selectionChangeInProgress = true;
        ((DefaultFeatureCollection)CismapBroker.getInstance().getMappingComponent().getFeatureCollection()).unselect(toBeUnselected);
        this.selectionChangeInProgress = false;
    }

    private void removeSelectionFromMap(AbstractFeatureService service) {
        MappingComponent map = CismapBroker.getInstance().getMappingComponent();
        SelectionListener sl = (SelectionListener)map.getInputEventListener().get("SELECT");
        List<PFeature> sel = sl.getAllSelectedPFeatures();
        ArrayList<Feature> toBeUnselected = new ArrayList<Feature>();
        for (PFeature feature : sel) {
            if (!(feature.getFeature() instanceof FeatureServiceFeature)) continue;
            FeatureServiceFeature fsf = (FeatureServiceFeature)feature.getFeature();
            if (fsf.getLayerProperties() != null && fsf.getLayerProperties().getFeatureService() != null && fsf.getLayerProperties().getFeatureService().equals(service) && feature.isSelected()) {
                feature.setSelected(false);
                sl.removeSelectedFeature(feature);
                toBeUnselected.add(feature.getFeature());
                continue;
            }
            if (fsf.getLayerProperties() != null && fsf.getLayerProperties().getFeatureService() != null || !service.equals(DUMMY) || !feature.isSelected()) continue;
            feature.setSelected(false);
            sl.removeSelectedFeature(feature);
            toBeUnselected.add(feature.getFeature());
        }
        this.selectionChangeInProgress = true;
        ((DefaultFeatureCollection)CismapBroker.getInstance().getMappingComponent().getFeatureCollection()).unselect(toBeUnselected);
        this.selectionChangeInProgress = false;
    }

    public void clearSelection() {
        this.selectedFeatures.clear();
        this.removeSelectionFromMap();
        this.fireSelectionChangedEvent();
    }

    public void clearSelection(AbstractFeatureService service) {
        if (service == null) {
            this.selectedFeatures.remove(DUMMY);
        } else {
            this.selectedFeatures.remove(service);
        }
        this.removeSelectionFromMap(service);
        this.fireSelectionChangedEvent();
    }

    public List<Feature> getSelectedFeatures() {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (AbstractFeatureService service : new ArrayList<AbstractFeatureService>(this.selectedFeatures.keySet())) {
            Set<Feature> serviceFeatures = this.selectedFeatures.get(service);
            if (serviceFeatures == null) continue;
            features.addAll(serviceFeatures);
        }
        return features;
    }

    public List<Feature> getSelectedFeatures(AbstractFeatureService service) {
        Set<Feature> set = service == null ? this.selectedFeatures.get(DUMMY) : this.selectedFeatures.get(service);
        if (set != null) {
            return new ArrayList<Feature>(set);
        }
        return new ArrayList<Feature>();
    }

    public static SelectionManager getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public Integer getSelectedFeaturesCount(AbstractFeatureService service) {
        Set<Feature> features = service == null ? this.selectedFeatures.get(DUMMY) : this.selectedFeatures.get(service);
        if (features == null) {
            return 0;
        }
        return features.size();
    }

    public Integer getModifiableFeaturesCount(AbstractFeatureService service) {
        if (service == null) {
            return null;
        }
        if (this.editableServices.contains(service)) {
            List<Feature> features = this.getSelectedFeatures(service);
            int modifiable = 0;
            AttributeTable table = AttributeTableFactory.getInstance().getAttributeTable(service);
            if (table == null) {
                return 0;
            }
            List<FeatureServiceFeature> selectedFeatures = table.getSelectedFeatures();
            for (Feature f : features) {
                FeatureServiceFeature featureFromTable = this.getFeatureFromList(selectedFeatures, f);
                if (featureFromTable != null) {
                    PFeature pf;
                    if (!featureFromTable.isEditable()) continue;
                    ++modifiable;
                    if (featureFromTable == f || (pf = CismapBroker.getInstance().getMappingComponent().getPFeatureHM().get(featureFromTable)) == null || pf.isSelected()) continue;
                    pf.setSelected(true);
                    continue;
                }
                if (!f.isEditable()) continue;
                ++modifiable;
            }
            return modifiable;
        }
        return null;
    }

    private FeatureServiceFeature getFeatureFromList(List<FeatureServiceFeature> features, Feature f) {
        if (f instanceof FeatureServiceFeature) {
            for (int i = 0; i < features.size(); ++i) {
                FeatureServiceFeature featureFromList = features.get(i);
                if (!featureFromList.equals(f)) continue;
                return featureFromList;
            }
        }
        return null;
    }

    public void switchProcessingMode(AbstractFeatureService service) {
        if (this.editableServices.contains(service)) {
            this.editableServices.remove(service);
        } else {
            this.editableServices.add(service);
        }
        this.fireSelectionChangedEvent();
    }

    public List<AbstractFeatureService> getEditableServices() {
        return this.editableServices;
    }

    public void addConsideredAttributeTable(AttributeTable table) {
        this.consideredAttributeTables.put(table.getFeatureService(), table);
        table.addListSelectionListener(this);
    }

    public AttributeTable getAttributeTableForService(AbstractFeatureService service) {
        return this.consideredAttributeTables.get(service);
    }

    public void removeConsideredAttributeTable(AttributeTable table) {
        this.consideredAttributeTables.remove(table.getFeatureService());
        table.removeListSelectionListener(this);
    }

    @Override
    public void featuresAdded(FeatureCollectionEvent fce) {
    }

    @Override
    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
    }

    @Override
    public void featuresRemoved(FeatureCollectionEvent fce) {
    }

    @Override
    public void featuresChanged(FeatureCollectionEvent fce) {
    }

    @Override
    public void featureSelectionChanged(FeatureCollectionEvent fce) {
        if (this.selectionChangeInProgress) {
            return;
        }
        MappingComponent map = CismapBroker.getInstance().getMappingComponent();
        SelectionListener sl = (SelectionListener)map.getInputEventListener().get("SELECT");
        boolean featuresAdded = sl.isFeatureAdded();
        if (fce != null && fce.getFeatureCollection() != null && fce.getFeatureCollection().getSelectedFeatures() != null) {
            ArrayList selectedMapFeatures = new ArrayList(fce.getFeatureCollection().getSelectedFeatures());
            this.setSelectedFeatures(selectedMapFeatures, !featuresAdded, false);
            if (sl.getLastUnselectedFeatures() != null) {
                HashSet<Feature> deselectedFeatures = new HashSet<Feature>();
                deselectedFeatures.addAll(sl.getLastUnselectedFeatures());
                deselectedFeatures.removeAll(selectedMapFeatures);
                ArrayList featuresToDeselect = new ArrayList(deselectedFeatures);
                if (!featuresToDeselect.isEmpty()) {
                    this.removeSelectedFeatures(featuresToDeselect);
                }
            }
        }
        this.fireSelectionChangedEvent();
    }

    @Override
    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
    }

    @Override
    public void featureCollectionChanged() {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    public void addSelectionChangedListener(SelectionChangedListener l) {
        this.listener.add(l);
    }

    public void removeSelectionChangedListener(SelectionChangedListener l) {
        this.listener.remove(l);
    }

    public void fireSelectionChangedEvent() {
        SelectionChangedEvent e = new SelectionChangedEvent(this);
        for (SelectionChangedListener l : this.listener) {
            l.selectionChanged(e);
        }
    }

    private class MapSelectionRefresher {
        private final Set<Feature> featuresToSelectInt = new HashSet<Feature>();
        private final Set<Feature> featuresToUnselectInt = new HashSet<Feature>();
        private Timer refreshTimer = new Timer();

        private MapSelectionRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh(List<Feature> featuresToSelect, List<Feature> featuresToUnselect) {
            Set<Feature> set = this.featuresToSelectInt;
            synchronized (set) {
                this.featuresToSelectInt.removeAll(featuresToUnselect);
                this.featuresToUnselectInt.removeAll(featuresToSelect);
                this.featuresToSelectInt.addAll(featuresToSelect);
                this.featuresToUnselectInt.addAll(featuresToUnselect);
                this.refreshTimer.cancel();
                this.refreshTimer = new Timer();
                this.refreshTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        EventQueue.invokeLater(new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Set set = MapSelectionRefresher.this.featuresToSelectInt;
                                synchronized (set) {
                                    if (!MapSelectionRefresher.this.featuresToSelectInt.isEmpty() || !MapSelectionRefresher.this.featuresToUnselectInt.isEmpty()) {
                                        SelectionManager.this.selectionChangeInProgress = true;
                                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addToSelection(MapSelectionRefresher.this.featuresToSelectInt);
                                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().unselect(MapSelectionRefresher.this.featuresToUnselectInt);
                                        MapSelectionRefresher.this.featuresToSelectInt.clear();
                                        MapSelectionRefresher.this.featuresToUnselectInt.clear();
                                        PNotificationCenter pn = PNotificationCenter.defaultCenter();
                                        pn.postNotification("SELECTION_CHANGED_NOTIFICATION", (Object)this);
                                        CismapBroker.getInstance().getMappingComponent().showHandles(false);
                                        SelectionManager.this.selectionChangeInProgress = false;
                                    }
                                }
                            }
                        });
                    }
                }, 100L);
            }
        }
    }

    private static class DummyFeatureService
    extends AbstractFeatureService {
        private DummyFeatureService() {
        }

        @Override
        protected FeatureFactory createFeatureFactory() throws Exception {
            return new AbstractFeatureFactory(){

                @Override
                protected boolean isGenerateIds() {
                    return false;
                }

                @Override
                public AbstractFeatureFactory clone() {
                    return this;
                }

                @Override
                public List createFeatures(Object query, BoundingBox boundingBox, SwingWorker workerThread) throws FeatureFactory.TooManyFeaturesException, Exception {
                    return null;
                }

                @Override
                public List createFeatures(Object query, BoundingBox boundingBox, SwingWorker workerThread, int offset, int limit, FeatureServiceAttribute[] orderBy) throws FeatureFactory.TooManyFeaturesException, Exception {
                    return null;
                }

                @Override
                public List createAttributes(SwingWorker workerThread) throws FeatureFactory.TooManyFeaturesException, UnsupportedOperationException, Exception {
                    return new ArrayList();
                }

                @Override
                public int getFeatureCount(Object query, BoundingBox bb) {
                    return 0;
                }
            };
        }

        public Object getQuery() {
            return null;
        }

        public void setQuery(Object query) {
        }

        @Override
        protected void initConcreteInstance() throws Exception {
        }

        @Override
        protected String getFeatureLayerType() {
            return UNKNOWN;
        }

        @Override
        public Icon getLayerIcon(int type) {
            return null;
        }

        @Override
        public Object clone() {
            return null;
        }

        @Override
        protected LayerProperties createLayerProperties() {
            return null;
        }
    }

    private static final class LazyInitialiser {
        static final SelectionManager INSTANCE = new SelectionManager();

        private LazyInitialiser() {
        }
    }
}

