/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfs;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.wfs.FeatureTypeDescription;
import de.cismet.cismap.commons.wfs.ResponseParserFactory;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilities;
import de.cismet.commons.security.AccessHandler;
import de.cismet.security.WebAccessManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class WFSFacade {
    private static final Logger logger = Logger.getLogger(WFSFacade.class);
    private static final Namespace WFS = Namespace.getNamespace((String)"wfs", (String)"http://www.opengis.net/wfs");
    private static final Namespace OGC = Namespace.getNamespace((String)"ogc", (String)"http://www.opengis.net/ogc");
    private static final Namespace GML = Namespace.getNamespace((String)"gml", (String)"http://www.opengis.net/gml");
    private static final Namespace OWS = Namespace.getNamespace((String)"ows", (String)"http://www.opengis.net/ows");
    private static final Namespace xsd = Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    private static final String GET_FEATURE_100 = "getFeatureQuery100";
    private static final String GET_FEATURE_110 = "getFeatureQuery110";
    private static final String CISMET_DESCRIBE_FEATURE_TYPE = "CismapDescribeFeatureType";
    private static final String DESCRIBE_FEATURE_TYPE = "DescribeFeatureType";
    private static final String GET_FEATURE = "GetFeature";
    private static final String QUERY = "Query";
    private static final String FILTER = "Filter";
    private static final String BBOX = "BBOX";
    private static final String TYPENAME = "TypeName";
    private static final String PROPERTY_NAME = "PropertyName";
    private static final String TYPE_NAME_ATTR = "typeName";
    private static final String VERSION_ATTR = "version";
    private static final String MAX_FEATURES_ATTR = "maxFeatures";
    private static final URL XML_FILE = WFSFacade.class.getResource("wfs.xml");
    public static final String CISMAP_BOUNDING_BOX_AS_GML_PLACEHOLDER = "<cismapBoundingBoxAsGmlPlaceholder />";
    public static final String CISMAP_RESULT_TYPE_PLACEHOLDER = "cismapResultTypePlaceholder";
    public static final String SRS_NAME_PLACEHOLDER = "SRSNAME_PLACEHOLDER";
    private WFSCapabilities cap;
    private ResponseParserFactory parserFactory;
    private Element rootNode;

    public WFSFacade(WFSCapabilities cap, ResponseParserFactory parserFactory) {
        this.cap = cap;
        this.parserFactory = parserFactory;
        try {
            SAXBuilder builder = new SAXBuilder();
            this.rootNode = builder.build(XML_FILE).getRootElement();
        }
        catch (Exception ex) {
            logger.error((Object)"Error during parsing of the CismapXML-Files", (Throwable)ex);
        }
    }

    public FeatureTypeDescription describeFeatureType(FeatureType feature) throws IOException, Exception {
        String version = this.cap.getVersion();
        XMLOutputter out = new XMLOutputter();
        QName featureName = feature.getName();
        Element requestElement = (Element)this.rootNode.getChild(CISMET_DESCRIBE_FEATURE_TYPE).getChild(DESCRIBE_FEATURE_TYPE, WFS).clone();
        if (!version.equals("1.0.0") && !version.equals("1.1.0")) {
            logger.error((Object)("unknown service version used: " + version + " service" + this.cap.getURL() + ". Try to use a 1.1.0 request with version string" + version));
        }
        requestElement.getAttribute(VERSION_ATTR).setValue(version);
        if (featureName.getPrefix() != null && !featureName.getPrefix().equals("") && featureName.getNamespaceURI() != null && !featureName.getNamespaceURI().equals("")) {
            Namespace ns = Namespace.getNamespace((String)featureName.getPrefix(), (String)featureName.getNamespaceURI());
            requestElement.addNamespaceDeclaration(ns);
        }
        requestElement.getChild(TYPENAME, WFS).setText(feature.getPrefixedNameString());
        String request = "SERVICE=WFS&REQUEST=DescribeFeatureType&VERSION=" + version + "&TYPENAME=" + feature.getPrefixedNameString();
        String response = this.getRequest(this.cap.getURL(), request);
        try {
            return this.parserFactory.getFeatureTypeDescription(response, feature);
        }
        catch (Exception e) {
            logger.error((Object)"Error while parsing the response of a describeFeature request.", (Throwable)e);
            return null;
        }
    }

    public Element getGetFeatureQuery(FeatureType feature) {
        Element request;
        String version = this.cap.getVersion();
        if (version.equals("1.0.0")) {
            request = this.getFeature100Request(feature);
        } else if (version.equals("1.1.0")) {
            request = this.getFeature110Request(feature);
        } else {
            logger.error((Object)("unknown service version used: " + version + " service" + this.cap.getURL() + ". Try to use a version 1.1.0 request"));
            request = this.getFeature110Request(feature);
        }
        return request;
    }

    public String setGetFeatureBoundingBox(String query, XBoundingBox bbox, FeatureType feature, String mapCrs, boolean reverseAxisOrder) {
        return this.setGetFeatureBoundingBox(query, bbox, feature, mapCrs, reverseAxisOrder, false);
    }

    public String setGetFeatureBoundingBox(String query, XBoundingBox bbox, FeatureType feature, String mapCrs, boolean reverseAxisOrder, boolean onlyFeatureCount) {
        String envelope;
        String resultType;
        String crs = WFSFacade.getOptimalCrsForFeature(feature, mapCrs);
        Geometry geom = CrsTransformer.transformToGivenCrs(bbox.getGeometry(), crs);
        XBoundingBox tbbox = new XBoundingBox(geom);
        String string = resultType = onlyFeatureCount ? "hits" : "results";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("optimal crs: " + crs));
        }
        if (this.cap.getVersion() != null && this.cap.getVersion().equals("1.0.0")) {
            envelope = "<gml:Box srsName=\"" + bbox.getSrs() + "\"><gml:coord><gml:X>" + tbbox.getX1() + "</gml:X><gml:Y>" + tbbox.getY1() + "</gml:Y></gml:coord><gml:coord><gml:X>" + tbbox.getX2() + "</gml:X><gml:Y>" + tbbox.getY2() + "</gml:Y></gml:coord></gml:Box>";
        } else if (this.cap.getVersion() != null && this.cap.getVersion().equals("1.1.0")) {
            envelope = reverseAxisOrder ? "<gml:Envelope srsName=\"" + bbox.getSrs() + "\"><gml:lowerCorner>" + tbbox.getY1() + " " + tbbox.getX1() + "</gml:lowerCorner><gml:upperCorner>" + tbbox.getY2() + " " + tbbox.getX2() + "</gml:upperCorner></gml:Envelope>" : "<gml:Envelope srsName=\"" + bbox.getSrs() + "\"><gml:lowerCorner>" + tbbox.getX1() + " " + tbbox.getY1() + "</gml:lowerCorner><gml:upperCorner>" + tbbox.getX2() + " " + tbbox.getY2() + "</gml:upperCorner></gml:Envelope>";
        } else {
            logger.error((Object)("unknown service version used: " + this.cap.getVersion() + ". Try to use a version 1.1.0 request"));
            envelope = reverseAxisOrder ? "<gml:Envelope srsName=\"" + bbox.getSrs() + "\"><gml:lowerCorner>" + tbbox.getY1() + " " + tbbox.getX1() + "</gml:lowerCorner><gml:upperCorner>" + tbbox.getY2() + " " + tbbox.getX2() + "</gml:upperCorner></gml:Envelope>" : "<gml:Envelope srsName=\"" + bbox.getSrs() + "\"><gml:lowerCorner>" + tbbox.getX1() + " " + tbbox.getY1() + "</gml:lowerCorner><gml:upperCorner>" + tbbox.getX2() + " " + tbbox.getY2() + "</gml:upperCorner></gml:Envelope>";
        }
        String request = query.toString().replaceAll(CISMAP_BOUNDING_BOX_AS_GML_PLACEHOLDER, envelope);
        request = request.replaceAll(SRS_NAME_PLACEHOLDER, crs);
        request = request.replaceAll(CISMAP_RESULT_TYPE_PLACEHOLDER, resultType);
        return request;
    }

    public static String getOptimalCrsForFeature(FeatureType feature, String mapSrs) {
        String desiredSrs = mapSrs;
        if (desiredSrs == null) {
            desiredSrs = CismapBroker.getInstance().getSrs().getCode();
        }
        for (String tmpSrs : feature.getSupportedSRS()) {
            if (!tmpSrs.equals(desiredSrs)) continue;
            return tmpSrs;
        }
        if (feature.getDefaultSRS() != null) {
            return feature.getDefaultSRS();
        }
        return mapSrs;
    }

    public static FeatureType extractRequestedFeatureType(String request, WFSCapabilities cap) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Element root = builder.build((Reader)new StringReader(request)).getRootElement();
            Attribute att = root.getChild(QUERY, WFS).getAttribute(TYPE_NAME_ATTR);
            if (att != null) {
                return WFSFacade.extractFeatureTypeFromCap(att.getValue(), cap);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error during parsing of the wfs request. The feature type cannot be recognized.", (Throwable)ex);
        }
        logger.error((Object)"The feature type cannot be extracted from the wfs request. So the supported crs cannot be determined exactly.");
        return null;
    }

    public static FeatureType extractFeatureTypeFromCap(String featureName, WFSCapabilities cap) {
        try {
            if (featureName != null) {
                Iterator<FeatureType> featureIterator = cap.getFeatureTypeList().iterator();
                String localFeatureName = featureName.substring(featureName.indexOf(":") + 1);
                while (featureIterator.hasNext()) {
                    FeatureType feature = featureIterator.next();
                    if (!feature.getName().getLocalPart().equals(localFeatureName)) continue;
                    return feature;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error while discovering the feature list.", (Throwable)ex);
        }
        logger.error((Object)("The feature type with the name " + featureName + " cannot be found."));
        return null;
    }

    public static void setMaxFeatureCount(Element wfsQuery, int maxFeatureCount, String version) {
        if (version == null) {
            logger.error((Object)"version string is null. Try to use version 1.1.0", (Throwable)new Exception());
            version = "1.1.0";
        }
        if (!version.equals("1.0.0") && !version.equals("1.1.0")) {
            logger.error((Object)("unknown wfs version: " + version + ". Try to handle this version like version 1.1.0"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setting may maxFeatureCount of WFS Query to " + maxFeatureCount));
        }
        if (wfsQuery != null) {
            wfsQuery.setAttribute(MAX_FEATURES_ATTR, String.valueOf(maxFeatureCount));
        } else {
            logger.warn((Object)"could not set maxFeatureCount, query not yet initialised");
        }
    }

    public static void changePropertyNames(Element query, Collection<String> properties, String version) {
        if (version == null) {
            logger.error((Object)"version string is null. Try to use version 1.1.0", (Throwable)new Exception());
            version = "1.1.0";
        }
        if (!version.equals("1.0.0") && !version.equals("1.1.0")) {
            logger.error((Object)("unknown wfs version: " + version + ". Try to handle this version like version 1.1.0"));
        }
        query.getChild(QUERY, WFS).removeChildren(PROPERTY_NAME, WFS);
        ArrayList<Element> propertyElements = new ArrayList<Element>();
        for (String s : properties) {
            Element tmp = new Element(PROPERTY_NAME, WFS);
            tmp.setText(s);
            propertyElements.add(tmp);
        }
        if (!propertyElements.isEmpty()) {
            query.getChild(QUERY, WFS).addContent(0, propertyElements);
        }
    }

    public static void setGeometry(Element query, String geoName, String version) {
        if (version == null) {
            logger.error((Object)"version string is null. Try to use version 1.1.0", (Throwable)new Exception());
            version = "1.1.0";
        }
        if (!version.equals("1.0.0") && !version.equals("1.1.0")) {
            logger.error((Object)("unknown wfs version: " + version + ". Try to handle this version like version 1.1.0"));
        }
        query.getChild(QUERY, WFS).getChild(FILTER, OGC).getChild(BBOX, OGC).getChild(PROPERTY_NAME, OGC).setText(geoName);
    }

    private Element getFeature100Request(FeatureType feature) {
        Element requestElement = (Element)this.rootNode.getChild(GET_FEATURE_100).getChild(GET_FEATURE, WFS).clone();
        QName featureName = feature.getName();
        if (feature.getNameOfGeometryAtrtibute() == null) {
            return null;
        }
        Element query = requestElement.getChild(QUERY, WFS);
        query.getAttribute(TYPE_NAME_ATTR).setValue(feature.getPrefixedNameString());
        if (featureName.getNamespaceURI() != null && featureName.getPrefix() != null) {
            Namespace ns = Namespace.getNamespace((String)featureName.getPrefix(), (String)featureName.getNamespaceURI());
            requestElement.addNamespaceDeclaration(ns);
        }
        Element propertyElement = query.getChild(FILTER, OGC).getChild(BBOX, OGC).getChild(PROPERTY_NAME, OGC);
        propertyElement.setText(feature.getNameOfGeometryAtrtibute());
        ArrayList<Element> propertyElements = new ArrayList<Element>();
        for (FeatureServiceAttribute attribute : feature.getFeatureAttributes()) {
            Element tmp = new Element(PROPERTY_NAME, WFS);
            tmp.setText(attribute.getName());
            propertyElements.add(tmp);
        }
        if (!propertyElements.isEmpty()) {
            query.addContent(0, propertyElements);
        }
        return requestElement;
    }

    private Element getFeature110Request(FeatureType feature) {
        Element requestElement = (Element)this.rootNode.getChild(GET_FEATURE_110).getChild(GET_FEATURE, WFS).clone();
        QName featureName = feature.getName();
        if (feature.getNameOfGeometryAtrtibute() == null) {
            return null;
        }
        Element query = requestElement.getChild(QUERY, WFS);
        query.getAttribute(TYPE_NAME_ATTR).setValue(feature.getPrefixedNameString());
        if (featureName.getNamespaceURI() != null && featureName.getPrefix() != null) {
            Namespace ns = Namespace.getNamespace((String)featureName.getPrefix(), (String)featureName.getNamespaceURI());
            requestElement.addNamespaceDeclaration(ns);
        }
        Element propertyElement = query.getChild(FILTER, OGC).getChild(BBOX, OGC).getChild(PROPERTY_NAME, OGC);
        propertyElement.setText(feature.getNameOfGeometryAtrtibute());
        ArrayList<Element> propertyElements = new ArrayList<Element>();
        for (FeatureServiceAttribute attribute : feature.getFeatureAttributes()) {
            Element tmp = new Element(PROPERTY_NAME, WFS);
            tmp.setText(attribute.getName());
            propertyElements.add(tmp);
        }
        if (!propertyElements.isEmpty()) {
            query.addContent(0, propertyElements);
        }
        return requestElement;
    }

    private String postRequest(URL serverURL, String request) throws IOException, Exception {
        logger.info((Object)("post request (" + serverURL + ")"));
        InputStream resp = WebAccessManager.getInstance().doRequest(serverURL, request, AccessHandler.ACCESS_METHODS.POST_REQUEST);
        char[] buffer = new char[256];
        StringBuilder response = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(resp));
        int count = br.read(buffer, 0, buffer.length);
        while (count != -1) {
            response.append(buffer, 0, count);
            count = br.read(buffer, 0, buffer.length);
        }
        br.close();
        return response.toString();
    }

    private String getRequest(URL serverURL, String request) throws IOException, Exception {
        logger.info((Object)("post request (" + serverURL + ")"));
        InputStream resp = WebAccessManager.getInstance().doRequest(serverURL, request, AccessHandler.ACCESS_METHODS.GET_REQUEST);
        char[] buffer = new char[256];
        StringBuilder response = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(resp));
        int count = br.read(buffer, 0, buffer.length);
        while (count != -1) {
            response.append(buffer, 0, count);
            count = br.read(buffer, 0, buffer.length);
        }
        br.close();
        return response.toString();
    }
}

