/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfs.capabilities.deegree;

import de.cismet.commons.capabilities.Service;
import java.util.ArrayList;
import org.deegree.model.metadata.iso19115.Keywords;
import org.deegree.ogcwebservices.getcapabilities.ServiceIdentification;
import org.deegree.ogcwebservices.getcapabilities.ServiceProvider;

public class DeegreeService
implements Service {
    private ServiceProvider service;
    private ServiceIdentification ident;

    public DeegreeService(ServiceProvider service, ServiceIdentification ident) {
        this.service = service;
        this.ident = ident;
    }

    public String[] getKeywordList() {
        Keywords[] list = this.ident.getKeywords();
        ArrayList<String> resultList = new ArrayList<String>();
        for (Keywords word : list) {
            for (String tmp : word.getKeywords()) {
                resultList.add(tmp);
            }
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    public String getAbstract() {
        return this.ident.getAbstract();
    }

    public String getTitle() {
        return this.ident.getTitle();
    }

    public String getName() {
        return this.ident.getName();
    }

    public String getContactPerson() {
        return this.service.getIndividualName();
    }

    public String getContactOrganization() {
        return this.service.getProviderName();
    }

    public String getFees() {
        return this.ident.getFees();
    }

    public String getAccessConstraints() {
        return this.stringArrayToString(this.ident.getAccessConstraints());
    }

    private String stringArrayToString(String[] array) {
        StringBuffer buffer = new StringBuffer("");
        for (String tmp : array) {
            if (buffer.length() != 0) {
                buffer.append(", " + tmp);
                continue;
            }
            buffer.append(tmp);
        }
        return buffer.toString();
    }
}

