/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfs.capabilities.deegree;

import de.cismet.cismap.commons.exceptions.ParserException;
import de.cismet.cismap.commons.wfs.FeatureTypeDescription;
import de.cismet.cismap.commons.wfs.ResponseParserFactory;
import de.cismet.cismap.commons.wfs.WFSFacade;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import de.cismet.cismap.commons.wfs.capabilities.FeatureTypeList;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilities;
import de.cismet.cismap.commons.wfs.capabilities.deegree.DeegreeFeatureType;
import de.cismet.cismap.commons.wfs.capabilities.deegree.DeegreeService;
import de.cismet.cismap.commons.wfs.deegree.DeegreeFeatureTypeDescription;
import de.cismet.commons.capabilities.Service;
import de.cismet.tools.CalculationCache;
import de.cismet.tools.Calculator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.deegree.ogcwebservices.getcapabilities.InvalidCapabilitiesException;
import org.deegree.ogcwebservices.wfs.capabilities.WFSCapabilitiesDocument;
import org.deegree.ogcwebservices.wfs.capabilities.WFSFeatureType;
import org.xml.sax.SAXException;

public class DeegreeWFSCapabilities
implements WFSCapabilities {
    private static final Logger LOG = Logger.getLogger(DeegreeWFSCapabilities.class);
    private final org.deegree.ogcwebservices.wfs.capabilities.WFSCapabilities cap;
    private final CalculationCache<String, FeatureTypeList> cache = new CalculationCache((Calculator)new FeatureTypeListRetriever());
    private final URL url;
    private Service service;
    private WFSFacade facade;
    private final String originalLink;

    public DeegreeWFSCapabilities(InputStream in, String link) throws InvalidCapabilitiesException, IOException, SAXException {
        this.originalLink = link;
        String urlString = link;
        WFSCapabilitiesDocument parser = new WFSCapabilitiesDocument();
        if (urlString.indexOf("?") != -1) {
            urlString = urlString.substring(0, urlString.indexOf("?"));
        }
        this.url = new URL(urlString);
        parser.load(in, link);
        this.cap = (org.deegree.ogcwebservices.wfs.capabilities.WFSCapabilities)parser.parseCapabilities();
    }

    @Override
    public String getOriginalLink() {
        return this.originalLink;
    }

    @Override
    public FeatureTypeList getFeatureTypeList() throws IOException, Exception {
        return (FeatureTypeList)this.cache.calcValue((Object)this.originalLink);
    }

    @Override
    public Service getService() {
        if (this.service == null) {
            this.service = new DeegreeService(this.cap.getServiceProvider(), this.cap.getServiceIdentification());
        }
        return this.service;
    }

    @Override
    public String getVersion() {
        return this.cap.getVersion();
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public WFSFacade getServiceFacade() {
        if (this.facade == null) {
            this.facade = new WFSFacade(this, new DeegreeResponseParserFactory());
        }
        return this.facade;
    }

    private class DeegreeResponseParserFactory
    implements ResponseParserFactory {
        private DeegreeResponseParserFactory() {
        }

        @Override
        public FeatureTypeDescription getFeatureTypeDescription(String featureTypeDescription, FeatureType feature) throws ParserException {
            return new DeegreeFeatureTypeDescription(featureTypeDescription, feature);
        }
    }

    private class FeatureTypeListRetriever
    implements Calculator<String, FeatureTypeList> {
        private FeatureTypeListRetriever() {
        }

        public FeatureTypeList calculate(String input) throws Exception {
            FeatureTypeList list = new FeatureTypeList();
            org.deegree.ogcwebservices.wfs.capabilities.FeatureTypeList tmpList = DeegreeWFSCapabilities.this.cap.getFeatureTypeList();
            for (WFSFeatureType type : tmpList.getFeatureTypes()) {
                if (type == null) {
                    LOG.error((Object)("TEST feature type == null " + type));
                }
                DeegreeFeatureType tmpType = new DeegreeFeatureType(type, DeegreeWFSCapabilities.this, input);
                list.put(tmpType.getName(), tmpType);
            }
            return list;
        }
    }
}

