/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfsforms;

import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.wfsforms.AbstractWFSForm;
import de.cismet.cismap.commons.wfsforms.WFSFormAdressListener;
import de.cismet.cismap.commons.wfsforms.WFSFormFeature;
import de.cismet.cismap.commons.wfsforms.WFSFormQuery;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class WFSFormAdress
extends AbstractWFSForm {
    private final Logger log = Logger.getLogger(this.getClass());
    private WFSFormFeature strasse = null;
    private WFSFormFeature nr = null;
    private final ArrayList<WFSFormAdressListener> listeners = new ArrayList();
    protected JComboBox cboNr;
    protected JComboBox cboStreets;
    protected JCheckBox chkLockScale;
    protected JCheckBox chkVisualize;
    protected JButton cmdOk;
    protected JLabel jLabel1;
    protected JLabel jLabel2;
    protected JPanel panEmpty;
    protected JProgressBar prbNr;
    protected JProgressBar prbStreets;

    public WFSFormAdress() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"new WFSFormAddress");
        }
        try {
            this.initComponents();
            StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cboStreets);
            StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cboNr);
            this.prbStreets.setPreferredSize(new Dimension(1, 5));
            this.prbNr.setPreferredSize(new Dimension(1, 5));
            this.listComponents.put("cboAllStreets", this.cboStreets);
            this.listComponents.put("cboAllStreetsProgress", this.prbStreets);
            this.listComponents.put("cboNumbersOfAStreet", this.cboNr);
            this.listComponents.put("cboNumbersOfAStreetProgress", this.prbNr);
            this.pMark.setVisible(false);
            JTextField nrEditor = (JTextField)this.cboNr.getEditor().getEditorComponent();
            nrEditor.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    WFSFormAdress.this.checkCboCorrectness(WFSFormAdress.this.cboNr);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    WFSFormAdress.this.checkCboCorrectness(WFSFormAdress.this.cboNr);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    WFSFormAdress.this.checkCboCorrectness(WFSFormAdress.this.cboNr);
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)"Could not Create WFForm", (Throwable)e);
        }
    }

    private void initComponents() {
        this.cmdOk = new JButton();
        this.chkVisualize = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.chkLockScale = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.panEmpty = new JPanel();
        this.cboNr = new JComboBox();
        this.prbNr = new JProgressBar();
        this.cboStreets = new JComboBox();
        this.prbStreets = new JProgressBar();
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setMaximumSize(new Dimension(498, 35));
        this.setMinimumSize(new Dimension(498, 35));
        this.setLayout(new GridBagLayout());
        this.cmdOk.setMnemonic('P');
        this.cmdOk.setText(NbBundle.getMessage(WFSFormAdress.class, (String)"WFSFormAdress.cmdOk.text"));
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormAdress.this.cmdOkActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.cmdOk, gridBagConstraints);
        this.chkVisualize.setSelected(true);
        this.chkVisualize.setToolTipText(NbBundle.getMessage(WFSFormAdress.class, (String)"WFSFormAdress.chkVisualize.toolTipText"));
        this.chkVisualize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormAdress.this.chkVisualizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 7, 0, 0);
        this.add((Component)this.chkVisualize, gridBagConstraints);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/markPoint.png")));
        this.jLabel1.setToolTipText(NbBundle.getMessage(WFSFormAdress.class, (String)"WFSFormAdress.jLabel1.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 7, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.chkLockScale.setSelected(true);
        this.chkLockScale.setToolTipText(NbBundle.getMessage(WFSFormAdress.class, (String)"WFSFormAdress.chkLockScale.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 14, 0, 0);
        this.add((Component)this.chkLockScale, gridBagConstraints);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/fixMapScale.png")));
        this.jLabel2.setToolTipText(NbBundle.getMessage(WFSFormAdress.class, (String)"WFSFormAdress.jLabel2.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 7, 4, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.panEmpty.setMinimumSize(new Dimension(1, 1));
        this.panEmpty.setPreferredSize(new Dimension(1, 1));
        GroupLayout panEmptyLayout = new GroupLayout((Container)this.panEmpty);
        this.panEmpty.setLayout((LayoutManager)panEmptyLayout);
        panEmptyLayout.setHorizontalGroup((GroupLayout.Group)panEmptyLayout.createParallelGroup(1).add(0, 8, Short.MAX_VALUE));
        panEmptyLayout.setVerticalGroup((GroupLayout.Group)panEmptyLayout.createParallelGroup(1).add(0, 33, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panEmpty, gridBagConstraints);
        this.cboNr.setEditable(true);
        this.cboNr.setEnabled(false);
        this.cboNr.setMaximumSize(new Dimension(70, 19));
        this.cboNr.setMinimumSize(new Dimension(70, 19));
        this.cboNr.setPreferredSize(new Dimension(70, 19));
        this.cboNr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormAdress.this.cboNrActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 30.0;
        gridBagConstraints.insets = new Insets(2, 3, 0, 0);
        this.add((Component)this.cboNr, gridBagConstraints);
        this.prbNr.setBorderPainted(false);
        this.prbNr.setMaximumSize(new Dimension(100, 5));
        this.prbNr.setMinimumSize(new Dimension(100, 5));
        this.prbNr.setPreferredSize(new Dimension(100, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 10);
        this.add((Component)this.prbNr, gridBagConstraints);
        this.cboStreets.setEnabled(false);
        this.cboStreets.setMaximumSize(new Dimension(200, 19));
        this.cboStreets.setMinimumSize(new Dimension(200, 19));
        this.cboStreets.setPreferredSize(new Dimension(200, 19));
        this.cboStreets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormAdress.this.cboStreetsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 60.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.cboStreets, gridBagConstraints);
        this.prbStreets.setBorderPainted(false);
        this.prbStreets.setMaximumSize(new Dimension(100, 5));
        this.prbStreets.setMinimumSize(new Dimension(100, 5));
        this.prbStreets.setPreferredSize(new Dimension(100, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 9);
        this.add((Component)this.prbStreets, gridBagConstraints);
    }

    private void chkVisualizeActionPerformed(ActionEvent evt) {
        if (this.mappingComponent == null) {
            this.mappingComponent = CismapBroker.getInstance().getMappingComponent();
        }
        if (this.nr != null) {
            this.visualizePosition(this.nr, this.chkVisualize.isSelected());
        } else if (this.strasse != null) {
            this.visualizePosition(this.strasse, this.chkVisualize.isSelected());
        }
    }

    private void cboStreetsActionPerformed(ActionEvent evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"cboStreetsActionPerformed()");
        }
        if (this.cboStreets.getSelectedItem() instanceof WFSFormFeature) {
            this.strasse = (WFSFormFeature)this.cboStreets.getSelectedItem();
            this.nr = null;
            this.requestRefresh("cboNumbersOfAStreet", (WFSFormFeature)this.cboStreets.getSelectedItem());
            this.fireWfsFormAddressStreetSelected();
        }
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        boolean history = true;
        MappingComponent mc = this.getMappingComponent();
        if (mc == null) {
            mc = CismapBroker.getInstance().getMappingComponent();
        }
        boolean scaling = !mc.isFixedMapScale() && !this.chkLockScale.isSelected();
        XBoundingBox bb = null;
        int animation = mc.getAnimationDuration();
        if (this.nr != null) {
            bb = scaling ? new XBoundingBox(this.nr.getJTSGeometry()) : new XBoundingBox(this.nr.getPosition().buffer(200.0));
        } else if (this.strasse != null) {
            bb = scaling ? new XBoundingBox(this.strasse.getJTSGeometry()) : new XBoundingBox(this.strasse.getPosition().buffer(200.0));
        } else {
            return;
        }
        mc.gotoBoundingBox(bb, true, scaling, animation);
        this.chkVisualizeActionPerformed(null);
        this.fireWfsFormAddressPositioned(bb);
    }

    @Override
    public void garbageDuringAutoCompletion(JComboBox box) {
        this.nr = null;
    }

    private void cboNrActionPerformed(ActionEvent evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"cboNrActionPerformed()");
        }
        if (this.cboNr.getSelectedItem() instanceof WFSFormFeature) {
            this.nr = (WFSFormFeature)this.cboNr.getSelectedItem();
            this.fireWfsFormAddressNrSelected();
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WFSFormQuery allStreets = new WFSFormQuery();
        allStreets.setComponentName("cboAllStreets");
        allStreets.setServerUrl("http://s103bdc-a1/deegreewfs/wfs");
        allStreets.setDisplayTextProperty("geographicIdentifier");
        allStreets.setExtentProperty("geographicExtent");
        allStreets.setFilename("/request_all_streets.xml");
        allStreets.setId("all_streets");
        allStreets.setIdProperty("identifier");
        allStreets.setTitle("Strassen");
        allStreets.setType("INITIAL");
        allStreets.setWfsQueryString(WFSFormAdress.readFileAsString(new File("C:\\request_alle_strassen_extent.xml")));
        WFSFormQuery numbers = new WFSFormQuery();
        numbers.setComponentName("cboNumbersOfAStreet");
        numbers.setServerUrl("http://s103bdc-a1/deegreewfs/wfs");
        numbers.setDisplayTextProperty("geographicIdentifier");
        numbers.setExtentProperty("geographicExtent");
        numbers.setFilename("/request_all_numbers.xml");
        numbers.setId("numbers");
        numbers.setIdProperty("identifier");
        numbers.setTitle("Nr");
        numbers.setType("FOLLOWUP");
        numbers.setQueryPlaceholder("@@strasse_id@@");
        numbers.setWfsQueryString(WFSFormAdress.readFileAsString(new File("C:\\request_hausnummern_from_strasse_extent.xml")));
        Vector<WFSFormQuery> v = new Vector<WFSFormQuery>();
        v.add(allStreets);
        v.add(numbers);
        final WFSFormAdress tester = new WFSFormAdress();
        tester.setQueries(v);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame();
                f.setDefaultCloseOperation(3);
                f.getContentPane().setLayout(new BorderLayout());
                f.getContentPane().add((Component)tester, "Center");
                f.setVisible(true);
                f.setSize(365, 65);
            }
        });
    }

    private void fireWfsFormAddressStreetSelected() {
        for (WFSFormAdressListener curListener : this.listeners) {
            curListener.wfsFormAdressStreetSelected();
        }
    }

    private void fireWfsFormAddressNrSelected() {
        for (WFSFormAdressListener curListener : this.listeners) {
            curListener.wfsFormAdressNrSelected();
        }
    }

    private void fireWfsFormAddressPositioned(BoundingBox addressBB) {
        for (WFSFormAdressListener curListener : this.listeners) {
            curListener.wfsFormAddressPositioned(addressBB);
        }
    }

    public void addWFSFormAddressListner(WFSFormAdressListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeWFSFormAddressListner(WFSFormAdressListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private static String readFileAsString(File file) throws IOException {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}

