/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfsforms;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.wfsforms.WFSFormQuery;
import java.net.URI;
import org.apache.log4j.Logger;
import org.deegree.datatypes.QualifiedName;
import org.deegree.model.feature.Feature;
import org.deegree.model.feature.FeatureProperty;
import org.deegree.model.spatialschema.Geometry;
import org.deegree.model.spatialschema.GeometryException;
import org.deegree.model.spatialschema.JTSAdapter;

public class WFSFormFeature {
    private final Logger log = Logger.getLogger(this.getClass());
    private Feature feature;
    private WFSFormQuery query;
    private String featureCrs = null;

    public WFSFormFeature(Feature feature, WFSFormQuery query) {
        this.feature = feature;
        this.query = query;
        if (feature != null && feature.getDefaultGeometryPropertyValue() != null && feature.getDefaultGeometryPropertyValue().getCoordinateSystem() != null) {
            this.featureCrs = feature.getDefaultGeometryPropertyValue().getCoordinateSystem().getIdentifier();
        }
    }

    public String getIdentifier() {
        try {
            return this.feature.getProperties(new QualifiedName(this.query.getPropertyPrefix().toString(), this.query.getIdProperty().toString(), new URI(this.query.getPropertyNamespace().toString())))[0].getValue().toString();
        }
        catch (Exception e) {
            this.log.error((Object)"Error in toIdentifier()", (Throwable)e);
            return null;
        }
    }

    public FeatureProperty[] getRawFeatureArray(String prefix, String identifier, String namespace) throws Exception {
        return this.feature.getProperties(new QualifiedName(prefix, identifier, new URI(namespace)));
    }

    public String toString() {
        try {
            if (this.query.getPropertyPrefix() != null) {
                String s = this.feature.getProperties(new QualifiedName(this.query.getPropertyPrefix().toString(), this.query.getDisplayTextProperty().toString(), new URI(this.query.getPropertyNamespace().toString())))[0].getValue().toString();
                return s;
            }
            String s = this.feature.getProperties(new QualifiedName(this.query.getDisplayTextProperty().toString()))[0].getValue().toString();
            return s;
        }
        catch (Exception e) {
            try {
                this.log.error((Object)("Error in toString() angefragt wurde: " + new QualifiedName(this.query.getPropertyPrefix().toString(), this.query.getDisplayTextProperty().toString(), new URI(this.query.getPropertyNamespace().toString())).toString()), (Throwable)e);
            }
            catch (Exception never) {
                this.log.error((Object)"Error in toString()", (Throwable)e);
            }
            for (FeatureProperty fp : this.feature.getProperties()) {
                this.log.fatal((Object)(fp.getName().getPrefix() + "." + fp.getName().getLocalName() + "." + fp.getName().getNamespace() + "->" + fp.getValue()));
            }
            return null;
        }
    }

    public Feature getFeature() {
        return this.feature;
    }

    public void setFeature(Feature feature) {
        this.log.error((Object)("setFeature " + feature), (Throwable)new Exception());
        this.feature = feature;
        if (feature != null && feature.getDefaultGeometryPropertyValue() != null && feature.getDefaultGeometryPropertyValue().getCoordinateSystem() != null) {
            this.featureCrs = feature.getDefaultGeometryPropertyValue().getCoordinateSystem().getIdentifier();
        }
    }

    public WFSFormQuery getQuery() {
        return this.query;
    }

    public com.vividsolutions.jts.geom.Geometry getJTSGeometry() {
        try {
            com.vividsolutions.jts.geom.Geometry res = JTSAdapter.export((Geometry)this.feature.getDefaultGeometryPropertyValue());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("feature srid: " + res.getSRID()));
            }
            if (this.feature != null && this.feature.getDefaultGeometryPropertyValue() != null && this.feature.getDefaultGeometryPropertyValue().getCoordinateSystem() != null) {
                String crsString = this.feature.getDefaultGeometryPropertyValue().getCoordinateSystem().getIdentifier();
                int srid = CrsTransformer.extractSridFromCrs(crsString);
                GeometryFactory fac = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
                res = fac.createGeometry(res);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Use saved crs from member variable. " + this.featureCrs));
                }
                if (this.featureCrs != null) {
                    int srid = CrsTransformer.extractSridFromCrs(this.featureCrs);
                    GeometryFactory fac = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
                    res = fac.createGeometry(res);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("feature srid after setting: " + res.getSRID()));
            }
            return res;
        }
        catch (GeometryException ex) {
            this.log.error((Object)"Error in getJTSGeometry()", (Throwable)ex);
            return null;
        }
    }

    public Point getPosition() {
        try {
            FeatureProperty[] fp = this.feature.getProperties(new QualifiedName(this.query.getPropertyPrefix().toString(), this.query.getPositionProperty().toString(), new URI(this.query.getPropertyNamespace().toString())));
            Geometry geo = (Geometry)fp[0].getValue();
            Point p = (Point)JTSAdapter.export((Geometry)geo);
            int srid = CrsTransformer.extractSridFromCrs(geo.getCoordinateSystem().getIdentifier());
            GeometryFactory fac = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
            p = fac.createPoint(p.getCoordinate());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("POSITION=" + p));
            }
            return p;
        }
        catch (Exception ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Feature has no POSITION. Calculate the centroid from getJTSGeometry() ", (Throwable)ex);
            }
            Point p = this.getJTSGeometry().getCentroid();
            return p;
        }
    }

    public void setQuery(WFSFormQuery query) {
        this.query = query;
    }
}

