/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfsforms;

import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import de.cismet.cismap.commons.wfsforms.AbstractWFSForm;
import de.cismet.cismap.commons.wfsforms.WFSFormFeature;
import de.cismet.cismap.commons.wfsforms.WFSFormQuery;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class WFSFormTester
extends AbstractWFSForm {
    private final Logger log = Logger.getLogger(this.getClass());
    private WFSFormFeature strasse = null;
    private WFSFormFeature nr = null;
    private JComboBox cboNr;
    private JComboBox cboStreets;
    private JButton cmdOk;
    private JProgressBar prbNr;
    private JProgressBar prbStreets;

    public WFSFormTester() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"new WFSFormTester");
        }
        this.initComponents();
        StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cboStreets);
        StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cboNr);
        this.prbStreets.setPreferredSize(new Dimension(10, 5));
        this.prbNr.setPreferredSize(new Dimension(10, 5));
        this.listComponents.put("cboAllStreets", this.cboStreets);
        this.listComponents.put("cboAllStreetsProgress", this.prbStreets);
        this.listComponents.put("cboNumbersOfAStreet", this.cboNr);
        this.listComponents.put("cboNumbersOfAStreetProgress", this.prbNr);
    }

    @Override
    public void garbageDuringAutoCompletion(JComboBox box) {
    }

    private void initComponents() {
        this.cboStreets = new JComboBox();
        this.cboNr = new JComboBox();
        this.cmdOk = new JButton();
        this.prbStreets = new JProgressBar();
        this.prbNr = new JProgressBar();
        this.cboStreets.setEnabled(false);
        this.cboStreets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormTester.this.cboStreetsActionPerformed(evt);
            }
        });
        this.cboStreets.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                WFSFormTester.this.cboStreetsKeyTyped(evt);
            }
        });
        this.cboNr.setEnabled(false);
        this.cboNr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormTester.this.cboNrActionPerformed(evt);
            }
        });
        this.cmdOk.setText(NbBundle.getMessage(WFSFormTester.class, (String)"WFSFormTester.cmdOk.text"));
        this.prbStreets.setBorderPainted(false);
        this.prbNr.setBorderPainted(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.prbStreets, -1, -1, Short.MAX_VALUE).add(1, (Component)this.cboStreets, 0, 236, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.prbNr, 0, 0, Short.MAX_VALUE).add((Component)this.cboNr, 0, 60, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.cmdOk).addContainerGap(194, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.cboStreets, this.prbStreets}, 1);
        layout.linkSize(new Component[]{this.cboNr, this.prbNr}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cboStreets, -2, -1, -2).add((Component)this.cboNr, -2, -1, -2).add((Component)this.cmdOk)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.prbStreets, -2, -1, -2).add((Component)this.prbNr, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cboNrActionPerformed(ActionEvent evt) {
    }

    private void cboStreetsKeyTyped(KeyEvent evt) {
        this.nr = this.cboNr.getSelectedItem() instanceof WFSFormFeature ? (WFSFormFeature)this.cboNr.getSelectedItem() : null;
    }

    private void cboStreetsActionPerformed(ActionEvent evt) {
        if (this.cboStreets.getSelectedItem() instanceof WFSFormFeature) {
            this.strasse = (WFSFormFeature)this.cboStreets.getSelectedItem();
            this.requestRefresh("cboNumbersOfAStreet", (WFSFormFeature)this.cboStreets.getSelectedItem());
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WFSFormQuery allStreets = new WFSFormQuery();
        allStreets.setComponentName("cboAllStreets");
        allStreets.setServerUrl("http://s103bdc-a1/deegreewfs/wfs");
        allStreets.setDisplayTextProperty("geographicIdentifier");
        allStreets.setExtentProperty("geographicExtent");
        allStreets.setFilename("/request_all_streets.xml");
        allStreets.setId("all_streets");
        allStreets.setIdProperty("identifier");
        allStreets.setTitle("Strassen");
        allStreets.setType("INITIAL");
        allStreets.setWfsQueryString(WFSFormTester.readFileAsString(new File("C:\\request_alle_strassen_extent.xml")));
        WFSFormQuery numbers = new WFSFormQuery();
        numbers.setComponentName("cboNumbersOfAStreet");
        numbers.setServerUrl("http://s103bdc-a1/deegreewfs/wfs");
        numbers.setDisplayTextProperty("geographicIdentifier");
        numbers.setExtentProperty("geographicExtent");
        numbers.setFilename("/request_all_numbers.xml");
        numbers.setId("numbers");
        numbers.setIdProperty("identifier");
        numbers.setTitle("Nr");
        numbers.setType("FOLLOWUP");
        numbers.setQueryPlaceholder("@@strasse_id@@");
        numbers.setWfsQueryString(WFSFormTester.readFileAsString(new File("C:\\request_hausnummern_from_strasse_extent.xml")));
        Vector<WFSFormQuery> v = new Vector<WFSFormQuery>();
        v.add(allStreets);
        v.add(numbers);
        final WFSFormTester tester = new WFSFormTester();
        tester.setQueries(v);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame();
                f.setDefaultCloseOperation(3);
                f.getContentPane().setLayout(new BorderLayout());
                f.getContentPane().add((Component)tester, "Center");
                f.setVisible(true);
                f.pack();
            }
        });
        tester.initWFSForm();
    }

    @Override
    public JComponent getListComponentByName(String name) {
        return (JComponent)this.listComponents.get(name);
    }

    private static String readFileAsString(File file) throws IOException {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}

