/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.Crs;
import de.cismet.commons.cismap.io.AddGeometriesToMapPreviewVisualPanel;
import de.cismet.commons.cismap.io.converters.GeometryConverter;
import de.cismet.commons.cismap.io.converters.MultiGeometriesProvider;
import de.cismet.commons.concurrency.CismetConcurrency;
import de.cismet.commons.converter.Converter;
import de.cismet.commons.gui.wizard.AbstractWizardPanel;
import java.awt.EventQueue;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public final class AddGeometriesToMapPreviewWizardPanel
extends AbstractWizardPanel {
    public static final String PROP_GEOMETRY = "__prop_geometry__";
    private static final transient Logger LOG = Logger.getLogger(AddGeometriesToMapPreviewWizardPanel.class);
    private transient Geometry geometry;
    private transient boolean busy;
    private transient String statusMessage;
    private transient String previewUrl;
    private transient Crs currentCrs;
    private transient boolean multipleGeometries;

    public Geometry getGeometry() {
        return this.geometry;
    }

    public boolean hasMultipleGeometries() {
        return this.multipleGeometries;
    }

    public void setGeometry(final Geometry geometry) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AddGeometriesToMapPreviewWizardPanel.this.geometry = geometry;
                AddGeometriesToMapPreviewWizardPanel.this.changeSupport.fireChange();
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(final boolean busy) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AddGeometriesToMapPreviewWizardPanel.this.busy = busy;
                AddGeometriesToMapPreviewWizardPanel.this.changeSupport.fireChange();
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(final String statusMessage) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AddGeometriesToMapPreviewWizardPanel.this.statusMessage = statusMessage;
                AddGeometriesToMapPreviewWizardPanel.this.changeSupport.fireChange();
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public String getPreviewUrl() {
        return this.previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        this.changeSupport.fireChange();
    }

    public Crs getCurrentCrs() {
        return this.currentCrs;
    }

    public void setCurrentCrs(Crs currentCrs) {
        this.currentCrs = currentCrs;
        this.changeSupport.fireChange();
    }

    protected AddGeometriesToMapPreviewVisualPanel createComponent() {
        return new AddGeometriesToMapPreviewVisualPanel(this);
    }

    protected void read(final WizardDescriptor wizard) {
        this.geometry = (Geometry)wizard.getProperty(PROP_GEOMETRY);
        this.previewUrl = (String)wizard.getProperty("__prop_preview_getmap_url__");
        this.currentCrs = (Crs)wizard.getProperty("__prop_current_epsg_code__");
        ExecutorService executor = CismetConcurrency.getInstance((String)"cismap-commons").getDefaultExecutor();
        executor.execute(new Thread("AddGeometriesToMapPreviewWizardPanel read()"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AddGeometriesToMapPreviewWizardPanel.this.setGeometry(null);
                AddGeometriesToMapPreviewWizardPanel.this.multipleGeometries = false;
                AddGeometriesToMapPreviewWizardPanel.this.setStatusMessage(NbBundle.getMessage(AddGeometriesToMapPreviewWizardPanel.class, (String)"AddGeometriesToMapPreviewWizardPanel.read(WizardDescriptor).runnable.statusMessage.convertingData"));
                AddGeometriesToMapPreviewWizardPanel.this.setBusy(true);
                Converter converter = (Converter)wizard.getProperty("__prop_converter__");
                Object data = wizard.getProperty("__prop_coordinate_data__");
                Crs crs = (Crs)wizard.getProperty("__prop_current_epsg_code__");
                assert (converter instanceof GeometryConverter) : "illegal wizard initialisation";
                GeometryConverter geomConverter = (GeometryConverter)converter;
                try {
                    Geometry geom = geomConverter.convertForward(data, crs.getCode());
                    AddGeometriesToMapPreviewWizardPanel.this.setStatusMessage(NbBundle.getMessage(AddGeometriesToMapPreviewWizardPanel.class, (String)"AddGeometriesToMapPreviewWizardPanel.read(WizardDescriptor).runnable.statusMessage.conversionSuccessful"));
                    AddGeometriesToMapPreviewWizardPanel.this.setGeometry(geom);
                    AddGeometriesToMapPreviewWizardPanel.this.multipleGeometries = geomConverter instanceof MultiGeometriesProvider;
                }
                catch (Exception ex) {
                    LOG.error((Object)("cannot convert geometry: [converter=" + geomConverter + "|data=" + data + "]"), (Throwable)ex);
                    AddGeometriesToMapPreviewWizardPanel.this.setStatusMessage(NbBundle.getMessage(AddGeometriesToMapPreviewWizardPanel.class, (String)"AddGeometriesToMapPreviewWizardPanel.read(WizardDescriptor).runnable.statusMessage.convertError", (Object)ex.getLocalizedMessage()));
                }
                finally {
                    AddGeometriesToMapPreviewWizardPanel.this.setBusy(false);
                }
            }
        });
    }

    protected void store(WizardDescriptor wizard) {
        wizard.putProperty(PROP_GEOMETRY, (Object)this.geometry);
    }
}

