/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.commons.cismap.io.AddGeometriesToMapChooseConverterWizardPanel;
import de.cismet.commons.cismap.io.AddGeometriesToMapEnterDataWizardPanel;
import de.cismet.commons.cismap.io.AddGeometriesToMapPreviewWizardPanel;
import de.cismet.commons.cismap.io.converters.AbstractGeometryFromTextConverter;
import de.cismet.commons.cismap.io.converters.GeometryConverter;
import de.cismet.commons.cismap.io.converters.MultiGeometriesProvider;
import de.cismet.commons.cismap.io.converters.TextToGeometryConverter;
import de.cismet.commons.converter.ConversionException;
import de.cismet.commons.converter.Converter;
import de.cismet.commons.gui.wizard.WizardUtils;
import de.cismet.commons.gui.wizard.converter.ConverterPreselectionMode;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class AddGeometriesToMapWizardAction
extends AbstractAction
implements Configurable {
    public static final String PROP_AVAILABLE_CONVERTERS = "__prop_available_converters__";
    public static final String PROP_INPUT_FILE = "__prop_input_file__";
    public static final String PROP_CURRENT_CRS = "__prop_current_epsg_code__";
    public static final String PROP_PREVIEW_GETMAP_URL = "__prop_preview_getmap_url__";
    public static final String PROP_CONVERTER_PRESELECT_MODE = "__prop_converter_preselect_mode__";
    public static final String CONF_SECTION = "addGeometriesToMapWizardAction";
    public static final String CONF_CONV_PRESELECT = "converterPreselectionMode";
    public static final String CONF_PREVIEW_GETMAP_URL = "previewGetMapUrl";
    public static final String CONF_GEOM_FROM_TEXT_CONV_DECIMAL_SEP = "geometryFromTextConverterDecimalSeparator";
    private static final transient Logger LOG = Logger.getLogger(AddGeometriesToMapWizardAction.class);
    private transient Converter selectedConverter;
    private transient WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private transient ConverterPreselectionMode converterPreselectionMode;
    private transient String previewGetMapUrl;
    private transient File inputFile;
    private transient String inputData;

    public AddGeometriesToMapWizardAction() {
        super("", ImageUtilities.loadImageIcon((String)(AddGeometriesToMapWizardAction.class.getPackage().getName().replace('.', '/') + "/new_geom_wiz_22.png"), (boolean)false));
        this.putValue("ShortDescription", NbBundle.getMessage(AddGeometriesToMapWizardAction.class, (String)"AddGeometriesToMapWizardAction.<init>.action.shortDescription"));
        this.setConverterPreselectionMode(this.getDefaultConverterPreselectionMode());
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        assert (EventQueue.isDispatchThread()) : "can only be called from EDT";
        if (this.panels == null) {
            AddGeometriesToMapChooseConverterWizardPanel chooseConvPanel = new AddGeometriesToMapChooseConverterWizardPanel();
            try {
                ResourceBundle customBundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".ConverterPanelL10N");
                chooseConvPanel.setResourceBundle(customBundle);
            }
            catch (Exception e) {
                LOG.warn((Object)"cannot set custom converter bundle", (Throwable)e);
            }
            this.panels = new WizardDescriptor.Panel[]{new AddGeometriesToMapEnterDataWizardPanel(), chooseConvPanel, new AddGeometriesToMapPreviewWizardPanel()};
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final WizardDescriptor wizard = new WizardDescriptor(this.getPanels());
        wizard.setTitleFormat(new MessageFormat("{0}"));
        wizard.setTitle(NbBundle.getMessage(AddGeometriesToMapWizardAction.class, (String)"AddGeometriesToMapWizardAction.actionPerformed(ActionEvent).wizard.title"));
        WizardUtils.setCustomButtonText((WizardDescriptor)wizard, (Object)WizardDescriptor.FINISH_OPTION, (String)NbBundle.getMessage(AddGeometriesToMapWizardAction.class, (String)"AddGeometriesToMapWizardAction.actionPerformed(ActionEvent).wizard.finishButton.text"));
        Collection availableConverters = Lookup.getDefault().lookupAll(TextToGeometryConverter.class);
        ConverterPreselectionMode preselectionMode = ConverterPreselectionMode.DEFAULT == this.getConverterPreselectionMode() ? this.getDefaultConverterPreselectionMode() : this.getConverterPreselectionMode();
        wizard.putProperty("__prop_converter__", (Object)this.selectedConverter);
        wizard.putProperty(PROP_PREVIEW_GETMAP_URL, (Object)this.getPreviewGetMapUrl());
        wizard.putProperty(PROP_AVAILABLE_CONVERTERS, new ArrayList(availableConverters));
        wizard.putProperty(PROP_CURRENT_CRS, (Object)CismapBroker.getInstance().getSrs());
        wizard.putProperty(PROP_CONVERTER_PRESELECT_MODE, (Object)preselectionMode);
        wizard.putProperty(PROP_INPUT_FILE, (Object)this.getInputFile());
        wizard.putProperty("__prop_coordinate_data__", (Object)this.getInputData());
        final Frame parent = StaticSwingTools.getParentFrame((Component)((Object)CismapBroker.getInstance().getMappingComponent()));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizard);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        dialog.toFront();
        this.setInputFile(null);
        this.setInputData(null);
        if (wizard.getValue() == WizardDescriptor.FINISH_OPTION) {
            if (ConverterPreselectionMode.SESSION_MEMORY == this.converterPreselectionMode || ConverterPreselectionMode.PERMANENT_MEMORY == this.converterPreselectionMode || ConverterPreselectionMode.CONFIGURE_AND_MEMORY == this.converterPreselectionMode) {
                this.setSelectedConverter((Converter)wizard.getProperty("__prop_converter__"));
            } else {
                this.setSelectedConverter(null);
            }
            WaitingDialogThread<Geometry> wdt = new WaitingDialogThread<Geometry>(parent, true, NbBundle.getMessage(AddGeometriesToMapWizardAction.class, (String)"AddGeometriesToMapWizardAction.actionPerformed(ActionEvent).waitingDialogThread.message"), null, 50){

                protected Geometry doInBackground() throws Exception {
                    Geometry geometry = (Geometry)wizard.getProperty("__prop_geometry__");
                    if (geometry == null) {
                        Converter converter = (Converter)wizard.getProperty("__prop_converter__");
                        Object data = wizard.getProperty("__prop_coordinate_data__");
                        Crs crs = (Crs)wizard.getProperty(AddGeometriesToMapWizardAction.PROP_CURRENT_CRS);
                        assert (converter instanceof GeometryConverter) : "illegal wizard initialisation";
                        GeometryConverter geomConverter = (GeometryConverter)converter;
                        geometry = geomConverter.convertForward(data, crs.getCode());
                    }
                    return geometry;
                }

                protected void done() {
                    try {
                        Geometry geom = (Geometry)this.get();
                        Converter converter = (Converter)wizard.getProperty("__prop_converter__");
                        ArrayList<PureNewFeature> featureList = new ArrayList<PureNewFeature>();
                        if (converter instanceof MultiGeometriesProvider && geom instanceof GeometryCollection) {
                            GeometryCollection gc = (GeometryCollection)geom;
                            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                                PureNewFeature feature = new PureNewFeature(gc.getGeometryN(i));
                                feature.setGeometryType(FeatureTools.getGeomType(gc.getGeometryN(i)));
                                feature.setEditable(true);
                                featureList.add(feature);
                            }
                        } else {
                            PureNewFeature feature = new PureNewFeature(geom);
                            feature.setGeometryType(FeatureTools.getGeomType(geom));
                            feature.setEditable(true);
                            featureList.add(feature);
                        }
                        MappingComponent map = CismapBroker.getInstance().getMappingComponent();
                        map.getFeatureCollection().addFeatures(featureList);
                        for (PureNewFeature feature : featureList) {
                            map.getFeatureCollection().holdFeature(feature);
                        }
                        if (!map.isFixedMapExtent()) {
                            map.zoomToAFeatureCollection(featureList, true, map.isFixedMapScale());
                        }
                    }
                    catch (Exception ex) {
                        StringWriter stacktraceWriter = new StringWriter();
                        ex.printStackTrace(new PrintWriter(stacktraceWriter));
                        ErrorInfo errorInfo = ex instanceof ConversionException ? new ErrorInfo(NbBundle.getMessage(AddGeometriesToMapWizardAction.class, (String)"AddGeometriesToMapWizardAction.actionPerformed(ActionEvent).waitingDialogThread.conversionError.title"), NbBundle.getMessage(AddGeometriesToMapWizardAction.class, (String)"AddGeometriesToMapWizardAction.actionPerformed(ActionEvent).waitingDialogThread.conversionError.message"), stacktraceWriter.toString(), "WARNING", (Throwable)ex, Level.WARNING, null) : new ErrorInfo(NbBundle.getMessage(AddGeometriesToMapWizardAction.class, (String)"AddGeometriesToMapWizardAction.actionPerformed(ActionEvent).waitingDialogThread.genericError.title"), NbBundle.getMessage(AddGeometriesToMapWizardAction.class, (String)"AddGeometriesToMapWizardAction.actionPerformed(ActionEvent).waitingDialogThread.genericError.message"), stacktraceWriter.toString(), "WARNING", (Throwable)ex, Level.WARNING, null);
                        JXErrorPane.showDialog((Component)parent, (ErrorInfo)errorInfo);
                    }
                }
            };
            wdt.start();
        }
    }

    public void configure(Element parent) {
    }

    public void masterConfigure(Element parent) {
        if (parent == null) {
            return;
        }
        Element actionConfigElement = parent.getChild(CONF_SECTION);
        if (actionConfigElement == null) {
            return;
        }
        Element convPreselectModeElement = actionConfigElement.getChild(CONF_CONV_PRESELECT);
        if (convPreselectModeElement == null) {
            this.setConverterPreselectionMode(ConverterPreselectionMode.DEFAULT);
        } else {
            String convPreselectModeString = convPreselectModeElement.getText();
            try {
                ConverterPreselectionMode convPreselectMode = ConverterPreselectionMode.valueOf((String)convPreselectModeString);
                this.setConverterPreselectionMode(convPreselectMode);
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Object)"illegal value for converterPreselectionMode, configuring DEFAULT", (Throwable)e);
                this.setConverterPreselectionMode(ConverterPreselectionMode.DEFAULT);
            }
        }
        Element convPreviewGetMapUrlElement = actionConfigElement.getChild(CONF_PREVIEW_GETMAP_URL);
        if (convPreviewGetMapUrlElement == null) {
            this.setPreviewGetMapUrl(null);
        } else {
            this.setPreviewGetMapUrl(convPreviewGetMapUrlElement.getText().trim());
        }
        Element convDecimalSeparator = actionConfigElement.getChild(CONF_GEOM_FROM_TEXT_CONV_DECIMAL_SEP);
        if (convDecimalSeparator != null) {
            System.setProperty(AbstractGeometryFromTextConverter.SYS_PROP_DECIMAL_SEP, convDecimalSeparator.getText());
        }
    }

    public Element getConfiguration() throws NoWriteError {
        Element sectionElement = new Element(CONF_SECTION);
        Element convPreselectModeElement = new Element(CONF_CONV_PRESELECT);
        convPreselectModeElement.setText(this.getConverterPreselectionMode().toString());
        Element convPreviewGetMapUrlElement = new Element(CONF_PREVIEW_GETMAP_URL);
        convPreviewGetMapUrlElement.setText(this.getPreviewGetMapUrl());
        Element convDecimalSeparator = new Element(CONF_GEOM_FROM_TEXT_CONV_DECIMAL_SEP);
        convDecimalSeparator.setText(System.getProperty(AbstractGeometryFromTextConverter.SYS_PROP_DECIMAL_SEP));
        sectionElement.addContent((Content)convPreselectModeElement);
        sectionElement.addContent((Content)convPreviewGetMapUrlElement);
        sectionElement.addContent((Content)convDecimalSeparator);
        return sectionElement;
    }

    public ConverterPreselectionMode getConverterPreselectionMode() {
        return this.converterPreselectionMode;
    }

    public void setConverterPreselectionMode(ConverterPreselectionMode converterPreselectionMode) {
        switch (converterPreselectionMode) {
            case CONFIGURE: 
            case CONFIGURE_AND_MEMORY: 
            case PERMANENT_MEMORY: {
                throw new IllegalArgumentException("mode not supported yet: " + converterPreselectionMode);
            }
        }
        this.converterPreselectionMode = converterPreselectionMode;
    }

    public ConverterPreselectionMode getDefaultConverterPreselectionMode() {
        return ConverterPreselectionMode.SESSION_MEMORY;
    }

    public String getPreviewGetMapUrl() {
        return this.previewGetMapUrl;
    }

    public void setPreviewGetMapUrl(String previewGetMapUrl) {
        this.previewGetMapUrl = previewGetMapUrl;
    }

    public Converter getSelectedConverter() {
        return this.selectedConverter;
    }

    public void setSelectedConverter(Converter selectedConverter) {
        this.selectedConverter = selectedConverter;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public String getInputData() {
        return this.inputData;
    }

    public void setInputData(String inputData) {
        this.inputData = inputData;
    }
}

