/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.commons.cismap.io.converters.AbstractRatingConverter;
import de.cismet.commons.cismap.io.converters.TextToGeometryConverter;
import de.cismet.commons.converter.ConversionException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public abstract class AbstractGeometryFromTextConverter
extends AbstractRatingConverter<String, Geometry>
implements TextToGeometryConverter {
    private static final transient Logger LOG = Logger.getLogger(AbstractGeometryFromTextConverter.class);
    public static final String SYS_PROP_DECIMAL_SEP = "de.cismet.commons.cismap.io.convertes.AbstractGeometryFromTextConverter.decimalSeparator";
    private static final char[] DEFAULT_TOKEN_SEPARATORS;
    private static final char[] WHITE_SPACE_CHARS;

    protected abstract Geometry createGeometry(Coordinate[] var1, GeometryFactory var2) throws ConversionException;

    @Override
    public Geometry convertForward(String from, String ... params) throws ConversionException {
        if (from == null || from.isEmpty()) {
            throw new IllegalArgumentException("from must not be null or empty");
        }
        if (params == null || params.length < 1) {
            throw new IllegalArgumentException("no parameters provided, epsgcode is required parameter");
        }
        String[] tokens = from.split(this.getTokenRegex());
        if (tokens.length % 2 == 0) {
            int srid;
            try {
                srid = CrsTransformer.extractSridFromCrs(params[0]);
            }
            catch (Exception e) {
                throw new ConversionException("unsupported epsg parameter: " + params[0], (Throwable)e);
            }
            GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
            Coordinate[] coordinates = new Coordinate[tokens.length / 2];
            DecimalFormat format = this.getDecimalFormat();
            for (int i = 0; i < tokens.length; i += 2) {
                try {
                    double easting = format.parse(tokens[i]).doubleValue();
                    double northing = format.parse(tokens[i + 1]).doubleValue();
                    coordinates[i / 2] = new Coordinate(easting, northing);
                    continue;
                }
                catch (ParseException ex) {
                    throw new ConversionException("cannot parse convert data into valid double", (Throwable)ex);
                }
            }
            return this.createGeometry(coordinates, geomFactory);
        }
        throw new ConversionException("uneven number of tokens illegal, only two dimensional coordinates allowed");
    }

    @Override
    public String convertBackward(Geometry to, String ... params) throws ConversionException {
        if (to == null) {
            throw new IllegalArgumentException("'to' must not be null");
        }
        StringBuilder sb = new StringBuilder();
        DecimalFormat nf = this.getDecimalFormat();
        for (Coordinate coord : to.getCoordinates()) {
            sb.append(nf.format(coord.x));
            sb.append(' ');
            sb.append(nf.format(coord.y));
            sb.append('\n');
        }
        return sb.toString();
    }

    protected char getDecimalSeparator() {
        char c;
        String systemSep = System.getProperty(SYS_PROP_DECIMAL_SEP);
        if (systemSep == null || systemSep.length() == 0) {
            c = ((DecimalFormat)NumberFormat.getNumberInstance(Locale.getDefault())).getDecimalFormatSymbols().getDecimalSeparator();
        } else {
            try {
                c = (char)Integer.decode(systemSep).intValue();
            }
            catch (NumberFormatException e) {
                if (systemSep.startsWith("\\u") || systemSep.startsWith("\\U")) {
                    try {
                        c = (char)Integer.parseInt(systemSep.substring(2), 16);
                    }
                    catch (NumberFormatException ex) {
                        LOG.warn((Object)("unrecognized separator format '" + systemSep + "', using locale default"), (Throwable)ex);
                        c = ((DecimalFormat)NumberFormat.getNumberInstance(Locale.getDefault())).getDecimalFormatSymbols().getDecimalSeparator();
                    }
                }
                c = systemSep.charAt(0);
            }
            if (Character.isWhitespace(c)) {
                LOG.warn((Object)"white space chars not accepted as decimal separator, using locale default");
                c = ((DecimalFormat)NumberFormat.getNumberInstance(Locale.getDefault())).getDecimalFormatSymbols().getDecimalSeparator();
            }
        }
        return c;
    }

    protected DecimalFormat getDecimalFormat() {
        DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(Locale.getDefault());
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        char decimalSep = this.getDecimalSeparator();
        symbols.setDecimalSeparator(decimalSep);
        symbols.setGroupingSeparator('\u0000');
        format.setDecimalFormatSymbols(symbols);
        format.setGroupingUsed(false);
        return format;
    }

    protected String getTokenRegex() {
        StringBuilder sb = new StringBuilder("[");
        for (char sep : this.getTokenSeparators()) {
            sb.append(sep);
        }
        sb.append("]+");
        return sb.toString();
    }

    protected char[] getTokenSeparators() {
        int i;
        char decimalSep = this.getDecimalSeparator();
        char[] chars = new char[DEFAULT_TOKEN_SEPARATORS.length];
        int j = 0;
        for (i = 0; i < DEFAULT_TOKEN_SEPARATORS.length; ++i) {
            if (decimalSep == DEFAULT_TOKEN_SEPARATORS[i]) continue;
            chars[j++] = DEFAULT_TOKEN_SEPARATORS[i];
        }
        if (i == j) {
            return chars;
        }
        char[] ret = new char[j];
        System.arraycopy(chars, 0, ret, 0, j);
        return ret;
    }

    private String getFormatSeparators() {
        int indexOfComma;
        StringBuilder sb = new StringBuilder();
        for (char c : this.getTokenSeparators()) {
            if (Character.isWhitespace(c)) continue;
            sb.append('\'');
            sb.append(c);
            sb.append('\'');
            sb.append(", ");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        if ((indexOfComma = sb.lastIndexOf(",")) > 0) {
            if (sb.charAt(indexOfComma - 1) == '\'' && sb.charAt(indexOfComma + 1) == '\'') {
                indexOfComma = sb.substring(0, indexOfComma).lastIndexOf(",");
            }
            if (indexOfComma > 0) {
                sb.replace(indexOfComma, indexOfComma + 1, NbBundle.getMessage(AbstractGeometryFromTextConverter.class, (String)"AbstractGeometryFromTextConverter.getFormatSeparators().or"));
            }
        }
        return sb.toString();
    }

    public String getFormatDescription() {
        return NbBundle.getMessage(AbstractGeometryFromTextConverter.class, (String)"AbstractGeometryFromTextConverter.getFormatDescription().returnValue", (Object)this.getFormatSeparators(), (Object)Character.valueOf(this.getDecimalSeparator()));
    }

    public String getFormatHtmlDescription() {
        return NbBundle.getMessage(AbstractGeometryFromTextConverter.class, (String)"AbstractGeometryFromTextConverter.getFormatHtmlDescription().returnValue", (Object)this.getFormatSeparators(), (Object)Character.valueOf(this.getDecimalSeparator()));
    }

    static {
        WHITE_SPACE_CHARS = new char[]{' ', '\u2028', '\u2029', '\t', '\n', '\u000b', '\f', '\r', '\u001c', '\u001d', '\u001e', '\u001f'};
        DEFAULT_TOKEN_SEPARATORS = new char[WHITE_SPACE_CHARS.length + 3];
        AbstractGeometryFromTextConverter.DEFAULT_TOKEN_SEPARATORS[0] = 58;
        AbstractGeometryFromTextConverter.DEFAULT_TOKEN_SEPARATORS[1] = 59;
        AbstractGeometryFromTextConverter.DEFAULT_TOKEN_SEPARATORS[2] = 44;
        System.arraycopy(WHITE_SPACE_CHARS, 0, DEFAULT_TOKEN_SEPARATORS, 3, WHITE_SPACE_CHARS.length);
    }
}

