/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.commons.cismap.io.converters.BinaryToGeometryConverter;
import de.cismet.commons.converter.ConversionException;

public final class GeomFromWkbConverter
implements BinaryToGeometryConverter {
    @Override
    public Geometry convertForward(byte[] from, String ... params) throws ConversionException {
        int srid;
        if (from == null || from.length == 0) {
            throw new IllegalArgumentException("'from' must not be null or empty");
        }
        if (params == null || params.length < 1) {
            throw new IllegalArgumentException("no parameters provided, epsgcode is required parameter");
        }
        try {
            srid = CrsTransformer.extractSridFromCrs(params[0]);
        }
        catch (Exception e) {
            throw new ConversionException("unsupported epsg parameter: " + params[0], (Throwable)e);
        }
        GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
        WKBReader wkbReader = new WKBReader(geomFactory);
        try {
            return wkbReader.read(from);
        }
        catch (ParseException ex) {
            throw new ConversionException("cannot create geometry from WKT: " + from, (Throwable)ex);
        }
    }

    @Override
    public byte[] convertBackward(Geometry to, String ... params) throws ConversionException {
        if (to == null) {
            throw new IllegalArgumentException("'to' must not be null");
        }
        int endian = 2;
        if (params != null && params.length > 0 && params[0] != null && "XDR".equalsIgnoreCase(params[0])) {
            endian = 1;
        }
        WKBWriter wkbWriter = new WKBWriter(2, endian);
        return wkbWriter.write(to);
    }

    public String getFormatName() {
        return "GeomFromWkbConverter";
    }

    public String getFormatDisplayName() {
        return "Geometry from WKB converter";
    }

    public String getFormatHtmlName() {
        return null;
    }

    public String getFormatDescription() {
        return null;
    }

    public String getFormatHtmlDescription() {
        return null;
    }

    public Object getFormatExample() {
        return null;
    }
}

