/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.gpx.helper.GpxReader;
import de.cismet.commons.cismap.io.converters.AbstractGeometryFromTextConverter;
import de.cismet.commons.cismap.io.converters.MultiGeometriesProvider;
import de.cismet.commons.cismap.io.converters.PointFromTextConverter;
import de.cismet.commons.converter.ConversionException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public final class GeometriesFromGPXConverter
extends AbstractGeometryFromTextConverter
implements MultiGeometriesProvider {
    private static final transient Logger LOG = Logger.getLogger(GeometriesFromGPXConverter.class);

    @Override
    protected Geometry createGeometry(Coordinate[] coordinates, GeometryFactory geomFactory) throws ConversionException {
        if (coordinates.length < 1) {
            throw new ConversionException("cannot create point from empty coordinate array");
        }
        ArrayList<Point> geomList = new ArrayList<Point>();
        for (Coordinate coord : coordinates) {
            geomList.add(geomFactory.createPoint(coord));
        }
        Geometry[] geomArray = geomList.toArray(new Geometry[geomList.size()]);
        return new GeometryCollection(geomArray, geomFactory);
    }

    @Override
    public Geometry convertForward(String from, String ... params) throws ConversionException {
        try {
            GpxReader reader = new GpxReader();
            Geometry[] geometries = reader.read(from);
            GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
            Object geometry = geometries.length == 1 ? geometries[0] : geometryFactory.createGeometryCollection(geometries);
            Geometry geomInCurrentCrs = CrsTransformer.transformToGivenCrs(geometry, params[0]);
            return geomInCurrentCrs;
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot import gpx file", (Throwable)e);
            return null;
        }
    }

    public String getFormatName() {
        return "GeomsFromGPXConverter";
    }

    public String getFormatDisplayName() {
        return NbBundle.getMessage(PointFromTextConverter.class, (String)"GeometriesFromGPXConverter.getFormatDisplayName().returnValue");
    }

    public String getFormatHtmlName() {
        return null;
    }

    @Override
    public String getFormatDescription() {
        String desc = NbBundle.getMessage(GeometriesFromGPXConverter.class, (String)"GeometriesFromGPXConverter.getFormatDescription().returnValue");
        String superDesc = super.getFormatDescription();
        return desc + "\n" + superDesc;
    }

    @Override
    public String getFormatHtmlDescription() {
        return NbBundle.getMessage(GeometriesFromGPXConverter.class, (String)"GeometriesFromGPXConverter.getFormatHtmlDescription().returnValue");
    }

    public Object getFormatExample() {
        return NbBundle.getMessage(GeometriesFromGPXConverter.class, (String)"GeometriesFromGPXConverter.getFormatExample().returnValue", (Object)Character.valueOf(this.getDecimalSeparator()));
    }

    @Override
    public int rate(String from, String ... params) {
        if (from == null) {
            return 0;
        }
        GpxReader reader = new GpxReader();
        if (reader.isValid(from)) {
            return 100;
        }
        return 0;
    }
}

