/*
 * Decompiled with CFR 0.152.
 */
package pswing;

import edu.umd.cs.piccolo.PCanvas;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import pswing.PSwing;
import pswing.PSwingCanvas;

public class PComboBox
extends JComboBox
implements Serializable {
    private MouseEvent currentEvent;
    private PSwing pSwing;
    private PSwingCanvas canvas;

    public PComboBox() {
        this.init();
    }

    public PComboBox(ComboBoxModel model) {
        super(model);
        this.init();
    }

    public PComboBox(Object[] items) {
        super(items);
        this.init();
    }

    public PComboBox(Vector items) {
        super(items);
        this.init();
    }

    private void init() {
        this.setUI(new ZBasicComboBoxUI());
    }

    private void setCurrentEvent(MouseEvent me) {
        this.currentEvent = me;
    }

    private MouseEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public void setEnvironment(PSwing pSwing, PSwingCanvas canvas) {
        this.pSwing = pSwing;
        this.canvas = canvas;
    }

    private Point2D getNodeLocationInFrame() {
        if (this.pSwing == null || this.canvas == null) {
            throw new RuntimeException("PComboBox.setEnvironment( swing, pCanvas );//has to be done manually at present");
        }
        Point2D r1c = this.pSwing.getBounds().getOrigin();
        this.pSwing.localToGlobal(r1c);
        this.canvas.getCamera().viewToLocal(r1c);
        return r1c;
    }

    class EventGrabber
    extends MouseAdapter {
        EventGrabber() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me instanceof MouseEvent) {
                PComboBox.this.setCurrentEvent(me);
            }
        }
    }

    class ZBasicComboPopup
    extends BasicComboPopup {
        public ZBasicComboPopup(JComboBox combo) {
            super(combo);
        }

        @Override
        protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
            if (PComboBox.this.currentEvent != null) {
                Rectangle absBounds;
                Point2D pt = PComboBox.this.getNodeLocationInFrame();
                Rectangle2D.Double bounds = new Rectangle2D.Double(pt.getX(), pt.getY(), this.comboBox.getBounds().width, this.comboBox.getBounds().height);
                py = (int)(((RectangularShape)bounds).getHeight() + 0.5);
                Rectangle r = new Rectangle(px, py, pw, ph);
                boolean inModalDialog = this.inModalDialog();
                if (inModalDialog) {
                    Point p;
                    Dialog dlg = this.getDialog();
                    if (dlg instanceof JDialog) {
                        JRootPane rp = ((JDialog)dlg).getRootPane();
                        p = rp.getLocationOnScreen();
                        absBounds = rp.getBounds();
                        absBounds.x = p.x;
                        absBounds.y = p.y;
                    } else {
                        absBounds = dlg.getBounds();
                    }
                    p = new Point(absBounds.x, absBounds.y);
                    SwingUtilities.convertPointFromScreen(p, this.comboBox);
                    absBounds.x = p.x;
                    absBounds.y = p.y;
                } else {
                    Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
                    absBounds = new Rectangle();
                    Point p = this.getComboLocationOnScreen();
                    absBounds.x = -p.x;
                    absBounds.y = -p.y;
                    absBounds.width = scrSize.width;
                    absBounds.height = scrSize.height;
                }
                Point offset = this.getJazzComboOffset();
                if (SwingUtilities.isRectangleContainingRectangle(absBounds, r)) {
                    r.x += offset.x;
                    r.y += offset.y;
                    return r;
                }
                Rectangle r2 = new Rectangle(0, -r.height, r.width, r.height);
                if (SwingUtilities.isRectangleContainingRectangle(absBounds, r2)) {
                    r2.x = offset.x;
                    r2.y = offset.y + r2.y;
                    return r2;
                }
                if (inModalDialog) {
                    SwingUtilities.computeIntersection(absBounds.x, absBounds.y, absBounds.width, absBounds.height, r);
                    SwingUtilities.computeIntersection(absBounds.x, absBounds.y, absBounds.width, absBounds.height, r2);
                    if (r.height > r2.height) {
                        r.x += offset.x;
                        r.y += offset.y;
                        return r;
                    }
                    r2.x = offset.x;
                    r2.y = offset.y + r2.y;
                    return r2;
                }
                r2.x = offset.x;
                r2.y = offset.y + r2.y;
                return r2;
            }
            return super.computePopupBounds(px, py, pw, ph);
        }

        private Point getComboLocationOnScreen() {
            Point position = null;
            if (this.comboBox.isShowing()) {
                Point2D pt = new Point2D.Double(0.0, 0.0);
                Container c = this.comboBox;
                while (!(c.getParent().getParent() instanceof PCanvas)) {
                    Point location = c.getLocation();
                    pt.setLocation(pt.getX() + location.getX(), pt.getY() + location.getY());
                    c = c.getParent();
                }
                pt = PComboBox.this.getNodeLocationInFrame();
                position = new Point((int)(pt.getX() + 0.5), (int)(pt.getY() + 0.5));
                Point canvasOffset = c.getParent().getLocationOnScreen();
                position.setLocation(position.getX() + canvasOffset.getX(), position.getY() + canvasOffset.getY());
            }
            return position;
        }

        private Point getJazzComboOffset() {
            Point swing = this.comboBox.getLocationOnScreen();
            Point jazz = this.getComboLocationOnScreen();
            jazz.setLocation(jazz.getLocation().getX() - swing.getLocation().getX(), jazz.getLocation().getY() - swing.getLocation().getY());
            return jazz;
        }

        private Dialog getDialog() {
            Container parent;
            for (parent = this.comboBox.getParent(); parent != null && !(parent instanceof Dialog) && !(parent instanceof Window); parent = parent.getParent()) {
            }
            if (parent instanceof Dialog) {
                return (Dialog)parent;
            }
            return null;
        }

        private boolean inModalDialog() {
            return this.getDialog() != null;
        }
    }

    class ZBasicComboBoxUI
    extends BasicComboBoxUI {
        EventGrabber eg;

        ZBasicComboBoxUI() {
            this.eg = new EventGrabber();
        }

        @Override
        public void configureArrowButton() {
            this.arrowButton.addMouseListener(this.eg);
            super.configureArrowButton();
        }

        @Override
        protected void installListeners() {
            this.comboBox.addMouseListener(this.eg);
            super.installListeners();
        }

        @Override
        protected ComboPopup createPopup() {
            ZBasicComboPopup popup = new ZBasicComboPopup(this.comboBox);
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return popup;
        }
    }
}

