/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * ServerInfo.java
 *
 * Created on 16. Februar 2006, 13:58
 */
package de.cismet.cismap.commons.gui.infowidgets;

import org.openide.util.NbBundle;

import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

import de.cismet.cismap.commons.interaction.ActiveLayerListener;
import de.cismet.cismap.commons.interaction.CapabilityListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.interaction.events.CapabilityEvent;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilities;

import de.cismet.commons.capabilities.Service;

import de.cismet.commons.wms.capabilities.WMSCapabilities;

import de.cismet.tools.Static2DTools;

import de.cismet.tools.gui.GUIWindow;
import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten.hell@cismet.de
 * @version  $Revision$, $Date$
 */
@org.openide.util.lookup.ServiceProvider(service = GUIWindow.class)
public class ServerInfo extends javax.swing.JPanel implements CapabilityListener, ActiveLayerListener, GUIWindow {

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList cboKeywords;
    private javax.swing.JLabel lblContact;
    private javax.swing.JLabel lblContactTitle;
    private javax.swing.JLabel lblFees;
    private javax.swing.JLabel lblFeesTitle;
    private javax.swing.JLabel lblInfo;
    private javax.swing.JLabel lblKeywords;
    private javax.swing.JLabel lblName;
    private javax.swing.JLabel lblOrganisation;
    private javax.swing.JLabel lblRestrictions;
    private javax.swing.JLabel lblRestrictionsTitle;
    private javax.swing.JLabel lblTitle;
    private javax.swing.JPanel panMain;
    private javax.swing.JScrollPane scpKeywords;
    private javax.swing.JScrollPane scpMain;
    private javax.swing.JSeparator sepContact;
    private javax.swing.JSeparator sepFees;
    private javax.swing.JSeparator sepKeywords;
    private javax.swing.JSeparator sepRestrictions;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form ServerInfo.
     */
    public ServerInfo() {
        initComponents();
        StaticSwingTools.setNiftyScrollBars(scpMain);
        CismapBroker.getInstance().addCapabilityListener(this);
        CismapBroker.getInstance().addActiveLayerListener(this);
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void serverChanged(final CapabilityEvent e) {
        final Object serverInfo = e.getCapabilityObject();
        if (serverInfo instanceof WMSCapabilities) {
            setValues(((WMSCapabilities)serverInfo).getService());
        } else if (serverInfo instanceof WFSCapabilities) {
            setValues(((WFSCapabilities)serverInfo).getService());
        }
    }

    @Override
    public void layerChanged(final CapabilityEvent e) {
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        scpMain = new javax.swing.JScrollPane();
        panMain = new javax.swing.JPanel();
        lblTitle = new javax.swing.JLabel();
        lblInfo = new javax.swing.JLabel();
        lblName = new javax.swing.JLabel();
        sepKeywords = new javax.swing.JSeparator();
        scpKeywords = new javax.swing.JScrollPane();
        cboKeywords = new javax.swing.JList();
        lblKeywords = new javax.swing.JLabel();
        sepContact = new javax.swing.JSeparator();
        lblContactTitle = new javax.swing.JLabel();
        lblContact = new javax.swing.JLabel();
        lblOrganisation = new javax.swing.JLabel();
        sepFees = new javax.swing.JSeparator();
        lblFeesTitle = new javax.swing.JLabel();
        lblFees = new javax.swing.JLabel();
        sepRestrictions = new javax.swing.JSeparator();
        lblRestrictionsTitle = new javax.swing.JLabel();
        lblRestrictions = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        scpMain.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        lblTitle.setFont(new java.awt.Font("Tahoma", 1, 14));
        lblTitle.setText(null);

        lblInfo.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cismap/commons/gui/infowidgets/res/info.png")));

        lblName.setText(null);

        cboKeywords.setBackground(panMain.getBackground());
        scpKeywords.setViewportView(cboKeywords);

        lblKeywords.setText(null);

        lblContactTitle.setText(null);

        lblContact.setText(null);

        lblOrganisation.setText(null);

        lblFeesTitle.setText(null);

        lblFees.setText(null);

        lblRestrictionsTitle.setText(null);

        lblRestrictions.setText(null);

        final org.jdesktop.layout.GroupLayout panMainLayout = new org.jdesktop.layout.GroupLayout(panMain);
        panMain.setLayout(panMainLayout);
        panMainLayout.setHorizontalGroup(
            panMainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
                org.jdesktop.layout.GroupLayout.TRAILING,
                panMainLayout.createSequentialGroup().addContainerGap().add(
                    panMainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING).add(
                        org.jdesktop.layout.GroupLayout.LEADING,
                        sepKeywords,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        338,
                        Short.MAX_VALUE).add(
                        org.jdesktop.layout.GroupLayout.LEADING,
                        sepRestrictions,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        338,
                        Short.MAX_VALUE).add(
                        org.jdesktop.layout.GroupLayout.LEADING,
                        sepContact,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        338,
                        Short.MAX_VALUE).add(
                        org.jdesktop.layout.GroupLayout.LEADING,
                        sepFees,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        338,
                        Short.MAX_VALUE).add(
                        org.jdesktop.layout.GroupLayout.LEADING,
                        panMainLayout.createSequentialGroup().add(lblName).addPreferredGap(
                            org.jdesktop.layout.LayoutStyle.RELATED).add(lblInfo)).add(
                        org.jdesktop.layout.GroupLayout.LEADING,
                        panMainLayout.createSequentialGroup().add(lblKeywords).addPreferredGap(
                            org.jdesktop.layout.LayoutStyle.RELATED).add(
                            scpKeywords,
                            org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                            322,
                            Short.MAX_VALUE).add(12, 12, 12)).add(org.jdesktop.layout.GroupLayout.LEADING, lblTitle)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, lblContactTitle).add(
                        org.jdesktop.layout.GroupLayout.LEADING,
                        lblOrganisation).add(org.jdesktop.layout.GroupLayout.LEADING, lblFeesTitle).add(
                        org.jdesktop.layout.GroupLayout.LEADING,
                        lblFees).add(org.jdesktop.layout.GroupLayout.LEADING, lblRestrictionsTitle).add(
                        org.jdesktop.layout.GroupLayout.LEADING,
                        lblRestrictions).add(
                        org.jdesktop.layout.GroupLayout.LEADING,
                        lblContact,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        338,
                        Short.MAX_VALUE)).addContainerGap()));
        panMainLayout.setVerticalGroup(
            panMainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
                panMainLayout.createSequentialGroup().addContainerGap().add(lblTitle).addPreferredGap(
                    org.jdesktop.layout.LayoutStyle.RELATED).add(
                    panMainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE).add(lblName).add(
                        lblInfo)).add(18, 18, 18).add(
                    sepKeywords,
                    org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                    org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).add(8, 8, 8).add(
                    panMainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(lblKeywords).add(
                        scpKeywords,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                        44,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)).add(8, 8, 8).add(
                    sepContact,
                    org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                    org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).addPreferredGap(
                    org.jdesktop.layout.LayoutStyle.RELATED).add(lblContactTitle).addPreferredGap(
                    org.jdesktop.layout.LayoutStyle.RELATED).add(lblContact).addPreferredGap(
                    org.jdesktop.layout.LayoutStyle.RELATED).add(lblOrganisation).add(12, 12, 12).add(
                    sepFees,
                    org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                    org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).addPreferredGap(
                    org.jdesktop.layout.LayoutStyle.RELATED).add(lblFeesTitle).addPreferredGap(
                    org.jdesktop.layout.LayoutStyle.RELATED).add(lblFees).addPreferredGap(
                    org.jdesktop.layout.LayoutStyle.RELATED).add(
                    sepRestrictions,
                    org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                    2,
                    org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).addPreferredGap(
                    org.jdesktop.layout.LayoutStyle.RELATED).add(lblRestrictionsTitle).addPreferredGap(
                    org.jdesktop.layout.LayoutStyle.RELATED).add(lblRestrictions).addContainerGap(
                    229,
                    Short.MAX_VALUE)));
        scpMain.setViewportView(panMain);

        add(scpMain, java.awt.BorderLayout.CENTER);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  service  caps DOCUMENT ME!
     */
    private void setValues(final Service service) {
        final Values v = new Values();
        try {
            v.name = service.getName();
        } catch (Exception e) {
        }
        try {
            v.title = service.getTitle();
        } catch (Exception e) {
        }

        try {
            v.abstractText = service.getAbstract();
        } catch (Exception e) {
        }

        try {
            v.keywords = service.getKeywordList();
        } catch (Exception e) {
        }

        try {
            v.contactName = service.getContactPerson();
        } catch (Exception e) {
        }

        try {
            v.contactOrganisation = service.getContactOrganization();
        } catch (Exception e) {
        }

        try {
            v.fees = service.getFees();
        } catch (Exception e) {
        }

        try {
            v.restrictions = service.getAccessConstraints();
        } catch (Exception e) {
        }

        setValues(v);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  v  DOCUMENT ME!
     */
    private void setValues(final Values v) {
        // Servername
        if (v.title.trim().equals("")) {                                                                          // NOI18N
            lblTitle.setText(org.openide.util.NbBundle.getMessage(ServerInfo.class, "ServerInfo.lblTitle.text")); // NOI18N
        } else {
            lblTitle.setText(v.title.trim());
        }

        // Servicename
        lblName.setText(v.name.trim());

        // Beschreibung
        if ((v.abstractText != null) && !v.abstractText.trim().equals("")) { // NOI18N
            lblInfo.setToolTipText(v.abstractText.trim());
        } else {
            lblInfo.setToolTipText("");
        }

        // Keywords
        if ((v.keywords != null) && (v.keywords.length > 0)) {
            cboKeywords.setModel(new DefaultComboBoxModel(v.keywords));
            setKeywordSectionVisible(true);
        } else {
            setKeywordSectionVisible(false);
        }

        // Ansprechpartner
        if (((v.contactName != null) && (v.contactName.trim().length() > 0))
                    || ((v.contactOrganisation != null) && (v.contactOrganisation.trim().length() > 0))) {
            setContactSectionVisible(true);
            if ((v.contactName != null) && (v.contactName.trim().length() > 0)) {
                lblContact.setText(v.contactName.trim());
            } else {
                lblContact.setVisible(false);
            }
            if ((v.contactOrganisation != null) && (v.contactOrganisation.trim().length() > 0)) {
                lblOrganisation.setText(v.contactOrganisation.trim());
            } else {
                lblOrganisation.setVisible(false);
            }
        } else {
            setContactSectionVisible(false);
        }
        // Fees
        if ((v.fees != null) && (v.fees.trim().length() > 0)) {
            setFeesSectionVisible(true);
            lblFees.setText(v.fees.trim());
        } else {
            setFeesSectionVisible(false);
        }

        // Constraints
        if ((v.restrictions != null) && (v.restrictions.trim().length() > 0)) {
            setRestrictionsSectionVisible(true);
            lblRestrictions.setText(v.restrictions.trim());
        } else {
            setRestrictionsSectionVisible(false);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  visible  DOCUMENT ME!
     */
    private void setKeywordSectionVisible(final boolean visible) {
        sepKeywords.setVisible(visible);
        lblKeywords.setVisible(visible);
        scpKeywords.setVisible(visible);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  visible  DOCUMENT ME!
     */
    private void setContactSectionVisible(final boolean visible) {
        sepContact.setVisible(visible);
        lblContactTitle.setVisible(visible);
        lblContact.setVisible(visible);
        lblOrganisation.setVisible(visible);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  visible  DOCUMENT ME!
     */
    private void setFeesSectionVisible(final boolean visible) {
        sepFees.setVisible(visible);
        lblFeesTitle.setVisible(visible);
        lblFees.setVisible(visible);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  visible  DOCUMENT ME!
     */
    private void setRestrictionsSectionVisible(final boolean visible) {
        sepRestrictions.setVisible(visible);
        lblRestrictionsTitle.setVisible(visible);
        lblRestrictions.setVisible(visible);
    }

    @Override
    public void layerVisibilityChanged(final ActiveLayerEvent e) {
    }

    @Override
    public void layerAvailabilityChanged(final ActiveLayerEvent e) {
    }

    @Override
    public void layerSelectionChanged(final ActiveLayerEvent e) {
        final Object serverInfo = e.getCapabilities();
        if (serverInfo instanceof WMSCapabilities) {
            setValues(((WMSCapabilities)serverInfo).getService());
        } else if (serverInfo instanceof WFSCapabilities) {
            setValues(((WFSCapabilities)serverInfo).getService());
        }
    }

    @Override
    public void layerRemoved(final ActiveLayerEvent e) {
    }

    @Override
    public void layerPositionChanged(final ActiveLayerEvent e) {
    }

    @Override
    public void layerInformationStatusChanged(final ActiveLayerEvent e) {
    }

    @Override
    public void layerAdded(final ActiveLayerEvent e) {
    }

    @Override
    public JComponent getGuiComponent() {
        return this;
    }

    @Override
    public String getPermissionString() {
        return GUIWindow.NO_PERMISSION;
    }

    @Override
    public String getViewTitle() {
        return NbBundle.getMessage(ServerInfo.class, "ServerInfo.getViewTitle");
    }

    @Override
    public Icon getViewIcon() {
        final Icon icoMap = new ImageIcon(getClass().getResource(
                    "/de/cismet/cismap/commons/gui/capabilitywidget/res/serverInfo.png"));
        return Static2DTools.borderIcon(icoMap, 0, 3, 0, 1);
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class Values {

        //~ Instance fields ----------------------------------------------------

        private String title;
        private String name;
        private String abstractText;
        private String fees;
        private String restrictions;
        private String contactName;
        private String contactPosition;
        private String contactOrganisation;
        private String[] keywords;
    }
}
