/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cismap.commons.tools;

import java.awt.EventQueue;
import java.awt.Font;

import de.cismet.cismap.commons.featureservice.style.FontChooserDialog;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class NewTextDialog extends javax.swing.JDialog {

    //~ Instance fields --------------------------------------------------------

    private boolean confirmed = false;
    private Runnable runWhenFinish = null;
    private Font font = null;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton jbCancel;
    private javax.swing.JButton jbOk;
    private javax.swing.JCheckBox jcHalo;
    private javax.swing.JCheckBox jcScale;
    private javax.swing.JTextArea taText;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form NewTextDialog.
     *
     * @param  parent  DOCUMENT ME!
     * @param  modal   DOCUMENT ME!
     */
    public NewTextDialog(final java.awt.Frame parent, final boolean modal) {
        super(parent, modal);
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  the font
     */
    @Override
    public Font getFont() {
        return font;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  font  the font to set
     */
    @Override
    public void setFont(final Font font) {
        this.font = font;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public boolean isConfirmed() {
        return confirmed;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public String getText() {
        return taText.getText();
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public boolean isHaloEnabled() {
        return jcHalo.isSelected();
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public boolean isAutoScaleEnabled() {
        return jcScale.isSelected();
    }

    /**
     * DOCUMENT ME!
     *
     * @param  enabled  DOCUMENT ME!
     */
    public void setHaloEnabled(final boolean enabled) {
        jcHalo.setSelected(enabled);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  enabled  DOCUMENT ME!
     */
    public void setAutoScaleEnabled(final boolean enabled) {
        jcScale.setSelected(enabled);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  text  DOCUMENT ME!
     */
    public void settext(final String text) {
        taText.setText(text);
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        taText = new javax.swing.JTextArea();
        jcScale = new javax.swing.JCheckBox();
        jbOk = new javax.swing.JButton();
        jbCancel = new javax.swing.JButton();
        jcHalo = new javax.swing.JCheckBox();
        jPanel1 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(NewTextDialog.class, "NewTextDialog.title", new Object[] {})); // NOI18N
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setMaximumSize(new java.awt.Dimension(300, 90));
        jScrollPane1.setMinimumSize(new java.awt.Dimension(300, 90));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(300, 90));

        taText.setColumns(20);
        taText.setRows(5);
        jScrollPane1.setViewportView(taText);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 10, 10);
        getContentPane().add(jScrollPane1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jcScale,
            org.openide.util.NbBundle.getMessage(NewTextDialog.class, "NewTextDialog.jcScale.text", new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 5);
        getContentPane().add(jcScale, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jbOk,
            org.openide.util.NbBundle.getMessage(NewTextDialog.class, "NewTextDialog.jbOk.text", new Object[] {})); // NOI18N
        jbOk.setPreferredSize(new java.awt.Dimension(85, 30));
        jbOk.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jbOkActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(jbOk, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jbCancel,
            org.openide.util.NbBundle.getMessage(
                NewTextDialog.class,
                "NewTextDialog.jbCancel.text",
                new Object[] {})); // NOI18N
        jbCancel.setPreferredSize(new java.awt.Dimension(85, 30));
        jbCancel.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jbCancelActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(jbCancel, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jcHalo,
            org.openide.util.NbBundle.getMessage(NewTextDialog.class, "NewTextDialog.jcHalo.text", new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 5);
        getContentPane().add(jcHalo, gridBagConstraints);

        final javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jPanel1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jButton1,
            org.openide.util.NbBundle.getMessage(
                NewTextDialog.class,
                "NewTextDialog.jButton1.text",
                new Object[] {})); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton1ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 5);
        getContentPane().add(jButton1, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jbOkActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jbOkActionPerformed
        confirmed = true;
        if (runWhenFinish != null) {
            EventQueue.invokeLater(runWhenFinish);
        }
        setVisible(false);
    }                                                                        //GEN-LAST:event_jbOkActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jbCancelActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jbCancelActionPerformed
        confirmed = false;
        setVisible(false);
    }                                                                            //GEN-LAST:event_jbCancelActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton1ActionPerformed
        final FontChooserDialog fontChooser = new FontChooserDialog(this, "Schrift wählen");
        if (font != null) {
            fontChooser.setSelectedFont(
                font,
                font.getSize(),
                (font.getStyle() & Font.BOLD)
                        == Font.BOLD,
                (font.getStyle() & Font.ITALIC)
                        == Font.ITALIC);
        }
        StaticSwingTools.showDialog(fontChooser);

        font = fontChooser.getReturnStatus();
    } //GEN-LAST:event_jButton1ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  runWhenFinish  the runWhenFinish to set
     */
    public void setRunWhenFinish(final Runnable runWhenFinish) {
        this.runWhenFinish = runWhenFinish;
    }
}
