/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.attributetable;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableReportBuilder;
import java.util.HashMap;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AttributeTableReportBuilderTest {
    @BeforeClass
    public static void setUpClass() {
        System.setProperty("net.sf.jasperreports.awt.ignore.missing.font", "true");
        System.setProperty("net.sf.jasperreports.default.font.name", "Lucida Sans");
        System.setProperty("net.sf.jasperreports.default.pdf.font.name", "Lucida Sans");
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void test010AttributeTableReportBuilder() throws Exception {
        TableDataSource tableDataSource = new TableDataSource(new CustomTableModel());
        HashMap<String, TableDataSource> generatedParams = new HashMap<String, TableDataSource>();
        generatedParams.put("table_data", tableDataSource);
        DynamicReport dynamicReport = new AttributeTableReportBuilder().buildReport("Titel", new JTable(new CustomTableModel()));
        Assert.assertNotNull((Object)dynamicReport);
        JasperReport jasperReport = DynamicJasperHelper.generateJasperReport((DynamicReport)dynamicReport, (LayoutManager)new ClassicLayoutManager(), generatedParams);
        Assert.assertNotNull((Object)jasperReport);
        for (String key : generatedParams.keySet()) {
            Object o = generatedParams.get(key);
            if (!(o instanceof JasperReport)) continue;
            JasperReport jr = (JasperReport)o;
            String reportFile = System.getProperty("user.dir") + "/target/reports/" + key + ".jrxml";
            DynamicJasperHelper.generateJRXML((JasperReport)jr, (String)"UTF-8", (String)reportFile);
            JasperReport restoredReport = JasperCompileManager.compileReport((String)reportFile);
            Assert.assertNotNull((Object)restoredReport);
            Assert.assertEquals((long)jr.getColumnCount(), (long)restoredReport.getColumnCount());
            Assert.assertEquals((long)jr.getBottomMargin(), (long)restoredReport.getBottomMargin());
            Assert.assertEquals((Object)jr.getName(), (Object)restoredReport.getName());
            Assert.assertEquals((Object)jr.getLanguage(), (Object)restoredReport.getLanguage());
            Assert.assertEquals((Object)jr.getMainDataset().getName(), (Object)restoredReport.getMainDataset().getName());
        }
        String reportFile = System.getProperty("user.dir") + "/target/reports/table_report.jrxml";
        DynamicJasperHelper.generateJRXML((JasperReport)jasperReport, (String)"UTF-8", (String)reportFile);
        JasperReport restoredReport = JasperCompileManager.compileReport((String)reportFile);
        Assert.assertNotNull((Object)restoredReport);
        Assert.assertEquals((long)jasperReport.getColumnCount(), (long)restoredReport.getColumnCount());
        Assert.assertEquals((long)jasperReport.getBottomMargin(), (long)restoredReport.getBottomMargin());
        Assert.assertEquals((Object)jasperReport.getName(), (Object)restoredReport.getName());
        Assert.assertEquals((Object)jasperReport.getLanguage(), (Object)restoredReport.getLanguage());
        Assert.assertEquals((Object)jasperReport.getMainDataset().getName(), (Object)restoredReport.getMainDataset().getName());
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, generatedParams, (JRDataSource)tableDataSource);
        Assert.assertNotNull((Object)jasperPrint);
    }

    private static class CustomTableModel
    implements TableModel {
        String[] cols = new String[]{"ab", "cd", "ef", "gh"};
        String[][] attr = new String[][]{{"a", "b", "c", "d"}, {"a1", "b1", "c1", "d1"}, {"a2", "b2", "c2", "d2"}, {"a3", "b3", "c3", "d3"}, {"a4", "4b", "c4", "4d"}};

        private CustomTableModel() {
        }

        @Override
        public int getRowCount() {
            return 5;
        }

        @Override
        public int getColumnCount() {
            return this.cols.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.cols[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.attr[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }

    private static class TableDataSource
    implements JRDataSource {
        private int index = -1;
        private final TableModel model;

        public TableDataSource(TableModel model) {
            this.model = model;
        }

        public boolean next() throws JRException {
            boolean ret;
            boolean bl = ret = ++this.index < this.model.getRowCount();
            if (!ret) {
                this.index = -1;
            }
            return ret;
        }

        public Object getFieldValue(JRField jrField) throws JRException {
            int col = 0;
            try {
                col = Integer.parseInt(jrField.getName());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Object result = this.model.getValueAt(this.index, col);
            if (result != null) {
                return String.valueOf(result);
            }
            return null;
        }
    }
}

