/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons;

import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CidsLayerFactory;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModelStore;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import edu.umd.cs.piccolo.PNode;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;

public class ModeLayer
implements RetrievalServiceLayer,
MapService,
ActiveLayerModelStore {
    protected HashMap<String, RetrievalServiceLayer> modeLayers = new HashMap();
    private String mode = null;
    private RetrievalServiceLayer currentModeLayer = null;
    private boolean enabled = true;
    private int layerPosition = -1;
    private float translucency = 0.0f;
    private ArrayList<RetrievalListener> retrievalListeners = new ArrayList();
    private ArrayList<PropertyChangeListener> pcListeners = new ArrayList();
    private ActiveLayerModel mappingModel;
    private String layerKey = null;

    @Override
    public void setActiveLayerModel(ActiveLayerModel alm) {
        this.mappingModel = alm;
    }

    @Override
    public ActiveLayerModel getActiveLayerModel() {
        return this.mappingModel;
    }

    public RetrievalServiceLayer putModeLayer(String mode, RetrievalServiceLayer layer) {
        if (layer.getPNode() == null) {
            layer.setPNode(new PNode());
        }
        return this.modeLayers.put(mode, layer);
    }

    public RetrievalServiceLayer getModeLayer(String mode) {
        return this.modeLayers.get(mode);
    }

    public Set<String> getModes() {
        return this.modeLayers.keySet();
    }

    public void forceMode(String mode) {
        this.setMode(mode, true);
    }

    public void setMode(String mode) {
        this.setMode(mode, false);
    }

    public void setVisible(boolean b) {
        for (RetrievalServiceLayer rsl : this.modeLayers.values()) {
            rsl.getPNode().setVisible(b);
        }
    }

    public void setMode(String mode, boolean forced) {
        if (this.mode == null || !this.mode.equals(mode) || forced) {
            RetrievalServiceLayer oldLayer = this.currentModeLayer;
            this.currentModeLayer = this.modeLayers.get(mode);
            if (this.currentModeLayer != null) {
                this.mode = mode;
                for (RetrievalListener rl : this.retrievalListeners) {
                    if (oldLayer != null) {
                        oldLayer.removeRetrievalListener(rl);
                        this.setTranslucency(oldLayer.getTranslucency());
                    }
                    this.currentModeLayer.addRetrievalListener(rl);
                }
                for (PropertyChangeListener pcl : this.pcListeners) {
                    if (oldLayer != null) {
                        oldLayer.removePropertyChangeListener(pcl);
                    }
                    this.currentModeLayer.addPropertyChangeListener(pcl);
                }
                ActiveLayerEvent ale = new ActiveLayerEvent();
                if (oldLayer != null) {
                    ale.setLayer(oldLayer);
                    CismapBroker.getInstance().fireLayerRemoved(ale);
                }
                if (this.mappingModel != null) {
                    if (oldLayer != null) {
                        this.mappingModel.fireMapServiceRemoved((MapService)((Object)oldLayer));
                    }
                    this.mappingModel.fireMapServiceAdded((MapService)((Object)this.currentModeLayer));
                }
                ale.setLayer(this.currentModeLayer);
                CismapBroker.getInstance().fireLayerAdded(ale);
            } else {
                this.currentModeLayer = oldLayer;
            }
        }
    }

    private void checkCurrentModeLayer() {
        if (this.currentModeLayer == null) {
            throw new IllegalStateException("A modeLayer without a mode is not a good idea. It should be configured with at least two different modes/layers and initialized with a start mode");
        }
    }

    @Override
    public void setErrorObject(Object error) {
        this.checkCurrentModeLayer();
        this.currentModeLayer.setErrorObject(error);
    }

    @Override
    public Object getErrorObject() {
        this.checkCurrentModeLayer();
        return this.currentModeLayer.getErrorObject();
    }

    @Override
    public boolean hasErrors() {
        return this.currentModeLayer.hasErrors();
    }

    @Override
    public PNode getPNode() {
        return this.currentModeLayer.getPNode();
    }

    @Override
    public void setPNode(PNode pNode) {
        this.currentModeLayer.setPNode(pNode);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        for (RetrievalServiceLayer rsl : this.modeLayers.values()) {
            rsl.setEnabled(enabled);
        }
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public int getLayerPosition() {
        return this.layerPosition;
    }

    @Override
    public void setLayerPosition(int layerPosition) {
        this.layerPosition = layerPosition;
    }

    @Override
    public float getTranslucency() {
        return this.translucency;
    }

    @Override
    public void setTranslucency(float translucency) {
        this.translucency = translucency;
        for (RetrievalServiceLayer rsl : this.modeLayers.values()) {
            rsl.setTranslucency(translucency);
        }
    }

    @Override
    public String getName() {
        return this.currentModeLayer.getName();
    }

    @Override
    public void setName(String name) {
        this.currentModeLayer.setName(name);
    }

    @Override
    public void addRetrievalListener(RetrievalListener rl) {
        this.retrievalListeners.add(rl);
        this.currentModeLayer.addRetrievalListener(rl);
    }

    @Override
    public void removeRetrievalListener(RetrievalListener irl) {
        this.retrievalListeners.remove(irl);
        this.currentModeLayer.removeRetrievalListener(irl);
    }

    @Override
    public void retrieve(boolean forced) {
        this.currentModeLayer.retrieve(forced);
    }

    @Override
    public void setRefreshNeeded(boolean refreshNeeded) {
        for (RetrievalServiceLayer rsl : this.modeLayers.values()) {
            rsl.setRefreshNeeded(refreshNeeded);
        }
    }

    public void setCrs(Crs crs) {
        for (RetrievalServiceLayer rsl : this.modeLayers.values()) {
            CidsLayerFactory.setLayerToCrs(crs, rsl);
        }
    }

    @Override
    public boolean isRefreshNeeded() {
        return this.currentModeLayer.isRefreshNeeded();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcListeners.add(l);
        this.currentModeLayer.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcListeners.remove(l);
        this.currentModeLayer.removePropertyChangeListener(l);
    }

    @Override
    public int getProgress() {
        return this.currentModeLayer.getProgress();
    }

    @Override
    public void setProgress(int progress) {
        this.currentModeLayer.setProgress(progress);
    }

    @Override
    public void setSize(int height, int width) {
        for (RetrievalServiceLayer rsl : this.modeLayers.values()) {
            if (!(rsl instanceof MapService)) continue;
            ((MapService)((Object)rsl)).setSize(height, width);
        }
    }

    public RetrievalServiceLayer getCurrentLayer() {
        return this.currentModeLayer;
    }

    public String getCurrentMode() {
        return this.mode;
    }

    @Override
    public void setBoundingBox(BoundingBox bb) {
        for (RetrievalServiceLayer rsl : this.modeLayers.values()) {
            if (!(rsl instanceof MapService)) continue;
            ((MapService)((Object)rsl)).setBoundingBox(bb);
        }
    }

    @Override
    public boolean isVisible() {
        return ((MapService)((Object)this.currentModeLayer)).isVisible();
    }

    public Element toElement() {
        Element element = new Element("ModeLayer");
        element.setAttribute("mode", this.getCurrentMode());
        element.setAttribute("key", this.layerKey);
        if (this.layerPosition != -1) {
            element.setAttribute("layerPosition", String.valueOf(this.layerPosition));
        }
        element.setAttribute("translucency", Float.toString(this.getCurrentLayer().getTranslucency()));
        element.setAttribute("enabled", Boolean.toString(this.getCurrentLayer().isEnabled()));
        element.setAttribute("visible", Boolean.toString(this.getCurrentLayer().getPNode().getVisible()));
        for (String m : this.getModes()) {
            Element modeElement = new Element("Mode");
            modeElement.setAttribute("key", m);
            modeElement.addContent((Content)CidsLayerFactory.getElement((MapService)((Object)this.getModeLayer(m))));
            element.addContent((Content)modeElement);
        }
        return element;
    }

    public String getLayerKey() {
        return this.layerKey;
    }

    public void setLayerKey(String layerKey) {
        this.layerKey = layerKey;
    }
}

