/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WorldToScreenTransform {
    double xHome;
    double yHome;
    private final Logger log = Logger.getLogger(this.getClass());
    private Map<Double, Double> snappedXCoordinates = new HashMap<Double, Double>();
    private Map<Double, Double> snappedYCoordinates = new HashMap<Double, Double>();

    public WorldToScreenTransform(double x, double y) {
        this.xHome = x;
        this.yHome = y;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("WorldToScreenTransform(x=" + this.xHome + ",y=" + this.yHome + ")"));
        }
    }

    public void addXCoordinate(double xScreen, double xWorld) {
        this.snappedXCoordinates.put(xScreen, xWorld);
    }

    public void addYCoordinate(double yScreen, double yWorld) {
        this.snappedYCoordinates.put(yScreen, yWorld);
    }

    public void removeXCoordinate(double xScreen) {
        this.snappedXCoordinates.remove(xScreen);
    }

    public void removeYCoordinate(double yScreen) {
        this.snappedYCoordinates.remove(yScreen);
    }

    public double getSourceX(double x) {
        return this.getWorldX(x);
    }

    public double getSourceY(double y) {
        return this.getWorldY(y);
    }

    public double getDestX(double x) {
        return this.getScreenX(x);
    }

    public double getDestY(double y) {
        return this.getScreenY(y);
    }

    public double getWorldX(double screenX) {
        if (this.snappedXCoordinates.get(screenX) == null) {
            return screenX + this.xHome;
        }
        return this.snappedXCoordinates.get(screenX);
    }

    public double getWorldY(double screenY) {
        if (this.snappedYCoordinates.get(screenY) == null) {
            return this.yHome - screenY;
        }
        return this.snappedYCoordinates.get(screenY);
    }

    public double getScreenX(double worldX) {
        return worldX - this.xHome;
    }

    public double getScreenY(double worldY) {
        return -1.0 * (worldY - this.yHome);
    }

    private static String xyToScreen(WorldToScreenTransform wtst, double x, double y) {
        return wtst.getScreenX(x) + "," + wtst.getScreenY(y);
    }

    public static void main(String[] args) {
        WorldToScreenTransform wtst = new WorldToScreenTransform(-180.0, 90.0);
        System.out.println(WorldToScreenTransform.xyToScreen(wtst, -180.0, 90.0));
        System.out.println(WorldToScreenTransform.xyToScreen(wtst, -180.0, -90.0));
        System.out.println(WorldToScreenTransform.xyToScreen(wtst, 180.0, -90.0));
        System.out.println(WorldToScreenTransform.xyToScreen(wtst, 180.0, 90.0));
    }

    public String toString() {
        return "de.cismet.cismap.commons.WorldToScreenTransform: xHome:" + this.xHome + " yHome:" + this.yHome;
    }
}

