/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.demo;

import de.cismet.cismap.commons.demo.ImageRetrievalDemo;
import de.cismet.cismap.commons.rasterservice.HTTPImageRetrieval;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ImageRetrievalAuthDemo
extends JFrame
implements RetrievalListener {
    HTTPImageRetrieval ir;
    private final Logger log = Logger.getLogger(this.getClass());
    private JMenuItem aboutMenuItem;
    private JMenuItem contentsMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JButton jButton1;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JPanel panMain;
    private JMenuItem pasteMenuItem;
    private JProgressBar prBar;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;

    public ImageRetrievalAuthDemo() {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        this.log.info((Object)"Simple Mapping Client started");
        this.initComponents();
        this.prBar.setMaximum(100);
    }

    private void initComponents() {
        this.prBar = new JProgressBar();
        this.panMain = new JPanel();
        this.jButton1 = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.getContentPane().add((Component)this.prBar, "South");
        this.panMain.setMinimumSize(new Dimension(100, 100));
        this.getContentPane().add((Component)this.panMain, "Center");
        this.jButton1.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageRetrievalAuthDemo.this.jButton1ActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.jButton1, "North");
        this.fileMenu.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.fileMenu.text"));
        this.openMenuItem.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.openMenuItem.text"));
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.saveMenuItem.text"));
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.saveAsMenuItem.text"));
        this.fileMenu.add(this.saveAsMenuItem);
        this.exitMenuItem.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.exitMenuItem.text"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageRetrievalAuthDemo.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.editMenuItem.text"));
        this.cutMenuItem.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.cutMenuItem.text"));
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.copyMenuItem.text"));
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.pasteMenuItem.text"));
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.deleteMenuItem.text"));
        this.editMenu.add(this.deleteMenuItem);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.helpMenu.text"));
        this.contentsMenuItem.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.contentsMenuItem.text"));
        this.helpMenu.add(this.contentsMenuItem);
        this.aboutMenuItem.setText(NbBundle.getMessage(ImageRetrievalAuthDemo.class, (String)"ImageRetrievalAuthDemo.aboutMenuItem.text"));
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 400) / 2, (screenSize.height - 300) / 2, 400, 300);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.prBar.setValue(0);
        this.prBar.setIndeterminate(true);
        if (this.ir == null) {
            this.ir = new HTTPImageRetrieval(this);
            this.ir.setUrl("http://localhost:8080/deegree2/ogcwebservice?REQUEST=GetMap&SERVICE=WMS&VERSION=1.1.1&WIDTH=674&HEIGHT=527&LAYERS=StateBoundary&TRANSPARENT=TRUE&FORMAT=image/jpg&BBOX=-39862.32289224541,3995357.845975933,919186.2219233183,4745237.049414809&SRS=EPSG:26912&STYLES=");
            this.ir.start();
        } else {
            this.ir.endRetrieval();
            this.ir = new HTTPImageRetrieval(this);
            this.ir.setUrl("http://localhost:8080/deegree2/ogcwebservice?REQUEST=GetMap&SERVICE=WMS&VERSION=1.1.1&WIDTH=674&HEIGHT=527&LAYERS=StateBoundary&TRANSPARENT=TRUE&FORMAT=image/jpg&BBOX=-39862.32289224541,3995357.845975933,919186.2219233183,4745237.049414809&SRS=EPSG:26912&STYLES=");
            this.ir.start();
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ImageRetrievalDemo().setVisible(true);
            }
        });
    }

    @Override
    public void retrievalStarted(RetrievalEvent e) {
    }

    @Override
    public void retrievalProgress(RetrievalEvent e) {
        final double p = e.getPercentageDone();
        System.out.println(p);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ImageRetrievalAuthDemo.this.prBar.isIndeterminate()) {
                    ImageRetrievalAuthDemo.this.prBar.setIndeterminate(false);
                }
                ImageRetrievalAuthDemo.this.prBar.setValue((int)p);
            }
        });
    }

    @Override
    public void retrievalError(RetrievalEvent e) {
        this.log.fatal((Object)("Fehler:" + e.getRetrievedObject()));
    }

    @Override
    public void retrievalComplete(RetrievalEvent e) {
        Object o = e.getRetrievedObject();
        Image i = null;
        if (o instanceof Image) {
            i = (Image)o;
        }
        this.panMain.getGraphics().drawImage(i, 0, 0, this);
    }

    @Override
    public void retrievalAborted(RetrievalEvent e) {
        this.prBar.setIndeterminate(false);
        this.panMain.repaint();
    }
}

